/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdOutputStream;
import com.stc.util.MessageManager;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FixedLengthWriter {
    private OtdOutputStream mOtdos;
    private String mEncoding = "UTF-8";

    public FixedLengthWriter(OtdOutputStream otdos) {
        this.mOtdos = otdos;
    }

    public FixedLengthWriter(OtdOutputStream otdos, String encoding) {
        this.mOtdos = otdos;
        this.mEncoding = encoding;
    }

    public void write(int length, String data) {
        this.write(length, this.mEncoding, data);
    }

    public void write(int length, String encoding, String data) {
        try {
            if (data != null) {
                byte[] bytes = data.getBytes(encoding);
                byte[] buffer = new byte[length];
                for (int i = 0; i < length; ++i) {
                    if (i < bytes.length) {
                        buffer[i] = bytes[i];
                        continue;
                    }
                    int n = i;
                    buffer[n] = (byte)(buffer[n] & 0x20);
                }
                this.mOtdos.write(buffer);
            }
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
            MessageManager mMsg = MessageManager.getManager((String)this.getClass().getPackage().getName());
            String mesg = mMsg.getString("otd.parse.char.error");
            Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, mesg, ioe);
        }
    }
}

