/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.bpms.bpel.runtime.EvaluationContext;
import com.stc.bpms.bpel.runtime.WSMessage;
import com.stc.otd.runtime.MarshalException;
import com.stc.otd.runtime.OtdLocation;
import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdNode2;
import com.stc.otd.runtime.UnmarshalException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NodePath {
    private final Part mList;

    public NodePath(OtdNode2 node, int child, int index) {
        if (node == null) {
            throw new NullPointerException("no node");
        }
        Part list = null;
        if (child >= 0) {
            list = new Part(node.meta().getChild(child), index, null);
        }
        while (node != null) {
            OtdMeta meta = node.meta();
            OtdNode2 parent = (OtdNode2)node.parent();
            index = -1;
            if (meta.getIndex() >= 0 && parent != null) {
                if (meta.indexed()) {
                    int ci = meta.getIndex();
                    for (index = parent.count(ci) - 1; index >= 0 && (OtdNode2)parent.get(ci, index) != node; --index) {
                    }
                }
                node = parent;
            } else {
                node = null;
            }
            list = new Part(meta, index, list);
        }
        this.mList = list;
    }

    public NodePath(OtdNode2 node) {
        this(node, -1, -1);
    }

    public String numeric() {
        StringBuffer sb = new StringBuffer();
        Part p = this.mList;
        while (p != null) {
            sb.append("." + p.mMeta.getIndex());
            if (p.mIndex >= 0) {
                sb.append("[" + p.mIndex + "]");
            }
            p = p.mNext;
        }
        return sb.toString().substring(1);
    }

    public String display() {
        StringBuffer sb = new StringBuffer();
        Part p = this.mList;
        while (p != null) {
            sb.append("." + p.mMeta.getName());
            if (p.mIndex >= 0) {
                sb.append("[" + p.mIndex + "]");
            }
            p = p.mNext;
        }
        return sb.toString().substring(1);
    }

    public String javaNames() {
        StringBuffer sb = new StringBuffer();
        Part p = this.mList;
        while (p != null) {
            sb.append("." + p.mMeta.getJavaName());
            if (p.mIndex >= 0) {
                sb.append("[" + p.mIndex + "]");
            }
            p = p.mNext;
        }
        return sb.toString().substring(1);
    }

    public static OtdLocation display(OtdNode2 node) {
        return new PathLocation(new NodePath(node));
    }

    private String xmlEscape(String s) {
        return s;
    }

    public String fault(UnmarshalException ue) {
        String message;
        StringBuffer sb = new StringBuffer("<?xml version='1.0' encoding='utf-8'?>\n<fault type='unmarshal'\n");
        OtdLocation loc = ue.getLocation();
        if (loc != null) {
            sb.append("    location='" + this.xmlEscape(loc.text()) + "'\n");
        }
        if ((message = ue.getMessage()) != null) {
            sb.append("    message='" + this.xmlEscape(message) + "'\n");
        }
        sb.append("/>");
        return sb.toString();
    }

    public static Object wrapFault(UnmarshalException e) {
        return new FaultBean(e);
    }

    public static Object wrapFault(MarshalException e) {
        return new FaultBean(e);
    }

    public static class FaultBean
    implements WSMessage {
        private final String mMessage;
        private final String mLocation;
        private final String mStackTrace;

        public FaultBean(String message, String location, String stackTrace) {
            this.mMessage = message;
            this.mLocation = location;
            this.mStackTrace = stackTrace;
        }

        public FaultBean(UnmarshalException e) {
            if (e == null) {
                throw new NullPointerException("no exception");
            }
            this.mMessage = e.getMessage();
            OtdLocation loc = e.getLocation();
            this.mLocation = loc == null ? null : loc.text();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.mStackTrace = sw.toString();
        }

        public FaultBean(MarshalException e) {
            if (e == null) {
                throw new NullPointerException("no exception");
            }
            this.mMessage = e.getMessage();
            OtdLocation loc = e.getLocation();
            this.mLocation = loc == null ? null : loc.text();
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            e.printStackTrace(pw);
            this.mStackTrace = sw.toString();
        }

        public String getMessage() {
            return this.mMessage;
        }

        public String getLocation() {
            return this.mLocation;
        }

        public String getStackTrace() {
            return this.mStackTrace;
        }

        public Object getRoot() {
            return this;
        }

        public Object getPart(String part) {
            if (part.equalsIgnoreCase("message")) {
                return this.mMessage;
            }
            if (part.equalsIgnoreCase("location")) {
                return this.mLocation;
            }
            if (part.equalsIgnoreCase("stackTrace")) {
                return this.mStackTrace;
            }
            return null;
        }

        public void setPart(String part, String query, Object value, EvaluationContext evalCtx) {
        }

        public void setPart(String part, String query, Object value) {
        }

        public WSMessage duplicate() {
            return new FaultBean(FaultBean.getClonedString(this.mMessage), FaultBean.getClonedString(this.mLocation), FaultBean.getClonedString(this.mStackTrace));
        }

        private static String getClonedString(String str) {
            return new String(str);
        }
    }

    public static class DualLocation
    implements OtdLocation {
        private final OtdLocation mLoc1;
        private final OtdLocation mLoc2;

        private DualLocation(OtdLocation loc1, OtdLocation loc2) {
            if (loc1 == null) {
                throw new NullPointerException("no 1st location");
            }
            if (loc2 == null) {
                throw new NullPointerException("no 2nd location");
            }
            this.mLoc1 = loc1;
            this.mLoc2 = loc2;
        }

        public static OtdLocation combine(OtdLocation loc1, OtdLocation loc2) {
            return loc1 == null ? (loc2 == null ? null : loc2) : (loc2 == null ? loc1 : new DualLocation(loc1, loc2));
        }

        public String text() {
            return this.mLoc1.text() + "\n" + this.mLoc2.text();
        }

        public OtdLocation from() {
            return DualLocation.combine(this.mLoc1.from(), this.mLoc2.from());
        }

        public Object getProperty(String name) {
            return null;
        }
    }

    private static class PathLocation
    implements OtdLocation {
        private final NodePath mPath;

        public PathLocation(NodePath path) {
            this.mPath = path;
        }

        public String text() {
            return this.mPath.display();
        }

        public OtdLocation from() {
            return null;
        }

        public Object getProperty(String name) {
            if ("path".equals(name)) {
                return this.mPath;
            }
            return null;
        }
    }

    private static class Part {
        public final OtdMeta mMeta;
        public final int mIndex;
        public final Part mNext;

        public Part(OtdMeta meta, int index, Part next) {
            this.mMeta = meta;
            this.mIndex = index;
            this.mNext = next;
        }
    }
}

