/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.CoderFactory;
import com.stc.otd.runtime.OtdRoot2;
import com.stc.otd.runtime.OtdTrace;
import com.stc.otd.runtime.StringCoder;
import com.stc.otd.runtime.provider.StringOtdInputStreamImpl;
import com.stc.util.Option;
import java.io.File;
import java.io.FileInputStream;

public class OtdDiagnostic {
    public static void test(OtdRoot2 root, String[] args) {
        if (root == null) {
            throw new NullPointerException("no root node");
        }
        try {
            long total;
            int c;
            byte[] inData = null;
            Object outData = null;
            String inText = null;
            Object outText = null;
            StringCoder inCode = null;
            StringCoder outCode = null;
            boolean ufb = false;
            boolean ufs = false;
            boolean mtb = false;
            boolean mts = false;
            boolean reset = false;
            boolean time = false;
            int count = 1;
            Option opt = new Option(args, "d:e:I:i:r:RtTX:");
            block17: while ((c = opt.getOpt()) != -1) {
                switch (c) {
                    case 98: {
                        ufb = true;
                        continue block17;
                    }
                    case 115: {
                        ufs = true;
                        continue block17;
                    }
                    case 100: {
                        String decode = opt.getOptArg();
                        inCode = CoderFactory.getCoder(decode);
                        continue block17;
                    }
                    case 101: {
                        String encode = opt.getOptArg();
                        outCode = CoderFactory.getCoder(encode);
                        continue block17;
                    }
                    case 73: {
                        inText = opt.getOptArg();
                        continue block17;
                    }
                    case 105: {
                        String inPath = opt.getOptArg();
                        File inFile = new File(inPath);
                        if (!inFile.exists()) {
                            throw new RuntimeException("no input file '" + inPath + "'");
                        }
                        inData = new byte[(int)inFile.length()];
                        FileInputStream fis = new FileInputStream(inFile);
                        fis.read(inData);
                        fis.close();
                        continue block17;
                    }
                    case 114: {
                        try {
                            count = Integer.parseInt(opt.getOptArg());
                            if (count > 0) continue block17;
                            throw new RuntimeException("option '-r' requires positive argument");
                        }
                        catch (NumberFormatException n) {
                            throw new RuntimeException("option '-r' requires numeric argument");
                        }
                    }
                    case 82: {
                        reset = true;
                        continue block17;
                    }
                    case 116: {
                        if (!(root instanceof OtdTrace)) continue block17;
                        ((OtdTrace)((Object)root)).setDebugStream(System.out);
                        continue block17;
                    }
                    case 84: {
                        time = true;
                        continue block17;
                    }
                    case 88: {
                        continue block17;
                    }
                }
                throw new RuntimeException("unknown option '-" + (char)c + "'");
            }
            int oind = opt.getOptInd();
            while (oind < args.length) {
                System.err.println("Ignored argument: [" + args[oind++] + "]");
            }
            if (ufs) {
                if (inText == null) {
                    if (inData == null) {
                        throw new RuntimeException("no input, use -i or -I");
                    }
                    if (inCode == null) {
                        inCode = CoderFactory.getCoder("latin-1");
                    }
                    inText = inCode.decode(inData);
                }
                long start = System.currentTimeMillis();
                for (int i = 0; i < count; ++i) {
                    if (reset) {
                        root.reset();
                    }
                    root.unmarshalFromString(inText);
                }
                total = System.currentTimeMillis() - start;
            } else {
                if (inData == null) {
                    if (inText == null) {
                        throw new RuntimeException("no input, use -i or -I");
                    }
                    if (inCode == null) {
                        inCode = CoderFactory.getCoder("latin-1");
                    }
                    inData = inCode.encode(inText);
                }
                long start = System.currentTimeMillis();
                for (int i = 0; i < count; ++i) {
                    if (reset) {
                        root.reset();
                    }
                    if (ufb) {
                        root.unmarshalFromBytes(inData);
                        continue;
                    }
                    root.unmarshal(new StringOtdInputStreamImpl(inData));
                }
                total = System.currentTimeMillis() - start;
            }
            total = Math.max(total, 1L);
            if (time) {
                System.out.println("calls: " + count);
                System.out.println("total: " + total + " ms");
                System.out.println("msg/s: " + (float)count / (float)total * 1000.0f);
                System.out.println("s/msg: " + (float)total / (float)count / 1000.0f);
            }
        }
        catch (Exception all) {
            all.printStackTrace();
            System.exit(1);
        }
    }
}

