/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdNode;
import java.util.Vector;

public class OtdPath {
    private int[] mCoded = null;
    private int mCount = 0;

    public OtdPath(OtdMeta meta, String path) {
        if (meta == null) {
            throw new NullPointerException("no meta");
        }
        if (path == null) {
            throw new NullPointerException("no path");
        }
        int len = path.length();
        boolean params = false;
        Vector<Integer> part = new Vector<Integer>();
        int pos = 0;
        while (pos < len) {
            NumLit num;
            int end = path.indexOf(46, pos);
            if (end < 0) {
                end = len;
            }
            if (pos == end) {
                OtdPath.fail(path, pos, "empty part");
            }
            char c = path.charAt(pos);
            int child = -1;
            int index = -1;
            int kids = meta.getChildCount();
            if (c == '$') {
                num = new NumLit(path, ++pos);
                pos += num.getDigits();
                child = -num.getValue();
                if (this.mCount <= -child) {
                    this.mCount = -child;
                }
            } else if ('0' <= c && c <= '9') {
                num = new NumLit(path, pos);
                pos += num.getDigits();
                child = num.getValue();
                if (child < 0 || kids <= child) {
                    OtdPath.fail(path, pos, "invalid field #" + child + ", legal values are 0..." + (kids - 1));
                }
            } else {
                int mid = path.indexOf(91, pos);
                if (mid < 0) {
                    mid = end;
                }
                String name = path.substring(pos, mid);
                for (int i = 0; i < kids; ++i) {
                    String find = meta.getChild(i).getName();
                    if (find == null || !find.equals(name)) continue;
                    child = i;
                    break;
                }
                if (child < 0) {
                    OtdPath.fail(path, pos, "unknown field name \"" + name + "\"");
                }
                pos = mid;
            }
            if (pos < end && path.charAt(pos) == '[') {
                if (!meta.indexed()) {
                    OtdPath.fail(path, pos, "indexing non-repeating field");
                }
                if (c == '$') {
                    num = new NumLit(path, ++pos);
                    pos += num.getDigits();
                    index = -(num.getValue() + 1);
                    if (this.mCount <= -index) {
                        this.mCount = -index;
                    }
                } else if ('0' <= c && c <= '9') {
                    num = new NumLit(path, pos);
                    pos += num.getDigits();
                    index = num.getValue();
                    if (index < 0) {
                        OtdPath.fail(path, pos, "invalid index #" + index);
                    }
                } else {
                    OtdPath.fail(path, pos, "expected index");
                }
                if (pos >= end || path.charAt(pos) != ']') {
                    OtdPath.fail(path, pos, "expected ']'");
                }
                if (++pos != end) {
                    OtdPath.fail(path, pos, "trailing junk after ']'");
                }
            } else {
                if (pos != end) {
                    OtdPath.fail(path, pos, "trailing junk after field number");
                }
                if (meta.indexed()) {
                    OtdPath.fail(path, pos, "missing index for repeating field");
                }
                index = -1;
            }
            part.add(new Integer(child));
            part.add(new Integer(index));
            pos = end + 1;
        }
        int size = part.size();
        this.mCoded = new int[size];
        for (int i = 0; i < size; ++i) {
            this.mCoded[i] = (Integer)part.get(i);
        }
    }

    private static void fail(String path, int pos, String msg) {
        throw new IllegalArgumentException("in OTD path \"" + path + "\", at offset " + pos + ": " + msg);
    }

    public Object get(OtdNode node, int[] params) {
        if (this.mCount >= (params == null ? 0 : params.length)) {
            throw new IllegalArgumentException("parameter count mismatch: got " + (params == null ? "none" : "" + params.length) + ", need " + this.mCount);
        }
        Object obj = node;
        int i = 0;
        while (i < this.mCoded.length) {
            int index;
            int child;
            node = obj;
            if ((child = this.mCoded[i++]) < 0) {
                child = params[-1 - child];
            }
            if ((index = this.mCoded[i++]) == -1) {
                obj = node.get(child);
                continue;
            }
            if (index < 0) {
                index = params[-1 - index];
            }
            obj = node.get(child, index);
        }
        return obj;
    }

    public String numeric() {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.mCoded.length) {
            int index;
            int child;
            if (i > 0) {
                sb.append(".");
            }
            if ((child = this.mCoded[i++]) < 0) {
                child = -child;
                sb.append('$');
            }
            sb.append(Integer.toString(child));
            if ((index = this.mCoded[i++]) == -1) continue;
            sb.append('[');
            if (index < 0) {
                index = -1 - index;
                sb.append('$');
            }
            sb.append(Integer.toString(index));
            sb.append(']');
        }
        return sb.toString();
    }

    private static class NumLit {
        private int mDigits = 0;
        private int mValue = 0;

        public NumLit(String path, int pos) {
            char c;
            int len = path.length();
            while (pos < len && '0' <= (c = path.charAt(pos)) && c <= '9') {
                this.mValue = this.mValue * 10 + (c - 48);
                ++this.mDigits;
                ++pos;
            }
            if (this.mDigits == 0) {
                OtdPath.fail(path, pos, "number expected");
            }
        }

        public int getDigits() {
            return this.mDigits;
        }

        public int getValue() {
            return this.mValue;
        }
    }
}

