/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdMeta;
import com.stc.otd.runtime.OtdNode;
import java.lang.reflect.Method;
import java.util.AbstractList;
import org.apache.commons.jxpath.DynamicPropertyHandler;

public class OtdPropertyHandler
implements DynamicPropertyHandler {
    boolean match(String propName, String name) {
        if (propName.equals(name)) {
            return true;
        }
        return (propName.substring(0, 1).toLowerCase() + propName.substring(1)).equals(name);
    }

    public Object getProperty(Object object, String name) {
        OtdNode node = (OtdNode)object;
        OtdMeta meta = node.meta();
        if (meta.isLeaf()) {
            throw new RuntimeException("leaf has no properties");
        }
        int children = meta.getChildCount();
        for (int i = 0; i < children; ++i) {
            OtdMeta m = meta.getChild(i);
            if (!this.match(m.getName(), name)) continue;
            if ((m.getAccess() & 0x20) != 0 && !node.has(i)) {
                return null;
            }
            boolean indexed = false;
            String getter = "get" + m.getJavaName();
            Method[] methods = node.getClass().getMethods();
            for (int j = 0; j < methods.length; ++j) {
                Class<?>[] params;
                Method meth = methods[j];
                if (!meth.getName().equals(getter) || (params = meth.getParameterTypes()).length != 1 || !params[0].equals(Integer.TYPE)) continue;
                indexed = true;
                break;
            }
            if (indexed) {
                return new IndexedProperty(node, i);
            }
            return OtdPropertyHandler.get(node, m);
        }
        return null;
    }

    private static Object get(OtdNode node, OtdMeta field) {
        try {
            Method method = node.getClass().getMethod("get" + field.getJavaName(), null);
            return method.invoke((Object)node, null);
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static Object get(OtdNode node, OtdMeta field, int index) {
        try {
            Method method = node.getClass().getMethod("get" + field.getJavaName(), Integer.TYPE);
            return method.invoke((Object)node, new Integer(index));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            return null;
        }
    }

    private static void set(OtdNode node, OtdMeta field, int index, Object value) {
        try {
            Method method = node.getClass().getMethod("get" + field.getJavaName(), Integer.TYPE);
            method = node.getClass().getMethod("set" + field.getJavaName(), Integer.TYPE, method.getReturnType());
            method.invoke((Object)node, new Integer(index), value);
        }
        catch (Exception exc) {
            System.out.println("Ignored exception : " + exc.getMessage());
        }
    }

    private static void set(OtdNode node, OtdMeta field, Object value) {
        try {
            Method method = node.getClass().getMethod("get" + field.getJavaName(), null);
            method = node.getClass().getMethod("set" + field.getJavaName(), method.getReturnType());
            method.invoke((Object)node, value);
        }
        catch (Exception exc) {
            System.out.println("Ignored exception : " + exc.getMessage());
        }
    }

    public String[] getPropertyNames(Object object) {
        OtdNode node = (OtdNode)object;
        OtdMeta meta = node.meta();
        if (meta.isLeaf()) {
            throw new RuntimeException("leaf has no properties");
        }
        int children = meta.getChildCount();
        int names = 0;
        for (int i = 0; i < children; ++i) {
            OtdMeta sub = meta.getChild(i);
            if (sub.getName() == null) continue;
            ++names;
        }
        String[] result = new String[names];
        if (names > 0) {
            for (int i = 0; names > 0 && i < children; ++i) {
                OtdMeta sub = meta.getChild(i);
                result[--names] = sub.getJavaName();
            }
        }
        return result;
    }

    public void setProperty(Object object, String name, Object value) {
        OtdNode node = (OtdNode)object;
        OtdMeta meta = node.meta();
        if (meta.isLeaf()) {
            throw new RuntimeException("leaf has no properties");
        }
        int children = meta.getChildCount();
        boolean names = false;
        for (int i = 0; i < children; ++i) {
            OtdMeta sub = meta.getChild(i);
            if (!this.match(sub.getJavaName(), name)) continue;
            OtdPropertyHandler.set(node, sub, value);
            break;
        }
    }

    public static class IndexedProperty
    extends AbstractList {
        final OtdNode node;
        final OtdMeta field;
        final int childIndex;

        public IndexedProperty(OtdNode node, int childIndex) {
            this.node = node;
            this.childIndex = childIndex;
            this.field = node.meta().getChild(childIndex);
        }

        public Object get(int index) {
            return OtdPropertyHandler.get(this.node, this.field, index);
        }

        public Object set(int index, Object element) {
            Object old = this.get(index);
            OtdPropertyHandler.set(this.node, this.field, index, element);
            return old;
        }

        public Object remove(int index) {
            return super.remove(index);
        }

        public int size() {
            return this.node.size(this.childIndex);
        }

        public void add(int index, Object object) {
            System.out.println("Add called");
            try {
                this.get(index);
                this.set(index, object);
            }
            catch (Exception e) {
                System.out.println("ERROR Suppressed " + e.getMessage());
            }
        }
    }
}

