/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.UnsupportedEncodingException;

public class ResUtil {

    public static class Lexer {
        private final String mPath;
        private final LineNumberReader mIn;
        private int mLast = -1;
        private StringBuffer mBuf = new StringBuffer();
        private int mQuote;

        public Lexer(InputStream in) {
            try {
                this.mPath = null;
                this.mIn = new LineNumberReader(new InputStreamReader(in, "UTF-8"));
            }
            catch (UnsupportedEncodingException ue) {
                throw new RuntimeException("platform broken, no UTF-8");
            }
        }

        public void fail(String text) {
            throw new RuntimeException("failed " + (this.mPath == null ? "" : "in " + this.mPath + " ") + "at line " + this.mIn.getLineNumber() + ": " + text);
        }

        public int get() throws IOException {
            if (this.mLast >= 0) {
                int res = this.mLast;
                this.mLast = -1;
                return res;
            }
            return this.mIn.read();
        }

        public void unget(int c) {
            if (this.mLast >= 0) {
                this.fail("double unget()");
            }
            this.mLast = c;
        }

        public int skipSpace() throws IOException {
            int c;
            while (Character.isWhitespace((char)(c = this.get()))) {
            }
            while (c == 35) {
                while ((c = this.get()) >= 0 && c != 10) {
                }
                if (c != 10) continue;
                c = this.get();
            }
            if (Character.isWhitespace((char)c)) {
                while (Character.isWhitespace((char)(c = this.get()))) {
                }
            }
            return c;
        }

        public int scanInt(String what) throws IOException {
            int c = this.skipSpace();
            int digits = 0;
            int value = 0;
            if (c == 45) {
                return -1;
            }
            while (48 <= c && c <= 57) {
                value = value * 10 + (c - 48);
                c = this.get();
                ++digits;
            }
            if (digits == 0) {
                this.fail(what + " not an integer, last char = '" + (char)c + "' (" + c + ")");
            }
            this.unget(c);
            return value;
        }

        public int[] scanIntRow(String what) throws IOException {
            int count = this.scanInt(what + " count");
            if (count < 0) {
                return null;
            }
            int[] value = new int[count];
            for (int i = 0; i < count; ++i) {
                value[i] = this.scanInt(what + " part");
            }
            return value;
        }

        public int[][] scanIntRowRow(String what) throws IOException {
            int count = this.scanInt(what + " count");
            if (count < 0) {
                return null;
            }
            int[][] value = new int[count][];
            for (int i = 0; i < count; ++i) {
                value[i] = this.scanIntRow(what + " part");
            }
            return value;
        }

        public boolean scanBool() throws IOException {
            int c = this.skipSpace();
            if (c == 102) {
                return false;
            }
            if (c == 116) {
                return true;
            }
            this.fail("not a boolean");
            return false;
        }

        public String scanString() throws IOException {
            int c = this.skipSpace();
            if (c == 45) {
                return null;
            }
            this.mQuote = c;
            this.mBuf.setLength(0);
            while ((c = this.get()) != this.mQuote) {
                if (c == 92) {
                    c = this.get();
                }
                if (c < 0) {
                    this.fail("EOF in string");
                }
                this.mBuf.append((char)c);
            }
            return this.mBuf.toString();
        }
    }
}

