/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.OtdInputStream;
import com.stc.otd.runtime.OtdInputStreamMark;
import java.io.IOException;
import java.io.InputStream;

public class SimpleOtdInputStreamImpl
implements OtdInputStream {
    protected InputStream mIn = null;
    private long mPos = 0L;
    public static final int REWIND_SIZE = Integer.MAX_VALUE;

    public SimpleOtdInputStreamImpl(InputStream in) throws IOException {
        if (in == null) {
            throw new IOException("Stream closed");
        }
        if (!in.markSupported()) {
            throw new IllegalArgumentException("input must support mark()");
        }
        in.mark(Integer.MAX_VALUE);
        this.mIn = in;
    }

    public InputStream getInputStream() {
        return this.mIn;
    }

    public void setInputStream(InputStream in) {
        this.mIn = in;
    }

    public int available() throws IOException {
        return this.mIn.available();
    }

    public void begin() throws IOException {
    }

    public void close() throws IOException {
        this.mIn.close();
    }

    public boolean end() throws IOException {
        this.mIn.close();
        return true;
    }

    public synchronized OtdInputStreamMark mark() throws IOException {
        return new Mark(this.mPos);
    }

    public synchronized void seek(OtdInputStreamMark mark) throws IOException {
        if (mark == null) {
            throw new NullPointerException("no mark");
        }
        if (!(mark instanceof Mark)) {
            throw new NullPointerException("foreign mark");
        }
        Mark m = (Mark)mark;
        if (m.mPos < this.mPos) {
            this.rewind();
        }
        this.skip(m.mPos - this.mPos);
    }

    public int read() throws IOException {
        int result = this.mIn.read();
        if (this.mPos++ > Integer.MAX_VALUE) {
            throw new IOException("exceeded rewindable size: 2147483647");
        }
        return result;
    }

    public boolean eof() throws IOException {
        throw new IOException("eof() not yet implemented...");
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public synchronized int read(byte[] b, int off, int len) throws IOException {
        int result = this.mIn.read(b, off, len);
        this.mPos += (long)len;
        if (this.mPos > Integer.MAX_VALUE) {
            throw new IOException("exceeded rewindable size: 2147483647");
        }
        return result;
    }

    public void rewind() throws IOException {
        this.mIn.reset();
        this.mPos = 0L;
    }

    public void skip(long count) throws IOException {
        if (count < 0L) {
            throw new IllegalArgumentException("negative count");
        }
        long did = this.mIn.skip(count);
        if (did != count) {
            throw new IOException("tried to skip " + count + ", did " + did);
        }
        this.mPos += count;
        if (this.mPos > Integer.MAX_VALUE) {
            throw new IOException("exceeded rewindable size: 2147483647");
        }
    }

    private static class Mark
    implements OtdInputStreamMark {
        public final long mPos;

        public Mark(long pos) {
            this.mPos = pos;
        }

        public long offset() {
            return this.mPos;
        }
    }
}

