/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.runtime.provider;

import com.stc.otd.runtime.CoderException;
import com.stc.otd.runtime.provider.SharedCoder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;

public class SingleByteCoder
extends SharedCoder {
    private static final int BYTES = 256;
    public static final int NOCHAR = -1;
    public static final short NOBYTE = -1;
    private final int[] mByte2Char = new int[256];
    private final short[][] mChar2Byte = new short[256][];
    private int mSurrogateChar = -1;
    private short mSurrogateByte = (short)-1;
    private byte mPaddingByte = (byte)32;
    static /* synthetic */ Class class$com$stc$otd$runtime$provider$SingleByteCoder;

    public SingleByteCoder(int[] codes, int sChar, short sByte) {
        if (codes == null) {
            throw new NullPointerException("no codes");
        }
        if (codes.length != 256) {
            throw new IllegalArgumentException("wrong code list size: " + codes.length + ", should be " + 256);
        }
        for (int i = 0; i < 256; ++i) {
            this.add((byte)i, codes[i]);
        }
        this.mSurrogateChar = sChar;
        this.mSurrogateByte = sByte;
    }

    public SingleByteCoder(File input) throws IOException {
        FileInputStream is = new FileInputStream(input);
        this.add(input.getPath(), is);
        ((InputStream)is).close();
    }

    public SingleByteCoder(String resource) throws IOException {
        ClassLoader loader = (class$com$stc$otd$runtime$provider$SingleByteCoder == null ? (class$com$stc$otd$runtime$provider$SingleByteCoder = SingleByteCoder.class$("com.stc.otd.runtime.provider.SingleByteCoder")) : class$com$stc$otd$runtime$provider$SingleByteCoder).getClassLoader();
        System.out.println("[ loading resource " + resource + " ]");
        InputStream is = loader.getResourceAsStream(resource);
        if (is == null) {
            throw new IOException("can't find code table resource '" + resource + "'");
        }
        this.add(resource, is);
        is.close();
    }

    private int getHexNumber(String path, LineNumberReader in, String s, String what, int max) throws IOException {
        try {
            s = s.trim();
            int n = Integer.parseInt(s, 16);
            if (n < 0 || max < n) {
                throw new IOException(path + " line " + in.getLineNumber() + ": invalid " + what + " value '" + s + "'");
            }
            return n;
        }
        catch (NumberFormatException n) {
            throw new IOException(path + " line " + in.getLineNumber() + ": malformed " + what + " value '" + s + "'");
        }
    }

    public void add(String path, InputStream is) throws IOException {
        String line;
        LineNumberReader in;
        if (is == null) {
            throw new NullPointerException("no input stream");
        }
        try {
            in = new LineNumberReader(new BufferedReader(new InputStreamReader(is, "UTF-8")));
        }
        catch (UnsupportedEncodingException u) {
            throw new RuntimeException("broken platform");
        }
        for (int i = 0; i < 256; ++i) {
            this.mByte2Char[i] = -1;
        }
        while ((line = in.readLine()) != null) {
            if (line.length() <= 0 || line.startsWith("#")) continue;
            if (line.startsWith("@byte")) {
                this.mSurrogateByte = (short)this.getHexNumber(path, in, line.substring(5), "byte", 255);
                continue;
            }
            if (line.startsWith("@char")) {
                this.mSurrogateChar = this.getHexNumber(path, in, line.substring(5), "char", 65533);
                continue;
            }
            if (line.startsWith("@fill")) {
                this.mPaddingByte = (byte)this.getHexNumber(path, in, line.substring(5), "fill", 255);
                continue;
            }
            int pos = line.indexOf(61);
            if (pos < 0) {
                throw new IOException(path + " line " + in.getLineNumber() + ": missing '='");
            }
            String b = line.substring(0, pos);
            String s = line.substring(pos + 1);
            byte nbyte = (byte)this.getHexNumber(path, in, b, "byte", 255);
            int nchar = this.getHexNumber(path, in, s, "char", 65533);
            this.add(nbyte, nchar);
        }
        in.close();
    }

    private void add(byte b, int c) {
        if (c < -1 || 65533 <= c) {
            throw new IllegalArgumentException("byte " + b + " maps to invalid code " + SingleByteCoder.uname(c));
        }
        this.mByte2Char[b & 0xFF] = c;
        if (this.mByte2Char[b & 0xFF] >= 0) {
            int lo = c & 0xFF;
            int hi = c >> 8 & 0xFF;
            if (this.mChar2Byte[hi] == null) {
                this.mChar2Byte[hi] = new short[256];
                short[] s = this.mChar2Byte[hi];
                for (int j = 0; j < 256; ++j) {
                    s[j] = -1;
                }
            }
            this.mChar2Byte[hi][lo] = (short)(b & 0xFF);
        }
    }

    public byte[] encode(String in, int min, int max) throws CoderException {
        if (in == null) {
            return null;
        }
        if (0 <= min && 0 <= max && max < min) {
            throw new IllegalArgumentException("max (" + max + ") < min (" + min + ")");
        }
        int len = in.length();
        int size = len;
        if (size < min) {
            size = min;
        }
        if (0 <= max && max < size) {
            throw new CoderException("too big: " + size + ", max=" + max);
        }
        byte[] out = new byte[size];
        size = 0;
        for (int i = 0; i < len; ++i) {
            char c = in.charAt(i);
            short[] map = this.mChar2Byte[c >> 8 & 0xFF];
            int b = map == null ? -1 : map[c & 0xFF];
            if (b == -1) {
                short s = this.mSurrogateByte;
                b = s;
                if (s == -1) {
                    throw new CoderException("char #" + i + " = " + SingleByteCoder.uname(c) + ", not encodable");
                }
            }
            out[size++] = (byte)b;
        }
        while (size < out.length) {
            out[size++] = this.mPaddingByte;
        }
        return out;
    }

    public String decode(byte[] in, int from, int length) throws CoderException {
        if (in == null) {
            return null;
        }
        if (from < 0 || in.length < from || length < 0 || in.length < from + length) {
            throw new CoderException("invalid size/from/length: " + in.length + "/" + from + "/" + length);
        }
        char[] out = new char[length];
        int size = 0;
        int last = from + length;
        for (int i = from; i < last; ++i) {
            int c = this.mByte2Char[in[i] & 0xFF];
            if (c == -1 && (c = this.mSurrogateChar) == -1) {
                throw new CoderException(i, "code = " + SingleByteCoder.bname(in[i]) + ", not decodable");
            }
            out[size++] = (char)c;
        }
        return new String(out);
    }

    public void dump(PrintStream ps) {
        ps.println("# Single-byte encoding map dump.");
        ps.println("#-------------------------------");
        ps.println();
        if (this.mSurrogateByte >= 0) {
            ps.println("@byte " + SingleByteCoder.hex2(this.mSurrogateByte));
            ps.println();
        }
        if (this.mSurrogateChar >= 0) {
            ps.println("@char " + SingleByteCoder.hex4(this.mSurrogateByte));
            ps.println();
        }
        for (int i = 0; i < 256; ++i) {
            if (this.mByte2Char[i] < 0) continue;
            ps.println(SingleByteCoder.hex2(i) + " = " + SingleByteCoder.hex4(this.mByte2Char[i]));
        }
    }

    public static void main(String[] args) {
        try {
            boolean res = false;
            String path = "my.code";
            int opt = 0;
            if (args.length > opt && args[opt].equals("-r")) {
                res = true;
                ++opt;
            }
            if (args.length > opt) {
                path = args[opt++];
            }
            SingleByteCoder sbc = res ? new SingleByteCoder(path) : new SingleByteCoder(new File(path));
            sbc.dump(System.out);
        }
        catch (Exception all) {
            all.printStackTrace(System.err);
            System.exit(1);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

