/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import java.util.HashMap;
import java.util.Map;

public class NamespaceMap {
    private Map mPrefix2URIMap = new HashMap();
    private Map mURI2PrefixMap = new HashMap();

    public void addNamespaceDecl(String prefix, String namespaceURI) {
        if (prefix == null) {
            throw new IllegalArgumentException("prefix cannot be null");
        }
        if (namespaceURI == null) {
            throw new IllegalArgumentException("namespace URI cannot be null");
        }
        if (namespaceURI.length() == 0) {
            throw new IllegalArgumentException("namespace URI cannot be empty");
        }
        this.mPrefix2URIMap.put(prefix, namespaceURI);
        this.mURI2PrefixMap.put(namespaceURI, prefix);
    }

    public void removeNamespaceDecl(String prefix) {
        if (prefix == null) {
            return;
        }
        String namespaceURI = (String)this.mPrefix2URIMap.get(prefix);
        this.mPrefix2URIMap.remove(prefix);
        String prefixFound = (String)this.mURI2PrefixMap.get(namespaceURI);
        if (prefix.equals(prefixFound)) {
            this.mURI2PrefixMap.remove(namespaceURI);
        }
    }

    public void clear() {
        this.mPrefix2URIMap.clear();
        this.mURI2PrefixMap.clear();
    }

    public boolean isEmpty() {
        return this.mPrefix2URIMap.isEmpty();
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            return null;
        }
        return (String)this.mPrefix2URIMap.get(prefix);
    }

    public String getPrefix(String namespaceURI) {
        if (namespaceURI == null) {
            return null;
        }
        return (String)this.mURI2PrefixMap.get(namespaceURI);
    }
}

