/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

public class NormalSafe {
    static boolean mShowSpace = false;

    public static String encode(String s) {
        StringBuffer sb = new StringBuffer();
        NormalSafe.encode(sb, s);
        return sb.toString();
    }

    public static void encode(StringBuffer sb, String s) {
        int last = s.length() - 1;
        if (mShowSpace) {
            boolean spc = true;
            for (int i = 0; i < last; ++i) {
                char c = s.charAt(i);
                if (!spc && c == ' ') {
                    sb.append(' ');
                    spc = true;
                    continue;
                }
                if (c == '\\' && s.charAt(i + 1) == 'u') {
                    sb.append(c);
                    spc = false;
                    continue;
                }
                NormalSafe.encode(sb, c);
                spc = false;
            }
            if (last >= 0) {
                NormalSafe.encode(sb, s.charAt(last));
            }
        } else {
            for (int i = 0; i <= last; ++i) {
                NormalSafe.encode(sb, s.charAt(i));
            }
        }
    }

    public static void encode(StringBuffer sb, int c) {
        boolean esc = false;
        switch (c) {
            case 34: 
            case 38: 
            case 39: 
            case 60: 
            case 62: 
            case 92: {
                esc = true;
                break;
            }
            default: {
                boolean bl = esc = c < 33 || 126 < c;
            }
        }
        if (esc) {
            sb.append('\\');
            sb.append('u');
            NormalSafe.numOut(sb, c, 4, 16);
        } else {
            sb.append((char)c);
        }
    }

    private static void numOut(StringBuffer sb, int num, int len, int base) {
        char[] c = new char[len];
        while (len-- > 0) {
            c[len] = "0123456789abcdef".charAt(num % base);
            num /= base;
        }
        sb.append(c);
    }

    public static String decode(String s) {
        if (s.indexOf(92) < 0) {
            return s;
        }
        int len = s.length();
        StringBuffer b = new StringBuffer(len);
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                if (i + 6 > len) {
                    throw new RuntimeException("'\\u' escape truncated");
                }
                if (s.charAt(i + 1) != 'u') {
                    throw new RuntimeException("missing 'u' after '\\'");
                }
                int d1 = NormalSafe.hexval(s.charAt(i + 2));
                int d2 = NormalSafe.hexval(s.charAt(i + 3));
                int d3 = NormalSafe.hexval(s.charAt(i + 4));
                int d4 = NormalSafe.hexval(s.charAt(i + 5));
                if (d1 < 0 || d2 < 0 || d3 < 0 || d4 < 0) {
                    throw new RuntimeException("non-hex digit after '\\u'");
                }
                c = (char)((d1 << 12) + (d2 << 8) + (d3 << 4) + d4);
                i += 5;
            }
            b.append(c);
        }
        return b.toString();
    }

    public static int hexval(char c) {
        if ('0' <= c && c <= '9') {
            return c - 48;
        }
        if ('a' <= c && c <= 'f') {
            return c - 97 + 10;
        }
        if ('A' <= c && c <= 'F') {
            return c - 65 + 10;
        }
        return -1;
    }

    public static void main(String[] args) throws Exception {
        String s = NormalSafe.encode("See\"Beyond<\n\r\tTech.>Corp.");
        System.out.println(s);
        s = NormalSafe.decode(s);
        System.out.println(s);
    }
}

