/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.ObjectTypeDefinition51;
import com.stc.otd.fog.FogException;
import com.stc.otd.fog.FogOtdNotFoundException;
import com.stc.otd.fog.FpiType;
import com.stc.otd.fog.provider.FogIOException;
import com.stc.otd.fog.provider.XmlIn;
import com.stc.otd.fog.provider.XmlOut;
import com.stc.otd.model.OTDHead;
import com.stc.otd.model.OtdPlugIn;
import com.stc.otd.model.provider.OTDHeadImpl;
import com.stc.otd.model.provider.OtdPlugInImpl;
import com.stc.otd.tools.util.OTDPathUtil;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import com.stc.util.UnicodeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.LineNumberReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.apache.log4j.Logger;

public class OtdHeadParser {
    private static Map mHeads = new WeakHashMap();
    private static Logger mLogger = Logger.getLogger((Class)(class$com$stc$otd$tools$xml$OtdHeadParser == null ? (class$com$stc$otd$tools$xml$OtdHeadParser = OtdHeadParser.class$("com.stc.otd.tools.xml.OtdHeadParser")) : class$com$stc$otd$tools$xml$OtdHeadParser));
    static /* synthetic */ Class class$com$stc$otd$tools$xml$OtdHeadParser;

    public static synchronized OTDHead getOTDHead(Repository rep, String path) throws RepositoryException, FogException {
        if (path == null) {
            throw new RuntimeException("Otd head path is null");
        }
        ObjectTypeDefinition otd = OTDPathUtil.getOTD((Repository)rep, (String)path);
        OTDHead head = null;
        if (otd instanceof ObjectTypeDefinition51) {
            String header = ((ObjectTypeDefinition51)otd).getHead();
            String leadRef = ((ObjectTypeDefinition51)otd).getLead();
            if (header != null && leadRef == null) {
                head = OtdHeadParser.getOTDHead(header);
                head.setContent(null);
                head.setPath(path);
            }
            if (header == null && leadRef != null) {
                head = OtdHeadParser.getOTDHead(rep, leadRef);
                head.setContent(null);
                head.setPath(leadRef);
            }
            if (header != null && leadRef != null) {
                head = OtdHeadParser.getOTDHead(header);
                if (!leadRef.equals(path)) {
                    OTDHead refHead = OtdHeadParser.getOTDHead(rep, leadRef);
                    head.inherit(refHead);
                }
                head.setContent(header);
                head.setPath(leadRef);
            }
        }
        return head;
    }

    public static synchronized OTDHead getOTDHead(String header, Repository rep, String leadRef) throws RepositoryException, FogException {
        if (leadRef == null && header == null) {
            return null;
        }
        OTDHead head = null;
        if (header != null && leadRef == null) {
            head = OtdHeadParser.getOTDHead(header);
            head.setContent(header);
        }
        if (header == null && leadRef != null) {
            head = OtdHeadParser.getOTDHead(rep, leadRef);
            head.setContent(null);
            head.setPath(leadRef);
        }
        if (header != null && leadRef != null) {
            head = OtdHeadParser.getOTDHead(header);
            OTDHead refHead = OtdHeadParser.getOTDHead(rep, leadRef);
            head.inherit(refHead);
            head.setContent(header);
            head.setPath(leadRef);
        }
        return head;
    }

    public static synchronized OTDHead getOTDHead(File type) throws FogException, FogOtdNotFoundException {
        if (type == null) {
            throw new FogIOException("error loading plugin data for fog type, null input stream");
        }
        try {
            return OtdHeadParser.getOTDHead(UnicodeFile.getText(type));
        }
        catch (FileNotFoundException fnf) {
            throw new FogOtdNotFoundException("cannot find head", type.getPath(), (Throwable)fnf);
        }
        catch (IOException ie) {
            throw new FogIOException("cannot get head", (Throwable)ie);
        }
    }

    public static synchronized OTDHead getOTDHead(String data) throws FogException {
        if (data == null) {
            return null;
        }
        LineNumberReader lnr = new LineNumberReader(new BufferedReader(new StringReader(data)));
        XmlIn in = new XmlIn(lnr);
        XmlIn.Token token = in.next();
        if (token.mType != 6) {
            in.barf(token, "expecting a tag with type [," + 6 + "] got " + token.mType);
        }
        if (!"OTDHead".equals(token.mName)) {
            in.barf(token, "expecting new <OTDHead>, got <" + token.mName + ">");
        }
        OTDHeadImpl head = new OTDHeadImpl();
        XMLReader.readOTDHead(in, token, (OTDHead)head);
        return head;
    }

    public static synchronized String serializeOTDHead(OTDHead head) throws FogException {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        XmlOut out = new XmlOut(pw);
        XMLWriter.writeOtdHead(out, head);
        out.flush();
        return sw.toString();
    }

    private static synchronized OTDHead getOTDHead(ObjectTypeDefinition51 otd) throws RepositoryException, FogException {
        OTDHead head = null;
        String header = otd.getHead();
        if (header != null) {
            head = OtdHeadParser.getOTDHead(header);
        }
        return head;
    }

    private static synchronized OTDHead getOTDHead(Repository rep, ObjectTypeDefinition51 otd) throws RepositoryException, FogException {
        OTDHead head = null;
        String header = otd.getHead();
        String leadRef = otd.getLead();
        if (header != null) {
            head = OtdHeadParser.getOTDHead(header);
        } else if (leadRef != null) {
            ObjectTypeDefinition51 lead = (ObjectTypeDefinition51)OTDPathUtil.getOTD((Repository)rep, (String)leadRef);
            head = OtdHeadParser.getOTDHead(lead);
            head.setPath(leadRef);
        }
        return head;
    }

    private static synchronized void setOTDHead() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class XMLWriter {
        public static void writeOtdHead(XmlOut out, OTDHead head) throws FogException {
            out.enter("OTDHead");
            if (head != null) {
                if (head.getExtRefs() != null) {
                    XMLWriter.writeExtRefs(out, head.getExtRefs());
                }
                XMLWriter.writeRoot(out, head.hasRoot());
            }
            out.leave("OTDHead");
        }

        public static void writeExtRefs(XmlOut out, Map extRefs) throws FogException {
            mLogger.debug((Object)"[write extRefs]");
            if (!extRefs.isEmpty()) {
                out.enter("extrefs");
                Iterator it = extRefs.keySet().iterator();
                while (it.hasNext()) {
                    String id = (String)it.next();
                    String link = (String)extRefs.get(id);
                    out.enter("extref");
                    out.attr("id", id);
                    out.attr("link", link);
                    out.leave("extref");
                }
                out.leave("extrefs");
            }
        }

        public static void writeRoot(XmlOut out, boolean hasRoot) throws FogException {
            mLogger.debug((Object)"[write root]");
            out.enter("root");
            out.attr("hasRoot", hasRoot);
            out.leave("root");
        }
    }

    public static class XMLReader {
        public static void readOTDHead(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            XmlIn.Token token;
            mLogger.debug((Object)"[ enter OTDHead ]");
            if (!"OTDHead".equals(tag.mName)) {
                throw new IllegalArgumentException("not an <OTDHead>");
            }
            while (true) {
                token = in.next();
                if (token.mType != 6) break;
                if ("root".equals(token.mName)) {
                    XMLReader.readRoot(in, token, head);
                    continue;
                }
                if ("extrefs".equals(token.mName)) {
                    XMLReader.readExtRefs(in, token, head);
                    continue;
                }
                if ("plugins".equals(token.mName)) {
                    XMLReader.readPlugIns(in, token, head);
                    continue;
                }
                if ("generator".equals(token.mName)) {
                    XMLReader.readGen(in, token, head);
                    continue;
                }
                if ("type".equals(token.mName)) {
                    XMLReader.readOTDType(in, token, head);
                    continue;
                }
                if ("classpath".equals(token.mName)) {
                    XMLReader.readClassPath(in, token, head);
                    continue;
                }
                in.barf(token, "<OTDHead> cannot contain <" + token.mName + ">");
            }
            XMLReader.readEnd(in, token, "OTDHead");
        }

        public static void readPlugIn(XmlIn in, XmlIn.Token tag, FpiType type) throws FogException {
            mLogger.debug((Object)"[ enter readPlugIn ]");
            if (!"plugin".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <plugin>");
            }
            String jar = tag.takeAttr("jar");
            String pack = tag.takeOptAttr("package", null);
            String version = tag.takeOptAttr("version", null);
            if (jar == null || pack == null) {
                throw new IllegalArgumentException("no jar or package attrib in <plugin>");
            }
            type.addPlugIn(jar, pack, version, null);
            tag.close();
            XMLReader.readEnd(in, in.next(), "plugin");
        }

        public static OtdPlugIn readPlugIn(XmlIn in, XmlIn.Token tag) throws FogException {
            mLogger.debug((Object)"[ enter readPlugIn ]");
            if (!"plugin".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <plugin>");
            }
            String jar = tag.takeAttr("jar");
            String pack = tag.takeOptAttr("package", null);
            String version = tag.takeOptAttr("version", null);
            if (jar == null || pack == null) {
                throw new IllegalArgumentException("no jar or package attrib in <plugin>");
            }
            OtdPlugInImpl plugin = new OtdPlugInImpl(jar, pack, version);
            tag.close();
            XMLReader.readEnd(in, in.next(), "plugin");
            return plugin;
        }

        public static void readPlugIns(XmlIn in, XmlIn.Token tag, FpiType type) throws FogException {
            XmlIn.Token token;
            mLogger.debug((Object)"[ enter readPlugIns ]");
            if (!"plugins".equals(tag.mName)) {
                throw new IllegalArgumentException("not a <plugins>");
            }
            while (true) {
                token = in.next();
                if (token.mType != 6) break;
                if ("plugin".equals(token.mName)) {
                    XMLReader.readPlugIn(in, token, type);
                    continue;
                }
                in.barf(token, "<plugins> cannot contain <" + token.mName + ">");
            }
            XMLReader.readEnd(in, token, "plugins");
        }

        public static void readPlugIns(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            XmlIn.Token token;
            mLogger.debug((Object)"[ enter readPlugIns ]");
            if (!"plugins".equals(tag.mName)) {
                throw new IllegalArgumentException("not a <plugins>");
            }
            ArrayList<OtdPlugIn> plugins = new ArrayList<OtdPlugIn>();
            while (true) {
                token = in.next();
                if (token.mType != 6) break;
                if ("plugin".equals(token.mName)) {
                    plugins.add(XMLReader.readPlugIn(in, token));
                    continue;
                }
                in.barf(token, "<plugins> cannot contain <" + token.mName + ">");
            }
            head.setPlugIns(plugins);
            XMLReader.readEnd(in, token, "plugins");
        }

        public static void readExtRefs(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            XmlIn.Token token;
            mLogger.debug((Object)"[ enter readExtRefs ]");
            if (!"extrefs".equals(tag.mName)) {
                throw new IllegalArgumentException("not a <extrefs>");
            }
            HashMap exRefs = new HashMap();
            while (true) {
                token = in.next();
                if (token.mType != 6) break;
                if ("extref".equals(token.mName)) {
                    XMLReader.readExtRef(in, token, exRefs);
                    continue;
                }
                in.barf(token, "<extrefs> cannot contain <" + token.mName + ">");
            }
            head.setExtRefs(exRefs);
            XMLReader.readEnd(in, token, "extrefs");
        }

        public static void readRoot(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            mLogger.debug((Object)"[ enter readRoot]");
            if (!"root".equals(tag.mName)) {
                throw new IllegalArgumentException("not a <bean>");
            }
            String root = tag.takeOptAttr("hasRoot", "true");
            boolean hasRoot = true;
            if ("false".equals(root)) {
                hasRoot = false;
            }
            head.setRootFlag(hasRoot);
            tag.close();
            XMLReader.readEnd(in, in.next(), "root");
        }

        public static void readExtRef(XmlIn in, XmlIn.Token tag, Map refs) throws FogException {
            mLogger.debug((Object)"[ enter readExtRef ]");
            if (!"extref".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <extref>");
            }
            String id = tag.takeAttr("id");
            String link = tag.takeAttr("link");
            if (id == null || link == null) {
                throw new IllegalArgumentException("no id or link attrib in <extref>");
            }
            refs.put(id, link);
            tag.close();
            XMLReader.readEnd(in, in.next(), "extref");
        }

        public static void readOTDType(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            mLogger.debug((Object)"[ enter type ]");
            if (!"type".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <type>");
            }
            String otdType = tag.takeAttr("name");
            if (otdType == null) {
                throw new IllegalArgumentException("no name attrib in <type>");
            }
            head.setOTDType(otdType);
            tag.close();
            XMLReader.readEnd(in, in.next(), "type");
        }

        public static void readGen(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            mLogger.debug((Object)"[ enter generator ]");
            if (!"generator".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <generator>");
            }
            String gen = tag.takeAttr("name");
            String api = tag.takeAttr("API");
            String edit = tag.takeOptAttr("editable", "true");
            head.setGenerator(gen);
            head.setGenAPI(api);
            boolean editable = true;
            if ("false".equals(edit)) {
                editable = false;
            }
            head.setEdit(editable);
            tag.close();
            XMLReader.readEnd(in, in.next(), "generator");
        }

        public static void readClassPath(XmlIn in, XmlIn.Token tag, OTDHead head) throws FogException {
            mLogger.debug((Object)"[ enter classpath ]");
            if (!"classpath".equals(tag.mName)) {
                throw new IllegalArgumentException(tag.mName + " is not a <classpath>");
            }
            String jarfile = tag.takeOptAttr("jarfile", null);
            String api = tag.takeOptAttr("repositoryapi", null);
            head.setJarFiles(XMLReader.getEle(jarfile));
            head.setRepositorySysID(XMLReader.getEle(api));
            tag.close();
            XMLReader.readEnd(in, in.next(), "generator");
        }

        private static void readEnd(XmlIn in, XmlIn.Token token, String at) throws FogException {
            if (token.mType == 6) {
                in.barf(token, "<" + at + "> cannot contain <" + token.mName + ">");
            }
            if (token.mType != 3) {
                in.barf(token, "unexpected token type #" + token.mType + " in <" + at + '>');
            }
        }

        private static Set getEle(String serial) {
            if (serial == null || serial.equals("")) {
                return null;
            }
            String[] eles = serial.split(";");
            HashSet<String> result = new HashSet<String>();
            for (int i = 0; i < eles.length; ++i) {
                result.add(eles[i]);
            }
            return result;
        }
    }
}

