/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import com.stc.otd.tools.xml.Location;
import org.xml.sax.Locator;
import org.xml.sax.helpers.LocatorImpl;

public class ParseEvent {
    public static final int PARSE_EVENT = 0;
    public static final int START_DOCUMENT = 1;
    public static final int END_DOCUMENT = 2;
    public static final int START_ELEMENT = 3;
    public static final int END_ELEMENT = 4;
    public static final int CHARACTERS = 5;
    public static final int PROCESSING_INSTRUCTION = 6;
    public static final int PARSE_EXCEPTION = 10;
    public static final int ERROR = 11;
    public static final int FATAL_ERROR = 12;
    public static final int WARNING = 13;
    public Locator location;
    public int type;
    private long mOffset;

    public ParseEvent(Locator locator) {
        this.location = locator;
        this.type = 0;
    }

    public ParseEvent(Location location) {
        LocatorImpl locator = new LocatorImpl();
        locator.setColumnNumber(location.getColumn());
        locator.setLineNumber(location.getLine());
        this.location = locator;
        this.mOffset = location.getOffset();
        this.type = 0;
    }

    public final int getType() {
        return this.type;
    }

    public String locString() {
        String msg = "";
        if (this.location != null) {
            String sysId = this.location.getSystemId();
            if (sysId != null) {
                msg = sysId + ",";
            }
            msg = msg + "line " + this.location.getLineNumber() + " column " + this.location.getColumnNumber();
        }
        return msg;
    }

    public String toString() {
        String msg = "";
        if (this.location != null) {
            String sysId = this.location.getSystemId();
            if (sysId != null) {
                msg = sysId + ",";
            }
            msg = msg + "line " + this.location.getLineNumber() + " column " + this.location.getColumnNumber();
        }
        return msg;
    }

    public long getOffset() {
        return this.mOffset;
    }

    public String toXML() {
        return this.toString();
    }
}

