/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.DefaultHandler;

public class SAX2Writer
extends DefaultHandler {
    private static final String DEFAULT_PARSER_NAME = "org.apache.xerces.parsers.SAXParser";
    private int numOpenElements = 0;
    private boolean escapeNonAscii = false;
    protected String encoding = null;
    private boolean mPretty = false;
    private String mIndentation = "    ";
    private int mIndentationLen = this.mIndentation.length();
    private String mIndent = "";
    private int mIndentLen = 0;
    private HashMap prefixMap = new HashMap();
    private HashMap reversedPrefixMap = new HashMap();
    private boolean namespacesDeclared = false;
    protected boolean canonical;
    protected BufferedWriter out;
    private boolean mIndentEnd;
    private boolean mNeedEndNL;
    private boolean mNeedStartNL;

    public SAX2Writer(boolean canonical) throws UnsupportedEncodingException {
        this(null, canonical, null);
    }

    public SAX2Writer(boolean canonical, OutputStream stream) throws UnsupportedEncodingException {
        this(null, canonical, stream);
    }

    public SAX2Writer(String encoding, boolean canonical, OutputStream stream) throws UnsupportedEncodingException {
        if (encoding == null) {
            encoding = "UTF-8";
        }
        if (stream == null) {
            stream = System.out;
        }
        this.out = new BufferedWriter(new OutputStreamWriter(stream, encoding));
        this.canonical = canonical;
        this.encoding = encoding;
    }

    public SAX2Writer(boolean canonical, Writer writer) {
        this.out = new BufferedWriter(writer);
        this.canonical = canonical;
    }

    public SAX2Writer(boolean canonical, PrintWriter writer) {
        this.out = new BufferedWriter(writer);
        this.canonical = canonical;
    }

    public static void main(String[] argv) {
        if (argv.length == 0) {
            SAX2Writer.printUsage();
            System.exit(1);
        }
        String parserName = DEFAULT_PARSER_NAME;
        boolean canonical = false;
        for (int i = 0; i < argv.length; ++i) {
            String arg = argv[i];
            if (arg.startsWith("-")) {
                if (arg.equals("-p")) {
                    if (i == argv.length - 1) {
                        System.err.println("error: missing parser name");
                        System.exit(1);
                    }
                    parserName = argv[++i];
                    continue;
                }
                if (arg.equals("-c")) {
                    canonical = true;
                    continue;
                }
                if (arg.equals("-h")) {
                    SAX2Writer.printUsage();
                    System.exit(1);
                }
            }
            System.err.println(arg + ':');
            SAX2Writer.print(parserName, arg, canonical);
            System.out.println();
        }
    }

    public static void print(String parserName, String uri, boolean canonical) {
        try {
            SAX2Writer handler = new SAX2Writer(canonical);
            XMLReader parser = (XMLReader)Class.forName(parserName).newInstance();
            parser.setContentHandler(handler);
            parser.setErrorHandler(handler);
            parser.parse(uri);
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (InstantiationException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
    }

    private static void printUsage() {
        System.err.println("usage: java sax.SAX2Writer (options) uri ...");
        System.err.println();
        System.err.println("options:");
        System.err.println("  -p name  Specify SAX parser by name.");
        System.err.println("           Default parser: org.apache.xerces.parsers.SAXParser");
        System.err.println("  -c       Canonical XML output.");
        System.err.println("  -h       This help screen.");
    }

    public boolean getEscapeNonAscii() {
        return this.escapeNonAscii;
    }

    public Writer getWriter() {
        return this.out;
    }

    public void setEscapeNonAscii(boolean val) {
        this.escapeNonAscii = val;
    }

    public void setIndentation(String val) {
        this.mIndentation = val;
        this.mIndentationLen = val.length();
    }

    public void setPrettyPrint(boolean val) {
        this.mPretty = val;
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.normalizeCharacters(ch, start, length, this.out);
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
        this.mNeedStartNL = false;
        this.mNeedEndNL = false;
        this.mIndentEnd = false;
    }

    public void emptyElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        try {
            if (this.mPretty) {
                if (this.mNeedStartNL) {
                    this.out.newLine();
                }
                this.printIndent();
            }
            this.out.write(60);
            this.out.write(raw, 0, raw.length());
            if (attrs != null) {
                if (this.mPretty) {
                    attrs = this.sortAttributes(attrs);
                }
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    this.out.write(32);
                    String qName = attrs.getQName(i);
                    this.out.write(qName, 0, qName.length());
                    this.out.write(61);
                    this.out.write(34);
                    this.normalize(attrs.getValue(i), this.out);
                    this.out.write(34);
                }
            }
            this.out.write(47);
            this.out.write(62);
            if (this.numOpenElements == 0) {
                this.out.flush();
            }
            if (this.mPretty) {
                this.mNeedStartNL = true;
                this.mNeedEndNL = true;
                this.mIndentEnd = true;
            }
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    public void endDocument() throws SAXException {
        try {
            this.out.flush();
            this.out.close();
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    public void endElement(String uri, String local, String raw) throws SAXException {
        try {
            if (this.mPretty) {
                if (this.mNeedEndNL) {
                    this.out.newLine();
                }
                if (this.mIndentEnd) {
                    this.undent();
                    this.printIndent();
                    this.indent();
                }
            }
            this.out.write(60);
            this.out.write(47);
            this.out.write(raw, 0, raw.length());
            this.out.write(62);
            --this.numOpenElements;
            if (this.numOpenElements == 0) {
                this.out.flush();
            }
            if (this.mPretty) {
                this.undent();
                this.mIndentEnd = true;
                this.mNeedEndNL = true;
                this.mNeedStartNL = true;
            }
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    public void endPrefixMapping(String prefix) {
        this.reversedPrefixMap.remove(this.prefixMap.get(prefix));
        this.prefixMap.remove(prefix);
    }

    public HashMap getPrefixHashMap() {
        return this.prefixMap;
    }

    public void error(SAXParseException ex) {
        System.err.println("[Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        System.err.println("[Fatal Error] " + this.getLocationString(ex) + ": " + ex.getMessage());
        throw ex;
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
        this.characters(ch, start, length);
    }

    public void processingInstruction(String target, String data) throws SAXException {
        try {
            this.out.write(60);
            this.out.write(63);
            this.out.write(target, 0, target.length());
            if (data != null && data.length() > 0) {
                this.out.write(32);
                this.out.write(data, 0, data.length());
            }
            this.out.write(63);
            this.out.write(62);
            this.out.write(13);
            this.out.write(10);
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    public void startDocument() {
        this.mIndent = "";
        this.mIndentLen = 0;
        this.mNeedStartNL = false;
        this.mNeedEndNL = false;
        this.mIndentEnd = false;
    }

    public void startElement(String uri, String local, String raw, Attributes attrs) throws SAXException {
        try {
            if (this.mPretty) {
                if (this.mNeedStartNL) {
                    this.out.newLine();
                }
                this.printIndent();
            }
            ++this.numOpenElements;
            this.out.write(60);
            this.out.write(raw, 0, raw.length());
            if (attrs != null) {
                if (this.mPretty) {
                    attrs = this.sortAttributes(attrs);
                }
                HashSet<String> attrQNameWritten = new HashSet<String>();
                if (!this.namespacesDeclared) {
                    this.namespacesDeclared = true;
                    Iterator iter = this.prefixMap.keySet().iterator();
                    while (iter.hasNext()) {
                        String prefix = (String)iter.next();
                        String ns = (String)this.prefixMap.get(prefix);
                        if (ns.length() <= 0) continue;
                        String attrName = "xmlns";
                        if (prefix.length() > 0) {
                            attrName = attrName + ":" + prefix;
                        }
                        this.out.write(32);
                        this.out.write(attrName, 0, attrName.length());
                        this.out.write(61);
                        this.out.write(34);
                        this.normalize(ns, this.out);
                        this.out.write(34);
                        attrQNameWritten.add(attrName);
                    }
                }
                int len = attrs.getLength();
                for (int i = 0; i < len; ++i) {
                    this.out.write(32);
                    String qName = attrs.getQName(i);
                    if (qName == null || qName.length() == 0) {
                        qName = attrs.getLocalName(i);
                        String attrURI = attrs.getURI(i);
                        if (attrURI != null && attrURI.length() > 0) {
                            if (this.reversedPrefixMap.get(attrURI) != null) {
                                String prefix = (String)this.reversedPrefixMap.get(attrURI);
                                if (prefix.length() > 0) {
                                    qName = prefix + ":" + attrs.getLocalName(i);
                                }
                            } else if (attrURI.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                                qName = "xsi:" + attrs.getLocalName(i);
                            } else {
                                throw new SAXException("Missing prefix map for '" + attrURI + "'");
                            }
                        }
                    }
                    if (attrQNameWritten.contains(qName)) continue;
                    this.out.write(qName, 0, qName.length());
                    this.out.write(61);
                    this.out.write(34);
                    this.normalize(attrs.getValue(i), this.out);
                    this.out.write(34);
                }
            }
            this.out.write(62);
            if (this.mPretty) {
                this.mNeedStartNL = true;
                this.mNeedEndNL = false;
                this.mIndentEnd = false;
                this.indent();
            }
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    public void startPrefixMapping(String prefix, String uri) {
        this.prefixMap.put(prefix, uri);
        this.reversedPrefixMap.put(uri, prefix);
    }

    public void warning(SAXParseException ex) {
        System.err.println("[Warning] " + this.getLocationString(ex) + ": " + ex.getMessage());
    }

    public void writeString(String str) throws SAXException {
        try {
            this.out.write(str, 0, str.length());
        }
        catch (IOException exc) {
            throw new SAXException(exc);
        }
    }

    protected void normalize(char[] chs, int start, int len, Writer out) throws IOException {
        int end = start + len;
        int mark = start;
        String esc = null;
        boolean isWithinCDATA = false;
        for (int i = start; i < end; ++i) {
            char ch = chs[i];
            switch (ch) {
                case '<': {
                    if (isWithinCDATA) break;
                    if (!this.isStartOfCDATA(chs, i)) {
                        esc = "&lt;";
                        break;
                    }
                    isWithinCDATA = true;
                    break;
                }
                case '>': {
                    if (isWithinCDATA) {
                        if (!this.isEndOfCDATA(chs, i)) break;
                        isWithinCDATA = false;
                        break;
                    }
                    esc = "&gt;";
                    break;
                }
                case '&': {
                    if (isWithinCDATA) break;
                    esc = "&amp;";
                    break;
                }
                case '\"': {
                    if (isWithinCDATA) break;
                    esc = "&quot;";
                    break;
                }
                case '\'': {
                    if (isWithinCDATA) break;
                    esc = "&apos;";
                    break;
                }
                default: {
                    if (isWithinCDATA || !this.escapeNonAscii || ' ' <= ch && ch <= '~') break;
                    esc = "&#x";
                    for (int n = 12; n >= 0; n -= 4) {
                        esc = esc + "0123456789ABCDEF".charAt(ch >> n & 0xF);
                    }
                    esc = esc + ";";
                }
            }
            if (esc == null) continue;
            out.write(chs, mark, i - mark);
            out.write(esc, 0, esc.length());
            mark = i + 1;
            esc = null;
        }
        out.write(chs, mark, end - mark);
    }

    protected void normalize(String s, Writer out) throws IOException {
        this.normalize(s.toCharArray(), 0, s.length(), out);
    }

    protected void normalizeCharacters(char[] chs, int start, int len, Writer out) throws IOException {
        this.normalize(chs, start, len, out);
    }

    protected Attributes sortAttributes(Attributes attrs) {
        AttributesImpl attributes = new AttributesImpl(attrs);
        return attributes;
    }

    private String getLocationString(SAXParseException ex) {
        StringBuffer str = new StringBuffer();
        String systemId = ex.getSystemId();
        if (systemId != null) {
            int index = systemId.lastIndexOf(47);
            if (index != -1) {
                systemId = systemId.substring(index + 1);
            }
            str.append(systemId);
        }
        str.append(':');
        str.append(ex.getLineNumber());
        str.append(':');
        str.append(ex.getColumnNumber());
        return str.toString();
    }

    private boolean isStartOfCDATA(char[] chs, int i) {
        if (i + "<![CDATA[".length() > chs.length) {
            return false;
        }
        return chs[i] == '<' && chs[i + 1] == '!' && chs[i + 2] == '[' && chs[i + 3] == 'C' && chs[i + 4] == 'D' && chs[i + 5] == 'A' && chs[i + 6] == 'T' && chs[i + 7] == 'A' && chs[i + 8] == '[';
    }

    private boolean isEndOfCDATA(char[] chs, int i) {
        if (i < "]]>".length() - 1) {
            return false;
        }
        return chs[i - 2] == ']' && chs[i - 1] == ']' && chs[i] == '>';
    }

    private boolean canUseCDATA(char[] chs, int start, int len) {
        for (int i = start; i < len; ++i) {
            char ch = chs[i];
            if (ch == '<' || ch == '>' || ch == '\"' || ch == '\'' || ch == '&') {
                for (int j = i + 1; j < len; ++j) {
                    ch = chs[j];
                    if (ch != ']' || j + 2 >= len || chs[j + 1] != ']' || chs[j + 2] != '>') continue;
                    return false;
                }
                continue;
            }
            if (ch != ']' || i + 2 >= len || chs[i + 1] != ']' || chs[i + 2] != '>') continue;
            return false;
        }
        return true;
    }

    private void indent() {
        this.mIndent = this.mIndent + this.mIndentation;
        this.mIndentLen += this.mIndentationLen;
    }

    private void printIndent() throws IOException {
        this.out.write(this.mIndent, 0, this.mIndentLen);
    }

    private void undent() {
        this.mIndentLen -= this.mIndentationLen;
        this.mIndent = this.mIndent.substring(0, this.mIndentLen);
    }
}

