/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import EDU.oswego.cs.dl.util.concurrent.Executor;
import EDU.oswego.cs.dl.util.concurrent.PooledExecutor;
import com.stc.otd.tools.xml.Characters;
import com.stc.otd.tools.xml.EndDocument;
import com.stc.otd.tools.xml.EndElement;
import com.stc.otd.tools.xml.Error;
import com.stc.otd.tools.xml.FatalError;
import com.stc.otd.tools.xml.ParseEvent;
import com.stc.otd.tools.xml.ParseException;
import com.stc.otd.tools.xml.SAXLexer;
import com.stc.otd.tools.xml.StartDocument;
import com.stc.otd.tools.xml.StartElement;
import com.stc.otd.tools.xml.XsiType;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Stack;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.AttributesImpl;
import org.xml.sax.helpers.LocatorImpl;

public class SAXLexerAdapter
implements ContentHandler,
ErrorHandler,
SAXLexer {
    private static SAXParserFactory mSAXParserFactory = SAXParserFactory.newInstance();
    private static LinkedList xmlReaderPool = new LinkedList();
    private String xmlSchemaInstance = null;
    private Stack elementStack = null;
    private Stack pcdataStack = null;
    private boolean start = false;
    private boolean closed = false;
    private Object parseMonitor = new Object();
    private boolean allowMixed = false;
    private boolean allowPIs = false;
    private Map tags = new HashMap();
    private static String mDefaultFactory = "org.apache.xerces.jaxp.SAXParserFactoryImpl";
    private HashMap prefixMap = new HashMap();
    private Queue queue;
    private Locator charLocator;
    private LinkedList current;
    private int currentPos;
    private int currentSize;
    private boolean hitEof;
    private LinkedList input;
    private InputSource inputSource;
    private Iterator iter;
    private Object lastPut;
    private Locator locator;
    private ParseEvent[] lookAhead;
    private ParseEvent lookBehind;
    private ParseThread parseThread;
    private StringBuffer referencer;
    private static Executor executor = new PooledExecutor(500);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLReader acquireXMLReader() {
        LinkedList linkedList = xmlReaderPool;
        synchronized (linkedList) {
            if (xmlReaderPool.size() == 0) {
                return this.getXMLReader();
            }
            return (XMLReader)xmlReaderPool.removeFirst();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseXMLReader(XMLReader reader) {
        LinkedList linkedList = xmlReaderPool;
        synchronized (linkedList) {
            xmlReaderPool.addLast(reader);
        }
    }

    public SAXLexerAdapter() {
        this(null);
    }

    public SAXLexerAdapter(String factoryName, InputSource inputSource, int low, int high) {
        this.queue = new Queue(low, high);
        this.parseThread = new ParseThread();
        try {
            ((PooledExecutor)executor).waitWhenBlocked();
            executor.execute((Runnable)this.parseThread);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        this.setInputSource(inputSource);
    }

    public SAXLexerAdapter(String factoryName, InputSource inputSource) {
        this(factoryName, inputSource, 16, 64);
    }

    public SAXLexerAdapter(String factoryName, int low, int high) {
        this.queue = new Queue(low, high);
        this.parseThread = new ParseThread();
        try {
            ((PooledExecutor)executor).waitWhenBlocked();
            executor.execute((Runnable)this.parseThread);
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
    }

    public SAXLexerAdapter(String factoryName) {
        this(factoryName, 16, 64);
    }

    public static void main(String[] argv) {
        int count = Integer.parseInt(argv[1]);
        int low = Integer.parseInt(argv[2]);
        int high = Integer.parseInt(argv[3]);
        String factoryName = null;
        if (argv.length > 4) {
            factoryName = argv[4];
        }
        SAXLexerAdapter lexer = new SAXLexerAdapter(factoryName, low, high);
        try {
            for (int i = 0; i < count; ++i) {
                FileInputStream is = new FileInputStream(argv[0]);
                InputSource inputSource = new InputSource(new BufferedInputStream(is));
                SAXLexerAdapter.test(lexer, inputSource);
            }
        }
        catch (IOException exc) {
            exc.printStackTrace();
        }
        lexer.close();
    }

    public static void test(SAXLexerAdapter lexer, InputSource inputSource) {
        ParseEvent event;
        long start = System.currentTimeMillis();
        lexer.setInputSource(inputSource);
        int elements = 0;
        int attributes = 0;
        int chars = 0;
        while ((event = lexer.lex()) != null && !(event instanceof EndDocument) && !(event instanceof ParseException)) {
            if (event instanceof StartElement) {
                ++elements;
                attributes += ((StartElement)event).attributes.getLength();
                continue;
            }
            if (!(event instanceof Characters)) continue;
            chars += ((Characters)event).chars.length;
        }
        long end = System.currentTimeMillis();
        System.out.println("elapsed time: " + (end - start));
        System.out.println("elements: " + elements);
        System.out.println("attributes: " + attributes);
        System.out.println("characters: " + chars);
        lexer.printStats();
        System.gc();
    }

    public boolean getAllowMixed() {
        return this.allowMixed;
    }

    public boolean getAllowPIs() {
        return this.allowPIs;
    }

    public void setAllowMixed(boolean b) {
        this.allowMixed = b;
    }

    public void setAllowPIs(boolean b) {
        this.allowPIs = b;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setInputSource(InputSource in) {
        this.setInputSource(in, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInputSource(InputSource in, String schemaInstance) {
        this.queue.reset();
        Object object = this.parseMonitor;
        synchronized (object) {
            while (this.start) {
                try {
                    this.parseMonitor.wait();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                }
            }
            this.referencer = null;
            this.charLocator = null;
            this.inputSource = in;
            this.current = null;
            this.lookAhead = null;
            this.lookBehind = null;
            this.input = null;
            this.start = true;
            this.hitEof = false;
            this.lastPut = null;
            this.elementStack = new Stack();
            this.pcdataStack = new Stack();
            this.xmlSchemaInstance = schemaInstance;
            this.prefixMap = new HashMap();
            this.queue.open();
            this.parseMonitor.notify();
        }
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.lastPut == null) {
            return;
        }
        if (length > 0) {
            this.appendChars(ch, start, length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        this.queue.close();
        Object object = this.parseMonitor;
        synchronized (object) {
            this.closed = true;
            this.start = false;
            this.parseMonitor.notify();
        }
    }

    public void endDocument() throws SAXException {
        this.put(new EndDocument(this.getLocator()));
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.flushChars();
        StartElement start = (StartElement)this.elementStack.pop();
        this.put(new EndElement(this.getLocator(), start));
        this.referencer = (StringBuffer)this.pcdataStack.pop();
    }

    public void endPrefixMapping(String name) throws SAXException {
        if (this.xmlSchemaInstance != null) {
            Stack stack = (Stack)this.prefixMap.get(name);
            stack.pop();
            if (stack.size() == 0) {
                this.prefixMap.remove(name);
            }
        }
    }

    public void error(SAXParseException exception) throws SAXException {
        this.put(new Error(this.getLocator(), exception));
    }

    public void fatalError(SAXParseException exception) throws SAXException {
        this.put(new FatalError(this.getLocator(), exception));
        throw exception;
    }

    public void finalize() {
        this.close();
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public ParseEvent lex() {
        if (!this.hitEof) {
            ParseEvent result;
            do {
                if (this.lookAhead == null) {
                    result = (ParseEvent)this.get();
                    this.lookAhead = new ParseEvent[1];
                } else {
                    result = this.lookAhead[0];
                }
                if (result instanceof EndDocument || result instanceof ParseException) {
                    this.hitEof = true;
                    break;
                }
                this.lookAhead[0] = (ParseEvent)this.get();
            } while (result instanceof Characters && !this.allowMixed && (!(this.lookAhead[0] instanceof EndElement) || !(this.lookBehind instanceof StartElement)));
            this.lookBehind = result;
            return result;
        }
        return null;
    }

    public void printStats() {
        System.out.println("put: wait = " + this.queue.putWaitCount + ", " + this.queue.putWaitTime);
        System.out.println("get: wait = " + this.queue.getWaitCount + ", " + this.queue.getWaitTime);
        this.queue.getWaitCount = (this.queue.putWaitCount = 0L);
        this.queue.getWaitTime = (this.queue.putWaitTime = 0L);
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void put(ParseEvent event) throws SAXException {
        this.lastPut = event;
        if (this.input == null) {
            this.input = new LinkedList();
        }
        this.input.addLast(event);
        if (event instanceof EndDocument || event instanceof ParseException || this.input.size() > this.queue.minSize) {
            if (!this.queue.put(this.input)) {
                this.input = null;
                throw new SAXException("aborting");
            }
            this.input = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reset() {
        this.queue.reset();
        Object object = this.parseMonitor;
        synchronized (object) {
            while (this.start) {
                try {
                    this.parseMonitor.wait();
                }
                catch (InterruptedException exc) {
                    exc.printStackTrace();
                }
            }
            this.referencer = null;
            this.charLocator = null;
            this.inputSource = null;
            this.current = null;
            this.lookAhead = null;
            this.lookBehind = null;
            this.input = null;
            this.hitEof = false;
            this.lastPut = null;
            this.elementStack = null;
            this.pcdataStack = null;
            this.xmlSchemaInstance = null;
            this.prefixMap = null;
        }
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void startDocument() throws SAXException {
        this.put(new StartDocument(this.getLocator()));
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        String xsiType;
        AttributesImpl attrImpl = new AttributesImpl(atts);
        StartElement start = new StartElement(this.getLocator(), namespaceURI, localName, qName, (Attributes)attrImpl, this.prefixMap);
        if (this.xmlSchemaInstance != null && (xsiType = atts.getValue(this.xmlSchemaInstance, "type")) != null) {
            String tag = xsiType;
            String ns = "";
            int colon = xsiType.indexOf(58);
            String name = xsiType;
            if (colon > 0) {
                String prefix = xsiType.substring(0, colon);
                name = xsiType.substring(colon + 1);
                Stack stack = (Stack)this.prefixMap.get(prefix);
                if (stack != null) {
                    ns = (String)stack.peek();
                }
            }
            start.xsiType = new XsiType(ns, tag, name);
        }
        this.elementStack.push(start);
        this.pcdataStack.push(this.referencer);
        this.referencer = null;
        this.put(start);
    }

    public void startPrefixMapping(String name, String namespaceURI) throws SAXException {
        if (this.xmlSchemaInstance != null) {
            Stack<String> stack = (Stack<String>)this.prefixMap.get(name);
            if (stack == null) {
                stack = new Stack<String>();
                this.prefixMap.put(name, stack);
            }
            stack.push(namespaceURI);
        }
    }

    public void warning(SAXParseException exception) throws SAXException {
    }

    Object get() {
        if (this.current == null) {
            this.current = this.queue.getList();
            if (this.current == null) {
                return null;
            }
            this.currentPos = 0;
            this.currentSize = this.current.size();
            this.iter = this.current.iterator();
        }
        if (this.currentPos == this.currentSize) {
            this.current = this.queue.getList();
            if (this.current == null) {
                return null;
            }
            this.iter = this.current.iterator();
            this.currentPos = 0;
            this.currentSize = this.current.size();
        }
        if (this.currentPos == this.currentSize) {
            return null;
        }
        ++this.currentPos;
        return this.iter.next();
    }

    Locator getLocator() {
        return new LocatorImpl(this.locator);
    }

    String getTag(String tag) {
        return tag;
    }

    void setFeature(XMLReader reader, String feature, boolean value) {
        try {
            reader.setFeature(feature, value);
        }
        catch (SAXNotSupportedException e1) {
        }
        catch (SAXNotRecognizedException e2) {
            // empty catch block
        }
    }

    void appendChars(char[] ch, int start, int length) {
        if (this.charLocator == null) {
            this.charLocator = new LocatorImpl(this.getLocator());
        }
        if (this.referencer == null) {
            this.referencer = new StringBuffer();
        }
        this.referencer.append(ch, start, length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private XMLReader getXMLReader() throws RuntimeException {
        try {
            XMLReader result;
            SAXParserFactory sAXParserFactory = mSAXParserFactory;
            synchronized (sAXParserFactory) {
                SAXParser saxParser = mSAXParserFactory.newSAXParser();
                result = saxParser.getXMLReader();
            }
            this.setFeature(result, "http://xml.org/sax/features/namespaces", true);
            this.setFeature(result, "http://xml.org/sax/features/namespace-prefixes", true);
            this.setFeature(result, "http://xml.org/sax/features/validation", false);
            this.setFeature(result, "http://xml.org/sax/features/external-general-entities", false);
            this.setFeature(result, "http://xml.org/sax/features/external-parameter-entities", false);
            this.setFeature(result, "http://apache.org/xml/features/nonvalidating/load-external-dtd", false);
            this.setFeature(result, "http://apache.org/xml/features/nonvalidating/load-dtd-grammar", false);
            return result;
        }
        catch (SAXException se) {
            throw new RuntimeException(se);
        }
        catch (ParserConfigurationException pce) {
            throw new RuntimeException(pce);
        }
    }

    boolean isEmptyText(char[] text) {
        if (text == null || text.length == 0) {
            return true;
        }
        for (int i = 0; i < text.length; ++i) {
            if (text[i] == ' ' || text[i] == '\t' || text[i] == '\n' || text[i] == '\r') continue;
            return false;
        }
        return true;
    }

    void flushChars() throws SAXException {
        if (this.referencer != null && this.referencer.length() > 0) {
            char[] temp = new char[this.referencer.length()];
            this.referencer.getChars(0, temp.length, temp, 0);
            if (!this.isEmptyText(temp)) {
                this.put(new Characters(this.charLocator, temp));
                this.referencer = null;
                this.charLocator = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run() {
        this.lastPut = null;
        XMLReader reader = null;
        try {
            reader = this.acquireXMLReader();
            reader.setContentHandler(this);
            reader.setErrorHandler(this);
            reader.parse(this.inputSource);
        }
        catch (SAXException exc) {
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                this.releaseXMLReader(reader);
            }
        }
        Object object = this.queue.monitor;
        synchronized (object) {
            if (this.queue.mList.isEmpty()) {
                this.queue.closed = true;
            }
            this.queue.monitor.notify();
        }
    }

    class Queue {
        private LinkedList mList = new LinkedList();
        private Object monitor = new Object();
        private boolean closed = false;
        private boolean reset = false;
        private int count;
        private long getWaitCount;
        private long getWaitTime;
        private int maxSize;
        private int minSize;
        private long putWaitCount;
        private long putWaitTime;

        Queue(int minSize, int maxSize) {
            this.minSize = minSize;
            this.maxSize = maxSize;
            this.closed = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close() {
            Object object = this.monitor;
            synchronized (object) {
                this.mList.clear();
                this.closed = true;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void open() {
            Object object = this.monitor;
            synchronized (object) {
                this.closed = false;
                this.reset = false;
                this.count = 0;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void reset() {
            Object object = this.monitor;
            synchronized (object) {
                this.mList.clear();
                this.closed = false;
                this.reset = true;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        LinkedList getList() {
            LinkedList result = null;
            Object object = this.monitor;
            synchronized (object) {
                while (!this.reset && !this.closed && this.mList.size() == 0) {
                    long startWait = System.currentTimeMillis();
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException exc) {
                        exc.printStackTrace();
                    }
                    long endWait = System.currentTimeMillis();
                    this.getWaitTime += endWait - startWait;
                    ++this.getWaitCount;
                }
                if (this.closed || this.reset) {
                    this.mList.clear();
                    this.monitor.notify();
                } else {
                    result = (LinkedList)this.mList.removeFirst();
                    this.count -= result.size();
                    if (this.count < this.maxSize) {
                        this.monitor.notify();
                    }
                }
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean put(LinkedList list) {
            Object object = this.monitor;
            synchronized (object) {
                while (!this.reset && !this.closed && this.count > this.maxSize) {
                    try {
                        this.monitor.wait();
                    }
                    catch (InterruptedException exc) {
                        exc.printStackTrace();
                    }
                }
                if (this.closed) {
                    this.monitor.notify();
                } else {
                    if (this.reset) {
                        this.mList.clear();
                        this.reset = false;
                        return false;
                    }
                    this.mList.addLast(list);
                    this.count += list.size();
                    if (this.mList.size() == 1) {
                        this.monitor.notify();
                    }
                }
            }
            return true;
        }
    }

    class ParseThread
    implements Runnable {
        ParseThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Object object = SAXLexerAdapter.this.parseMonitor;
            synchronized (object) {
                while (!SAXLexerAdapter.this.start) {
                    try {
                        SAXLexerAdapter.this.parseMonitor.wait();
                    }
                    catch (InterruptedException exc) {
                        exc.printStackTrace();
                    }
                }
            }
            SAXLexerAdapter.this.run();
        }
    }
}

