/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import com.stc.otd.tools.xml.Location;
import com.stc.otd.tools.xml.NamespaceMap;
import com.stc.otd.tools.xml.NamespaceMaps;
import com.stc.otd.tools.xml.ParseEvent;
import com.stc.otd.tools.xml.Utils;
import com.stc.otd.tools.xml.XsiType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;

public class StartElement
extends ParseEvent {
    public Attributes attributes;
    public String localName;
    public String namespaceURI;
    public HashMap prefixMapping;
    public String qName;
    public XsiType xsiType;

    public StartElement(Locator locator, String namespaceURI, String localName, String qName, Attributes atts, HashMap prefixMap) {
        this(locator, namespaceURI, localName, qName, atts, prefixMap, true);
    }

    StartElement(Locator locator, String namespaceURI, String localName, String qName, Attributes atts, HashMap prefixMap, boolean processPrefixMap) {
        super(locator);
        this.namespaceURI = namespaceURI;
        this.qName = qName;
        this.localName = localName;
        this.attributes = atts;
        this.type = 3;
        if (prefixMap != null && prefixMap.size() > 0) {
            if (processPrefixMap) {
                this.prefixMapping = new HashMap();
                Iterator iter = prefixMap.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Stack sameNamePrefix = (Stack)prefixMap.get(key);
                    String uri = (String)sameNamePrefix.peek();
                    this.prefixMapping.put(key, uri);
                }
            } else {
                this.prefixMapping = prefixMap;
            }
            this.prefixMapping.put("xml", "http://www.w3.org/XML/1998/namespace");
        }
    }

    StartElement(Location location, String namespaceURI, String localName, String qName, Attributes atts, HashMap prefixMap) {
        this(location, namespaceURI, localName, qName, atts, prefixMap, true);
    }

    StartElement(Location location, String namespaceURI, String localName, String qName, Attributes atts, HashMap prefixMap, boolean processPrefixMap) {
        super(location);
        this.namespaceURI = namespaceURI;
        this.qName = qName;
        this.localName = localName;
        this.attributes = atts;
        this.type = 3;
        if (prefixMap != null && prefixMap.size() > 0) {
            if (processPrefixMap) {
                this.prefixMapping = new HashMap();
                Iterator iter = prefixMap.keySet().iterator();
                while (iter.hasNext()) {
                    String key = (String)iter.next();
                    Stack sameNamePrefix = (Stack)prefixMap.get(key);
                    String uri = (String)sameNamePrefix.peek();
                    this.prefixMapping.put(key, uri);
                }
            } else {
                this.prefixMapping = prefixMap;
            }
            this.prefixMapping.put("xml", "http://www.w3.org/XML/1998/namespace");
        }
    }

    public boolean isXsiType(String namespaceURI, String localName) {
        return this.xsiType != null && (this.xsiType.namespaceURI.equals(namespaceURI) || this.xsiType.namespaceURI.length() <= 0 && this.namespaceURI.equals(namespaceURI)) && this.xsiType.localName.equals(localName);
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        if (this.namespaceURI.length() > 0) {
            buf.append("{");
            buf.append(this.namespaceURI);
            buf.append("}");
        }
        buf.append(this.localName);
        int len = this.attributes.getLength();
        for (int i = 0; i < len; ++i) {
            String uri = this.attributes.getURI(i);
            String name = this.attributes.getLocalName(i);
            String value = this.attributes.getValue(i);
            buf.append(" ");
            if (uri.length() > 0) {
                buf.append("{");
                buf.append(uri);
                buf.append("}");
            }
            buf.append(name);
            buf.append("=\"");
            buf.append(value);
            buf.append("\"");
        }
        buf.append(">");
        return buf.toString();
    }

    public String toXML() {
        return this.toXML(null, null);
    }

    public String toXML(NamespaceMaps currentNSDecls, NamespaceMap newNSDecls) {
        StringBuffer buf = new StringBuffer();
        buf.append("<");
        buf.append(this.qName);
        int len = this.attributes.getLength();
        HashSet<String> nsSet = new HashSet<String>();
        if (this.namespaceURI != null && this.namespaceURI.length() > 0) {
            int colon = this.qName.indexOf(58);
            String prefix = colon > 0 ? this.qName.substring(0, colon) : "";
            if (currentNSDecls == null || !this.namespaceURI.equals(currentNSDecls.getNamespaceURI(prefix))) {
                buf.append(" ");
                buf.append("xmlns");
                if (colon > 0) {
                    buf.append(":");
                    buf.append(prefix);
                }
                buf.append("=\"");
                buf.append(this.namespaceURI);
                buf.append("\"");
                nsSet.add(this.namespaceURI);
                if (newNSDecls != null) {
                    newNSDecls.addNamespaceDecl(prefix, this.namespaceURI);
                }
            }
        }
        for (int i = 0; i < len; ++i) {
            String ns = this.attributes.getURI(i);
            String name = this.attributes.getQName(i);
            String value = this.attributes.getValue(i);
            if (ns != null && ns.length() > 0 && !nsSet.contains(ns)) {
                nsSet.add(ns);
                int colon = name.indexOf(58);
                String prefix = colon > 0 ? name.substring(0, colon) : "";
                if (currentNSDecls == null || !ns.equals(currentNSDecls.getNamespaceURI(prefix))) {
                    buf.append(" ");
                    buf.append("xmlns");
                    if (colon > 0) {
                        buf.append(":");
                        buf.append(prefix);
                    }
                    buf.append("=\"");
                    buf.append(Utils.encode(ns));
                    buf.append("\"");
                    if (newNSDecls != null) {
                        newNSDecls.addNamespaceDecl(prefix, ns);
                    }
                }
            }
            boolean addAttr = true;
            if (name.equals("xmlns") || name.startsWith("xmlns:")) {
                if (nsSet.contains(value)) continue;
                int colon = name.indexOf(58);
                String prefix = colon > 0 ? name.substring(colon + 1) : "";
                if (currentNSDecls != null && value != null && value.equals(currentNSDecls.getNamespaceURI(prefix))) {
                    addAttr = false;
                } else if (null != value && null != newNSDecls) {
                    newNSDecls.addNamespaceDecl(prefix, value);
                }
                nsSet.add(Utils.encode(value));
            }
            if (!addAttr) continue;
            buf.append(" ");
            buf.append(name);
            buf.append("=\"");
            buf.append(Utils.encode(value));
            buf.append("\"");
        }
        buf.append(">");
        return buf.toString();
    }
}

