/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import com.stc.otd.tools.xml.Characters;
import com.stc.otd.tools.xml.EndDocument;
import com.stc.otd.tools.xml.EndElement;
import com.stc.otd.tools.xml.EndTag;
import com.stc.otd.tools.xml.Error;
import com.stc.otd.tools.xml.FatalError;
import com.stc.otd.tools.xml.LexerException;
import com.stc.otd.tools.xml.Location;
import com.stc.otd.tools.xml.NoSyncStack;
import com.stc.otd.tools.xml.ParseEvent;
import com.stc.otd.tools.xml.SAXLexer;
import com.stc.otd.tools.xml.StartDocument;
import com.stc.otd.tools.xml.StartElement;
import com.stc.otd.tools.xml.StartTag;
import com.stc.otd.tools.xml.Tag;
import com.stc.otd.tools.xml.XmlAttributesImpl;
import com.stc.otd.tools.xml.XmlLexerImpl;
import com.stc.otd.tools.xml.XsiType;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XXLLexerAdapter
implements SAXLexer {
    private InputSource mInputSource;
    private boolean mAllowMixed = true;
    private boolean mAllowPIs = true;
    private XmlLexerImpl mXmlLexer;
    private LinkedList mParseExceptions = new LinkedList();
    private EndTag mLastEndTag;
    private NoSyncStack mStartElementStack = new NoSyncStack();
    private boolean mDocStarted = false;
    private boolean mDocInitialized = false;
    private boolean mDocEnded = false;
    private String mSchemaInstance;

    public void close() {
    }

    public boolean getAllowMixed() {
        return this.mAllowMixed;
    }

    public boolean getAllowPIs() {
        return this.mAllowPIs;
    }

    public ParseEvent lex() {
        Tag tag;
        if (this.mParseExceptions.size() > 0) {
            return (ParseEvent)this.mParseExceptions.removeFirst();
        }
        if (!this.mDocStarted) {
            this.mDocStarted = true;
            this.mDocEnded = false;
            return new StartDocument(new Location(1, 1, 1L));
        }
        if (!this.mDocInitialized) {
            try {
                this.mXmlLexer.init();
                this.mDocInitialized = true;
            }
            catch (IOException ioe) {
                Location location = this.mXmlLexer.getCurrentLocation();
                this.mParseExceptions.add(new FatalError(location, new SAXParseException(" XmlLexer.init() failed due to IO. " + ioe.getMessage(), location.getLocator(), ioe)));
                return (ParseEvent)this.mParseExceptions.removeFirst();
            }
            catch (LexerException le) {
                Location location = this.mXmlLexer.getCurrentLocation();
                this.mParseExceptions.add(new FatalError(location, new SAXParseException(" XmlLexer.init() failed. " + le.getMessage(), location.getLocator(), le)));
                return (ParseEvent)this.mParseExceptions.removeFirst();
            }
        }
        if (this.mLastEndTag != null) {
            StartElement se;
            Location location = new Location(this.mLastEndTag.getColumn(), this.mLastEndTag.getLine(), this.mLastEndTag.getOffset());
            try {
                se = (StartElement)this.mStartElementStack.pop();
            }
            catch (RuntimeException e) {
                this.mParseExceptions.add(new FatalError(location, new SAXParseException("End tag more than start tag. tag = " + this.mLastEndTag.getQName(), location.getLocator(), e)));
                return (ParseEvent)this.mParseExceptions.removeFirst();
            }
            EndElement ee = new EndElement(location, se);
            this.mLastEndTag = null;
            return ee;
        }
        if (this.mXmlLexer.isEOF()) {
            if (!this.mDocEnded) {
                this.mDocEnded = true;
                return new EndDocument(this.mXmlLexer.getCurrentLocation());
            }
            return null;
        }
        try {
            tag = this.mXmlLexer.nextTag();
        }
        catch (IOException ioe) {
            Location location = this.mXmlLexer.getCurrentLocation();
            this.mParseExceptions.add(new Error(location, new SAXParseException("XmlLexer.nextTag() failed on I/O: " + ioe.getMessage(), location.getLocator(), ioe)));
            return (ParseEvent)this.mParseExceptions.removeFirst();
        }
        catch (LexerException le) {
            Location location = this.mXmlLexer.getCurrentLocation();
            this.mParseExceptions.add(new Error(location, new SAXParseException("XmlLexer.nextTag() failed: " + le.getMessage(), location.getLocator(), le)));
            return (ParseEvent)this.mParseExceptions.removeFirst();
        }
        if (tag instanceof StartTag) {
            StartTag st = (StartTag)tag;
            Location location = new Location(st.getColumn(), st.getLine(), st.getOffset());
            XmlAttributesImpl atts = new XmlAttributesImpl(st.getAttrs(), st.getPrefixMap(), st.getReversePrefixMap());
            StartElement se = new StartElement(location, st.getNsUri(), st.getLocalName(), st.getQName(), (Attributes)atts, (HashMap)st.getPrefixMap(), false);
            String xsiType = atts.getValue(this.mSchemaInstance, "type");
            if (xsiType != null) {
                String extType = xsiType;
                String ns = "";
                int colon = xsiType.indexOf(58);
                String name = xsiType;
                if (colon > 0) {
                    String prefix = xsiType.substring(0, colon);
                    name = xsiType.substring(colon + 1);
                    if (st.getPrefixMap().containsKey(prefix)) {
                        ns = (String)st.getPrefixMap().get(prefix);
                    }
                }
                se.xsiType = new XsiType(ns, extType, name);
            }
            this.mStartElementStack.push(se);
            return se;
        }
        if (tag instanceof EndTag) {
            StartElement se;
            EndTag et = (EndTag)tag;
            String data = et.getData();
            Location location = new Location(et.getColumn(), et.getLine(), et.getOffset());
            if (data != null && data.length() > 0) {
                Characters chs = new Characters(location, data.toCharArray());
                this.mLastEndTag = et;
                return chs;
            }
            try {
                se = (StartElement)this.mStartElementStack.pop();
            }
            catch (RuntimeException e) {
                this.mParseExceptions.add(new FatalError(location, new SAXParseException("End tag more than start tag. tag = " + et.getQName(), location.getLocator(), e)));
                return (ParseEvent)this.mParseExceptions.removeFirst();
            }
            return new EndElement(location, se);
        }
        Location location = this.mXmlLexer.getCurrentLocation();
        this.mParseExceptions.add(new Error(location, new SAXParseException("XmlLexer.nextTag() returns invalid tag type.", location.getLocator())));
        return (ParseEvent)this.mParseExceptions.removeFirst();
    }

    public void printStats() {
    }

    public void reset() {
        this.mXmlLexer = null;
        this.mParseExceptions = null;
        this.mInputSource = null;
    }

    public void setAllowMixed(boolean b) {
        this.mAllowMixed = b;
    }

    public void setAllowPIs(boolean b) {
        this.mAllowPIs = b;
    }

    public void setInputSource(InputSource in) {
        throw new RuntimeException("XXLLexerAdapter requires setInputSource with schemaInstance.");
    }

    public void setInputSource(InputSource in, String schemaInstance) {
        this.mInputSource = in;
        this.mDocStarted = false;
        this.mDocInitialized = false;
        this.mDocEnded = false;
        this.mLastEndTag = null;
        this.mParseExceptions = new LinkedList();
        this.mStartElementStack = new NoSyncStack();
        this.mSchemaInstance = schemaInstance;
        try {
            Reader reader = this.mInputSource.getCharacterStream();
            this.mXmlLexer = reader == null ? new XmlLexerImpl(this.mInputSource.getByteStream()) : new XmlLexerImpl(reader);
            this.mXmlLexer.setReturnPrefixMap(true);
        }
        catch (LexerException e) {
            Location location = new Location(1, 1, 1L);
            this.mParseExceptions.add(new FatalError(location, new SAXParseException("Unable to create lexer. " + e.getMessage(), location.getLocator(), e)));
        }
    }

    public static void main(String[] args) {
        try {
            System.out.println("start - " + new Date());
            for (int unmarshalloop = 0; unmarshalloop < 100; ++unmarshalloop) {
                XXLLexerAdapter lexer = new XXLLexerAdapter();
                InputSource in = new InputSource(new InputStreamReader(new FileInputStream("put the input file name here.")));
                lexer.setInputSource(in, "http://www.w3.org/2001/XMLSchema-instance");
                while (lexer.lex() != null) {
                }
            }
            System.out.println("end - " + new Date());
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
    }
}

