/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.xml.sax.Attributes;

class XmlAttributesImpl
implements Attributes {
    Map mAttrs;
    Map mReversePrefixMap = null;
    Map mPrefixMap;
    String[] mQNames;
    HashMap mQName2IdxMap = null;

    public XmlAttributesImpl(Map attrs, Map prefixMap) {
        this(attrs, prefixMap, null);
    }

    public XmlAttributesImpl(Map attrs, Map prefixMap, Map reversePrefixMap) {
        this.mAttrs = attrs;
        if (this.mAttrs == null) {
            this.mAttrs = new HashMap();
        }
        this.mPrefixMap = prefixMap;
        if (attrs != null && attrs.size() > 0) {
            this.mQNames = new String[attrs.size()];
            Iterator it2 = attrs.keySet().iterator();
            int i = 0;
            while (it2.hasNext()) {
                String qName;
                this.mQNames[i] = qName = (String)it2.next();
                ++i;
            }
        }
        this.mReversePrefixMap = reversePrefixMap;
    }

    private Map getQ2IMap() {
        if (this.mQName2IdxMap == null) {
            this.mQName2IdxMap = new HashMap();
            if (this.mAttrs != null && this.mAttrs.size() > 0) {
                Iterator it2 = this.mAttrs.keySet().iterator();
                int i = 0;
                while (it2.hasNext()) {
                    String qName = (String)it2.next();
                    this.mQName2IdxMap.put(qName, String.valueOf(i));
                    ++i;
                }
            }
        }
        return this.mQName2IdxMap;
    }

    private Map getRMap() {
        if (this.mReversePrefixMap == null) {
            this.mReversePrefixMap = new HashMap();
            if (this.mPrefixMap != null && this.mPrefixMap.size() > 0) {
                Iterator it = this.mPrefixMap.keySet().iterator();
                while (it.hasNext()) {
                    String prefix = (String)it.next();
                    this.mReversePrefixMap.put(this.mPrefixMap.get(prefix), prefix);
                }
            }
        }
        return this.mReversePrefixMap;
    }

    private String getPrefix(String uri) {
        String prefix = (String)this.getRMap().get(uri);
        if (prefix == null) {
            return "";
        }
        return prefix;
    }

    private String makeQName(String uri, String localname) {
        String prefix = (String)this.getRMap().get(uri);
        if (prefix == null || prefix.length() == 0) {
            return localname;
        }
        return prefix + ":" + localname;
    }

    public int getIndex(String qName) {
        String str = (String)this.getQ2IMap().get(qName);
        try {
            return Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return -1;
        }
    }

    public int getIndex(String uri, String localName) {
        return this.getIndex(this.makeQName(uri, localName));
    }

    public int getLength() {
        return this.mAttrs.size();
    }

    public String getLocalName(int index) {
        if (index >= this.mAttrs.size() || index < 0) {
            return null;
        }
        String qName = this.mQNames[index];
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            return qName.substring(idx + 1);
        }
        return qName;
    }

    public String getQName(int index) {
        if (index >= this.mAttrs.size() || index < 0) {
            return null;
        }
        return this.mQNames[index];
    }

    public String getType(int index) {
        return "CDATA";
    }

    public String getType(String qName) {
        return "CDATA";
    }

    public String getType(String uri, String localName) {
        return "CDATA";
    }

    public String getURI(int index) {
        if (index >= this.mAttrs.size() || index < 0) {
            return null;
        }
        String qName = this.mQNames[index];
        int idx = qName.indexOf(58);
        if (idx >= 0) {
            String uri = (String)this.mPrefixMap.get(qName.substring(0, idx));
            if (uri == null) {
                return "";
            }
            return uri;
        }
        return "";
    }

    public String getValue(int index) {
        if (index >= this.mAttrs.size() || index < 0) {
            return null;
        }
        return (String)this.mAttrs.get(this.mQNames[index]);
    }

    public String getValue(String qName) {
        return (String)this.mAttrs.get(qName);
    }

    public String getValue(String uri, String localName) {
        return (String)this.mAttrs.get(this.makeQName(uri, localName));
    }
}

