/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.tools.xml;

import com.stc.otd.tools.xml.EndTag;
import com.stc.otd.tools.xml.LexerException;
import com.stc.otd.tools.xml.Location;
import com.stc.otd.tools.xml.NoSyncStack;
import com.stc.otd.tools.xml.StartTag;
import com.stc.otd.tools.xml.Tag;
import com.stc.otd.tools.xml.XmlCharacter;
import com.stc.otd.tools.xml.XmlLexer;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class XmlLexerImpl
implements XmlLexer {
    private static final int CHAR_LT = 60;
    private static final int CHAR_GT = 62;
    private static final int CHAR_QM = 63;
    private static final int CHAR_EM = 33;
    private static final int CHAR_HP = 45;
    private static final int CHAR_LBT = 91;
    private static final int CHAR_RBT = 93;
    private static final int CHAR_US = 95;
    private static final int CHAR_CLN = 58;
    private static final int CHAR_SPC = 32;
    private static final int CHAR_SLASH = 47;
    private static final int CHAR_EQUAL = 61;
    private static final int CHAR_QUOT = 34;
    private static final int CHAR_APOS = 39;
    private static final int CHAR_DOT = 46;
    private static final int CHAR_AMP = 38;
    private static final int CHAR_SEMICLN = 59;
    private static final int CHAR_POUND = 35;
    private static final int MAXBUFFERSIZE = 2048;
    private Reader msReader;
    private int[] mLastRead = new int[]{-1, -1, -1};
    private long mOffset = 0L;
    int mCol = -1;
    int mLine = -1;
    private boolean mInitialized = false;
    private boolean mDocTypeRead = false;
    private boolean mEOF = false;
    private boolean mTagOpen = false;
    private NoSyncStack mTagStack = new NoSyncStack();
    private EndTag mEndTag = null;
    private char[] streambuffer = new char[2048];
    private int buffersize = -1;
    private int bufferpos = -1;
    private boolean mReturnPrefixMap = false;
    private NoSyncStack mTagPrefixStack = new NoSyncStack();
    private HashMap mCurrentPrefixMap = new HashMap();
    boolean mPrefixInUse = false;
    private HashMap mCurrentReversePrefixMap = new HashMap();
    private Map mAccumulatedPrefixMap = new HashMap();
    private Map mAccReversedPrefixMap = new HashMap();

    public XmlLexerImpl(Reader s) throws LexerException {
        if (s == null) {
            throw new LexerException("no character stream.");
        }
        this.msReader = s;
    }

    public XmlLexerImpl(InputStream s) throws LexerException {
        if (s == null) {
            throw new LexerException("no input stream.");
        }
        byte[] d = new byte[128];
        if (!s.markSupported()) {
            s = new BufferedInputStream(s);
        }
        s.mark(256);
        try {
            s.read(d);
            s.reset();
        }
        catch (IOException e) {
            throw new LexerException("Unable to read first four bytes.");
        }
        try {
            if (d[0] == 0 && d[1] == 60 && d[2] == 0 && d[3] != 0) {
                this.msReader = new InputStreamReader(s, "UTF-16BE");
            } else if (d[0] == 60 && d[1] == 0 && d[2] != 0 && d[3] == 0) {
                this.msReader = new InputStreamReader(s, "UTF-16LE");
            } else if (d[0] == -1 && d[1] == -2 || d[0] == -2 && d[1] == -1) {
                this.msReader = new InputStreamReader(s, "UTF-16");
            } else if (d[0] == -17 && d[1] == -69 && d[2] == -65) {
                s.skip(3L);
                this.msReader = new InputStreamReader(s, "UTF-8");
            } else {
                String encoding = this.getEncoding(d);
                if (encoding == null) {
                    encoding = "UTF-8";
                }
                this.msReader = new InputStreamReader(s, encoding);
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new LexerException("Unsupported encoding.", e);
        }
        catch (IOException e) {
            throw new LexerException("IOException.", e);
        }
    }

    private final String getEncoding(byte[] headerBytes) {
        if (headerBytes[0] == 60 && headerBytes[1] == 63 && headerBytes[2] == 120 && headerBytes[3] == 109) {
            String xmlHeader = new String(headerBytes);
            int posStart = 0;
            int posEnd = 0;
            posStart = xmlHeader.indexOf("encoding=");
            if (posStart < 0) {
                return null;
            }
            char quote = xmlHeader.charAt(posStart + "encoding=".length());
            posEnd = xmlHeader.indexOf(quote, posStart + "encoding=".length() + 1);
            if (posEnd < 0) {
                return null;
            }
            return xmlHeader.substring(posStart + "encoding=".length() + 1, posEnd);
        }
        return null;
    }

    private final int LA(int k) {
        return this.mLastRead[k];
    }

    private final void LT() throws IOException {
        if (++this.bufferpos >= this.buffersize) {
            this.buffersize = this.msReader.read(this.streambuffer);
            if (this.buffersize <= 0) {
                if (this.mLastRead[0] == 10) {
                    ++this.mLine;
                    this.mCol = 1;
                } else {
                    ++this.mCol;
                }
                this.mLastRead[0] = this.mLastRead[1];
                this.mLastRead[1] = this.mLastRead[2];
                ++this.mOffset;
                this.mLastRead[2] = -1;
                this.bufferpos = -1;
                return;
            }
            this.bufferpos = 0;
        }
        if (this.mLastRead[0] == -1) {
            int i;
            for (i = 0; i < this.buffersize && i < 3; ++i) {
                this.mLastRead[i] = this.streambuffer[i];
            }
            this.bufferpos = i - 1;
        } else {
            if (this.mLastRead[0] == 10) {
                ++this.mLine;
                this.mCol = 1;
            } else {
                ++this.mCol;
            }
            this.mLastRead[0] = this.mLastRead[1];
            this.mLastRead[1] = this.mLastRead[2];
            ++this.mOffset;
            this.mLastRead[2] = this.streambuffer[this.bufferpos];
        }
    }

    private String currentFragment() {
        int endPos;
        if (this.bufferpos >= this.buffersize) {
            return "";
        }
        int startPos = this.bufferpos - 20;
        if (startPos < 0) {
            startPos = 0;
        }
        if ((endPos = this.bufferpos + 20) > this.buffersize) {
            endPos = this.buffersize;
        }
        if (endPos - startPos > 0) {
            return new String(this.streambuffer, startPos, endPos - startPos);
        }
        return "";
    }

    private void fireEndPrefixMapping() {
        Map prefixMap = (Map)this.mTagPrefixStack.pop();
        if (prefixMap.size() > 0) {
            Iterator it = prefixMap.keySet().iterator();
            while (it.hasNext()) {
                this.endPrefixMapping((String)it.next());
            }
        }
    }

    private void startPrefixMapping(String prefix, String url) {
        NoSyncStack stack = (NoSyncStack)this.mAccumulatedPrefixMap.get(prefix);
        if (stack == null) {
            stack = new NoSyncStack();
            this.mAccumulatedPrefixMap.put(prefix, stack);
        }
        stack.push(url);
        this.getPrefixMapForUpdate().put(prefix, url);
        stack = (NoSyncStack)this.mAccReversedPrefixMap.get(url);
        if (stack == null) {
            stack = new NoSyncStack();
            this.mAccReversedPrefixMap.put(url, stack);
        }
        stack.push(prefix);
        this.getRevPrefixMapForUpdate().put(url, prefix);
    }

    public void endPrefixMapping(String prefix) {
        NoSyncStack stack = (NoSyncStack)this.mAccumulatedPrefixMap.get(prefix);
        String uri = (String)stack.pop();
        if (stack.size() == 0) {
            this.mAccumulatedPrefixMap.remove(prefix);
            this.getPrefixMapForUpdate().remove(prefix);
        } else {
            this.getPrefixMapForUpdate().put(prefix, (String)stack.peek());
        }
        stack = (NoSyncStack)this.mAccReversedPrefixMap.get(uri);
        stack.pop();
        if (stack.size() == 0) {
            this.mAccReversedPrefixMap.remove(uri);
            this.getRevPrefixMapForUpdate().remove(uri);
        } else {
            this.getRevPrefixMapForUpdate().put(uri, (String)stack.peek());
        }
    }

    private void skipBlanks() throws IOException {
        while (XmlCharacter.isWhitespace((char)this.LA(0))) {
            this.LT();
        }
    }

    private void skipSpace() throws IOException {
        while (this.LA(0) == 32) {
            this.LT();
        }
    }

    public void init() throws IOException, LexerException {
        if (this.mInitialized || this.mEOF) {
            throw new LexerException("Invalid context.");
        }
        this.mLine = 1;
        this.mCol = 1;
        this.LT();
        if (this.LA(0) == -1) {
            this.mEOF = true;
            return;
        }
        if (this.LA(0) == 60 && this.LA(1) == 63) {
            this.parsePI(true);
        }
        block4: while (true) {
            this.skipBlanks();
            if (this.LA(0) != 60) {
                throw new LexerException("Unexpected character. position = " + this.mOffset + ", fragment='" + this.currentFragment() + "'");
            }
            switch (this.LA(1)) {
                case 63: {
                    this.parsePI(false);
                    continue block4;
                }
                case 33: {
                    if (this.LA(2) == 45) {
                        this.parseComments();
                        continue block4;
                    }
                    if (this.LA(2) == 68) {
                        this.parseDocType();
                        continue block4;
                    }
                    throw new LexerException("Unexpected character. position = " + this.mOffset + ", fragment='" + this.currentFragment() + "'");
                }
            }
            break;
        }
        if (!XmlCharacter.isLetter(this.LA(1)) && this.LA(1) != 95 && this.LA(1) != 58) {
            throw new LexerException("Invalid NCName character. position = " + this.mOffset);
        }
        this.mInitialized = true;
    }

    private void parsePI(boolean prologAllowed) throws IOException, LexerException {
        this.LT();
        this.LT();
        if (!XmlCharacter.isLetter(this.LA(0)) && this.LA(0) != 95 && this.LA(0) != 58) {
            throw new LexerException("Invalid NCName character. position = " + this.mOffset);
        }
        StringBuffer tagnamebuf = new StringBuffer();
        while (XmlCharacter.isNameChar(this.LA(0))) {
            tagnamebuf.append((char)this.LA(0));
            this.LT();
        }
        if (this.LA(0) == 63 && this.LA(1) == 62) {
            this.LT();
            this.LT();
            return;
        }
        if (!XmlCharacter.isWhitespace(this.LA(0))) {
            throw new LexerException("Invalid character, must be whitespace. position = " + this.mOffset);
        }
        this.LT();
        String tagname = tagnamebuf.toString();
        if (tagname.equals("xml")) {
            LinkedHashMap attrs = new LinkedHashMap();
            this.parseAttributes(attrs);
            if (this.LA(0) != 63) {
                throw new LexerException("Invalid character, '?' required.position = " + this.mOffset);
            }
            this.LT();
            if (this.LA(0) != 62) {
                throw new LexerException("Invalid character. '>' required.position = " + this.mOffset);
            }
            this.LT();
            if (!prologAllowed) {
                throw new LexerException("Invalid context - PI cannot use name 'xml'");
            }
            if (attrs.size() > 3) {
                throw new LexerException("Invalid prolog - too many attributes.");
            }
            if (attrs.size() > 0) {
                String attrname;
                Iterator it = attrs.keySet().iterator();
                if (it.hasNext() && !((String)it.next()).equals("version")) {
                    throw new LexerException("Invalid prolog - 'version' expected.");
                }
                if (it.hasNext()) {
                    attrname = (String)it.next();
                    if (!attrname.equals("encoding") && !attrname.equals("standalone")) {
                        throw new LexerException("Invalid prolog - 'encoding/standalone' expected.");
                    }
                    if (attrname.equals("standalone") && it.hasNext()) {
                        throw new LexerException("Invalid prolog - unexpected: " + (String)it.next());
                    }
                }
                if (it.hasNext() && !(attrname = (String)it.next()).equals("standalone")) {
                    throw new LexerException("Invalid prolog - 'standalone' expected.");
                }
            }
        } else {
            if (tagname.equalsIgnoreCase("xml")) {
                throw new LexerException("Invalid context - PI cannot use name '('X' | 'x') ('M' | 'm') ('L' | 'l')'");
            }
            while (XmlCharacter.isChar(this.LA(0))) {
                if (this.LA(0) == 63 && this.LA(1) == 62) {
                    this.LT();
                    this.LT();
                    return;
                }
                tagnamebuf.append((char)this.LA(0));
                this.LT();
            }
        }
    }

    private void parseComments() throws IOException, LexerException {
        this.LT();
        if (this.LA(2) != 45) {
            throw new LexerException("Invalid character. position = " + this.mOffset);
        }
        this.LT();
        this.LT();
        this.LT();
        while (this.LA(0) != 45 || this.LA(1) != 45 || this.LA(2) != 62) {
            if (this.LA(0) == -1) {
                this.mEOF = true;
                throw new LexerException("Unexpected EOF. position = " + this.mOffset);
            }
            this.LT();
        }
        this.LT();
        this.LT();
        this.LT();
    }

    private void parseDocType() throws IOException, LexerException {
        if (this.mDocTypeRead) {
            throw new LexerException("Invalid context - DOCTYPE already read.");
        }
        this.LT();
        this.LT();
        StringBuffer tagnamebuf = new StringBuffer();
        while (XmlCharacter.isNameChar(this.LA(0))) {
            tagnamebuf.append((char)this.LA(0));
            this.LT();
        }
        if (!tagnamebuf.toString().equals("DOCTYPE")) {
            throw new LexerException("Invalid token: " + tagnamebuf.toString() + ", should be DOCTYPE.");
        }
        NoSyncStack stack = new NoSyncStack();
        stack.push(new Integer(0));
        while (true) {
            if (this.LA(0) == -1) {
                this.mEOF = true;
                throw new LexerException("Unexpected EOF. position = " + this.mOffset);
            }
            if (this.LA(0) == 91) {
                stack.push(new Integer(1));
            } else if (this.LA(0) == 93) {
                if (stack.isEmpty()) {
                    throw new LexerException("']' does not match in DOCTYPE. position = " + this.mOffset);
                }
                if ((Integer)stack.pop() != 1) {
                    throw new LexerException("']' does not match in DOCTYPE. position = " + this.mOffset);
                }
            } else if (this.LA(0) == 60 && this.LA(1) == 33) {
                stack.push(new Integer(0));
            } else if (this.LA(0) == 62) {
                if (stack.isEmpty()) {
                    throw new LexerException("'>' does not match in DOCTYPE. position = " + this.mOffset);
                }
                if ((Integer)stack.pop() != 0) {
                    throw new LexerException("'>' does not match in DOCTYPE. position = " + this.mOffset);
                }
                if (stack.isEmpty()) break;
            }
            this.LT();
        }
        this.LT();
    }

    private StartTag parseStartTag(boolean ignoreAttibutes) throws IOException, LexerException {
        if (this.mEndTag != null) {
            throw new LexerException("Invalid context - end tag must be retrieved.");
        }
        long offset = this.mOffset;
        int col = this.mCol;
        int line = this.mLine;
        this.LT();
        StringBuffer tagnamebuf = new StringBuffer();
        while (XmlCharacter.isNameChar(this.LA(0))) {
            tagnamebuf.append((char)this.LA(0));
            this.LT();
        }
        this.skipBlanks();
        String tagname = tagnamebuf.toString();
        HashMap attrs = null;
        if (XmlCharacter.isLetter(this.LA(0)) || this.LA(0) == 95 || this.LA(0) == 58) {
            if (!ignoreAttibutes) {
                attrs = new HashMap();
                this.parseAttributes(attrs);
            } else {
                this.skipAttributes();
            }
        }
        switch (this.LA(0)) {
            case 47: {
                if (this.LA(1) == 62) {
                    this.LT();
                    this.LT();
                    this.mEndTag = new EndTag(tagname);
                    this.mEndTag.setOffset(this.mOffset);
                    break;
                }
                throw new LexerException("Unexpected character. position = " + this.mOffset + ", fragment='" + this.currentFragment() + "'");
            }
            case 62: {
                this.LT();
                this.mTagStack.push(new EndTag(tagname));
                break;
            }
            default: {
                throw new LexerException("Unexpected character. position = " + this.mOffset + ", fragment='" + this.currentFragment() + "'");
            }
        }
        this.mTagOpen = true;
        return new StartTag(tagname, attrs, offset, col, line);
    }

    private EndTag parseEndTag() throws IOException, LexerException {
        this.LT();
        this.LT();
        if (!XmlCharacter.isLetter(this.LA(0)) && this.LA(0) != 95 && this.LA(0) != 58) {
            throw new LexerException("Invalid character. position = " + this.mOffset);
        }
        StringBuffer tagnamebuf = new StringBuffer();
        while (XmlCharacter.isNameChar(this.LA(0))) {
            tagnamebuf.append((char)this.LA(0));
            this.LT();
        }
        this.skipSpace();
        String tagname = tagnamebuf.toString();
        if (this.LA(0) != 62) {
            throw new LexerException("Invalid character. position = " + this.mOffset);
        }
        this.LT();
        if (this.mTagStack.isEmpty()) {
            throw new LexerException("Tag does not match. position = " + this.mOffset + ", tag = " + tagname);
        }
        EndTag endtag = (EndTag)this.mTagStack.pop();
        if (!tagname.equals(endtag.getQName())) {
            throw new LexerException("Tag does not match. position = " + this.mOffset + ", tag = " + tagname);
        }
        endtag.setOffset(this.mOffset);
        endtag.setColumn(this.mCol);
        endtag.setLine(this.mLine);
        this.mTagOpen = false;
        return endtag;
    }

    private void parseAttributes(Map attrs) throws IOException, LexerException {
        if (attrs == null) {
            this.skipAttributes();
        } else {
            do {
                StringBuffer strbuf = new StringBuffer();
                while (XmlCharacter.isNameChar(this.LA(0))) {
                    strbuf.append((char)this.LA(0));
                    this.LT();
                }
                String attrname = strbuf.toString();
                this.skipSpace();
                if (this.LA(0) != 61) {
                    throw new LexerException("Invalid character. position = " + this.mOffset);
                }
                this.LT();
                this.skipSpace();
                if (this.LA(0) != 34 && this.LA(0) != 39) {
                    throw new LexerException("Invalid character. position = " + this.mOffset);
                }
                int quote = this.LA(0);
                this.LT();
                strbuf = new StringBuffer();
                while (this.LA(0) != quote) {
                    if (this.LA(0) == -1) {
                        this.mEOF = true;
                        throw new LexerException("Unexpected EOF. position = " + this.mOffset);
                    }
                    if (this.LA(0) == 38) {
                        strbuf.append((char)this.parseEscape());
                    } else {
                        strbuf.append((char)this.LA(0));
                    }
                    this.LT();
                }
                this.LT();
                this.skipBlanks();
                attrs.put(attrname, strbuf.toString());
            } while (XmlCharacter.isLetter(this.LA(0)) || this.LA(0) == 95 || this.LA(0) == 58);
        }
    }

    private void skipAttributes() throws IOException, LexerException {
        while (true) {
            if (XmlCharacter.isNameChar(this.LA(0))) {
                this.LT();
                continue;
            }
            this.skipSpace();
            if (this.LA(0) != 61) {
                throw new LexerException("Invalid character. position = " + this.mOffset);
            }
            this.LT();
            this.skipSpace();
            if (this.LA(0) != 34 && this.LA(0) != 39) {
                throw new LexerException("Invalid character. position = " + this.mOffset);
            }
            int quote = this.LA(0);
            this.LT();
            while (this.LA(0) != quote) {
                if (this.LA(0) == -1) {
                    this.mEOF = true;
                    throw new LexerException("Unexpected EOF. position = " + this.mOffset);
                }
                this.LT();
            }
            this.LT();
            this.skipSpace();
            if (!XmlCharacter.isLetter(this.LA(0)) && this.LA(0) != 95 && this.LA(0) != 58) break;
        }
    }

    private int parseIntChar() throws IOException, LexerException {
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            if (this.LA(0) < 48 || this.LA(0) > 57) {
                if (this.LA(0) == 59) {
                    if (sbuf.length() > 0) {
                        return Integer.parseInt(sbuf.toString());
                    }
                    throw new LexerException("Numeric character reference must have value. position = " + this.mOffset);
                }
                throw new LexerException("Invalid termination of numeric character reference. position = " + this.mOffset);
            }
            sbuf.append((char)this.LA(0));
            this.LT();
        }
        throw new LexerException("Numeric character reference too long. position = " + this.mOffset);
    }

    private int parseHexChar() throws IOException, LexerException {
        StringBuffer sbuf = new StringBuffer();
        int c = 0;
        for (int i = 0; i < 20; ++i) {
            c = this.LA(0);
            if (!(c >= 48 && c <= 57 || c >= 97 && c <= 102 || c >= 65 && c <= 70)) {
                if (this.LA(0) == 59) {
                    if (sbuf.length() > 0) {
                        return Integer.parseInt(sbuf.toString(), 16);
                    }
                    throw new LexerException("Numeric character reference must have value. position = " + this.mOffset);
                }
                throw new LexerException("Invalid termination of numeric character reference. position = " + this.mOffset);
            }
            sbuf.append((char)this.LA(0));
            this.LT();
        }
        throw new LexerException("Numeric character reference too long. position = " + this.mOffset);
    }

    private int parseEscape() throws IOException, LexerException {
        if (this.LA(1) == 35) {
            if (this.LA(2) != 120) {
                this.LT();
                this.LT();
                return this.parseIntChar();
            }
            this.LT();
            this.LT();
            this.LT();
            return this.parseHexChar();
        }
        this.LT();
        StringBuffer sbuf = new StringBuffer();
        for (int i = 0; i < 20; ++i) {
            if (this.LA(0) < 97 || this.LA(0) > 122) {
                if (this.LA(0) == 59) {
                    if (sbuf.length() > 0) {
                        String s = sbuf.toString();
                        if (s.equals("amp")) {
                            return 38;
                        }
                        if (s.equals("lt")) {
                            return 60;
                        }
                        if (s.equals("gt")) {
                            return 62;
                        }
                        if (s.equals("apos")) {
                            return 39;
                        }
                        if (s.equals("quot")) {
                            return 34;
                        }
                        throw new LexerException("Invalid escape: " + s + ", position = " + this.mOffset);
                    }
                    throw new LexerException("Escape must have value. position = " + this.mOffset);
                }
                throw new LexerException("Invalid termination of escape. position = " + this.mOffset);
            }
            sbuf.append((char)this.LA(0));
            this.LT();
        }
        throw new LexerException("Escape too long. position = " + this.mOffset);
    }

    private void parseData(boolean skipData) throws IOException, LexerException {
        StringBuffer strbuf = null;
        StringBuffer cdatabuf = null;
        while (true) {
            if (this.LA(0) != 60) {
                if (this.LA(0) == -1) {
                    this.mEOF = true;
                    throw new LexerException("Unexpected EOF. position = " + this.mOffset);
                }
                if (!skipData) {
                    if (strbuf == null) {
                        strbuf = new StringBuffer();
                    }
                    if (this.LA(0) == 38) {
                        strbuf.append((char)this.parseEscape());
                    } else {
                        strbuf.append((char)this.LA(0));
                    }
                }
                this.LT();
                continue;
            }
            if (this.LA(1) == 33 && this.LA(2) == 45) {
                this.parseComments();
                continue;
            }
            if (this.LA(1) != 33 || this.LA(2) != 91) break;
            if (!skipData) {
                if (cdatabuf == null) {
                    cdatabuf = new StringBuffer();
                }
                cdatabuf.append((char)this.LA(0));
                cdatabuf.append((char)this.LA(1));
                cdatabuf.append((char)this.LA(2));
            }
            this.LT();
            this.LT();
            this.LT();
            if (this.LA(0) != 67 || this.LA(1) != 68 || this.LA(2) != 65) {
                if (skipData) continue;
                if (strbuf == null) {
                    strbuf = new StringBuffer();
                }
                strbuf.append(cdatabuf);
                continue;
            }
            if (!skipData) {
                if (cdatabuf == null) {
                    cdatabuf = new StringBuffer();
                }
                cdatabuf.append((char)this.LA(0));
                cdatabuf.append((char)this.LA(1));
                cdatabuf.append((char)this.LA(2));
            }
            this.LT();
            this.LT();
            this.LT();
            if (this.LA(0) != 84 || this.LA(1) != 65 || this.LA(2) != 91) {
                if (skipData) continue;
                if (strbuf == null) {
                    strbuf = new StringBuffer();
                }
                strbuf.append(cdatabuf);
                continue;
            }
            this.LT();
            this.LT();
            this.LT();
            if (skipData) continue;
            if (strbuf == null) {
                strbuf = new StringBuffer();
            }
            strbuf.append(this.parseCDATA());
        }
        if (strbuf != null && !skipData) {
            ((EndTag)this.mTagStack.peek()).appendData(strbuf);
        }
    }

    private String parseCDATA() throws IOException, LexerException {
        StringBuffer cdatabuf = null;
        while (this.LA(0) != 93 || this.LA(1) != 93 || this.LA(2) != 62) {
            if (this.LA(0) == -1) {
                this.mEOF = true;
                throw new LexerException("Unexpected EOF. position = " + this.mOffset);
            }
            if (cdatabuf == null) {
                cdatabuf = new StringBuffer();
            }
            cdatabuf.append((char)this.LA(0));
            this.LT();
        }
        this.LT();
        this.LT();
        this.LT();
        if (cdatabuf == null) {
            return null;
        }
        return cdatabuf.toString();
    }

    private Tag nextTag(boolean ignoreAttibutes, boolean skipData) throws IOException, LexerException {
        block16: {
            if (!this.mInitialized || this.mEOF) {
                throw new LexerException("Invalid context - not initialized or EOF.");
            }
            if (this.mEndTag != null) {
                if (!this.mTagOpen) {
                    throw new LexerException("Invalid state - tag must be open.");
                }
                EndTag tag = this.mEndTag;
                this.mEndTag = null;
                this.mTagOpen = false;
                if (this.mTagStack.isEmpty()) {
                    this.mEOF = true;
                }
                this.fireEndPrefixMapping();
                return tag;
            }
            while (true) {
                if (this.mTagStack.isEmpty()) {
                    this.skipBlanks();
                } else {
                    this.parseData(skipData);
                }
                if (this.LA(0) != 60) {
                    throw new LexerException("Expect '<'. position = " + this.mOffset);
                }
                if (this.LA(1) == 63) {
                    this.parsePI(false);
                    continue;
                }
                if (this.LA(1) != 33) break block16;
                if (this.LA(2) != 45) break;
                this.parseComments();
            }
            throw new LexerException("Invalid character. position = " + this.mOffset + 2);
        }
        if (XmlCharacter.isLetter(this.LA(1)) || this.LA(1) == 95 || this.LA(1) == 58) {
            StartTag starttag = this.parseStartTag(ignoreAttibutes);
            Map attrs = starttag.getAttrs();
            HashMap tagPrefixMap = new HashMap();
            if (attrs != null && attrs.size() > 0) {
                Iterator it = attrs.keySet().iterator();
                while (it.hasNext()) {
                    String qname = (String)it.next();
                    if (qname.startsWith("xmlns:")) {
                        String prefix = qname.substring("xmlns:".length());
                        tagPrefixMap.put(prefix, attrs.get(qname));
                        this.startPrefixMapping(prefix, (String)attrs.get(qname));
                        continue;
                    }
                    if (!qname.equals("xmlns")) continue;
                    tagPrefixMap.put("", attrs.get(qname));
                    this.startPrefixMapping("", (String)attrs.get(qname));
                }
            }
            this.mTagPrefixStack.push(tagPrefixMap);
            if (this.mReturnPrefixMap) {
                starttag.setPrefixMap(this.mCurrentPrefixMap);
                starttag.setReversePrefixMap(this.mCurrentReversePrefixMap);
                this.mPrefixInUse = true;
            }
            return starttag;
        }
        if (this.LA(1) == 47) {
            EndTag endtag = this.parseEndTag();
            if (this.mTagStack.isEmpty()) {
                this.mEOF = true;
            }
            this.fireEndPrefixMapping();
            return endtag;
        }
        throw new LexerException("Invalid token character. position = " + this.mOffset + 1);
    }

    public void setReturnPrefixMap(boolean b) {
        this.mReturnPrefixMap = b;
    }

    public boolean getReturnPrefixMap() {
        return this.mReturnPrefixMap;
    }

    public Location getCurrentLocation() {
        return new Location(this.mCol, this.mLine, this.mOffset);
    }

    public void skip(String tagname) throws IOException, LexerException {
    }

    public void skip(int nTags) throws IOException, LexerException {
    }

    public Tag search(String path) throws IOException, LexerException {
        return null;
    }

    public Tag nextTag() throws IOException, LexerException {
        return this.nextTag(false, false);
    }

    public EndTag matchEndTag(String tagname) throws IOException, LexerException {
        return null;
    }

    public void continueAt(long pos) throws IOException, LexerException {
    }

    public void validateForm() throws IOException, LexerException {
        if (!this.mInitialized) {
            this.init();
        }
        while (!this.mEOF) {
            this.nextTag(true, true);
        }
    }

    public boolean isEOF() {
        return this.mEOF;
    }

    Map getPrefixMapForUpdate() {
        if (this.mPrefixInUse) {
            HashMap oldMap = this.mCurrentPrefixMap;
            this.mCurrentPrefixMap = new HashMap();
            this.mCurrentReversePrefixMap = new HashMap();
            Iterator it = oldMap.keySet().iterator();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                String uri = (String)oldMap.get(prefix);
                this.mCurrentPrefixMap.put(prefix, uri);
                this.mCurrentReversePrefixMap.put(uri, prefix);
            }
            this.mPrefixInUse = false;
        }
        return this.mCurrentPrefixMap;
    }

    Map getRevPrefixMapForUpdate() {
        return this.mCurrentReversePrefixMap;
    }
}

