/*
 * Decompiled with CFR 0.152.
 */
package com.stc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class EgateConfig {
    private static Properties preProp = new Properties();
    private static Properties jcsProp = new Properties();
    private static File jcsFile = new File(System.getProperty("user.home"), ".ecrc");

    public static void reload() {
        try {
            FileInputStream is = new FileInputStream(jcsFile);
            jcsProp.load(is);
            ((InputStream)is).close();
        }
        catch (FileNotFoundException fnf) {
        }
        catch (IOException io) {
            System.out.println("can't init from \"" + jcsFile.getPath() + '\"');
        }
    }

    public static String getProperty(String key) {
        return EgateConfig.getProperty(key, null, false);
    }

    public static String getProperty(String key, String deft) {
        return EgateConfig.getProperty(key, deft, false);
    }

    public static String getProperty(String key, boolean now) {
        return EgateConfig.getProperty(key, null, now);
    }

    public static String getProperty(String key, String deft, boolean now) {
        String res = System.getProperty(key);
        if (res == null) {
            if (now) {
                EgateConfig.reload();
            }
            if ((res = jcsProp.getProperty(key)) == null && (res = preProp.getProperty(key)) == null) {
                res = deft;
            }
        }
        return res;
    }

    public static boolean getFlag(String key, boolean deft) {
        String res = EgateConfig.getProperty(key);
        if (res == null) {
            return deft;
        }
        if (res.equals("0") || res.equals("N") || res.equals("n") || res.equals("no") || res.equals("F") || res.equals("f") || res.equals("false")) {
            return false;
        }
        if (res.equals("1") || res.equals("Y") || res.equals("y") || res.equals("yes") || res.equals("T") || res.equals("t") || res.equals("true")) {
            return true;
        }
        throw new RuntimeException("eGate property [" + key + "] has illegal value \"" + res + "\"");
    }

    public static int getInteger(String key, int deft) throws NumberFormatException {
        String res = EgateConfig.getProperty(key);
        return res == null || res.equals("") ? deft : Integer.parseInt(res);
    }

    public static void main(String[] args) {
        System.out.println("ecrc file " + (jcsFile.exists() ? "is" : "would be") + " <" + jcsFile.getPath() + ">");
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-p")) {
                System.out.println("// Predefined Properties:");
                preProp.list(System.out);
                continue;
            }
            if (args[i].equals("-j")) {
                System.out.println("// User-defined Properties:");
                jcsProp.list(System.out);
                continue;
            }
            String v = EgateConfig.getProperty(args[i]);
            System.out.println("Value of [" + args[i] + "] is " + (v == null ? "undefined" : '\"' + v + '\"'));
        }
    }

    static {
        EgateConfig.reload();
        preProp.setProperty("JGen.antlr", "com.stc.antlr");
    }
}

