/*
 * Decompiled with CFR 0.152.
 */
package com.stc.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class FileSelect {
    private static Properties mChoices = null;
    private static File mDefault = null;

    private static File getDefault() {
        if (mDefault == null) {
            String path = System.getProperty("user.home");
            if (path == null || !(path instanceof String)) {
                path = ".";
            }
            mDefault = new File(path);
        }
        return mDefault;
    }

    private static File getStorage() {
        return new File(System.getProperty("user.home"), ".etmp");
    }

    private static Properties getChoices() {
        if (mChoices == null) {
            mChoices = new Properties();
            File file = FileSelect.getStorage();
            if (file.isFile()) {
                try {
                    System.out.println("loading from [" + file.getAbsolutePath() + "]");
                    mChoices.load(new FileInputStream(FileSelect.getStorage()));
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return mChoices;
    }

    private static void dump(PrintStream out) {
        Properties choices = FileSelect.getChoices();
        Iterator iter = choices.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry entry = iter.next();
            out.println((String)entry.getKey() + "=" + entry.getValue());
        }
        out.flush();
    }

    public static File getFile(String key) {
        File file;
        if (key == null) {
            throw new NullPointerException("no key");
        }
        String path = FileSelect.getChoices().getProperty(key);
        if (path != null && (file = new File(path)).exists()) {
            return file;
        }
        file = FileSelect.getDefault();
        FileSelect.setFile(key, file);
        return file;
    }

    public static boolean setFile(String key, File file) {
        if (key == null) {
            throw new NullPointerException("no key");
        }
        if (file == null) {
            throw new NullPointerException("no file");
        }
        String path = file.getAbsolutePath();
        String old = FileSelect.getChoices().getProperty(key);
        System.out.println("setting [" + key + "]=[" + path + "] from [" + old + "]");
        if (!path.equals(old)) {
            mChoices.setProperty(key, path);
            try {
                mChoices.store(new FileOutputStream(FileSelect.getStorage()), "eGate file chooser defaults");
                return true;
            }
            catch (IOException io) {
                // empty catch block
            }
        }
        return false;
    }
}

