/*
 * Decompiled with CFR 0.152.
 */
package com.stc.util;

public class Option {
    public static final int EOF = -1;
    public boolean mDebug = false;
    private String mOptArg = null;
    private String[] mArgs;
    private boolean mEnd;
    private int mOptInd;
    private int mOptPos;
    private String mValid;

    public Option(String[] args, String valid) {
        if (args == null) {
            throw new NullPointerException("no arguments");
        }
        if (valid == null) {
            throw new NullPointerException("no valid options");
        }
        this.mArgs = args;
        this.mValid = valid;
        this.mOptInd = 0;
        this.mOptPos = 0;
        this.mEnd = false;
    }

    public int getOpt() {
        if (this.mEnd || this.mOptInd >= this.mArgs.length) {
            return -1;
        }
        int len = this.mArgs[this.mOptInd].length();
        if (len <= this.mOptPos) {
            ++this.mOptInd;
            this.mOptPos = 0;
            return this.getOpt();
        }
        if (this.mOptPos == 0) {
            if (len == 0) {
                return -1;
            }
            if (this.mArgs[this.mOptInd].charAt(0) == '-') {
                if (len == 1 || len == 2 && this.mArgs[this.mOptInd].charAt(1) == '-') {
                    if (this.mDebug) {
                        System.out.println("[ option end ]");
                    }
                    this.mEnd = true;
                    ++this.mOptInd;
                    return -1;
                }
                this.mOptPos = 1;
            } else {
                return -1;
            }
        }
        char c = this.mArgs[this.mOptInd].charAt(this.mOptPos);
        int i = this.mValid.indexOf(c);
        ++this.mOptPos;
        if (i < 0) {
            StringBuffer sb = new StringBuffer("unknown option '-" + c + "' (in argument " + this.mOptInd + "), valid options are:");
            for (int j = 0; j < this.mValid.length(); ++j) {
                char v = this.mValid.charAt(j);
                sb.append(v != ':' ? " -" + v : "#");
            }
            throw new RuntimeException(sb.toString());
        }
        if (i + 1 < this.mValid.length() && this.mValid.charAt(i + 1) == ':') {
            if (this.mOptPos < len) {
                this.mOptArg = this.mArgs[this.mOptInd].substring(this.mOptPos, len);
                ++this.mOptInd;
                this.mOptPos = 0;
            } else {
                if (this.mOptInd + 1 >= this.mArgs.length) {
                    throw new RuntimeException("missing final parameter");
                }
                this.mOptArg = this.mArgs[this.mOptInd + 1];
                this.mOptInd += 2;
                this.mOptPos = 0;
            }
            if (this.mDebug) {
                System.out.println("[ option '-" + c + "' <" + this.mOptArg + "> ]");
            }
        } else {
            this.mOptArg = null;
            if (this.mDebug) {
                System.out.println("[ option '-" + c + "' ]");
            }
        }
        return c;
    }

    public String getOptArg() {
        if (this.mOptArg == null) {
            throw new RuntimeException("can't get argument for this option");
        }
        return this.mOptArg;
    }

    public int getOptInd() {
        return this.mOptInd;
    }

    public static void main(String[] args) {
        try {
            int at;
            int key;
            String keys = args[0];
            String[] rest = new String[args.length - 1];
            for (int i = 0; i < rest.length; ++i) {
                rest[i] = args[i + 1];
            }
            Option opt = new Option(rest, keys);
            while ((key = opt.getOpt()) != -1) {
                at = keys.indexOf((char)key);
                if (at >= 0 && ++at < keys.length() && keys.charAt(at) == ':') {
                    System.out.println("  -" + (char)key + " '" + opt.getOptArg() + "'");
                    continue;
                }
                System.out.println("  -" + (char)key);
            }
            for (at = opt.getOptInd(); at < rest.length; ++at) {
                System.out.println("  '" + rest[at] + "'");
            }
        }
        catch (Exception all) {
            all.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

