/*
 * Decompiled with CFR 0.152.
 */
package com.stc.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;

public class OtdObjectFactory {
    private static boolean mUseCaching = true;
    private static HashMap mReadCache = new HashMap();
    private static HashMap mWriteCache = new HashMap();

    public static Object createInstance(ClassLoader loader, String className) throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        return OtdObjectFactory.loadClass(loader, className).newInstance();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class loadClass(ClassLoader loader, String className) throws ClassNotFoundException {
        String originalClassName = className;
        String s1 = null;
        String s2 = null;
        int idx1 = -1;
        String key = originalClassName;
        Class<?> clazz = null;
        if (mUseCaching) {
            SoftReference clazzRef;
            if (loader != null) {
                StringBuffer sBuf = new StringBuffer();
                sBuf.append(loader.hashCode());
                sBuf.append(originalClassName);
                key = sBuf.toString();
            }
            if ((clazzRef = (SoftReference)mReadCache.get(key)) != null && (clazz = (Class<?>)clazzRef.get()) != null) {
                return clazz;
            }
        }
        try {
            clazz = loader == null ? Class.forName(className) : loader.loadClass(className);
        }
        catch (ClassNotFoundException ex) {
            // empty catch block
        }
        while (clazz == null && (idx1 = className.lastIndexOf(".")) >= 0) {
            s1 = className.substring(0, idx1);
            s2 = className.substring(idx1 + 1);
            className = s1 + "$" + s2;
            try {
                if (loader == null) {
                    clazz = Class.forName(className);
                    continue;
                }
                clazz = loader.loadClass(className);
            }
            catch (ClassNotFoundException ex) {}
        }
        if (clazz == null) {
            throw new ClassNotFoundException(originalClassName);
        }
        if (mUseCaching) {
            HashMap hashMap = mWriteCache;
            synchronized (hashMap) {
                mWriteCache.put(key, new SoftReference<Class>(clazz));
                mReadCache = new HashMap(mWriteCache);
            }
        }
        return clazz;
    }

    public static void disableCaching() {
        mUseCaching = false;
        mReadCache.clear();
        mWriteCache.clear();
    }
}

