/*
 * Decompiled with CFR 0.152.
 */
package com.stc.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.jar.JarFile;

public class OtdURLClassLoader
extends ClassLoader {
    private final ClassLoader mClassLoader;
    private final ClassLoader mParentLoader;

    public OtdURLClassLoader(ClassLoader urlClassLoader, ClassLoader parent) {
        this.mClassLoader = urlClassLoader;
        this.mParentLoader = parent;
    }

    public Class findClass(String name) throws ClassNotFoundException {
        InputStream s = this.mClassLoader.getResourceAsStream(name.replace('.', '/') + ".class");
        if (s == null) {
            try {
                String classname = name.replace('.', '/') + ".class";
                String jarfilename = ((URLClassLoader)this.mClassLoader).getURLs()[0].getFile();
                JarFile jf = new JarFile(jarfilename);
                s = jf.getInputStream(jf.getEntry(classname));
            }
            catch (Throwable E) {
                // empty catch block
            }
        }
        if (s == null) {
            return this.mParentLoader.loadClass(name);
        }
        byte[] classImage = this.loadBytes(s);
        try {
            s.close();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to close class image stream.", e);
        }
        return this.defineClass(name, classImage, 0, classImage.length);
    }

    protected URL findResource(String name) {
        URL url = this.mClassLoader.getResource(name);
        if (url != null) {
            return url;
        }
        return this.mParentLoader.getResource(name);
    }

    private byte[] loadBytes(InputStream in) {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        try {
            int read = -1;
            while ((read = in.read(buf)) != -1) {
                bOut.write(buf, 0, read);
            }
            return bOut.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException("unable to load class image from stream.", e);
        }
    }

    public InputStream getResourceAsStream(String name) {
        InputStream is = super.getResourceAsStream(name);
        if (is != null) {
            return is;
        }
        try {
            String jarfilename = ((URLClassLoader)this.mClassLoader).getURLs()[0].getFile();
            JarFile jf = new JarFile(jarfilename);
            is = jf.getInputStream(jf.getEntry(name));
            return is;
        }
        catch (Throwable E) {
            return null;
        }
    }
}

