/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.bpi;

import com.stc.bpms.common.integration.mapper.MNode;
import com.stc.bpms.common.integration.mapper.MNodeException;
import com.stc.bpms.common.model.wsdl.Part;
import com.stc.egate.gui.projectexplorer.ProjectTree;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.Project;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdFlower;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdLeaf;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdNameValueTypeMap;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.OtdPetal;
import com.stc.otd.forest.OtdSeed;
import com.stc.otd.forest.OtdThorn;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdTrunk;
import com.stc.otd.forest.OtdVine;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.provider.OtdCommonModule;
import com.stc.otd.xsd.repository.XSDObjectTypeDefinition;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;
import org.openide.TopManager;

public class OTDMNodeImpl
implements MNode {
    private static Logger mLogger = Logger.getLogger((Class)(class$com$stc$otd$xsd$bpi$OTDMNodeImpl == null ? (class$com$stc$otd$xsd$bpi$OTDMNodeImpl = OTDMNodeImpl.class$("com.stc.otd.xsd.bpi.OTDMNodeImpl")) : class$com$stc$otd$xsd$bpi$OTDMNodeImpl));
    private String mName;
    private int mMin;
    private int mMax;
    private String mDescription;
    private boolean mIsOptional;
    private boolean mIsAttribute;
    private List mChildren;
    private MNode mParent;
    private OtdGrove mOtdGrove;
    private OtdOrigin mOtdOrigin;
    private OtdWood mOtdWood;
    static /* synthetic */ Class class$com$stc$otd$xsd$bpi$OTDMNodeImpl;

    public OTDMNodeImpl(Part part) {
        this.mParent = null;
        this.initRoot(part);
    }

    public OTDMNodeImpl(MNode parent, OtdWood node, OtdGrove grove, OtdOrigin origin) {
        this.mParent = parent;
        this.mOtdGrove = grove;
        this.mOtdOrigin = origin;
        this.mOtdWood = node;
        this.initNode(node);
    }

    private boolean isFakeTree(OtdWood wood) {
        OtdNameValueType nvt;
        OtdSeed seed = this.mOtdOrigin.getOtdSeed(wood.getId());
        if (seed != null && (nvt = seed.getOtdSeedInfo("fakeTree")) != null) {
            Object value = nvt.getValue();
            if (value == null) {
                return false;
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            if (value instanceof String && (((String)value).equalsIgnoreCase("true") || ((String)value).equalsIgnoreCase("1"))) {
                return true;
            }
        }
        return false;
    }

    void initRoot(Part part) {
        this.mChildren = null;
        this.mIsAttribute = false;
        this.mIsOptional = false;
        this.mDescription = "";
        this.mName = "";
        this.mMax = 1;
        this.mMin = 1;
        XSDObjectTypeDefinition otd = (XSDObjectTypeDefinition)part.getMetadataRepositoryObject();
        if (null == otd) {
            return;
        }
        try {
            String nuName;
            OtdMetaContainer otdMeta = this.getMeta((ObjectTypeDefinition)otd);
            this.mOtdGrove = otdMeta.getOtdGrove();
            this.mOtdOrigin = otdMeta.getOtdOrigin();
            int topNodeId = otd.getTopNodeId();
            OtdTrunk trunk = this.mOtdGrove.getTopTree(Integer.toString(topNodeId));
            if (trunk == null) {
                mLogger.error((Object)"Top node id not set by otd");
                return;
            }
            String otdGetName = otd.getName();
            String partGetName = part.getName();
            String trunkGetName = trunk.getName();
            boolean matchPartName = false;
            if (otd.getName().equals(part.getName())) {
                this.mOtdWood = trunk;
                this.mName = otd.getJavaName();
            } else {
                if (trunk.getName().equals(part.getName()) || trunk.getJavaName().equals(part.getName())) {
                    this.mOtdWood = trunk;
                    this.mName = this.mOtdWood.getJavaName();
                }
                if (this.mOtdWood == null) {
                    OtdOrigin otdOrigin = otdMeta.getOtdOrigin();
                    Iterator i = ((OtdTree)trunk).getChildren().iterator();
                    while (i.hasNext()) {
                        OtdNameValueType attr;
                        OtdWood wood = (OtdWood)i.next();
                        String partName = null;
                        OtdNameValueTypeMap attrs = otdOrigin.getOtdSeedInfo(wood.getId());
                        if (attrs != null && (attr = attrs.get("part")) != null) {
                            partName = (String)attr.getValue();
                        }
                        if (!wood.getName().equals(part.getName()) && !part.getName().equals(partName)) continue;
                        this.mOtdWood = wood;
                        this.mName = this.mOtdWood.getJavaName();
                        matchPartName = true;
                        break;
                    }
                }
            }
            if (!matchPartName && this.mName.compareToIgnoreCase(trunkGetName) != 0 && (nuName = this.fix504DisplayName(this.mName, trunkGetName, otdGetName)) != null) {
                this.mName = nuName;
            }
            if (this.mOtdWood != null) {
                if (this.mOtdWood.isRepeated()) {
                    this.mMax = -1;
                }
                this.mIsOptional = this.mOtdWood.isOptional();
            }
        }
        catch (Exception e) {
            mLogger.error((Object)"Unable to initialize MNode:", (Throwable)e);
        }
    }

    private String fix504DisplayName(String dName, String tName, String oName) {
        String xoName;
        String xdName = dName.replaceAll("_", ".").toLowerCase();
        if (!xdName.endsWith(xoName = oName.replaceAll("_", ".").toLowerCase())) {
            return tName;
        }
        return null;
    }

    void initNode(OtdWood node) {
        this.mChildren = null;
        this.mDescription = "";
        this.mIsAttribute = false;
        this.mMin = 1;
        this.mMax = 1;
        this.mIsOptional = false;
        this.mName = node.getJavaName();
        this.mIsOptional = node.isOptional();
        if (node.isRepeated()) {
            this.mMax = -1;
        }
    }

    public MNode getChildAt(int index) throws MNodeException {
        try {
            return (MNode)this.getChildren().get(index);
        }
        catch (IndexOutOfBoundsException e) {
            throw new MNodeException(e.getMessage());
        }
    }

    public int getChildCount() {
        return this.getChildren().size();
    }

    public List getChildren() {
        if (null == this.mChildren) {
            this.mChildren = new ArrayList();
            OtdWood wood = this.mOtdWood;
            if (wood.getType() == 4) {
                while (wood.getType() == 4 && this.isFakeTree((OtdWood)((OtdVine)wood).getRef())) {
                    wood = ((OtdVine)wood).getRef().getFirstChild();
                }
                OtdTree refWood = ((OtdVine)wood).getRef();
                if (refWood != null) {
                    wood = refWood;
                }
            }
            Iterator woodIter = wood.getChildren().iterator();
            while (woodIter.hasNext()) {
                OtdWood node = (OtdWood)woodIter.next();
                OTDMNodeImpl mNode = new OTDMNodeImpl(this, node, this.mOtdGrove, this.mOtdOrigin);
                this.mChildren.add(mNode);
            }
        }
        return Collections.unmodifiableList(this.mChildren);
    }

    public String getDescription() {
        return this.mDescription;
    }

    public int getMax() {
        return this.mMax;
    }

    public int getMin() {
        return this.mMin;
    }

    public String getName() {
        return this.mName;
    }

    public MNode getParent() {
        return this.mParent;
    }

    public String getXSDType() {
        if (this.mOtdWood != null) {
            OtdNameValueType nvt;
            OtdSeed seed;
            String id = this.mOtdWood.getId();
            if (this.mOtdOrigin != null && (seed = this.mOtdOrigin.getOtdSeed(id)) != null && (nvt = seed.getOtdSeedInfo("xsdType")) != null) {
                String value = nvt.getValue().toString();
                if (value != null) {
                    value = "xsd:" + value;
                }
                return value;
            }
        }
        if (this.mOtdWood instanceof OtdLeaf) {
            return this.getXSDType(((OtdLeaf)this.mOtdWood).getJavaType());
        }
        if (this.mOtdWood instanceof OtdFlower) {
            return this.getXSDType(((OtdFlower)this.mOtdWood).getJavaType());
        }
        if (this.mOtdWood instanceof OtdPetal) {
            return this.getXSDType(((OtdPetal)this.mOtdWood).getJavaType());
        }
        if (this.mOtdWood instanceof OtdThorn) {
            return this.getXSDType(((OtdThorn)this.mOtdWood).getJavaType());
        }
        return null;
    }

    private String getXSDType(String javaType) {
        if (javaType == null) {
            return null;
        }
        String xsdType = null;
        if (javaType.startsWith("com.stc.")) {
            if (javaType.equals("com.stc.duration")) {
                xsdType = "duration";
            } else if (javaType.equals("com.stc.dateTime")) {
                xsdType = "dateTime";
            } else if (javaType.equals("com.stc.time")) {
                xsdType = "time";
            } else if (javaType.equals("com.stc.date")) {
                xsdType = "date";
            } else if (javaType.equals("com.stc.gYearMonth")) {
                xsdType = "gYearMonth";
            } else if (javaType.equals("com.stc.gYear")) {
                xsdType = "gYear";
            } else if (javaType.equals("com.stc.gMonthDay")) {
                xsdType = "gMonthDay";
            } else if (javaType.equals("com.stc.gDay")) {
                xsdType = "gDay";
            } else if (javaType.equals("com.stc.gMonth")) {
                xsdType = "gMonth";
            } else if (javaType.equals("com.stc.anyURI")) {
                xsdType = "anyURI";
            }
            if (xsdType != null) {
                xsdType = "xsd:" + xsdType;
            }
            return xsdType;
        }
        if (javaType.equals("java.lang.String") || javaType.equalsIgnoreCase("string")) {
            xsdType = "string";
        } else if (javaType.equals("boolean")) {
            xsdType = "boolean";
        } else if (javaType.equals("java.math.BigDecimal")) {
            xsdType = "decimal";
        } else if (javaType.equalsIgnoreCase("int")) {
            xsdType = "int";
        } else if (javaType.equalsIgnoreCase("long")) {
            xsdType = "long";
        } else if (javaType.equalsIgnoreCase("short")) {
            xsdType = "short";
        } else if (javaType.equalsIgnoreCase("byte")) {
            xsdType = "byte";
        } else if (javaType.equalsIgnoreCase("float")) {
            xsdType = "float";
        } else if (javaType.equalsIgnoreCase("double")) {
            xsdType = "double";
        } else if (javaType.equals("java.lang.Object")) {
            xsdType = "Node";
        } else if (javaType.equals("byte[]")) {
            xsdType = "base64Binary";
        }
        if (xsdType != null) {
            xsdType = "xsd:" + xsdType;
        }
        return xsdType;
    }

    public boolean isAttribute() {
        return false;
    }

    public boolean isLeaf() {
        return this.getChildCount() == 0;
    }

    public boolean isOptional() {
        return this.mIsOptional;
    }

    private OtdMetaContainer getMeta(ObjectTypeDefinition otd) throws Exception {
        OtdContext context = OtdCommonModule.getOtdContext((Repository)ProjectTree.getConnectRepository(), (ClassLoader)TopManager.getDefault().systemClassLoader());
        String path = this.getOtdPath(otd);
        mLogger.debug((Object)("looking up otd meta for: '" + path + "'"));
        return context.lookUpOtd(path);
    }

    private String getOtdPath(ObjectTypeDefinition otd) throws RepositoryException {
        StringBuffer path = new StringBuffer("/" + otd.getName());
        for (Project parent = otd.getParentProject(); parent != null; parent = parent.getParentProject()) {
            path.insert(0, "/" + parent.getName());
        }
        return path.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

