/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.bpi;

import com.stc.bpms.common.integration.mapper.MNodeFactory;
import com.stc.bpms.common.integration.mapper.MNodeFactoryRegistry;
import com.stc.bpms.common.model.wsdl.MNodeContainer;
import com.stc.bpms.common.model.wsdl.Operation;
import com.stc.bpms.common.model.wsdl.OperationFault;
import com.stc.bpms.common.model.wsdl.OperationInput;
import com.stc.bpms.common.model.wsdl.OperationOutput;
import com.stc.bpms.common.model.wsdl.Part;
import com.stc.bpms.common.model.wsdl.PortType;
import com.stc.bpms.common.model.wsdl.WSDLDefinitions;
import com.stc.bpms.common.model.wsdl.WSDLDocument;
import com.stc.bpms.common.model.wsdl.WSDLMessage;
import com.stc.bpms.common.repository.EInsightManager;
import com.stc.bpms.common.repository.WSDLRepositoryObject;
import com.stc.guirepositorymanager.GUIRepositoryManager;
import com.stc.guirepositorymanager.GUIRepositoryManagerException;
import com.stc.model.common.ObjectTypeDefinition;
import com.stc.model.common.Project;
import com.stc.model.common.ProjectElement;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdTrunk;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import com.stc.otd.forest.provider.OtdCommonModule;
import com.stc.otd.forest.provider.OtdXMLUtil;
import com.stc.otd.xsd.repository.XSDObjectTypeDefinition;
import com.stc.repository.Repository;
import com.stc.repository.RepositoryException;
import com.stc.repository.RepositoryObject;
import com.stc.repository.persistence.client.Persistable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.openide.TopManager;

public abstract class XSDOTDBusinessProcessCallableSupport {
    public static final String WSDL_TARGET_NAMESPACE_PREFIX = "urn:stc:egate:otd";
    public static final String WSDL_REPOSITORY_NAME_PREFIX = "wsdl_otd_";
    public static final String TNS_PREFIX = "tns";
    public static final String MARSHAL_NAME = "marshal";
    public static final String UNMARSHAL_NAME = "unmarshal";
    private static ProjectElement mProjectElement;

    private XSDOTDBusinessProcessCallableSupport() {
    }

    private static String getJavaName(OtdMetaContainer metaContainer, String topNodeId) throws RepositoryException, Exception {
        OtdGrove grove = metaContainer.getOtdGrove();
        String packageName = metaContainer.getPackageName();
        OtdTrunk topTrunk = grove.getTopTree(topNodeId);
        if (topTrunk != null) {
            String className;
            String result = "";
            if (packageName != null) {
                result = result + packageName;
            }
            if (result.length() > 0) {
                result = result + ".";
            }
            if ((className = topTrunk.getJavaName()) == null) {
                className = topTrunk.getName();
            }
            result = result + className;
            return result;
        }
        OtdTree tree = grove.getFirstTree();
        OtdWoodList woodList = grove.getTrees();
        Iterator iter = woodList.iterator();
        while (iter.hasNext()) {
            String className;
            OtdWood wood = (OtdWood)iter.next();
            OtdTrunk trunk = (OtdTrunk)wood;
            if (!trunk.isTop()) continue;
            String result = "";
            if (packageName != null) {
                result = result + packageName;
            }
            if (result.length() > 0) {
                result = result + ".";
            }
            if ((className = wood.getJavaName()) == null) {
                className = wood.getName();
            }
            result = result + className;
            return result;
        }
        throw new Exception("Failed to find java name. Top Node ID = " + topNodeId);
    }

    public static RepositoryObject createRepositoryObject(String portTypeName, String name, ProjectElement projectElement) throws RepositoryException, Exception {
        Repository rep;
        RepositoryObject repObj;
        block5: {
            if (projectElement == null) {
                throw new NullPointerException("The otd projectElement is null");
            }
            repObj = ((XSDObjectTypeDefinition)projectElement).getBusinessProcessDefinitions();
            rep = null;
            try {
                rep = GUIRepositoryManager.getActiveRepository();
            }
            catch (GUIRepositoryManagerException grme) {
                rep = (Repository)projectElement.getCUDTracker();
                if (rep != null) break block5;
                throw new RepositoryException("No active repository connection available");
            }
        }
        EInsightManager eInsightManager = (EInsightManager)rep.getAPI("EInsightManager/SBYN200");
        if (null == repObj) {
            WSDLDocument wsdlDoc = XSDOTDBusinessProcessCallableSupport.createWSDLDocument(portTypeName, name, (XSDObjectTypeDefinition)projectElement, eInsightManager);
            String repName = WSDL_REPOSITORY_NAME_PREFIX + ((XSDObjectTypeDefinition)projectElement).getName();
            WSDLRepositoryObject wsdlRep = eInsightManager.createWSDLRepositoryObject(repName);
            wsdlRep.setConcreteModel(wsdlDoc);
            repObj = wsdlRep;
            ((XSDObjectTypeDefinition)projectElement).setBusinessProcessDefinitions(repObj);
            projectElement.getParentProject().addProjectElement((ProjectElement)wsdlRep);
        } else {
            WSDLDocument wsdlDoc = ((WSDLRepositoryObject)repObj).getConcreteModel();
        }
        return repObj;
    }

    public static void updateRepositoryObject(String portTypeName, String name, ProjectElement xsdProjectElement, RepositoryObject wsdl) throws RepositoryException, Exception {
        Repository rep;
        block2: {
            rep = null;
            try {
                rep = GUIRepositoryManager.getActiveRepository();
            }
            catch (GUIRepositoryManagerException grme) {
                rep = (Repository)xsdProjectElement.getCUDTracker();
                if (rep != null) break block2;
                throw new RepositoryException("No active repository connection available");
            }
        }
        rep.getVersionManager().checkOutForWrite((Persistable)wsdl);
        WSDLDocument wsdlDoc = ((WSDLRepositoryObject)wsdl).getConcreteModel();
        XSDOTDBusinessProcessCallableSupport.populateWSDLDocument(portTypeName, name, (XSDObjectTypeDefinition)xsdProjectElement, wsdlDoc);
        ((WSDLRepositoryObject)wsdl).setConcreteModel(wsdlDoc);
        rep.getVersionManager().saveToWorkspace((Persistable)wsdl);
    }

    static void populateWSDLDocument(String portTypeName, String name, XSDObjectTypeDefinition otd, WSDLDocument wsdlDoc) throws RepositoryException, Exception {
        HashMap<String, WSDLMessage> mapOfFaults = new HashMap<String, WSDLMessage>();
        WSDLDefinitions wsdlDef = wsdlDoc.createDefinitions();
        wsdlDoc.setDocumentDefinitions(wsdlDef);
        String targetNS = "urn:stc:egate:otd:" + name;
        wsdlDef.setTargetNamespace(targetNS);
        wsdlDef.setNamespace(TNS_PREFIX, targetNS);
        wsdlDef.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        String otdName = otd.getName();
        wsdlDef.setName(otdName);
        int topNodeId = otd.getTopNodeId();
        String sTopNodeId = Integer.toString(topNodeId);
        OtdMetaContainer metaContainer = OtdXMLUtil.parseOtd((ObjectTypeDefinition)otd);
        WSDLMessage otdMessage = null;
        String otdMessageName = null;
        try {
            otdMessageName = XSDOTDBusinessProcessCallableSupport.getJavaName(metaContainer, sTopNodeId);
            otdMessage = wsdlDoc.createWSDLMessage();
            otdMessage.setName(otdMessageName);
        }
        catch (Exception ex) {
            throw new Exception("Failed to get Java Name for OTD: " + otd.getName(), ex);
        }
        OtdGrove grove = metaContainer.getOtdGrove();
        OtdTrunk topTrunk = grove.getTopTree(sTopNodeId);
        if (topTrunk != null) {
            Part otdPart = wsdlDoc.createPart();
            otdPart.setName(topTrunk.getName());
            otdPart.setMetadataRepositoryObject((RepositoryObject)otd);
            otdPart.setElement(topTrunk.getName());
            otdMessage.addPart(otdPart);
        } else {
            OtdWoodList woodList = grove.getTrees();
            Iterator iter = woodList.iterator();
            while (iter.hasNext()) {
                OtdWood wood = (OtdWood)iter.next();
                OtdTrunk trunk = (OtdTrunk)wood;
                if (!trunk.isTop()) continue;
                Part otdPart = wsdlDoc.createPart();
                otdPart.setName(trunk.getName());
                otdPart.setMetadataRepositoryObject((RepositoryObject)otd);
                otdPart.setElement(trunk.getName());
                otdMessage.addPart(otdPart);
                break;
            }
        }
        wsdlDef.addMessage(otdMessage);
        String streamMessageName = "Stream";
        WSDLMessage streamMessage = wsdlDoc.createWSDLMessage();
        streamMessage.setName(streamMessageName);
        Part contentsPart = wsdlDoc.createPart();
        contentsPart.setName("contents");
        contentsPart.setType("xsd:string");
        streamMessage.addPart(contentsPart);
        wsdlDef.addMessage(streamMessage);
        String faultMessageName = "faultMessage";
        WSDLMessage faultMessage = wsdlDoc.createWSDLMessage();
        faultMessage.setName(faultMessageName);
        Part faultMessagePart = wsdlDoc.createPart();
        faultMessagePart.setName("message");
        faultMessagePart.setType("xsd:string");
        faultMessage.addPart(faultMessagePart);
        wsdlDef.addMessage(faultMessage);
        String unmarshalMarshalFaultMessageName = "unmarshalMarshalFaultMessage";
        WSDLMessage unmarshalMarshalFaultMessage = wsdlDoc.createWSDLMessage();
        unmarshalMarshalFaultMessage.setName(unmarshalMarshalFaultMessageName);
        Part faultLocationPart = wsdlDoc.createPart();
        faultLocationPart.setName("location");
        faultLocationPart.setType("xsd:string");
        Part faultStacktracePart = wsdlDoc.createPart();
        faultStacktracePart.setName("stackTrace");
        faultStacktracePart.setType("xsd:string");
        unmarshalMarshalFaultMessage.addPart(faultMessagePart);
        unmarshalMarshalFaultMessage.addPart(faultLocationPart);
        unmarshalMarshalFaultMessage.addPart(faultStacktracePart);
        wsdlDef.addMessage(unmarshalMarshalFaultMessage);
        mapOfFaults.put("GenericException", faultMessage);
        mapOfFaults.put("MarshalException", unmarshalMarshalFaultMessage);
        mapOfFaults.put("UnmarshalException", unmarshalMarshalFaultMessage);
        PortType portType = null;
        portType = XSDOTDBusinessProcessCallableSupport.createPortType(wsdlDoc, portTypeName, otdMessageName, streamMessageName, mapOfFaults);
        wsdlDef.addPortType(portType);
    }

    static WSDLDocument createWSDLDocument(String portTypeName, String name, XSDObjectTypeDefinition otd, EInsightManager eInsightManager) throws RepositoryException, Exception {
        WSDLDocument wsdlDoc = eInsightManager.createWSDLDocument();
        XSDOTDBusinessProcessCallableSupport.populateWSDLDocument(portTypeName, name, otd, wsdlDoc);
        return wsdlDoc;
    }

    public static WSDLDocument createWSDLDocument(XSDObjectTypeDefinition otd, EInsightManager eInsightManager) throws RepositoryException, Exception {
        WSDLDocument wsdlDoc = eInsightManager.createWSDLDocument();
        HashMap<String, WSDLMessage> mapOfFaults = new HashMap<String, WSDLMessage>();
        WSDLDefinitions wsdlDef = wsdlDoc.createDefinitions();
        wsdlDoc.setDocumentDefinitions(wsdlDef);
        String javaName = otd.getJavaName() != null ? otd.getJavaName() : otd.getName();
        String rootName = XSDOTDBusinessProcessCallableSupport.getForestRootJavaName((ObjectTypeDefinition)otd);
        String targetNS = "urn:stc:egate:otd:" + javaName.replace('.', ':');
        wsdlDef.setTargetNamespace(targetNS);
        wsdlDef.setNamespace(TNS_PREFIX, targetNS);
        wsdlDef.setNamespace("xsd", "http://www.w3.org/2001/XMLSchema");
        String otdName = otd.getName();
        wsdlDef.setName(otdName);
        WSDLMessage otdMessage = null;
        String otdMessageName = javaName;
        try {
            otdMessage = wsdlDoc.createWSDLMessage();
            otdMessage.setName(otdMessageName);
        }
        catch (Exception ex) {
            throw new Exception("Failed to get Java Name for OTD: " + otd.getName(), ex);
        }
        Part otdPart = wsdlDoc.createPart();
        otdPart.setName(rootName);
        otdPart.setMetadataRepositoryObject((RepositoryObject)otd);
        MNodeFactory mnFact = MNodeFactoryRegistry.get((String)(otd.getClass().getName() + "-bpms-MNodeFactory"));
        if (otdPart instanceof MNodeContainer) {
            ((MNodeContainer)otdPart).setMNodeFactory(mnFact);
        }
        otdPart.setType(javaName);
        otdMessage.addPart(otdPart);
        wsdlDef.addMessage(otdMessage);
        String streamMessageName = "Stream";
        WSDLMessage streamMessage = wsdlDoc.createWSDLMessage();
        streamMessage.setName(streamMessageName);
        Part contentsPart = wsdlDoc.createPart();
        contentsPart.setName("contents");
        contentsPart.setType("xsd:string");
        streamMessage.addPart(contentsPart);
        wsdlDef.addMessage(streamMessage);
        String faultMessageName = "faultMessage";
        WSDLMessage faultMessage = wsdlDoc.createWSDLMessage();
        faultMessage.setName(faultMessageName);
        Part faultMessagePart = wsdlDoc.createPart();
        faultMessagePart.setName("message");
        faultMessagePart.setType("xsd:string");
        faultMessage.addPart(faultMessagePart);
        wsdlDef.addMessage(faultMessage);
        String unmarshalMarshalFaultMessageName = "unmarshalMarshalFaultMessage";
        WSDLMessage unmarshalMarshalFaultMessage = wsdlDoc.createWSDLMessage();
        unmarshalMarshalFaultMessage.setName(unmarshalMarshalFaultMessageName);
        Part faultLocationPart = wsdlDoc.createPart();
        faultLocationPart.setName("location");
        faultLocationPart.setType("xsd:string");
        Part faultStacktracePart = wsdlDoc.createPart();
        faultStacktracePart.setName("stackTrace");
        faultStacktracePart.setType("xsd:string");
        unmarshalMarshalFaultMessage.addPart(faultMessagePart);
        unmarshalMarshalFaultMessage.addPart(faultLocationPart);
        unmarshalMarshalFaultMessage.addPart(faultStacktracePart);
        wsdlDef.addMessage(unmarshalMarshalFaultMessage);
        mapOfFaults.put("GenericException", faultMessage);
        mapOfFaults.put("MarshalException", unmarshalMarshalFaultMessage);
        mapOfFaults.put("UnmarshalException", unmarshalMarshalFaultMessage);
        PortType portType = null;
        portType = XSDOTDBusinessProcessCallableSupport.createPortType(wsdlDoc, javaName + "PortType", otdMessageName, streamMessageName, mapOfFaults);
        wsdlDef.addPortType(portType);
        return wsdlDoc;
    }

    static PortType createPortType(WSDLDocument doc, String portTypeName, String otdMessageName, String streamMessageName, Map faults) throws RepositoryException {
        PortType portType = doc.createPortType();
        portType.setName(portTypeName);
        for (int i = 0; i < 1; ++i) {
            String operationName = MARSHAL_NAME;
            portType.addOperation(XSDOTDBusinessProcessCallableSupport.createOperation(doc, operationName, portTypeName, otdMessageName, streamMessageName, new String[]{"GenericException", "MarshalException"}, faults));
            operationName = UNMARSHAL_NAME;
            portType.addOperation(XSDOTDBusinessProcessCallableSupport.createOperation(doc, operationName, portTypeName, streamMessageName, otdMessageName, new String[]{"GenericException", "UnmarshalException"}, faults));
        }
        return portType;
    }

    static Operation createOperation(WSDLDocument doc, String operationName, String portTypeName, String inputName, String outputName, String[] faultNames, Map faults) {
        Operation operation = doc.createOperation();
        operation.setName(operationName);
        OperationInput operInput = doc.createOperationInput();
        operInput.setMessage("tns:" + inputName);
        operation.setInput(operInput);
        OperationOutput operOutput = doc.createOperationOutput();
        operOutput.setMessage("tns:" + outputName);
        operation.setOutput(operOutput);
        for (int i = 0; i < faultNames.length; ++i) {
            String faultName = faultNames[i];
            String faultMessageName = ((WSDLMessage)faults.get(faultName)).getName();
            OperationFault operFault = doc.createOperationFault();
            operFault.setName(faultName);
            operFault.setMessage("tns:" + faultMessageName);
            operation.addFault(operFault);
        }
        return operation;
    }

    static String getForestRootJavaName(ObjectTypeDefinition otd) throws Exception {
        OtdTrunk root;
        block1: {
            OtdContext context = OtdCommonModule.getOtdContext((Repository)((Repository)otd.getCUDTracker()), (ClassLoader)TopManager.getDefault().systemClassLoader());
            OtdMetaContainer metaContainer = context.lookUpOtd(XSDOTDBusinessProcessCallableSupport.getOtdPath(otd));
            String sTopNodeId = Integer.toString(otd.getTopNodeId());
            root = metaContainer.getOtdGrove().getTopTree(sTopNodeId);
            if (root != null) break block1;
            Iterator iter = metaContainer.getOtdGrove().getTrees().iterator();
            while (iter.hasNext() && !(root = (OtdTrunk)iter.next()).isTop()) {
            }
        }
        return root.getJavaName();
    }

    static String getOtdPath(ObjectTypeDefinition otd) throws RepositoryException {
        StringBuffer path = new StringBuffer("/" + otd.getName());
        for (Project parent = otd.getParentProject(); parent != null; parent = parent.getParentProject()) {
            path.insert(0, "/" + parent.getName());
        }
        return path.toString();
    }
}

