/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.builder;

import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.OtdSeed;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class Memento {
    public static final String SEQUENCE_PREFIX = "_sequence_";
    public static final String CHOICE_PREFIX = "_choice_";
    public static final String ALL_PREFIX = "_all_";
    public static final String REPLACE_SEQUENCE_PREFIX = "_replace_s_";
    public static final String REPLACE_CHOICE_PREFIX = "_replace_c_";
    public static final String REPLACE_ALL_PREFIX = "_replace_a_";
    public static final String REPLACE_PREFIX = "_replace_";
    public boolean mDebug = true;
    public boolean mClash = false;
    public boolean mUseAncestorName = true;
    public boolean mPreservePackageName = false;
    private final Map mPool = new HashMap();
    private final Set mUsed = new HashSet();
    private final HashMap mTreeIDs = new HashMap();
    private String mPackageName;
    private String mOtdName;
    private int mRevision;
    private int mSeqNo = 0;

    public Memento() {
        this(false);
    }

    public Memento(boolean preservePackageName) {
        this.mPreservePackageName = preservePackageName;
    }

    public boolean hasMapping() {
        return this.mPool.size() > 0;
    }

    public void analyze(OtdMetaContainer otd) {
        OtdGrove grove;
        if (otd == null) {
            throw new NullPointerException("no OTD");
        }
        if (this.mPreservePackageName && otd.getOtdGrove() != null) {
            this.mPackageName = otd.getOtdGrove().getPackageName();
        }
        if ((grove = otd.getOtdGrove()) != null) {
            this.mOtdName = grove.getName();
            OtdWoodList trees = grove.getTrees();
            if (trees != null) {
                Iterator iter = trees.iterator();
                while (iter.hasNext()) {
                    OtdTree tree = (OtdTree)iter.next();
                    this.mTreeIDs.put(tree.getName(), tree.getId());
                    this.analyze((OtdWood)tree);
                }
            }
        }
        this.mRevision = this.getOtdRevision(otd);
    }

    private String[] fetchName(String parent, int index, String currentName) {
        String key = this.makeKey(parent, index);
        String[] names = (String[])this.mPool.get(key);
        if (names == null) {
            names = new String[]{this.isChoice(currentName) ? REPLACE_CHOICE_PREFIX + this.mSeqNo++ : (this.isAll(currentName) ? REPLACE_ALL_PREFIX + this.mSeqNo++ : REPLACE_SEQUENCE_PREFIX + this.mSeqNo++), CodeGeneratorUtil.makeClassName((String)names[0])};
            while (this.mUsed.contains(names[1])) {
            }
        } else {
            this.mPool.remove(key);
        }
        this.mUsed.add(names[1]);
        return names;
    }

    private String getAbsolutePath(OtdWood node) {
        String path = node.getName();
        if (node.getType() != 1) {
            for (OtdWood parentNode = node.getParent(); parentNode != null; parentNode = parentNode.getParent()) {
                if (!this.isCandidate(parentNode.getName())) {
                    path = path + "." + parentNode.getName();
                }
                if (parentNode.getType() == 1) break;
            }
        }
        return path;
    }

    private void analyze(OtdWood node) {
        OtdWoodList children;
        if (node != null && (children = node.getChildren()) != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                OtdWood child = children.getOtdWood(i);
                if (this.isCandidate(child.getName()) && !this.mUsed.contains(child.getJavaName())) {
                    String[] names = new String[]{child.getName(), child.getJavaName()};
                    if (this.mUseAncestorName) {
                        this.add(this.getAbsolutePath(node), i, names);
                    } else {
                        this.add(node.getName(), i, names);
                    }
                    this.mUsed.add(child.getJavaName());
                }
                if (child.getType() != 2) continue;
                this.analyze(child);
            }
        }
    }

    public boolean isCandidate(String name) {
        return name != null && (name.startsWith(CHOICE_PREFIX) || name.startsWith(SEQUENCE_PREFIX) || name.startsWith(ALL_PREFIX) || name.startsWith(REPLACE_SEQUENCE_PREFIX) || name.startsWith(REPLACE_CHOICE_PREFIX) || name.startsWith(REPLACE_ALL_PREFIX) || name.startsWith(REPLACE_PREFIX));
    }

    public boolean isSequence(String name) {
        return name != null && (name.startsWith(SEQUENCE_PREFIX) || name.startsWith(REPLACE_SEQUENCE_PREFIX));
    }

    public boolean isChoice(String name) {
        return name != null && (name.startsWith(CHOICE_PREFIX) || name.startsWith(REPLACE_CHOICE_PREFIX));
    }

    public boolean isAll(String name) {
        return name != null && (name.startsWith(ALL_PREFIX) || name.startsWith(REPLACE_ALL_PREFIX));
    }

    private String makeKey(String parent, int index) {
        return Integer.toString(index) + "." + parent;
    }

    private void add(String parent, int index, String[] names) {
        String key = this.makeKey(parent, index);
        String[] dup = (String[])this.mPool.get(key);
        if (dup != null && !dup[1].equals(names[1])) {
            this.mClash = true;
            if (this.mDebug) {
                System.out.println("[ memento duplicate: (" + key + ") -> (" + names[1] + "), (" + dup[1] + ") ]");
            }
        } else {
            this.mPool.put(key, names);
        }
    }

    public void replaceMetaInfo(OtdMetaContainer otd) {
        if (this.mPreservePackageName) {
            if (otd == null) {
                throw new NullPointerException("no OTD");
            }
            if (this.mPackageName != null && otd.getOtdGrove() != null) {
                otd.getOtdGrove().setPackageName(this.mPackageName);
            }
        }
        this.pumpOtdRevision(otd);
    }

    public void replace(OtdWood node) {
        OtdWoodList children;
        if (node != null && (children = node.getChildren()) != null) {
            int size = children.size();
            for (int i = 0; i < size; ++i) {
                OtdWood child = children.getOtdWood(i);
                if (this.isCandidate(child.getName())) {
                    String[] names = this.mUseAncestorName ? this.fetchName(this.getAbsolutePath(node), i, child.getName()) : this.fetchName(node.getName(), i, child.getName());
                    child.setName(names[0]);
                    child.setJavaName(names[1]);
                }
                if (child.getType() != 2) continue;
                this.replace(child);
            }
        }
    }

    public Map getTreeIDMap() {
        return this.mTreeIDs;
    }

    public String getOtdName() {
        return this.mOtdName;
    }

    private int getOtdRevision(OtdMetaContainer otd) {
        String value;
        OtdOrigin origin = otd.getOtdOrigin();
        if (origin == null || otd.getOtdGrove() == null) {
            return 0;
        }
        OtdSeed seed = origin.getOtdSeed(otd.getOtdGrove().getId());
        if (seed == null) {
            return 0;
        }
        OtdNameValueType typedValue = seed.getOtdSeedInfo("Revision");
        int revision = 0;
        if (typedValue != null && (revision = Integer.parseInt(value = (String)typedValue.getValue())) < 0) {
            revision = 0;
        }
        return revision;
    }

    private void pumpOtdRevision(OtdMetaContainer otd) {
        OtdOrigin origin = otd.getOtdOrigin();
        if (origin == null || otd.getOtdGrove() == null) {
            return;
        }
        origin.addOtdSeed(otd.getOtdGrove().getId(), "Revision", (Object)String.valueOf(this.mRevision + 1));
    }
}

