/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.builder;

import com.stc.bpms.common.repository.XSDRepositoryObject;
import com.stc.otd.builder.OtdBuilder;
import com.stc.otd.builder.OtdBuilderException;
import com.stc.otd.builder.OtdBuilderSpec;
import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.GuidGenerator;
import com.stc.otd.codegen.OtdNormalizeTask;
import com.stc.otd.forest.OtdBranch;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdContextSpec;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdNameValueTypeMap;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.OtdSeed;
import com.stc.otd.forest.OtdSpell;
import com.stc.otd.forest.OtdStem;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdTreeException;
import com.stc.otd.forest.OtdTrunk;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import com.stc.otd.forest.provider.GuiUtil;
import com.stc.otd.forest.provider.OtdNativeContextSpec;
import com.stc.otd.xsd.builder.XsdBuilderSpec;
import com.stc.otd.xsd.builder.XsdUtil;
import com.stc.otd.xsd.codegen.XsdOriginVelocityWrapper;
import com.stc.otd.xsd.codegen.XsdParserGenerator;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.exolab.castor.xml.schema.AttributeDecl;
import org.exolab.castor.xml.schema.AttributeGroup;
import org.exolab.castor.xml.schema.AttributeGroupReference;
import org.exolab.castor.xml.schema.BlockList;
import org.exolab.castor.xml.schema.ComplexType;
import org.exolab.castor.xml.schema.ContentModelGroup;
import org.exolab.castor.xml.schema.ElementDecl;
import org.exolab.castor.xml.schema.Form;
import org.exolab.castor.xml.schema.Group;
import org.exolab.castor.xml.schema.ModelGroup;
import org.exolab.castor.xml.schema.Order;
import org.exolab.castor.xml.schema.Particle;
import org.exolab.castor.xml.schema.Schema;
import org.exolab.castor.xml.schema.SchemaException;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Structure;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.Wildcard;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.reader.SchemaReader;
import org.exolab.castor.xml.schema.simpletypes.AtomicType;
import org.exolab.castor.xml.schema.simpletypes.ListType;
import org.exolab.castor.xml.schema.simpletypes.UrType;
import org.exolab.castor.xml.schema.writer.SchemaWriter;
import org.xml.sax.SAXException;

public class XsdOtdBuilder
implements OtdBuilder {
    public static final String SCHEMA_NAMESPACE_200010 = "http://www.w3.org/2000/10/XMLSchema";
    public static final String SCHEMA_NAMESPACE_2001 = "http://www.w3.org/2001/XMLSchema";
    static final String SCHEMA_INSTANCE_200010 = "http://www.w3.org/2000/10/XMLSchema-instance";
    static final String SCHEMA_INSTANCE_2001 = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String XML_NAMESPACE = "http://www.w3.org/XML/1998/namespace";
    public static final String ORIGIN_SOURCE = "originSource";
    public static final String PACKAGE_NAME_PREFIX = "xsd.";
    public static final String XSD_TEXT = "__PCDATA__";
    public static final String XSD_TEXT_MIXED = "__PCDATA__MX";
    public static final String XSD_BRANCH = "_sequence_";
    public static final String XSD_ALL = "_all_";
    public static final String XSD_CHOICE = "_choice_";
    public static final String XSD_ANY = "__AnyText__";
    public static final String XSD_ANY_ATTR = "__AnyAttribute__";
    public static final String XSD_NIL = "__NIL__";
    public static final String XSD_TYPE = "__TYPE__";
    public static final String REF_TYPE = "refType";
    public static final String TREE_TYPE = "treeType";
    public static final String SUBSTITUTION_CHOICE = "__STCBranch__Substitution_Choice_";
    public static final String ST_PREFIX = "_simpletype_";
    public static final String TREE_COMPLEX_TYPE = "ComplexType";
    public static final String TREE_SIMPLE_TYPE = "SimpleType";
    public static final String TREE_MODEL_GROUP = "Group";
    public static final String TREE_TOP_COMPLEX_ELEMENT = "TopComplexTypeElement";
    public static final String TREE_ELEMENT = "Element";
    static Logger mLogger = Logger.getLogger((Class)(class$com$stc$otd$xsd$builder$XsdOtdBuilder == null ? (class$com$stc$otd$xsd$builder$XsdOtdBuilder = XsdOtdBuilder.class$("com.stc.otd.xsd.builder.XsdOtdBuilder")) : class$com$stc$otd$xsd$builder$XsdOtdBuilder));
    String prefix = "";
    int mIdCount = 0;
    int mBranchCount = 0;
    int mSTBranchCount = 0;
    int mTargetNamespaceId = 1;
    String mOtdName = null;
    String mFileName = null;
    private Schema schemaObject = null;
    HashMap mAllTopElemMap = new HashMap();
    HashMap mSubstitutionGroupMap = new HashMap();
    HashMap mTopElemMap = new HashMap();
    HashMap mComplexTypeMap = new HashMap();
    HashMap mSimpleTypeMap = new HashMap();
    HashMap mModelGroupMap = new HashMap();
    HashMap mOriginRefMap = new HashMap();
    HashMap mUsedNameMap = new HashMap();
    HashMap mRoot = new HashMap();
    HashMap mTempRoot = new HashMap();
    HashMap mAllNamespaces = new HashMap();
    HashMap mProcessedCompMap = new HashMap();
    HashMap mComplexBaseTypeMap = new HashMap();
    OtdMetaContainer mContainer;
    XsdBuilderSpec mBuilderSpec;
    OtdGrove mOtdGrove;
    OtdOrigin mOtdOrigin;
    OtdSpell mOtdSpell;
    String mSchemaVersion;
    Schema mMainSchema;
    boolean mAccurateDecimal = true;
    boolean mKeepFakeTree = false;
    boolean mIncludeRawXSD = false;
    boolean mPerformStrictValidation = false;
    boolean mUseInterface = true;
    private XSDRepositoryObject mXSDRepositoryObject = null;
    private boolean mHasNillableElement = false;
    private boolean mNormalizeCardinalityEnabled = false;
    static /* synthetic */ Class class$com$stc$otd$xsd$builder$XsdOtdBuilder;

    public XsdOtdBuilder() {
        if ("true".equals(System.getProperty("castor.normalizeCardinality", "true"))) {
            this.mNormalizeCardinalityEnabled = true;
        }
    }

    public XsdOtdBuilder(OtdBuilderSpec aSpec) throws IOException {
        this.mBuilderSpec = (XsdBuilderSpec)aSpec;
        if ("true".equals(System.getProperty("castor.normalizeCardinality", "true"))) {
            this.mNormalizeCardinalityEnabled = true;
        }
    }

    OtdBuilderException createException(String key, Object[] args, Exception e) {
        String msg = ResourceBundle.getBundle(this.getClass().getPackage().getName() + ".LocalStrings").getString(key);
        if (args != null) {
            msg = MessageFormat.format(msg, args);
        }
        if (e != null) {
            return new OtdBuilderException(msg, (Throwable)e);
        }
        return new OtdBuilderException(msg);
    }

    public static void main(String[] args) {
        try {
            if (args == null || args.length != 3) {
                System.out.println("Usage: com.stc.otd.xsd.builder.XsdBuilderGenerator otdName xsdFileName outOutputDir");
                return;
            }
            XsdBuilderSpec aSpec = new XsdBuilderSpec(args[1]);
            aSpec.setOtdName(args[0]);
            XsdOtdBuilder builder = new XsdOtdBuilder(aSpec);
            OtdContext otdContext = (OtdContext)Class.forName("com.stc.otd.forest.provider.OtdNativeContext").newInstance();
            OtdNativeContextSpec otdContextSpec = new OtdNativeContextSpec(args[2]);
            otdContext.setOtdContextSpec((OtdContextSpec)otdContextSpec);
            OtdMetaContainer otdMeta = otdContext.createOtd(aSpec.getOtdName(), "com.stc.otd.xsd.codegen.XsdParserGenerator");
            builder.buildOtd(otdMeta);
            otdContext.bindOtd(otdMeta, aSpec.getOtdName());
        }
        catch (Exception e) {
            System.out.println("Exception..." + e.getMessage());
            e.printStackTrace();
        }
    }

    public OtdBuilderSpec getOtdBuilderSpec() {
        return this.mBuilderSpec;
    }

    public String getOtdName() {
        return this.mOtdName;
    }

    public XSDRepositoryObject getXSDRepositoryObject() {
        return this.mXSDRepositoryObject;
    }

    public void setOtdBuilderSpec(OtdBuilderSpec aSpec) {
        this.mBuilderSpec = (XsdBuilderSpec)aSpec;
    }

    public void generateCode(OtdMetaContainer otdMetaContainer) throws OtdBuilderException {
        throw this.createException("not.supported.yet", null, null);
    }

    public void buildOtd(OtdMetaContainer container, Schema schema) throws OtdBuilderException {
        Object notUseInterfaceForDT;
        if (this.mBuilderSpec == null) {
            throw this.createException("null.connection.spec", null, null);
        }
        this.mHasNillableElement = false;
        this.reserveIDs(this.mBuilderSpec.getReservedTreeIDs());
        Object strictValidate = this.mBuilderSpec.getProperty("validate");
        if (strictValidate != null && strictValidate.toString().equalsIgnoreCase("true")) {
            this.mPerformStrictValidation = true;
        }
        if ((notUseInterfaceForDT = this.mBuilderSpec.getProperty("notUseInterfaceForDT")) == null || notUseInterfaceForDT != null && notUseInterfaceForDT.toString().equalsIgnoreCase("true")) {
            this.mUseInterface = false;
        }
        this.mTargetNamespaceId = 1;
        this.mMainSchema = schema;
        this.mContainer = container;
        this.mOtdOrigin = this.mContainer.createOrigin("create otd origin");
        try {
            String pkgName;
            String schemaInstance = SCHEMA_INSTANCE_2001;
            String schemaNS = this.mMainSchema.getSchemaNamespace();
            if (schemaNS.equals(SCHEMA_NAMESPACE_2001)) {
                this.mSchemaVersion = "2001";
            } else {
                this.mSchemaVersion = "200010";
                schemaInstance = SCHEMA_INSTANCE_200010;
            }
            this.mOtdName = this.mBuilderSpec.getOtdName();
            Object objPackageName = this.mBuilderSpec.getProperty("packageName");
            if (objPackageName != null && objPackageName.toString().length() > 0) {
                pkgName = objPackageName.toString();
            } else {
                String guid = Integer.toString(GuidGenerator.getNewGuid().hashCode());
                guid = guid.replace('-', '_');
                String newOtdName = CodeGeneratorUtil.makeJavaName((String)this.mOtdName) + guid;
                pkgName = PACKAGE_NAME_PREFIX + newOtdName;
            }
            this.mOtdGrove = this.mContainer.createGrove(this.mOtdName, String.valueOf(this.mIdCount++), pkgName, CodeGeneratorUtil.makeClassName((String)(this.mOtdName + "Grove")), container.getOtdType(), "");
            String targetNS = this.mMainSchema.getTargetNamespace();
            if (targetNS != null) {
                this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "targetNamespace", (Object)targetNS);
            }
            if (schemaNS != null) {
                this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "schemaInstance", (Object)schemaInstance);
            }
            this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "schemaVersion", (Object)this.mSchemaVersion);
            Hashtable nslist = this.mMainSchema.getNamespaces();
            Enumeration en1 = nslist.keys();
            while (en1.hasMoreElements()) {
                String key = (String)en1.nextElement();
                String url = (String)nslist.get(key);
                if (this.mAllNamespaces.containsKey(url) && this.mAllNamespaces.get(url) != null && ((String)this.mAllNamespaces.get(url)).length() > 0) continue;
                this.mAllNamespaces.remove(url);
                this.mAllNamespaces.put(url, key);
            }
            this.mUsedNameMap.put(this.mOtdName, this.mOtdName);
            HashMap options = (HashMap)this.mBuilderSpec.getProperties();
            if (options != null && options.keySet() != null) {
                Iterator en = options.keySet().iterator();
                while (en.hasNext()) {
                    String key = (String)en.next();
                    Object obj = options.get(key);
                    this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), key, (Object)obj.toString());
                }
            }
            HashMap schemaMap = new HashMap();
            this.getDefaultRoots(this.mMainSchema);
            this.buildOtdFromSchema(this.mMainSchema);
            HashSet nilAlreadyCreated = new HashSet();
            this.setRefId((OtdWood)this.mOtdGrove, nilAlreadyCreated);
            this.resolveDuplicateJavaNames((OtdWood)this.mOtdGrove);
            this.setOriginRefId();
            this.setTopRoots();
            OtdNormalizeTask task = new OtdNormalizeTask();
            task.normalizeOtd(this.mContainer, null);
            if (!XsdParserGenerator.mXXLCodegen) {
                this.normalizeOccurrences(this.mOtdGrove);
            }
            this.dumpAllNamespaces(this.mOtdGrove);
            this.removeAllNameQualifications((OtdWood)this.mOtdGrove);
        }
        catch (OtdBuilderException be) {
            throw be;
        }
        catch (Exception e) {
            mLogger.error((Object)"Exception in XsdBuilder:", (Throwable)e);
            throw this.createException("xsd.build.error", new Object[]{schema.getTargetNamespace(), e.toString()}, e);
        }
    }

    public void buildOtd(OtdMetaContainer container) throws OtdBuilderException {
        block30: {
            Object strictValidate;
            Object notUseInterfaceForDT;
            Object includeRawXSD;
            Object keepFakeTree;
            if (this.mBuilderSpec == null) {
                throw this.createException("null.connection.spec", null, null);
            }
            this.mHasNillableElement = false;
            this.reserveIDs(this.mBuilderSpec.getReservedTreeIDs());
            Object theUseDoubleFLag = this.mBuilderSpec.getProperty("useDouble");
            if (theUseDoubleFLag != null && theUseDoubleFLag.toString().equalsIgnoreCase("true")) {
                this.mAccurateDecimal = false;
            }
            if ((keepFakeTree = this.mBuilderSpec.getProperty("keepFakeTree")) != null && keepFakeTree.toString().equalsIgnoreCase("true")) {
                this.mKeepFakeTree = true;
            }
            if ((includeRawXSD = this.mBuilderSpec.getProperty("includeRawXSD")) != null && includeRawXSD.toString().equalsIgnoreCase("true")) {
                this.mIncludeRawXSD = true;
            }
            if ((notUseInterfaceForDT = this.mBuilderSpec.getProperty("notUseInterfaceForDT")) == null || notUseInterfaceForDT != null && notUseInterfaceForDT.toString().equalsIgnoreCase("true")) {
                this.mUseInterface = false;
            }
            if ((strictValidate = this.mBuilderSpec.getProperty("validate")) != null && strictValidate.toString().equalsIgnoreCase("true")) {
                this.mPerformStrictValidation = true;
            }
            this.mTargetNamespaceId = 1;
            this.mContainer = container;
            this.mOtdOrigin = this.mContainer.createOrigin("create otd origin");
            File inFile = null;
            String rawXSDContent = null;
            if (this.mBuilderSpec.getProperty("input type").equals("file")) {
                inFile = this.mBuilderSpec.getXsdInputFile();
                if (inFile == null || !inFile.isFile()) {
                    throw this.createException("invalid.input.xsd.file", null, null);
                }
                this.mFileName = inFile.getName();
                this.mFileName = this.mFileName.substring(0, this.mFileName.lastIndexOf(46));
                String normalizingFileName = (String)this.mBuilderSpec.getProperty(inFile.getAbsolutePath());
                if (normalizingFileName == null || normalizingFileName.length() == 0) {
                    normalizingFileName = inFile.toString();
                }
                normalizingFileName = "1 " + normalizingFileName;
                this.mOtdOrigin.createSpell().setOtdSpellInfo(normalizingFileName.getBytes());
                this.mOtdOrigin.createSpell(normalizingFileName.getBytes());
                try {
                    if (this.mIncludeRawXSD) {
                        int charRead;
                        InputStreamReader in = new InputStreamReader(new BufferedInputStream(new FileInputStream(inFile)));
                        char[] buf = new char[2048];
                        StringWriter sw = new StringWriter();
                        while ((charRead = in.read(buf)) != -1) {
                            sw.write(buf, 0, charRead);
                        }
                        rawXSDContent = sw.toString();
                    }
                    SchemaReader schemaReader = new SchemaReader(inFile, (String)this.mBuilderSpec.getProperty("encoding"));
                    schemaReader.setValidation(true);
                    this.mMainSchema = schemaReader.read();
                }
                catch (Exception e) {
                    throw this.createException("xsd.parse.exception", new Object[]{inFile.getName(), e.toString()}, e);
                }
            } else if (this.mBuilderSpec.getProperty("input type").equals("object")) {
                String filename = "TopXsdOTD";
                this.mOtdOrigin.createSpell().setOtdSpellInfo(filename.getBytes());
                this.mOtdOrigin.createSpell(filename.getBytes());
                this.mMainSchema = this.mBuilderSpec.getSchema();
            }
            try {
                String pkgName;
                String schemaInstance = SCHEMA_INSTANCE_2001;
                String schemaNS = this.mMainSchema.getSchemaNamespace();
                if (schemaNS.equals(SCHEMA_NAMESPACE_2001)) {
                    this.mSchemaVersion = "2001";
                } else {
                    this.mSchemaVersion = "200010";
                    schemaInstance = SCHEMA_INSTANCE_200010;
                }
                this.mOtdName = this.mBuilderSpec.getOtdName();
                Object objPackageName = this.mBuilderSpec.getProperty("packageName");
                if (objPackageName != null && objPackageName.toString().length() > 0) {
                    pkgName = objPackageName.toString();
                } else {
                    String guid = Integer.toString(GuidGenerator.getNewGuid().hashCode());
                    guid = guid.replace('-', '_');
                    String newOtdName = CodeGeneratorUtil.makeJavaName((String)this.mOtdName) + guid;
                    pkgName = PACKAGE_NAME_PREFIX + newOtdName;
                }
                this.mOtdGrove = this.mContainer.createGrove(this.mOtdName, String.valueOf(this.mIdCount++), pkgName, CodeGeneratorUtil.makeClassName((String)(this.mOtdName + "Grove")), container.getOtdType(), "");
                String targetNS = this.mMainSchema.getTargetNamespace();
                if (targetNS != null) {
                    this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "targetNamespace", (Object)targetNS);
                }
                if (schemaNS != null) {
                    this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "schemaInstance", (Object)schemaInstance);
                }
                this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "schemaVersion", (Object)this.mSchemaVersion);
                Hashtable nslist = this.mMainSchema.getNamespaces();
                Enumeration en1 = nslist.keys();
                while (en1.hasMoreElements()) {
                    String key = (String)en1.nextElement();
                    String url = (String)nslist.get(key);
                    if (this.mAllNamespaces.containsKey(url) && this.mAllNamespaces.get(url) != null && ((String)this.mAllNamespaces.get(url)).length() > 0) continue;
                    this.mAllNamespaces.remove(url);
                    this.mAllNamespaces.put(url, key);
                }
                this.mUsedNameMap.put(this.mOtdName, this.mOtdName);
                HashMap options = (HashMap)this.mBuilderSpec.getProperties();
                if (options != null && options.keySet() != null) {
                    Iterator en = options.keySet().iterator();
                    while (en.hasNext()) {
                        String key = (String)en.next();
                        Object obj = options.get(key);
                        this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), key, (Object)obj.toString());
                    }
                }
                if (this.mIncludeRawXSD && rawXSDContent != null) {
                    this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "rawXSDContent", (Object)rawXSDContent);
                }
                this.getDefaultRoots(this.mMainSchema);
                this.buildOtdFromSchema(this.mMainSchema);
                HashSet nilAlreadyCreated = new HashSet();
                this.setRefId((OtdWood)this.mOtdGrove, nilAlreadyCreated);
                this.resolveDuplicateJavaNames((OtdWood)this.mOtdGrove);
                this.setOriginRefId();
                this.setTopRoots();
                OtdNormalizeTask task = new OtdNormalizeTask();
                task.normalizeOtd(this.mContainer, null);
                if (!XsdParserGenerator.mXXLCodegen) {
                    this.normalizeOccurrences(this.mOtdGrove);
                }
                this.dumpAllNamespaces(this.mOtdGrove);
                this.removeAllNameQualifications((OtdWood)this.mOtdGrove);
            }
            catch (OtdBuilderException be) {
                throw be;
            }
            catch (Exception e) {
                mLogger.error((Object)"Exception in XsdBuilder:", (Throwable)e);
                if ("file".equals(this.mBuilderSpec.getProperty("input type")) && inFile != null) {
                    throw this.createException("xsd.build.error", new Object[]{inFile.getName(), e.toString()}, e);
                }
                if (!"object".equals(this.mBuilderSpec.getProperty("input type"))) break block30;
                throw this.createException("xsd build error", new Object[]{"TopXsdOTD", e.toString()}, e);
            }
        }
    }

    void normalizeOccurrences(OtdGrove otd) {
        OtdWoodList list = otd.getTrees();
        for (int i = 0; list != null && i < list.size(); ++i) {
            OtdWood tree = list.getOtdWood(i);
            OtdWoodList children = tree.getChildren();
            for (int j = 0; children != null && j < children.size(); ++j) {
                OtdWood child = children.getOtdWood(j);
                if (child.getType() != 2) continue;
                this.removeInnerCardinal((OtdBranch)child);
            }
        }
    }

    void dumpAllNamespaces(OtdGrove otd) {
        if (this.mAllNamespaces != null && this.mAllNamespaces.keySet() != null) {
            Iterator it = this.mAllNamespaces.keySet().iterator();
            while (it.hasNext()) {
                String url = (String)it.next();
                String key = (String)this.mAllNamespaces.get(url);
                if (key == null) {
                    key = "";
                }
                this.mOtdOrigin.addOtdSeed(otd.getId(), "NS:" + key, (Object)url);
            }
        }
    }

    void removeInnerCardinal(OtdBranch branch) {
        OtdWood child;
        int j;
        boolean allOptional = true;
        boolean allRepeat = true;
        OtdWoodList children = branch.getChildren();
        for (j = 0; children != null && j < children.size(); ++j) {
            child = children.getOtdWood(j);
            if (!child.isOptional()) {
                allOptional = false;
            }
            if (child.isRepeated()) continue;
            allRepeat = false;
        }
        children = branch.getChildren();
        for (j = 0; children != null && j < children.size(); ++j) {
            child = children.getOtdWood(j);
            if (branch.isChoice() && (branch.isRepeated() || branch.isOptional()) && (allOptional || allRepeat)) {
                child.setOptional(false);
                child.setRepeated(false);
            } else if (branch.isRepeated() && allOptional && children.size() > 1) {
                child.setOptional(false);
                child.setRepeated(false);
                branch.setChoice(true);
            }
            if (child.getType() != 2) continue;
            this.removeInnerCardinal((OtdBranch)child);
        }
    }

    void removeOuterCardinal(OtdBranch wood) {
        if (wood == null) {
            return;
        }
        OtdWoodList children = wood.getChildren();
        for (int j = 0; children != null && j < children.size(); ++j) {
            OtdWood child = children.getOtdWood(j);
            if (children.size() == 1) {
                if (child.isOptional()) {
                    if (wood.isOptional()) {
                        wood.setOptional(false);
                    }
                    if (wood.isRepeated()) {
                        wood.setRepeated(false);
                        child.setRepeated(true);
                    }
                }
                if (child.isRepeated()) {
                    if (wood.isOptional()) {
                        wood.setOptional(false);
                        child.setOptional(true);
                    }
                    if (wood.isRepeated()) {
                        wood.setRepeated(false);
                    }
                }
            }
            if (child.getType() != 2) continue;
            this.removeOuterCardinal((OtdBranch)child);
        }
    }

    void writeSchemaSource(Schema schema, String name, HashMap schemaMap) throws IOException, SAXException {
        String targetNamespace = schema.getTargetNamespace();
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        if (schemaMap.get(targetNamespace) != null) {
            return;
        }
        schemaMap.put(targetNamespace, schema);
        if (null == name) {
            name = "originSource:" + targetNamespace;
        }
        Enumeration e = schema.getImportedSchema();
        while (e.hasMoreElements()) {
            Schema importedSchema = (Schema)e.nextElement();
            importedSchema.setSchemaLocation(null);
        }
        StringWriter stringWriter = new StringWriter();
        SchemaWriter swriter = new SchemaWriter((Writer)stringWriter);
        swriter.write(schema);
        String schemaStr = this.escape(stringWriter.toString());
        this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), name, (Object)schemaStr);
        if (name.equals(ORIGIN_SOURCE)) {
            this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "originSource:" + targetNamespace, (Object)schemaStr);
        }
        stringWriter.close();
        Enumeration e2 = schema.getImportedSchema();
        while (e2.hasMoreElements()) {
            Schema importedSchema = (Schema)e2.nextElement();
            this.writeSchemaSource(importedSchema, null, schemaMap);
        }
    }

    String escape(String str) {
        char[] cbuf = str.toCharArray();
        StringBuffer buf = new StringBuffer();
        int start = 0;
        int end = str.length();
        int mark = start;
        char[] esc = null;
        for (int i = start; i < end; ++i) {
            char ch = cbuf[i];
            if ((ch < ' ' || ch > '~') && ch != '\r' && ch != '\n' && ch != '\t') {
                String escStr = "&#x";
                for (int n = 12; n >= 0; n -= 4) {
                    escStr = escStr + "0123456789ABCDEF".charAt(ch >> n & 0xF);
                }
                escStr = escStr + ";";
                esc = escStr.toCharArray();
            }
            if (esc == null) continue;
            buf.append(cbuf, mark, i - mark);
            buf.append(esc, 0, esc.length);
            mark = i + 1;
            esc = null;
        }
        buf.append(cbuf, mark, end - mark);
        return buf.toString();
    }

    void processElementDeclAttributes(ComplexType complexType, OtdWood wood) throws SchemaException, OtdTreeException {
        Enumeration enut = complexType.getAttributeDecls();
        while (enut.hasMoreElements()) {
            AttributeDecl attr = (AttributeDecl)enut.nextElement();
            if (attr.isProhibited()) continue;
            this.processAttributeDecl(attr, wood);
        }
        Wildcard anyattr = complexType.getAnyAttribute();
        if (anyattr != null) {
            anyattr.setMaxOccurs(-1);
            anyattr.setMinOccurs(0);
        }
        this.processWildcard(anyattr, wood, null);
    }

    String getBranchName(String name, int c) {
        StringBuffer sb = new StringBuffer(name);
        if (c < 0) {
            throw new IllegalArgumentException("negative counter");
        }
        while (c > 0) {
            sb.append((char)(65 + c % 26));
            c /= 26;
        }
        return sb.toString();
    }

    boolean getOptional(long minOccurs, long maxOccurs) {
        return 0L == minOccurs;
    }

    boolean getRepeat(long minOccurs, long maxOccurs) {
        return maxOccurs != 1L;
    }

    void setRefId(OtdWood wood, Set nilAlreadyCreated) throws OtdTreeException {
        ArrayList list;
        if (wood.getType() == 4 || wood.getType() == 7) {
            OtdNameValueType data;
            OtdStem stem = (OtdStem)wood;
            String refType = null;
            boolean isNillable = false;
            String uid = null;
            OtdSeed seed = this.mOtdOrigin.getOtdSeed(wood.getId());
            if (seed != null && seed.getOtdSeedInfo(REF_TYPE) != null) {
                data = seed.getOtdSeedInfo(REF_TYPE);
                refType = (String)data.getValue();
            }
            if (seed != null && seed.getOtdSeedInfo("elemNillable") != null) {
                data = seed.getOtdSeedInfo("elemNillable");
                isNillable = XsdOriginVelocityWrapper.isTrue(data.getValue());
            }
            if (refType != null) {
                if (refType.equals(TREE_MODEL_GROUP)) {
                    uid = (String)this.mModelGroupMap.get(stem.getRefId());
                } else if (refType.equals(TREE_COMPLEX_TYPE)) {
                    OtdWood compTree;
                    uid = (String)this.mComplexTypeMap.get(stem.getRefId());
                    if (isNillable && (compTree = this.mOtdGrove.getChild(uid)) != null && !nilAlreadyCreated.contains(uid)) {
                        this.createNilAttribute(compTree);
                        nilAlreadyCreated.add(uid);
                    }
                } else if (refType == null || refType.equals(TREE_ELEMENT)) {
                    uid = (String)this.mTopElemMap.get(stem.getRefId());
                }
            }
            if (uid != null) {
                stem.setRefId(uid);
            }
        }
        if ((list = (ArrayList)wood.getChildren()) != null) {
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                OtdWood child = (OtdWood)list.get(i);
                this.setRefId(child, nilAlreadyCreated);
            }
        }
    }

    void resolveDuplicateJavaNames(OtdWood wood) {
        ArrayList list = (ArrayList)wood.getChildren();
        if (list != null) {
            OtdWood child;
            int i;
            HashMap<String, String> jnameMap = new HashMap<String, String>();
            int size = list.size();
            for (i = 0; i < size; ++i) {
                child = (OtdWood)list.get(i);
                while (jnameMap.containsKey(child.getJavaName())) {
                    child.setJavaName(child.getJavaName() + "_");
                }
                jnameMap.put(child.getJavaName(), child.getJavaName());
            }
            for (i = 0; i < size; ++i) {
                child = (OtdWood)list.get(i);
                this.resolveDuplicateJavaNames(child);
            }
        }
    }

    void removeAllNameQualifications(OtdWood wood) {
        ArrayList list = (ArrayList)wood.getChildren();
        if (list != null) {
            for (int i = 0; i < list.size(); ++i) {
                OtdWood child = (OtdWood)list.get(i);
                String childname = child.getName();
                if (childname != null) {
                    if (childname.startsWith("Substitution_Tree_")) {
                        child.setName("Substitution_Tree_" + this.removeQualification(childname.substring("Substitution_Tree_".length())));
                    } else if (childname.startsWith(SUBSTITUTION_CHOICE)) {
                        child.setName(SUBSTITUTION_CHOICE + this.removeQualification(childname.substring(SUBSTITUTION_CHOICE.length())));
                    } else {
                        child.setName(this.removeQualification(child.getName()));
                    }
                }
                this.removeAllNameQualifications(child);
            }
        }
    }

    void setOriginRefId() {
        if (this.mOtdOrigin == null || this.mComplexTypeMap == null && this.mSimpleTypeMap == null || this.mOriginRefMap == null || this.mOriginRefMap.size() < 1) {
            return;
        }
        Iterator iter = this.mOriginRefMap.keySet().iterator();
        while (iter.hasNext()) {
            OtdNameValueType data;
            String key = (String)iter.next();
            String name = (String)this.mOriginRefMap.get(key);
            OtdSeed seed = this.mOtdOrigin.getOtdSeed(key);
            if (seed == null || (data = seed.getOtdSeedInfo(name)) == null || data.getValue() == null) continue;
            String treeId = (String)this.mComplexTypeMap.get(data.getValue());
            if (treeId == null) {
                treeId = (String)this.mSimpleTypeMap.get(data.getValue());
            }
            data.setValue((Object)treeId);
        }
    }

    void buildOtdFromSchema(Schema schema) throws SchemaException, OtdTreeException, OtdBuilderException {
        this.schemaObject = schema;
        this.processTopSubstitutions(schema);
        this.processComplexTypeRestrictions(schema);
        if (this.mPerformStrictValidation) {
            this.processTopSimpleTypes(schema);
        }
        this.processTopGroups(schema);
        this.processTopComplexTypes(schema);
        this.processTopElements(schema);
        if (this.mHasNillableElement && this.mOtdGrove != null && this.mOtdOrigin != null) {
            this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "hasNillableElem", (Object)Boolean.TRUE, 1);
        }
    }

    void processAttributeDecl(AttributeDecl attr, OtdWood wood) throws SchemaException, OtdTreeException {
        String javaType = "java.lang.String";
        boolean optional = false;
        boolean repeat = false;
        String name = attr.getName(true);
        if (name == null || name.length() == 0) {
            name = attr.getName();
        }
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAttribute", (Object)"true");
        if (attr.isRequired()) {
            optional = false;
        } else if (attr.isOptional()) {
            optional = true;
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isOptional", (Object)"true");
        } else if (attr.isFixed()) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isFixed", (Object)"true");
        } else if (attr.isProhibited()) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isProhibited", (Object)"true");
        } else if (attr.isReference()) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isReference", (Object)"true");
        }
        String namespaceURI = this.getTargetNamespace((Structure)attr);
        if (this.isAttributeQualified(attr)) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "form", (Object)"qualified");
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "namespaceURI", (Object)namespaceURI);
        } else {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "form", (Object)"unqualified");
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "namespaceURI", (Object)"");
        }
        if (attr.getDefaultValue() != null) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "attrDefaultValue", (Object)attr.getDefaultValue());
        }
        if (attr.getFixedValue() != null) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "attrDefaultValue", (Object)attr.getFixedValue());
        }
        SimpleType attrType = attr.getSimpleType();
        OtdSeed seed = this.mOtdOrigin.getOtdSeed(String.valueOf(this.mIdCount));
        javaType = XsdUtil.getJavaType(attr.getSimpleType(), this.mSchemaVersion, seed, this.mAccurateDecimal, this.mUseInterface);
        wood.createChild(3, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)name), 3, javaType, null, repeat, optional, false, "leaf");
    }

    void processAttributeGroup(AttributeGroup attrgroup, OtdWood wood) throws SchemaException, OtdTreeException {
        if (attrgroup == null) {
            SchemaException se = new SchemaException("top Attribute Group has no name");
            mLogger.error((Object)"processAttributeGroup", (Throwable)se);
            throw se;
        }
        Enumeration enut = attrgroup.getAttributes();
        while (enut.hasMoreElements()) {
            AttributeDecl attr = (AttributeDecl)enut.nextElement();
            this.processAttributeDecl(attr, wood);
        }
        Wildcard anyattr = attrgroup.getAnyAttribute();
        this.processWildcard(anyattr, wood, null);
    }

    SimpleType getFirstSimpleType(ComplexType complexType) {
        XMLType theType;
        for (theType = complexType.getBaseType(); theType != null && theType.getBaseType() != null && !theType.isSimpleType(); theType = theType.getBaseType()) {
        }
        if (theType != null && theType.isSimpleType()) {
            return (SimpleType)theType;
        }
        return null;
    }

    XMLType getFinalBaseType(ComplexType complexType) {
        XMLType theType;
        for (theType = complexType.getBaseType(); theType != null && theType.getBaseType() != null; theType = theType.getBaseType()) {
        }
        return theType;
    }

    boolean isMixedContent(ComplexType compType) {
        return compType.getContentType() != null && compType.getContentType().getType() == 1;
    }

    void processComplexTypeContent(ElementDecl parent, ComplexType complexType, OtdWood wood, boolean isTrueTopComplexType) throws SchemaException, OtdTreeException {
        String[] basetypeInfo;
        String name = complexType.getName();
        XMLType baseType = complexType.getBaseType();
        XMLType finalBaseType = this.getFinalBaseType(complexType);
        if (baseType != null && baseType.isComplexType()) {
            if (isTrueTopComplexType) {
                if (complexType.isRestricted()) {
                    this.mOriginRefMap.put(wood.getId(), "resBaseType");
                    this.mOtdOrigin.addOtdSeed(wood.getId(), "resBaseType", (Object)this.normalizeName(this.getQualifiedName(baseType)));
                } else if (!((ComplexType)baseType).isSimpleContent()) {
                    this.mOriginRefMap.put(wood.getId(), "extBaseType");
                    this.mOtdOrigin.addOtdSeed(wood.getId(), "extBaseType", (Object)this.normalizeName(this.getQualifiedName(baseType)));
                }
            }
            this.processComplexTypeDerivation(complexType);
        }
        if (isTrueTopComplexType && baseType == null && (basetypeInfo = this.getSavedBaseType(complexType)) != null) {
            if (basetypeInfo[0].equals("true")) {
                this.mOriginRefMap.put(wood.getId(), "resBaseType");
                this.mOtdOrigin.addOtdSeed(wood.getId(), "resBaseType", (Object)basetypeInfo[1]);
            } else {
                this.mOriginRefMap.put(wood.getId(), "extBaseType");
                this.mOtdOrigin.addOtdSeed(wood.getId(), "extBaseType", (Object)basetypeInfo[1]);
            }
        }
        this.processElementDeclAttributes(complexType, wood);
        if (complexType.isSimpleContent()) {
            if (finalBaseType == null || finalBaseType.isSimpleType() || finalBaseType instanceof ComplexType && ((ComplexType)finalBaseType).isSimpleContent()) {
                ComplexType cType;
                SimpleType simpleType = this.getFirstSimpleType(complexType);
                OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
                if (finalBaseType == null) {
                    seed.addOtdSeedInfo("xsdType", (Object)"null");
                } else if (finalBaseType.isAnyType()) {
                    seed.addOtdSeedInfo("xsdType", (Object)"anyType");
                }
                if (finalBaseType instanceof ComplexType && (cType = (ComplexType)finalBaseType).getContentType() != null) {
                    finalBaseType = cType.getContentType().getSimpleType();
                }
                String javaType = XsdUtil.getJavaType(simpleType, this.mSchemaVersion, seed, this.mAccurateDecimal, this.mUseInterface);
                if (this.mPerformStrictValidation) {
                    if (simpleType.getParent() instanceof Schema) {
                        this.mOriginRefMap.put(String.valueOf(this.mIdCount), "simpleTypeRef");
                        seed.addOtdSeedInfo("simpleTypeRef", (Object)this.normalizeName(this.getQualifiedName((XMLType)simpleType)));
                    } else {
                        seed.addOtdSeedInfo("validationFacets", (Object)XsdUtil.getFullFacets(simpleType).serialize());
                    }
                }
                if (finalBaseType == null) {
                    this.processAtomicType(javaType, wood, seed);
                } else if (finalBaseType instanceof AtomicType) {
                    this.processAtomicType(javaType, wood, seed);
                } else if (finalBaseType instanceof ListType) {
                    this.processListType(javaType, wood, seed);
                } else if (finalBaseType instanceof Union) {
                    this.processUnionType(javaType, wood, seed);
                } else if (finalBaseType instanceof UrType) {
                    throw new SchemaException("UR types not yet supported.");
                }
                this.mOtdOrigin.addOtdSeed(seed);
                return;
            }
        } else if (complexType.isComplexContent() && baseType != null && baseType.isAnyType() && !complexType.isRestricted()) {
            String anyname = XSD_ANY;
            boolean repeat = true;
            boolean optional = true;
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAny", (Object)"true");
            wood.createChild(3, anyname, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)anyname), 3, "java.lang.String", null, repeat, optional, false, "leaf");
        }
        if (complexType.isRestricted()) {
            this.mOtdOrigin.addOtdSeed(wood.getId(), "isRestricted", (Object)"true");
        }
        Enumeration enut = complexType.enumerate();
        int structureProcessed = 0;
        block3: while (enut.hasMoreElements()) {
            ++structureProcessed;
            Structure structure = (Structure)enut.nextElement();
            switch (structure.getStructureType()) {
                case 10: 
                case 16: {
                    Group group = (Group)structure;
                    if (group instanceof ModelGroup && ((ModelGroup)group).getReference() != null || group.getParticleCount() > 1 || !this.mNormalizeCardinalityEnabled) {
                        this.processContentModel(group, wood, null);
                        continue block3;
                    }
                    if (group.getParticleCount() != 1) continue block3;
                    Particle particle = group.getParticle(0);
                    this.processContent((Structure)particle, wood, new OccurrenceInfo(group.getMinOccurs(), group.getMaxOccurs()));
                    continue block3;
                }
            }
            SchemaException se = new SchemaException("invalid complexType structure type: " + structure.getStructureType() + ", name:" + name);
            mLogger.error((Object)"createComplexTypeContent", (Throwable)se);
            throw se;
        }
    }

    void processComplexTypeDerivation(ComplexType complexType) throws SchemaException {
        XMLType baseType = complexType.getBaseType();
        if (baseType != null && baseType.isComplexType()) {
            if (complexType.isRestricted()) {
                if (!complexType.isSimpleContent()) {
                    this.mergeContentModels(complexType, (ComplexType)baseType);
                } else {
                    SimpleType firstSimpleType = this.getFirstSimpleType(complexType);
                    this.mergeContentModels(complexType, (ComplexType)baseType);
                    complexType.setBaseType((XMLType)firstSimpleType);
                    complexType.setDerivationMethod("extension");
                    complexType.setRestriction(false);
                }
            } else {
                this.processComplexTypeDerivation((ComplexType)baseType);
                this.mergeExtendedComplexContentModels(complexType, (ComplexType)baseType);
            }
        }
    }

    void mergeExtendedComplexContentModels(ComplexType complexType, ComplexType baseType) throws SchemaException {
        Particle p;
        ContentModelGroup baseContentModel = baseType.getContentModel();
        ContentModelGroup extendedContentModel = complexType.getContentModel();
        ContentModelGroup _contentModel = new ComplexType(this.schemaObject).getContentModel();
        Enumeration baseAttributesEnum = baseType.getLocalAttributeDecls();
        while (baseAttributesEnum.hasMoreElements()) {
            complexType.addAttributeDecl((AttributeDecl)baseAttributesEnum.nextElement());
        }
        Enumeration baseAttributesReferenceEnum = baseType.getAttributeGroupReferences();
        while (baseAttributesReferenceEnum.hasMoreElements()) {
            complexType.addAttributeGroupReference((AttributeGroupReference)baseAttributesReferenceEnum.nextElement());
        }
        Enumeration extendedContentModelEnum = extendedContentModel.enumerate();
        Enumeration baseContentModelEnum = baseContentModel.enumerate();
        while (baseContentModelEnum.hasMoreElements()) {
            p = (Particle)baseContentModelEnum.nextElement();
            switch (p.getStructureType()) {
                case 8: {
                    _contentModel.addElementDecl((ElementDecl)p);
                    break;
                }
                case 10: {
                    _contentModel.addGroup((Group)p);
                    break;
                }
                case 16: {
                    _contentModel.addGroup((ModelGroup)p);
                    break;
                }
            }
        }
        while (extendedContentModelEnum.hasMoreElements()) {
            p = (Particle)extendedContentModelEnum.nextElement();
            switch (p.getStructureType()) {
                case 8: {
                    _contentModel.addElementDecl((ElementDecl)p);
                    break;
                }
                case 10: {
                    _contentModel.addGroup((Group)p);
                    break;
                }
                case 16: {
                    _contentModel.addGroup((ModelGroup)p);
                    break;
                }
            }
        }
        complexType.setContentModel(_contentModel);
        this.saveBaseType(complexType);
        complexType.setBaseType(null);
        complexType.setBase(null);
    }

    long mergeMinOccurs(long min1, long min2) {
        return min1 * min2;
    }

    long mergeMaxOccurs(long max1, long max2) {
        if (max1 < 0L || max2 < 0L) {
            return -1L;
        }
        return max1 * max2;
    }

    void processAtomicType(String javaType, OtdWood wood, OtdSeed seed) throws OtdTreeException {
        seed.addOtdSeedInfo("isText", (Object)"true");
        wood.createChild(3, XSD_TEXT, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT), 3, javaType, null, false, false, false, "leaf");
    }

    void processUnionType(String javaType, OtdWood wood, OtdSeed seed) throws OtdTreeException {
        seed.addOtdSeedInfo("isText", (Object)"true");
        wood.createChild(3, XSD_TEXT, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT), 3, javaType, null, false, false, false, "leaf");
    }

    void processListType(String javaType, OtdWood wood, OtdSeed seed) throws OtdTreeException {
        seed.addOtdSeedInfo("isText", (Object)"true");
        wood.createChild(3, XSD_TEXT, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT), 3, javaType, null, false, false, false, "leaf");
    }

    void processContent(Structure structure, OtdWood wood, OccurrenceInfo parentOccursInfo) throws SchemaException, OtdTreeException {
        if (structure == null) {
            return;
        }
        short type = structure.getStructureType();
        switch (type) {
            case 8: {
                this.processElementDeclContent((ElementDecl)structure, wood, parentOccursInfo);
                break;
            }
            case 10: 
            case 16: {
                this.processContentModel((Group)structure, wood, parentOccursInfo);
                break;
            }
            case 24: {
                this.processWildcard((Wildcard)structure, wood, parentOccursInfo);
                break;
            }
            default: {
                SchemaException se = new SchemaException("Invalid element type: " + type);
                mLogger.error((Object)"createContent", (Throwable)se);
                throw se;
            }
        }
    }

    void processContentModel(Group contentModel, OtdWood wood, OccurrenceInfo parentOccursInfo) throws SchemaException, OtdTreeException {
        ModelGroup refgroup;
        long maxOccurs;
        long minOccurs;
        long maxOccursNorm;
        long minOccursNorm;
        if (contentModel == null) {
            return;
        }
        if (parentOccursInfo != null) {
            minOccursNorm = this.mergeMinOccurs(contentModel.getNormalizedMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccursNorm = this.mergeMaxOccurs(contentModel.getNormalizedMaxOccurs(), parentOccursInfo.getMaxOccurs());
            minOccurs = this.mergeMinOccurs(contentModel.getMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccurs = this.mergeMaxOccurs(contentModel.getMaxOccurs(), parentOccursInfo.getMaxOccurs());
        } else {
            minOccursNorm = contentModel.getNormalizedMinOccurs();
            maxOccursNorm = contentModel.getNormalizedMaxOccurs();
            minOccurs = contentModel.getMinOccurs();
            maxOccurs = contentModel.getMaxOccurs();
        }
        boolean optional = this.getOptional(minOccursNorm, maxOccursNorm);
        boolean repeat = this.getRepeat(minOccursNorm, maxOccursNorm);
        String name = contentModel.getName();
        if (contentModel instanceof ModelGroup && (refgroup = ((ModelGroup)contentModel).getReference()) != null && !(contentModel.getParent() instanceof Schema)) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), REF_TYPE, (Object)TREE_MODEL_GROUP);
            if (repeat) {
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
            }
            wood.createChild(4, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)name), 3, null, this.normalizeName(this.getQualifiedName(refgroup)), repeat, optional, false, "vine");
            return;
        }
        Order order = contentModel.getOrder();
        String branchSuffix = "";
        switch (order.getType()) {
            case 2: {
                branchSuffix = XSD_CHOICE;
                break;
            }
            case 0: {
                branchSuffix = XSD_ALL;
                break;
            }
            default: {
                branchSuffix = XSD_BRANCH;
            }
        }
        String bname = this.getBranchName(branchSuffix, ++this.mBranchCount);
        String javaName = CodeGeneratorUtil.makeClassName((String)bname);
        javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
        OccurrenceInfo parentOccursInfo_ = null;
        switch (order.getType()) {
            case 1: {
                if ((repeat || optional || wood.isRepeated() || wood.isOptional() || wood.getType() == 2 && ((OtdBranch)wood).isChoice()) && (contentModel.getParticleCount() > 1 || !this.mNormalizeCardinalityEnabled)) {
                    this.mUsedNameMap.put(javaName, javaName);
                    if (repeat) {
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
                    }
                    wood = wood.createChild(2, bname, String.valueOf(this.mIdCount++), javaName, 3, null, null, repeat, optional, false, "branch");
                    break;
                }
                parentOccursInfo_ = new OccurrenceInfo(minOccurs, maxOccurs);
                break;
            }
            case 2: {
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isChoice", (Object)"true");
                this.mUsedNameMap.put(javaName, javaName);
                if (repeat) {
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccursNorm));
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccursNorm));
                }
                wood = wood.createChild(2, bname, String.valueOf(this.mIdCount++), javaName, 3, null, null, repeat, optional, true, "branch");
                break;
            }
            case 0: {
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAll", (Object)"true");
                this.mUsedNameMap.put(javaName, javaName);
                if (repeat) {
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
                }
                wood = wood.createChild(2, bname, String.valueOf(this.mIdCount++), javaName, 3, null, null, repeat, optional, false, "branch");
                break;
            }
            default: {
                SchemaException se = new SchemaException("Invalid group compositor: " + order.toString());
                mLogger.error((Object)"createModel", (Throwable)se);
                throw se;
            }
        }
        for (int i = 0; i < contentModel.getParticleCount(); ++i) {
            this.processContent((Structure)contentModel.getParticle(i), wood, parentOccursInfo_);
        }
    }

    private boolean isFakeTree(OtdWood wood) {
        String sVal;
        if (wood.getType() != 1) {
            return false;
        }
        OtdNameValueTypeMap valueMap = this.mOtdOrigin.getOtdSeedInfo(wood.getId());
        if (valueMap == null) {
            return false;
        }
        OtdNameValueType value = valueMap.get("fakeTree");
        if (value == null) {
            return false;
        }
        String string = sVal = value.getValue() == null ? "" : value.getValue().toString();
        return sVal != null && (sVal.equalsIgnoreCase("true") || sVal.equalsIgnoreCase("1") || sVal.equalsIgnoreCase("-1"));
    }

    void processElementDeclContent(ElementDecl elem, OtdWood wood, OccurrenceInfo parentOccursInfo) throws SchemaException, OtdTreeException {
        long maxOccurs;
        long minOccurs;
        if (elem == null) {
            return;
        }
        if (parentOccursInfo != null) {
            minOccurs = this.mergeMinOccurs(elem.getMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccurs = this.mergeMaxOccurs(elem.getMaxOccurs(), parentOccursInfo.getMaxOccurs());
        } else {
            minOccurs = elem.getMinOccurs();
            maxOccurs = elem.getMaxOccurs();
        }
        boolean optional = this.getOptional(minOccurs, maxOccurs);
        boolean repeat = this.getRepeat(minOccurs, maxOccurs);
        String name = this.normalizeName(this.getQualifiedName(elem));
        String unqualifiedName = elem.getName();
        if (elem.isReference()) {
            this.processElementRef(elem, wood, parentOccursInfo);
        } else {
            XMLType xmlType = this.getElemXmlType(elem);
            if (null == xmlType || xmlType.isAnyType()) {
                this.processAnyType(elem, wood, minOccurs, maxOccurs, false);
            } else if (xmlType.isSimpleType()) {
                this.processSimpleElement(elem, wood, minOccurs, maxOccurs);
            } else if (xmlType.isComplexType()) {
                String idStr = String.valueOf(this.mIdCount++);
                OtdSeed seed = this.mOtdOrigin.createSeed(idStr);
                String namespaceURI = this.getTargetNamespace((Structure)elem);
                seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
                if (this.isElementQualified(elem)) {
                    seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
                }
                if (elem.getDefaultValue() != null && elem.getDefaultValue().length() > 0) {
                    seed.addOtdSeedInfo("elemDefaultValue", (Object)elem.getDefaultValue());
                }
                if (elem.isNillable()) {
                    seed.addOtdSeedInfo("elemNillable", (Object)Boolean.TRUE, 1);
                    if (optional) {
                        seed.addOtdSeedInfo("isOptionalNillable", (Object)Boolean.TRUE, 1);
                    }
                    this.mHasNillableElement = true;
                }
                if (((ComplexType)xmlType).isTopLevel()) {
                    String javaName = this.isFakeTree(wood) ? wood.getJavaName() : CodeGeneratorUtil.makeClassName((String)unqualifiedName);
                    seed.addOtdSeedInfo(REF_TYPE, (Object)TREE_COMPLEX_TYPE);
                    if (repeat) {
                        seed.addOtdSeedInfo("maxOccurs", (Object)("" + maxOccurs));
                        seed.addOtdSeedInfo("minOccurs", (Object)("" + minOccurs));
                    }
                    wood.createChild(4, name, idStr, javaName, 3, null, this.normalizeName(this.getQualifiedName(xmlType)), repeat, optional, false, "vine");
                } else {
                    if (!this.mProcessedCompMap.containsValue(elem)) {
                        if (this.isMixedContent((ComplexType)xmlType)) {
                            seed.addOtdSeedInfo("isMixed", (Object)"true");
                        }
                        if (maxOccurs != 1L) {
                            seed.addOtdSeedInfo("maxOccurs", (Object)("" + maxOccurs));
                            seed.addOtdSeedInfo("minOccurs", (Object)("" + minOccurs));
                        }
                        wood = wood.createChild(2, name, idStr, CodeGeneratorUtil.makeClassName((String)unqualifiedName), 3, null, null, repeat, optional, false, "branch");
                    }
                    this.processComplexTypeContent(elem, (ComplexType)xmlType, wood, false);
                    if (elem.isNillable()) {
                        this.createNilAttribute(wood);
                    }
                    if (this.isMixedContent((ComplexType)xmlType)) {
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isText", (Object)"true");
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isMixed", (Object)"true");
                        String javaType = "java.lang.String";
                        wood.createChild(3, XSD_TEXT_MIXED, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT_MIXED), 3, javaType, null, false, true, false, "leaf");
                    }
                }
                this.mOtdOrigin.addOtdSeed(seed);
            } else {
                SchemaException se = new SchemaException("unknown content type" + xmlType.getName());
                mLogger.error((Object)"processElementDeclContent", (Throwable)se);
                throw se;
            }
        }
    }

    void processAnyType(ElementDecl elem, OtdWood wood, long min, long max, boolean isTop) throws SchemaException, OtdTreeException {
        if (!isTop) {
            boolean optional = this.getOptional(min, max);
            boolean repeat = this.getRepeat(min, max);
            String name = this.normalizeName(this.getQualifiedName(elem));
            String unqualifiedName = elem.getName();
            OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
            String namespaceURI = this.getTargetNamespace((Structure)elem);
            seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
            if (this.isElementQualified(elem)) {
                seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
            }
            if (elem.getDefaultValue() != null && elem.getDefaultValue().length() > 0) {
                seed.addOtdSeedInfo("elemDefaultValue", (Object)elem.getDefaultValue());
            }
            if (repeat) {
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + max));
                this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + min));
            }
            wood = wood.createChild(2, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeClassName((String)unqualifiedName), 3, null, null, repeat, optional, false, "branch");
            this.mOtdOrigin.addOtdSeed(seed);
        }
        this.createTypeAttribute(wood);
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAttribute", (Object)"true");
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAny", (Object)"true");
        wood.createChild(3, XSD_ANY_ATTR, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_ANY_ATTR), 3, "java.lang.String", null, true, true, false, "leaf");
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAny", (Object)"true");
        wood.createChild(3, XSD_ANY, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_ANY), 3, "java.lang.String", null, true, true, false, "leaf");
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isText", (Object)"true");
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isMixed", (Object)"true");
        String javaType = "java.lang.String";
        wood.createChild(3, XSD_TEXT_MIXED, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT_MIXED), 3, javaType, null, false, true, false, "leaf");
    }

    void processElementRef(ElementDecl elem, OtdWood wood, OccurrenceInfo parentOccursInfo) throws OtdTreeException, SchemaException {
        long maxOccurs;
        long minOccurs;
        if (elem == null) {
            return;
        }
        if (parentOccursInfo != null) {
            minOccurs = this.mergeMinOccurs(elem.getMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccurs = this.mergeMaxOccurs(elem.getMaxOccurs(), parentOccursInfo.getMaxOccurs());
        } else {
            minOccurs = elem.getMinOccurs();
            maxOccurs = elem.getMaxOccurs();
        }
        boolean optional = this.getOptional(minOccurs, maxOccurs);
        boolean repeat = this.getRepeat(minOccurs, maxOccurs);
        ElementDecl ref = elem.getReference();
        if (ref == null) {
            SchemaException se = new SchemaException("unknown reference element");
            mLogger.error((Object)"processElementRef", (Throwable)se);
            throw se;
        }
        if (this.mTempRoot.containsKey(this.normalizeName(this.getQualifiedName(ref)))) {
            this.mTempRoot.remove(this.normalizeName(this.getQualifiedName(ref)));
        }
        if (this.mSubstitutionGroupMap.containsKey(this.normalizeName(this.getQualifiedName(ref)))) {
            if (ref.getBlock() == null || ref.getBlock() != null && !ref.getBlock().hasSubstitution()) {
                this.processSubstitutionRef(elem, wood, parentOccursInfo);
            }
            return;
        }
        XMLType xmlType = this.getElemXmlType(ref);
        if (null == xmlType || xmlType.isAnyType()) {
            this.processAnyType(ref, wood, elem.getMinOccurs(), elem.getMaxOccurs(), false);
            return;
        }
        if (xmlType.isSimpleType()) {
            this.processSimpleElement(ref, wood, elem.getMinOccurs(), elem.getMaxOccurs());
            return;
        }
        OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
        seed.addOtdSeedInfo(REF_TYPE, (Object)TREE_ELEMENT);
        String namespaceURI = this.getTargetNamespace((Structure)ref);
        seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
        if (this.isElementQualified(ref)) {
            seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
        }
        if (ref.getDefaultValue() != null && ref.getDefaultValue().length() > 0) {
            seed.addOtdSeedInfo("elemDefaultValue", (Object)ref.getDefaultValue());
        }
        if (ref.isNillable()) {
            seed.addOtdSeedInfo("elemNillable", (Object)Boolean.TRUE, 1);
            if (optional) {
                seed.addOtdSeedInfo("isOptionalNillable", (Object)Boolean.TRUE, 1);
            }
            this.mHasNillableElement = true;
        }
        this.mOtdOrigin.addOtdSeed(seed);
        String name = this.normalizeName(this.getQualifiedName(ref));
        String unqualifiedName = ref.getName();
        if (repeat) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
        }
        wood.createChild(4, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeClassName((String)unqualifiedName), 3, null, name, repeat, optional, false, "vine");
    }

    void processSubstitutionRef(ElementDecl elem, OtdWood wood, OccurrenceInfo parentOccursInfo) throws OtdTreeException, SchemaException {
        long maxOccurs;
        long minOccurs;
        if (parentOccursInfo != null) {
            minOccurs = this.mergeMinOccurs(elem.getMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccurs = this.mergeMaxOccurs(elem.getMaxOccurs(), parentOccursInfo.getMaxOccurs());
        } else {
            minOccurs = elem.getMinOccurs();
            maxOccurs = elem.getMaxOccurs();
        }
        boolean optional = this.getOptional(minOccurs, maxOccurs);
        boolean repeat = this.getRepeat(minOccurs, maxOccurs);
        ElementDecl ref = elem.getReference();
        if (ref == null) {
            SchemaException se = new SchemaException("unknown reference element");
            mLogger.error((Object)"processElementRef", (Throwable)se);
            throw se;
        }
        String name = this.normalizeName(this.getQualifiedName(ref));
        String unqualifiedName = ref.getName();
        if (!this.mSubstitutionGroupMap.containsKey(name)) {
            return;
        }
        String subTreeName = "Substitution_Tree_" + name;
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), REF_TYPE, (Object)TREE_MODEL_GROUP);
        if (repeat) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
        }
        wood.createChild(4, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeClassName((String)unqualifiedName), 3, null, subTreeName, repeat, optional, false, "vine");
    }

    void processSimpleElement(ElementDecl elem, OtdWood wood, long min, long max) throws SchemaException, OtdTreeException {
        XMLType xmltype = this.getElemXmlType(elem);
        if (xmltype == null || xmltype.isAnyType()) {
            throw new SchemaException("Must be simple type.");
        }
        String name = this.normalizeName(this.getQualifiedName(elem));
        String UnqualifiedName = elem.getName();
        boolean optional = this.getOptional(min, max);
        boolean repeat = this.getRepeat(min, max);
        OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
        String namespaceURI = this.getTargetNamespace((Structure)elem);
        seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
        if (this.isElementQualified(elem)) {
            seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
        }
        if (elem.getDefaultValue() != null && elem.getDefaultValue().length() > 0) {
            seed.addOtdSeedInfo("elemDefaultValue", (Object)elem.getDefaultValue());
        }
        if (elem.isNillable()) {
            seed.addOtdSeedInfo("elemNillable", (Object)Boolean.TRUE, 1);
            if (optional) {
                seed.addOtdSeedInfo("isOptionalNillable", (Object)Boolean.TRUE, 1);
            }
            optional = true;
            this.mHasNillableElement = true;
        }
        String javaType = "java.lang.String";
        if (xmltype instanceof SimpleType) {
            javaType = XsdUtil.getJavaType((SimpleType)xmltype, this.mSchemaVersion, seed, this.mAccurateDecimal, this.mUseInterface);
            if (this.mPerformStrictValidation) {
                SimpleType type = (SimpleType)xmltype;
                if (type.getParent() instanceof Schema) {
                    this.mOriginRefMap.put(String.valueOf(this.mIdCount), "simpleTypeRef");
                    seed.addOtdSeedInfo("simpleTypeRef", (Object)this.normalizeName(this.getQualifiedName((XMLType)type)));
                } else {
                    seed.addOtdSeedInfo("validationFacets", (Object)XsdUtil.getFullFacets(type).serialize());
                }
            }
        }
        this.mOtdOrigin.addOtdSeed(seed);
        if (repeat) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + max));
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + min));
        }
        wood.createChild(3, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeClassName((String)UnqualifiedName), 3, javaType, null, repeat, optional, false, "leaf");
    }

    void processTopSubstitutions(Schema schema) throws SchemaException, OtdTreeException {
        ElementDecl elem;
        Enumeration e = this.getAllElementDecls(schema);
        while (e.hasMoreElements()) {
            elem = (ElementDecl)e.nextElement();
            this.mAllTopElemMap.put(this.getQualifiedName(elem), elem);
        }
        e = this.getAllElementDecls(schema);
        while (e.hasMoreElements()) {
            ElementDecl headerElem;
            BlockList blockList;
            elem = (ElementDecl)e.nextElement();
            String qName = this.getQualifiedName(elem);
            String headGroupName = elem.getSubstitutionGroup();
            if (headGroupName == null || headGroupName.trim().length() <= 0 || (blockList = (headerElem = elem.getSchema().getElementDecl(headGroupName, false)).getBlock()) != null && blockList.hasSubstitution()) continue;
            String qualiHeadGroupName = this.normalizeName(this.getQualifiedName(headerElem));
            HashMap<String, String> subGroupMap = (HashMap<String, String>)this.mSubstitutionGroupMap.get(qualiHeadGroupName);
            if (subGroupMap == null) {
                subGroupMap = new HashMap<String, String>();
                subGroupMap.put(qualiHeadGroupName, qualiHeadGroupName);
            }
            subGroupMap.put(qName, qName);
            this.mSubstitutionGroupMap.put(qualiHeadGroupName, subGroupMap);
        }
        if (this.mSubstitutionGroupMap == null || this.mSubstitutionGroupMap.size() < 1) {
            return;
        }
        Iterator iter = this.mSubstitutionGroupMap.keySet().iterator();
        while (iter.hasNext()) {
            String headerName = (String)iter.next();
            String treeName = "Substitution_Tree_" + headerName;
            String unqualifiedTreeName = "Substitution_Tree_" + this.removeQualification(headerName);
            ElementDecl headerElem = (ElementDecl)this.mAllTopElemMap.get(headerName);
            String javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedTreeName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            this.mComplexTypeMap.put(treeName, String.valueOf(this.mIdCount));
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), TREE_TYPE, (Object)TREE_MODEL_GROUP);
            this.mModelGroupMap.put(treeName, String.valueOf(this.mIdCount));
            OtdTree wood = this.mOtdGrove.createTree(treeName, String.valueOf(this.mIdCount++), javaName, 3, false, false, "tree");
            String bname = SUBSTITUTION_CHOICE + headerName;
            String unqualifiedBName = SUBSTITUTION_CHOICE + this.removeQualification(headerName);
            javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedBName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "IsChoice", (Object)"true");
            this.mUsedNameMap.put(javaName, javaName);
            wood = wood.createChild(2, bname, String.valueOf(this.mIdCount++), javaName, 3, null, null, false, false, true, "branch");
            HashMap subGroup = (HashMap)this.mSubstitutionGroupMap.get(headerName);
            Iterator iter1 = subGroup.keySet().iterator();
            while (iter1.hasNext()) {
                String unqualifiedSubName;
                String subName = (String)iter1.next();
                if (subName.equals(headerName) && headerElem != null && headerElem.isAbstract()) continue;
                ElementDecl subElem = (ElementDecl)this.mAllTopElemMap.get(subName);
                XMLType xmlType = this.getElemXmlType(subElem);
                if (xmlType == null || xmlType.isAnyType()) {
                    this.processAnyType(subElem, (OtdWood)wood, subElem.getMinOccurs(), subElem.getMaxOccurs(), false);
                    continue;
                }
                if (xmlType.isSimpleType()) {
                    this.processSimpleElement(subElem, (OtdWood)wood, subElem.getMinOccurs(), subElem.getMaxOccurs());
                    continue;
                }
                if (!subName.equals(headerName) && this.mSubstitutionGroupMap.containsKey(subName)) {
                    unqualifiedSubName = "Substitution_Tree_" + this.removeQualification(subName);
                    subName = "Substitution_Tree_" + subName;
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), REF_TYPE, (Object)TREE_MODEL_GROUP);
                } else {
                    unqualifiedSubName = this.removeQualification(subName);
                    String namespaceURI = this.getTargetNamespace((Structure)subElem);
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "namespaceURI", (Object)namespaceURI);
                    if (this.isElementQualified(subElem)) {
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "elementFormDefault", (Object)"qualified");
                    }
                    if (subElem.getDefaultValue() != null && subElem.getDefaultValue().length() > 0) {
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "elemDefaultValue", (Object)subElem.getDefaultValue());
                    }
                    if (subElem.isNillable()) {
                        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "elemNillable", (Object)Boolean.TRUE, 1);
                        this.mHasNillableElement = true;
                    }
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), REF_TYPE, (Object)TREE_ELEMENT);
                }
                wood.createChild(4, subName, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeClassName((String)unqualifiedSubName), 3, null, subName, false, false, false, "substitution vine");
            }
        }
    }

    void processComplexTypeRestrictions(Schema schema) throws SchemaException {
        Enumeration e = this.getAllComplexTypes(schema);
        while (e.hasMoreElements()) {
            ComplexType cType = (ComplexType)e.nextElement();
            if (!cType.isRestricted() || !cType.getBaseType().isComplexType()) continue;
            ComplexType baseType = (ComplexType)cType.getBaseType();
            if (!cType.isSimpleContent()) {
                this.mergeContentModels(cType, baseType);
                continue;
            }
            SimpleType firstSimpleType = this.getFirstSimpleType(cType);
            this.mergeContentModels(cType, baseType);
            cType.setBaseType((XMLType)firstSimpleType);
            cType.setDerivationMethod("extension");
            cType.setRestriction(false);
        }
    }

    private boolean hasLocalAttributes(ComplexType complexType) {
        boolean hasAnyAttributes = true;
        if (complexType.getAnyAttribute() == null) {
            hasAnyAttributes = false;
        }
        int numOfLocalAttributes = 0;
        Enumeration attributesEnum = complexType.getLocalAttributeDecls();
        while (attributesEnum.hasMoreElements()) {
            attributesEnum.nextElement();
            ++numOfLocalAttributes;
        }
        int numOfAttributeRefs = 0;
        Enumeration attributeRefsEnum = complexType.getAttributeGroupReferences();
        while (attributeRefsEnum.hasMoreElements()) {
            attributeRefsEnum.nextElement();
            ++numOfAttributeRefs;
        }
        return hasAnyAttributes || numOfLocalAttributes > 0 || numOfAttributeRefs > 0;
    }

    private void copyAttributes(ComplexType toType, ComplexType fromType) throws SchemaException {
        Set baseAttrSet = this.getAttributeDecls(fromType);
        Iterator iter = baseAttrSet.iterator();
        while (iter.hasNext()) {
            AttributeDecl baseAttr = (AttributeDecl)iter.next();
            AttributeDecl localAttr = toType.getAttributeDecl(baseAttr.getName());
            if (localAttr != null && this.sameAttribute(baseAttr, localAttr)) continue;
            toType.addAttributeDecl(baseAttr);
        }
        if (toType.getAnyAttribute() == null && fromType.getAnyAttribute() != null) {
            toType.setAnyAttribute(fromType.getAnyAttribute());
        }
    }

    private Set getAttributeDecls(ComplexType cType) {
        Set baseSet = null;
        if (cType.getBaseType() != null && cType.getBaseType().isComplexType() && !cType.getBaseType().isAnyType()) {
            baseSet = this.getAttributeDecls((ComplexType)cType.getBaseType());
        }
        HashSet attrSet = new HashSet();
        Enumeration attributesEnum = cType.getAttributeDecls();
        while (attributesEnum.hasMoreElements()) {
            attrSet.add(attributesEnum.nextElement());
        }
        if (baseSet != null) {
            Iterator iter = baseSet.iterator();
            while (iter.hasNext()) {
                AttributeDecl baseAttr = (AttributeDecl)iter.next();
                AttributeDecl localAttr = cType.getAttributeDecl(baseAttr.getName());
                if (localAttr != null && this.sameAttribute(baseAttr, localAttr)) continue;
                attrSet.add(baseAttr);
            }
        }
        return attrSet;
    }

    boolean sameAttribute(AttributeDecl attr1, AttributeDecl attr2) {
        if (attr1.getName() == null && attr2.getName() == null) {
            return true;
        }
        if (attr1.getName() == null || attr2.getName() == null) {
            return false;
        }
        if (!attr1.getName().equals(attr2.getName())) {
            return false;
        }
        String ns1 = "";
        String ns2 = "";
        if (this.getForm(attr1).isQualified() && (ns1 = attr1.getSchema().getTargetNamespace()) == null) {
            ns1 = "";
        }
        if (this.getForm(attr2).isQualified() && (ns2 = attr2.getSchema().getTargetNamespace()) == null) {
            ns2 = "";
        }
        return ns1.equals(ns2);
    }

    Form getForm(AttributeDecl attr) {
        Form form = attr.getForm();
        if (form != null) {
            return form;
        }
        form = attr.getSchema().getAttributeFormDefault();
        if (form == null) {
            form = Form.Unqualified;
        }
        return form;
    }

    void mergeContentModels(ComplexType complexType, ComplexType baseType) throws SchemaException {
        if (baseType.isRestricted() && baseType.getBaseType().isComplexType()) {
            ComplexType baseTypeBase = (ComplexType)baseType.getBaseType();
            this.mergeContentModels(baseType, baseTypeBase);
        }
        this.copyAttributes(complexType, baseType);
        boolean baseSimpleContent = baseType.isSimpleContent();
        boolean baseComplexContent = baseType.isComplexContent();
        complexType.setSimpleContent(baseSimpleContent);
        complexType.setComplexContent(baseComplexContent);
        this.saveBaseType(complexType);
        complexType.setBaseType(null);
        complexType.setBase(null);
        complexType.setRestriction(false);
    }

    void processTopComplexTypes(Schema schema) throws SchemaException, OtdTreeException {
        Enumeration e = this.getAllComplexTypes(schema);
        while (e.hasMoreElements()) {
            ComplexType cType = (ComplexType)e.nextElement();
            String name = this.normalizeName(this.getQualifiedName((XMLType)cType));
            String unqualifiedName = cType.getName();
            if (name == null || name.trim().length() < 1) {
                SchemaException se = new SchemaException("top ComplexType has no name");
                mLogger.error((Object)"processTopComplexType", (Throwable)se);
                throw se;
            }
            OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
            seed.addOtdSeedInfo(TREE_TYPE, (Object)TREE_COMPLEX_TYPE);
            String namespaceURI = this.getTargetNamespace((Structure)cType);
            seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
            seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
            if (cType.isAbstract()) {
                seed.addOtdSeedInfo("isAbstract", (Object)"true");
            }
            if (this.isMixedContent(cType)) {
                seed.addOtdSeedInfo("isMixed", (Object)"true");
            }
            this.mOtdOrigin.addOtdSeed(seed);
            String javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            this.mComplexTypeMap.put(name, String.valueOf(this.mIdCount));
            OtdTree wood = this.mOtdGrove.createTree(name, String.valueOf(this.mIdCount++), javaName, 3, false, false, "tree");
            this.createTypeAttribute((OtdWood)wood);
            this.processComplexTypeContent(null, cType, (OtdWood)wood, true);
            if (!this.isMixedContent(cType) || cType.isAbstract()) continue;
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isText", (Object)"true");
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isMixed", (Object)"true");
            String javaType = "java.lang.String";
            wood.createChild(3, XSD_TEXT_MIXED, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT_MIXED), 3, javaType, null, false, true, false, "leaf");
        }
    }

    void processTopElements(Schema schema) throws SchemaException, OtdTreeException, OtdBuilderException {
        Enumeration e = this.getAllElementDecls(schema);
        if (!e.hasMoreElements()) {
            throw this.createException("xsd.zero.global.elements", null, null);
        }
        Vector topNodeNames = this.mBuilderSpec.getTopNodeNames();
        Map reservedIDs = this.mBuilderSpec.getReservedTreeIDs();
        while (e.hasMoreElements()) {
            Structure parent;
            ElementDecl elem = (ElementDecl)e.nextElement();
            XMLType xmlType = this.getElemXmlType(elem);
            if (xmlType != null && xmlType.isSimpleType()) continue;
            String name = this.normalizeName(this.getQualifiedName(elem));
            String unqualifiedName = elem.getName();
            if (name == null || name.trim().length() == 0) {
                unqualifiedName = name = this.getBranchName(XSD_BRANCH, ++this.mBranchCount);
            }
            String javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            int treeid = this.mIdCount;
            boolean usedReserved = false;
            if (reservedIDs != null && reservedIDs.containsKey(unqualifiedName)) {
                try {
                    treeid = Integer.valueOf((String)reservedIDs.get(unqualifiedName));
                    reservedIDs.remove(unqualifiedName);
                    usedReserved = true;
                }
                catch (Exception nfe) {
                    // empty catch block
                }
            }
            this.mTopElemMap.put(name, String.valueOf(treeid));
            OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(treeid));
            if (!elem.isReference()) {
                String namespaceURI = this.getTargetNamespace((Structure)elem);
                seed.addOtdSeedInfo("namespaceURI", (Object)namespaceURI);
                if (this.isElementQualified(elem)) {
                    seed.addOtdSeedInfo("elementFormDefault", (Object)"qualified");
                }
                if (elem.getDefaultValue() != null && elem.getDefaultValue().length() > 0) {
                    seed.addOtdSeedInfo("elemDefaultValue", (Object)elem.getDefaultValue());
                }
                if (elem.isNillable()) {
                    seed.addOtdSeedInfo("elemNillable", (Object)Boolean.TRUE, 1);
                    this.mHasNillableElement = true;
                }
            }
            String topNodeName = unqualifiedName;
            if (this.mFileName != null) {
                topNodeName = this.mFileName + "_" + unqualifiedName;
            }
            boolean root = false;
            if (topNodeNames == null || topNodeNames.isEmpty() || topNodeNames.contains(topNodeName)) {
                root = true;
            }
            boolean bInlineComplexType = false;
            if (root && xmlType != null && !xmlType.isAnyType() && xmlType.isComplexType() && ((ComplexType)xmlType).isTopLevel()) {
                bInlineComplexType = true;
            }
            if (xmlType instanceof ComplexType && !((parent = ((ComplexType)xmlType).getParent()) instanceof ElementDecl) && parent instanceof Schema && (this.mKeepFakeTree || !bInlineComplexType)) {
                seed.addOtdSeedInfo("fakeTree", (Object)"true", 1);
            }
            OtdTree wood = this.mOtdGrove.createTree(name, String.valueOf(treeid), javaName, 3, true, true, "tree");
            if (!usedReserved) {
                ++this.mIdCount;
            }
            if (root) {
                GuiUtil gui = new GuiUtil();
                gui.addOtdRootMethods(wood);
            }
            if ((this.mKeepFakeTree || !root) && xmlType != null && !xmlType.isAnyType() && xmlType.isComplexType() && ((ComplexType)xmlType).isTopLevel()) {
                seed.addOtdSeedInfo(TREE_TYPE, (Object)TREE_TOP_COMPLEX_ELEMENT);
            }
            this.mOtdOrigin.addOtdSeed(seed);
            this.mProcessedCompMap.put(wood.getId(), elem);
            if (xmlType == null || xmlType.isAnyType()) {
                this.processAnyType(elem, (OtdWood)wood, 1L, 1L, true);
                continue;
            }
            if (bInlineComplexType && !this.mKeepFakeTree) {
                Enumeration enut = this.getAllComplexTypes(schema);
                while (enut.hasMoreElements()) {
                    ComplexType cType = (ComplexType)enut.nextElement();
                    if (!this.getQualifiedName(xmlType).equals(this.getQualifiedName((XMLType)cType))) continue;
                    this.processComplexTypeContent(null, cType, (OtdWood)wood, false);
                    if (elem.isNillable()) {
                        this.createNilAttribute((OtdWood)wood);
                    }
                    if (!this.isMixedContent(cType)) continue;
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isText", (Object)"true");
                    this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isMixed", (Object)"true");
                    String javaType = "java.lang.String";
                    wood.createChild(3, XSD_TEXT_MIXED, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TEXT_MIXED), 3, javaType, null, false, true, false, "leaf");
                }
                continue;
            }
            this.processElementDeclContent(elem, (OtdWood)wood, null);
        }
    }

    void processTopGroups(Schema schema) throws SchemaException, OtdTreeException {
        Enumeration e = this.getAllModelGroups(schema);
        while (e.hasMoreElements()) {
            ModelGroup group = (ModelGroup)e.nextElement();
            String name = this.normalizeName(this.getQualifiedName(group));
            String unqualifiedName = group.getName();
            if (name == null || name.trim().length() < 1) {
                SchemaException se = new SchemaException("top ModelGroup has no name");
                mLogger.error((Object)"processTopGroup", (Throwable)se);
                throw se;
            }
            String javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            this.mModelGroupMap.put(name, String.valueOf(this.mIdCount));
            OtdTree wood = this.mOtdGrove.createTree(name, String.valueOf(this.mIdCount++), javaName, 3, false, false, "tree");
            this.mOtdOrigin.addOtdSeed(wood.getId(), TREE_TYPE, (Object)TREE_MODEL_GROUP);
            if (group.getParticleCount() > 1 || !this.mNormalizeCardinalityEnabled) {
                this.processContentModel((Group)group, (OtdWood)wood, null);
                continue;
            }
            this.processContent((Structure)group, (OtdWood)wood, null);
        }
    }

    void processTopSimpleTypes(Schema schema) throws OtdTreeException, SchemaException {
        Enumeration e = this.getAllSimpleTypes(schema);
        while (e.hasMoreElements()) {
            SimpleType sType = (SimpleType)e.nextElement();
            String name = sType.getName();
            if (name == null || name.trim().length() < 1) {
                SchemaException se = new SchemaException("top SimpleType has no name");
                mLogger.error((Object)"processTopComplexType", (Throwable)se);
                throw se;
            }
            name = this.normalizeName(this.getQualifiedName((XMLType)sType));
            String unqualifiedName = sType.getName();
            String javaName = CodeGeneratorUtil.makeClassName((String)unqualifiedName);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            this.mSimpleTypeMap.put(name, String.valueOf(this.mIdCount));
            OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
            seed.addOtdSeedInfo(TREE_TYPE, (Object)TREE_SIMPLE_TYPE);
            XsdUtil.Facets facets = XsdUtil.getFacets(sType, seed);
            seed.addOtdSeedInfo("validationFacets", (Object)XsdUtil.getFullFacets(sType).serialize());
            OtdTree wood = this.mOtdGrove.createTree(name, String.valueOf(this.mIdCount++), javaName, 3, true, true, "tree");
            this.mOtdOrigin.addOtdSeed(seed);
        }
    }

    void processWildcard(Wildcard wildcard, OtdWood wood, OccurrenceInfo parentOccursInfo) throws OtdTreeException {
        long maxOccurs;
        long minOccurs;
        if (wildcard == null) {
            return;
        }
        if (parentOccursInfo != null) {
            minOccurs = this.mergeMinOccurs(wildcard.getMinOccurs(), parentOccursInfo.getMinOccurs());
            maxOccurs = this.mergeMaxOccurs(wildcard.getMaxOccurs(), parentOccursInfo.getMaxOccurs());
        } else {
            minOccurs = wildcard.getMinOccurs();
            maxOccurs = wildcard.getMaxOccurs();
        }
        boolean optional = this.getOptional(minOccurs, maxOccurs);
        boolean repeat = this.getRepeat(minOccurs, maxOccurs);
        if (wood.getType() == 999) {
            String anyname = this.getBranchName(XSD_ANY, ++this.mBranchCount);
            String javaName = CodeGeneratorUtil.makeClassName((String)anyname);
            javaName = CodeGeneratorUtil.getUniqueNameIgnoreCase((String)javaName, (Map)this.mUsedNameMap);
            this.mUsedNameMap.put(javaName, javaName);
            this.mTopElemMap.put(anyname, String.valueOf(this.mIdCount));
            this.mOtdGrove.createTree(anyname, String.valueOf(this.mIdCount++), javaName, 3, false, false, "tree");
            wood = wood.getLastChild();
        }
        String name = XSD_ANY;
        if (wildcard.isAttributeWildcard()) {
            name = XSD_ANY_ATTR;
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAttribute", (Object)"true");
        }
        this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "isAny", (Object)"true");
        if (repeat) {
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "maxOccurs", (Object)("" + maxOccurs));
            this.mOtdOrigin.addOtdSeed(String.valueOf(this.mIdCount), "minOccurs", (Object)("" + minOccurs));
        }
        wood.createChild(3, name, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)name), 3, "java.lang.String", null, repeat, optional, false, "leaf");
    }

    void getDefaultRoots(Schema schema) {
        Enumeration e = this.getAllElementDecls(schema);
        while (e.hasMoreElements()) {
            ElementDecl elem = (ElementDecl)e.nextElement();
            this.mRoot.put(this.normalizeName(this.getQualifiedName(elem)), this.normalizeName(this.getQualifiedName(elem)));
            this.mTempRoot.put(this.normalizeName(this.getQualifiedName(elem)), this.normalizeName(this.getQualifiedName(elem)));
        }
    }

    void setTopRoots() {
        if (this.mTopElemMap == null || this.mOtdGrove == null) {
            return;
        }
        Vector topNodeNames = this.mBuilderSpec.getTopNodeNames();
        Iterator iter = this.mTopElemMap.keySet().iterator();
        while (iter.hasNext()) {
            OtdTrunk tree;
            String topElemName = (String)iter.next();
            String fullTopElemName = this.removeQualification(topElemName);
            if (this.mFileName != null) {
                fullTopElemName = this.mFileName + "_" + this.removeQualification(topElemName);
            }
            String topElemId = (String)this.mTopElemMap.get(topElemName);
            if (!this.mRoot.containsKey(topElemName) || (tree = (OtdTrunk)this.mOtdGrove.getChild(topElemId)) == null) continue;
            if (XsdParserGenerator.mCheckReachable) {
                if (topNodeNames == null || topNodeNames.isEmpty() || topNodeNames.contains(fullTopElemName)) {
                    tree.setPublic(true);
                    tree.setTop(true);
                    continue;
                }
                tree.setPublic(false);
                tree.setTop(false);
                continue;
            }
            tree.setPublic(true);
            tree.setTop(true);
        }
    }

    XMLType getSubstitutionElemType(ElementDecl elem) {
        XMLType xmlType = null;
        if (elem == null) {
            return xmlType;
        }
        xmlType = elem.getType();
        String subHeaderName = elem.getSubstitutionGroup();
        ElementDecl headerElem = elem;
        while (xmlType == null && subHeaderName != null) {
            headerElem = headerElem.getSchema().getElementDecl(subHeaderName, false);
            xmlType = headerElem.getType();
            subHeaderName = headerElem.getSubstitutionGroup();
        }
        return xmlType;
    }

    XMLType getElemXmlType(ElementDecl elem) {
        return this.getSubstitutionElemType(elem);
    }

    Enumeration getAllElementDecls(Schema schema) {
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        this.getAllElementDecls(schema, list, map);
        return Collections.enumeration(list);
    }

    void getAllElementDecls(Schema schema, Collection list, HashMap map) {
        String targetNamespace = schema.getTargetNamespace();
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        if (map.get(targetNamespace) != null) {
            return;
        }
        this.mOtdOrigin.addOtdSeed(this.mOtdGrove.getId(), "targetNamespace" + String.valueOf(this.mTargetNamespaceId++), (Object)targetNamespace);
        Hashtable nslist = schema.getNamespaces();
        Enumeration en1 = nslist.keys();
        while (en1.hasMoreElements()) {
            String key = (String)en1.nextElement();
            String url = (String)nslist.get(key);
            if (this.mAllNamespaces.containsKey(url) && this.mAllNamespaces.get(url) != null && ((String)this.mAllNamespaces.get(url)).length() > 0) continue;
            this.mAllNamespaces.remove(url);
            this.mAllNamespaces.put(url, key);
        }
        map.put(targetNamespace, schema);
        Enumeration e = schema.getElementDecls();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        e = schema.getImportedSchema();
        while (e.hasMoreElements()) {
            this.getAllElementDecls((Schema)e.nextElement(), list, map);
        }
    }

    Enumeration getAllComplexTypes(Schema schema) {
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        this.getAllComplexTypes(schema, list, map);
        return Collections.enumeration(list);
    }

    void getAllComplexTypes(Schema schema, Collection list, HashMap map) {
        String targetNamespace = schema.getTargetNamespace();
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        if (map.get(targetNamespace) != null) {
            return;
        }
        map.put(targetNamespace, schema);
        Enumeration e = schema.getComplexTypes();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        e = schema.getImportedSchema();
        while (e.hasMoreElements()) {
            this.getAllComplexTypes((Schema)e.nextElement(), list, map);
        }
    }

    Enumeration getAllSimpleTypes(Schema schema) {
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        this.getAllSimpleTypes(schema, list, map);
        return Collections.enumeration(list);
    }

    void getAllSimpleTypes(Schema schema, Collection list, HashMap map) {
        String targetNamespace = schema.getTargetNamespace();
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        if (map.get(targetNamespace) != null) {
            return;
        }
        map.put(targetNamespace, schema);
        Enumeration e = schema.getSimpleTypes();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        e = schema.getImportedSchema();
        while (e.hasMoreElements()) {
            this.getAllSimpleTypes((Schema)e.nextElement(), list, map);
        }
    }

    Enumeration getAllModelGroups(Schema schema) {
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        this.getAllModelGroups(schema, list, map);
        return Collections.enumeration(list);
    }

    void getAllModelGroups(Schema schema, Collection list, HashMap map) {
        String targetNamespace = schema.getTargetNamespace();
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        if (map.get(targetNamespace) != null) {
            return;
        }
        map.put(targetNamespace, schema);
        Enumeration e = schema.getModelGroups();
        while (e.hasMoreElements()) {
            list.add(e.nextElement());
        }
        e = schema.getImportedSchema();
        while (e.hasMoreElements()) {
            this.getAllModelGroups((Schema)e.nextElement(), list, map);
        }
    }

    String getTargetNamespace(Structure structure) {
        String targetNamespace = null;
        if (structure instanceof ElementDecl) {
            ElementDecl elem = (ElementDecl)structure;
            if (elem.isReference()) {
                elem = elem.getReference();
            }
            Schema schema = elem.getSchema();
            targetNamespace = schema.getTargetNamespace();
        } else if (structure instanceof ComplexType) {
            ComplexType complexType = (ComplexType)structure;
            Structure parent = complexType.getParent();
            if (parent instanceof Schema) {
                targetNamespace = ((Schema)parent).getTargetNamespace();
            }
        } else if (structure instanceof SimpleType) {
            SimpleType simpleType = (SimpleType)structure;
            Structure parent = simpleType.getParent();
            if (parent instanceof Schema) {
                targetNamespace = ((Schema)parent).getTargetNamespace();
            }
        } else if (structure instanceof ModelGroup) {
            ModelGroup mg = (ModelGroup)structure;
            if (mg.isReference()) {
                mg = mg.getReference();
            }
            if (mg.getName() != null && mg.getName().length() > 0) {
                Schema schema = mg.getSchema();
                targetNamespace = schema.getTargetNamespace();
            }
        } else if (structure instanceof AttributeDecl) {
            AttributeDecl attr = (AttributeDecl)structure;
            if (attr.isReference()) {
                attr = attr.getReference();
            }
            Schema schema = attr.getSchema();
            targetNamespace = schema.getTargetNamespace();
        }
        if (null == targetNamespace) {
            targetNamespace = "";
        }
        return targetNamespace;
    }

    private boolean isElementQualified(ElementDecl element) {
        String targetNamespace;
        Schema schema;
        if (element.isReference()) {
            element = element.getReference();
        }
        boolean shouldQualify = false;
        Structure elemParent = element.getParent();
        if (elemParent != null && elemParent instanceof Schema) {
            shouldQualify = true;
        }
        if ((schema = element.getSchema()) == null) {
            throw new NullPointerException("ERROR: XSD Schema for element (" + element.getName() + ") is null.");
        }
        if (!shouldQualify) {
            Form elemForm = element.getForm();
            if (elemForm != null) {
                if (elemForm.isQualified()) {
                    shouldQualify = true;
                }
            } else {
                elemForm = schema.getElementFormDefault();
                if (elemForm != null && elemForm.isQualified()) {
                    shouldQualify = true;
                }
            }
        }
        if (shouldQualify && (null == (targetNamespace = schema.getTargetNamespace()) || 0 == targetNamespace.length())) {
            shouldQualify = false;
        }
        return shouldQualify;
    }

    private boolean isAttributeQualified(AttributeDecl attribute) {
        String targetNamespace;
        Schema schema;
        if (attribute.isReference()) {
            attribute = attribute.getReference();
        }
        boolean shouldQualify = false;
        Structure attrParent = attribute.getParent();
        if (attrParent != null && attrParent instanceof Schema) {
            shouldQualify = true;
        }
        if ((schema = attribute.getSchema()) == null) {
            throw new NullPointerException("ERROR: XSD Schema for attribute (" + attribute.getName() + ") is null.");
        }
        if (!shouldQualify) {
            Form attrForm = attribute.getForm();
            if (attrForm != null) {
                if (attrForm.isQualified()) {
                    shouldQualify = true;
                }
            } else {
                attrForm = schema.getAttributeFormDefault();
                if (attrForm != null && attrForm.isQualified()) {
                    shouldQualify = true;
                }
            }
        }
        if (shouldQualify && (null == (targetNamespace = schema.getTargetNamespace()) || 0 == targetNamespace.length())) {
            shouldQualify = false;
        }
        return shouldQualify;
    }

    private void saveBaseType(ComplexType complextype) {
        if (complextype == null || complextype.getName() == null || complextype.getName().length() <= 0) {
            return;
        }
        XMLType basetype = complextype.getBaseType();
        if (basetype == null || !basetype.isComplexType()) {
            return;
        }
        if (((ComplexType)basetype).isSimpleContent()) {
            return;
        }
        String keyName = this.normalizeName(this.getQualifiedName((XMLType)complextype));
        if (keyName == null || keyName.length() <= 0) {
            return;
        }
        if (basetype.getName() == null || basetype.getName().length() <= 0) {
            return;
        }
        this.mComplexBaseTypeMap.put(keyName, new String[]{complextype.isRestricted() ? "true" : "false", this.normalizeName(this.getQualifiedName(basetype))});
    }

    private String[] getSavedBaseType(ComplexType complextype) {
        if (complextype == null) {
            return null;
        }
        String keyName = this.normalizeName(this.getQualifiedName((XMLType)complextype));
        if (keyName == null) {
            return null;
        }
        return (String[])this.mComplexBaseTypeMap.get(keyName);
    }

    private void reserveIDs(Map reserveIDMap) {
        if (reserveIDMap == null || reserveIDMap.values() == null) {
            return;
        }
        Iterator it = reserveIDMap.values().iterator();
        int maxID = 0;
        while (it.hasNext()) {
            try {
                int id = Integer.valueOf((String)it.next());
                if (id <= maxID) continue;
                maxID = id;
            }
            catch (Exception e) {}
        }
        if (maxID > this.mIdCount) {
            this.mIdCount = maxID + 1;
        }
    }

    private String normalizeName(String name) {
        if (name == null) {
            return null;
        }
        return name;
    }

    private String getQualifiedName(ElementDecl elem) {
        String elemName = elem.getName();
        if (!this.isElementQualified(elem)) {
            return elemName;
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("{");
        sBuf.append(this.getTargetNamespace((Structure)elem));
        sBuf.append("}");
        sBuf.append(elemName);
        return sBuf.toString();
    }

    private String getQualifiedName(XMLType type) {
        String name = type.getName();
        if (name == null) {
            return null;
        }
        String ts = this.getTargetNamespace((Structure)type);
        if (ts == null && ts.length() == 0) {
            return name;
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("{");
        sBuf.append(ts);
        sBuf.append("}");
        sBuf.append(name);
        return sBuf.toString();
    }

    private String getQualifiedName(ModelGroup group) {
        String name = group.getName();
        if (name == null) {
            return null;
        }
        String ts = this.getTargetNamespace((Structure)group);
        if (ts == null && ts.length() == 0) {
            return name;
        }
        StringBuffer sBuf = new StringBuffer();
        sBuf.append("{");
        sBuf.append(ts);
        sBuf.append("}");
        sBuf.append(name);
        return sBuf.toString();
    }

    private String removeQualification(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        int pos = -1;
        if (name.charAt(0) != '{' || (pos = name.lastIndexOf(125)) < 0) {
            return name;
        }
        return name.substring(pos + 1);
    }

    private String getNsPrefix(ElementDecl elem) {
        String key;
        String nsprefix = "";
        if (elem.getSchema() != null && elem.getSchema().getTargetNamespace() != null && (key = (String)this.mAllNamespaces.get(elem.getSchema().getTargetNamespace())) != null && key.length() > 0) {
            nsprefix = key;
        }
        return nsprefix;
    }

    private String getNsPrefix(XMLType type) {
        String key;
        String nsprefix = "";
        if (type.getSchema() != null && type.getSchema().getTargetNamespace() != null && (key = (String)this.mAllNamespaces.get(type.getSchema().getTargetNamespace())) != null && key.length() > 0) {
            nsprefix = key;
        }
        return nsprefix;
    }

    private String getNsPrefix(ModelGroup group) {
        String key;
        String nsprefix = "";
        if (group.getSchema() != null && group.getSchema().getTargetNamespace() != null && (key = (String)this.mAllNamespaces.get(group.getSchema().getTargetNamespace())) != null && key.length() > 0) {
            nsprefix = key;
        }
        return nsprefix;
    }

    private void createNilAttribute(OtdWood wood) throws OtdTreeException {
        OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
        seed.addOtdSeedInfo("isAttribute", (Object)"true");
        seed.addOtdSeedInfo("isOptional", (Object)"true");
        seed.addOtdSeedInfo("isNilAttribute", (Object)"true");
        String javaType = "boolean";
        wood.createChild(3, XSD_NIL, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_NIL), 3, javaType, null, false, true, false, "leaf");
    }

    private void createTypeAttribute(OtdWood wood) throws OtdTreeException {
        OtdSeed seed = this.mOtdOrigin.createSeed(String.valueOf(this.mIdCount));
        seed.addOtdSeedInfo("isAttribute", (Object)"true");
        seed.addOtdSeedInfo("isOptional", (Object)"true");
        seed.addOtdSeedInfo("isTypeAttribute", (Object)"true");
        String javaType = "java.lang.String";
        wood.createChild(3, XSD_TYPE, String.valueOf(this.mIdCount++), CodeGeneratorUtil.makeJavaName((String)XSD_TYPE), 3, javaType, null, false, true, false, "leaf");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class OccurrenceInfo {
        private final long mMinOccurs;
        private final long mMaxOccurs;

        public OccurrenceInfo(long minOccurs, long maxOccurs) {
            this.mMinOccurs = minOccurs;
            this.mMaxOccurs = maxOccurs;
        }

        public long getMinOccurs() {
            return this.mMinOccurs;
        }

        public long getMaxOccurs() {
            return this.mMaxOccurs;
        }
    }
}

