/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.builder;

import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdNameValueTypeMap;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class XsdOtdRelaunch {
    static final String RCS_ID = "$Id: XsdOtdRelaunch.java,v 1.2 2007/03/14 01:32:10 lxu Exp $";
    private final String CHOICE_AG = "_choice_";
    private final String SEQUENCE_AG = "_sequence_";
    private final String ALL_AG = "_all_";
    private final double ANCHOR_INDEX = 1.7797162035136925E308;
    private final String RELAUNCHED = "1";
    private Hashtable m_xsdGroupOtds = new Hashtable();
    private Hashtable m_noneLeafOtds = new Hashtable();

    public void relaunch(OtdGrove newOtdGrove, OtdOrigin newOtdOrigin, OtdGrove oldOtdGrove, OtdOrigin oldOtdOrigin) {
        try {
            OtdWood newOtdWood;
            if (!"true".equals(System.getProperty("XsdOtdRelaunch.enabled", "true"))) {
                return;
            }
            if (newOtdGrove != null && (newOtdWood = newOtdGrove.getFirstChild()) != null) {
                this.loadOtdInfos(newOtdWood, newOtdOrigin);
            }
            if (newOtdGrove != null && oldOtdGrove != null) {
                OtdWood oldOtdWood;
                OtdWood newOtdWood2;
                Hashtable match;
                List matches = this.getMatchGroveChildren((OtdWood)newOtdGrove, newOtdOrigin, (OtdWood)oldOtdGrove, oldOtdOrigin);
                Iterator iterator = matches.iterator();
                while (iterator.hasNext()) {
                    match = (Hashtable)iterator.next();
                    newOtdWood2 = (OtdWood)match.get("newOtdWood");
                    oldOtdWood = (OtdWood)match.get("oldOtdWood");
                    if (oldOtdWood == null) continue;
                    this.relaunchXsdGroupOtd(newOtdWood2, newOtdOrigin, oldOtdWood, oldOtdOrigin);
                }
                iterator = matches.iterator();
                while (iterator.hasNext()) {
                    match = (Hashtable)iterator.next();
                    newOtdWood2 = (OtdWood)match.get("newOtdWood");
                    oldOtdWood = (OtdWood)match.get("oldOtdWood");
                    if (oldOtdWood == null) continue;
                    this.relaunchAfterUpdate(newOtdWood2, newOtdOrigin, oldOtdWood, oldOtdOrigin);
                }
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }

    private void loadOtdInfos(OtdWood newOtdWood, OtdOrigin newOtdOrigin) {
        while (newOtdWood != null) {
            this.updateRelaunchFlag(newOtdWood, newOtdOrigin, "");
            if (newOtdWood.getFirstChild() != null) {
                String key;
                if (this.getXsdGroupOtdName(newOtdWood) == null) {
                    key = newOtdWood.getJavaName();
                    this.m_noneLeafOtds.put(key, newOtdWood);
                } else {
                    key = this.getXsdGroupOtdKey(newOtdWood.getName());
                    this.m_xsdGroupOtds.put(key, newOtdWood);
                }
                this.loadOtdInfos(newOtdWood.getFirstChild(), newOtdOrigin);
            }
            newOtdWood = newOtdWood.getNextSibling();
        }
    }

    private List getMatchGroveChildren(OtdWood newOtdGrove, OtdOrigin newOtdOrigin, OtdWood oldOtdGrove, OtdOrigin oldOtdOrigin) {
        int weightcount;
        ArrayList<Hashtable> matches = new ArrayList<Hashtable>(0);
        int relunchcount = newOtdGrove.getChildren().size();
        if (relunchcount > 0 && (weightcount = oldOtdGrove.getChildren().size()) > 0) {
            Hashtable match;
            OtdWood newOtdWood;
            int i;
            double weight = 1.7797162035136925E308;
            OtdWoodList newOtdWoods = newOtdGrove.getChildren();
            for (i = 0; i < newOtdWoods.size(); ++i) {
                newOtdWood = newOtdWoods.getOtdWood(i);
                if (!this.isTopRoot(newOtdWood) || (match = this.getMatchTopRoot(newOtdWood, newOtdOrigin, oldOtdGrove, oldOtdOrigin, weight)) == null) continue;
                matches.add(match);
            }
            for (i = 0; i < newOtdWoods.size(); ++i) {
                newOtdWood = newOtdWoods.getOtdWood(i);
                if (!this.isTopElement(newOtdWood) || (match = this.getMatchTopElement(newOtdWood, newOtdOrigin, oldOtdGrove, oldOtdOrigin, weight)) == null) continue;
                matches.add(match);
            }
            for (i = 0; i < newOtdWoods.size(); ++i) {
                newOtdWood = newOtdWoods.getOtdWood(i);
                if (this.isTopRoot(newOtdWood) || this.isTopElement(newOtdWood) || newOtdWood.getFirstChild() != null || (match = this.getMatchTopLeafOtd(newOtdWood, newOtdOrigin, oldOtdGrove, oldOtdOrigin, weight)) == null) continue;
                matches.add(match);
            }
            int matchcount = 0;
            Iterator iterator = matches.iterator();
            while (iterator.hasNext()) {
                match = (Hashtable)iterator.next();
                Double temp = (Double)match.get("value");
                if (!(temp > 0.0)) continue;
                ++matchcount;
            }
            if (matchcount < weightcount) {
                Hashtable newTopNoneleafOtds = this.getTopNoneleafOtds(newOtdGrove, newOtdOrigin);
                Hashtable oldTopNoneleafOtds = this.getTopNoneleafOtds(oldOtdGrove, oldOtdOrigin);
                Iterator iterator2 = newTopNoneleafOtds.keySet().iterator();
                while (iterator2.hasNext()) {
                    String key = (String)iterator2.next();
                    matches.addAll(this.getMatchNoneleafOtds((List)newTopNoneleafOtds.get(key), newOtdOrigin, (List)oldTopNoneleafOtds.get(key), oldOtdOrigin, weight));
                }
            }
        }
        return matches;
    }

    private Hashtable getMatchTopRoot(OtdWood newOtdWood, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin, double weight) {
        Hashtable<String, Object> match = null;
        if (this.isTopRoot(newOtdWood)) {
            OtdWoodList oldOtdWoods = oldOtdParent.getChildren();
            for (int i = 0; i < oldOtdWoods.size(); ++i) {
                OtdWood oldOtdWood = oldOtdWoods.getOtdWood(i);
                if (!this.isTopRoot(oldOtdWood) || !this.isIdentical(newOtdWood, oldOtdWood)) continue;
                match = new Hashtable<String, Object>();
                match.put("newOtdWood", newOtdWood);
                match.put("oldOtdWood", oldOtdWood);
                match.put("value", new Double(weight));
                break;
            }
        }
        return match;
    }

    private Hashtable getMatchTopElement(OtdWood newOtdWood, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin, double weight) {
        Hashtable<String, Object> match = null;
        if (this.isTopElement(newOtdWood)) {
            OtdWoodList oldOtdWoods = oldOtdParent.getChildren();
            for (int i = 0; i < oldOtdWoods.size(); ++i) {
                OtdWood oldOtdWood = oldOtdWoods.getOtdWood(i);
                if (!this.isTopElement(oldOtdWood) || !this.isIdentical(newOtdWood, oldOtdWood)) continue;
                match = new Hashtable<String, Object>();
                match.put("newOtdWood", newOtdWood);
                match.put("oldOtdWood", oldOtdWood);
                match.put("value", new Double(weight));
                break;
            }
        }
        return match;
    }

    private Hashtable getMatchTopLeafOtd(OtdWood newOtdWood, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin, double weight) {
        Hashtable<String, Object> match = null;
        if (!this.isTopRoot(newOtdWood) && !this.isTopElement(newOtdWood) && newOtdWood.getFirstChild() == null) {
            OtdWoodList oldOtdWoods = oldOtdParent.getChildren();
            for (int i = 0; i < oldOtdWoods.size(); ++i) {
                OtdWood oldOtdWood = oldOtdWoods.getOtdWood(i);
                if (this.isTopRoot(oldOtdWood) || this.isTopElement(oldOtdWood) || oldOtdWood.getFirstChild() != null || !this.isIdentical(newOtdWood, oldOtdWood)) continue;
                match = new Hashtable<String, Object>();
                match.put("newOtdWood", newOtdWood);
                match.put("oldOtdWood", oldOtdWood);
                match.put("value", new Double(weight));
                break;
            }
        }
        return match;
    }

    private Hashtable getTopNoneleafOtds(OtdWood otdParent, OtdOrigin otdOrigin) {
        Hashtable topNoneleafOtds = new Hashtable();
        OtdWoodList otdWoods = otdParent.getChildren();
        for (int i = 0; i < otdWoods.size(); ++i) {
            OtdWood otdWood = otdWoods.getOtdWood(i);
            if (this.isTopRoot(otdWood) || this.isTopElement(otdWood) || otdWood.getFirstChild() == null) continue;
            String name = this.getQualifiedOtdName(otdWood, otdOrigin);
            ArrayList<OtdWood> list = (ArrayList<OtdWood>)topNoneleafOtds.get(name);
            if (list == null) {
                list = new ArrayList<OtdWood>(0);
                topNoneleafOtds.put(name, list);
            }
            if (list.contains(otdWood)) continue;
            list.add(otdWood);
        }
        return topNoneleafOtds;
    }

    private void relaunchXsdGroupOtd(OtdWood newOtdParent, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin) {
        List matches = this.getMatchOtdChildren(newOtdParent, newOtdOrigin, oldOtdParent, oldOtdOrigin, 1.7797162035136925E308);
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            Hashtable match = (Hashtable)iterator.next();
            OtdWood newOtdWood = (OtdWood)match.get("newOtdWood");
            OtdWood oldOtdWood = (OtdWood)match.get("oldOtdWood");
            if (oldOtdWood == null) continue;
            if (newOtdWood.getFirstChild() == null) {
                this.updateLeafOtd(newOtdWood, oldOtdWood, newOtdOrigin);
            } else if (this.isOtdBranch(newOtdWood) && this.isOtdBranch(oldOtdWood)) {
                this.updateOtdBranch(newOtdWood, oldOtdWood, newOtdOrigin);
            }
            this.relaunchXsdGroupOtd(newOtdWood, newOtdOrigin, oldOtdWood, oldOtdOrigin);
        }
    }

    private List getMatchOtdChildren(OtdWood newOtdParent, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin, double weight) {
        int weightcount;
        ArrayList<Hashtable> matches = new ArrayList<Hashtable>(0);
        int relunchcount = newOtdParent.getChildren().size();
        if (relunchcount > 0 && (weightcount = oldOtdParent.getChildren().size()) > 0) {
            Hashtable match;
            double subweight = weight / (double)weightcount;
            OtdWoodList otdWoods = newOtdParent.getChildren();
            for (int i = 0; i < otdWoods.size(); ++i) {
                OtdWood newOtdWood = otdWoods.getOtdWood(i);
                if (newOtdWood.getFirstChild() != null || (match = this.getMatchLeafOtd(newOtdWood, newOtdOrigin, oldOtdParent, oldOtdOrigin, subweight)) == null) continue;
                matches.add(match);
            }
            int matchcount = 0;
            Iterator iterator = matches.iterator();
            while (iterator.hasNext()) {
                match = (Hashtable)iterator.next();
                Double temp = (Double)match.get("value");
                if (!(temp > 0.0)) continue;
                ++matchcount;
            }
            if (matchcount < weightcount) {
                Hashtable newNoneleafOtds = this.getNoneleafOtds(newOtdParent, newOtdOrigin);
                Hashtable oldNoneleafOtds = this.getNoneleafOtds(oldOtdParent, oldOtdOrigin);
                Iterator iterator2 = newNoneleafOtds.keySet().iterator();
                while (iterator2.hasNext()) {
                    String key = (String)iterator2.next();
                    matches.addAll(this.getMatchNoneleafOtds((List)newNoneleafOtds.get(key), newOtdOrigin, (List)oldNoneleafOtds.get(key), oldOtdOrigin, weight));
                }
            }
        }
        return matches;
    }

    private Hashtable getMatchLeafOtd(OtdWood newLeafOtd, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin, double weight) {
        Hashtable<String, Object> match = null;
        if (newLeafOtd.getFirstChild() == null) {
            match = new Hashtable<String, Object>();
            match.put("newOtdWood", newLeafOtd);
            double value = 0.0;
            OtdWoodList oldOtdWoods = oldOtdParent.getChildren();
            for (int i = 0; i < oldOtdWoods.size(); ++i) {
                OtdWood oldLeafOtd = oldOtdWoods.getOtdWood(i);
                if (oldLeafOtd.getFirstChild() != null || newLeafOtd.getType() != oldLeafOtd.getType() || !this.isIdentical(newLeafOtd, oldLeafOtd)) continue;
                match.put("oldOtdWood", oldLeafOtd);
                value = weight;
                break;
            }
            match.put("value", new Double(value));
        }
        return match;
    }

    private void updateLeafOtd(OtdWood newLeafOtd, OtdWood oldLeafOtd, OtdOrigin newOtdOrigin) {
        if (newLeafOtd.getFirstChild() != null || oldLeafOtd.getFirstChild() != null || !this.isRelunchable(newLeafOtd) || this.isRelunchable(oldLeafOtd)) {
            // empty if block
        }
    }

    private void updateOtdBranch(OtdWood newNoneleafOtd, OtdWood oldNoneleafOtd, OtdOrigin newOtdOrigin) {
        if (newNoneleafOtd.getFirstChild() != null && oldNoneleafOtd.getFirstChild() != null) {
            if (this.getXsdGroupOtdName(newNoneleafOtd) == null && this.getXsdGroupOtdName(oldNoneleafOtd) == null) {
                String oldotdJavaName;
                String newOtdJavaName;
                if (this.isRelunchable(newNoneleafOtd) && this.isRelunchable(oldNoneleafOtd) && !(newOtdJavaName = newNoneleafOtd.getJavaName()).equals(oldotdJavaName = oldNoneleafOtd.getJavaName())) {
                    newNoneleafOtd.setJavaName(oldotdJavaName);
                    this.updateRelaunchFlag(newNoneleafOtd, newOtdOrigin, "1");
                    String replacingJavaName = oldotdJavaName;
                    String replacedJavaName = newOtdJavaName;
                    OtdWood newNoneleafOtd2 = (OtdWood)this.m_noneLeafOtds.get(replacingJavaName);
                    if (newNoneleafOtd2 != null) {
                        newNoneleafOtd2.setJavaName(replacedJavaName);
                        this.updateRelaunchFlag(newNoneleafOtd2, newOtdOrigin, "1");
                    }
                    this.m_noneLeafOtds.remove(replacedJavaName);
                    if (newNoneleafOtd2 != null) {
                        this.m_noneLeafOtds.remove(replacingJavaName);
                    }
                    this.m_noneLeafOtds.put(replacingJavaName, newNoneleafOtd);
                    if (newNoneleafOtd2 != null) {
                        this.m_noneLeafOtds.put(replacedJavaName, newNoneleafOtd2);
                    }
                }
            } else {
                this.updateXsdGroupOtd(newNoneleafOtd, oldNoneleafOtd, newOtdOrigin);
            }
        }
    }

    private void updateXsdGroupOtd(OtdWood newXsdGroupOtd, OtdWood oldXsdGroupOtd, OtdOrigin newOtdOrigin) {
        String oldotdName;
        String newOtdName;
        if (this.getXsdGroupOtdName(newXsdGroupOtd) != null && this.getXsdGroupOtdName(oldXsdGroupOtd) != null && this.isRelunchable(newXsdGroupOtd) && this.isRelunchable(oldXsdGroupOtd) && !(newOtdName = newXsdGroupOtd.getName()).equals(oldotdName = oldXsdGroupOtd.getName())) {
            newXsdGroupOtd.setName(oldotdName);
            newXsdGroupOtd.setJavaName("X" + newXsdGroupOtd.getName());
            this.updateRelaunchFlag(newXsdGroupOtd, newOtdOrigin, "1");
            String replacingkey = this.getXsdGroupOtdKey(oldotdName);
            String replacedkey = this.getXsdGroupOtdKey(newOtdName);
            OtdWood newXsdGroupOtd2 = (OtdWood)this.m_xsdGroupOtds.get(replacingkey);
            if (newXsdGroupOtd2 != null) {
                String resolvedOtdName = this.getXsdGroupOtdName(newXsdGroupOtd2) + replacedkey;
                newXsdGroupOtd2.setName(resolvedOtdName);
                newXsdGroupOtd2.setJavaName("X" + newXsdGroupOtd2.getName());
                this.updateRelaunchFlag(newXsdGroupOtd2, newOtdOrigin, "1");
            }
            this.m_xsdGroupOtds.remove(replacedkey);
            if (newXsdGroupOtd2 != null) {
                this.m_xsdGroupOtds.remove(replacingkey);
            }
            this.m_xsdGroupOtds.put(replacingkey, newXsdGroupOtd);
            if (newXsdGroupOtd2 != null) {
                this.m_xsdGroupOtds.put(replacedkey, newXsdGroupOtd2);
            }
        }
    }

    private boolean isIdentical(OtdWood newOtdWood, OtdWood oldOtdWood) {
        boolean temp = false;
        if (newOtdWood.getType() == oldOtdWood.getType()) {
            String newOtdName = newOtdWood.getName();
            String oldotdName = oldOtdWood.getName();
            temp = newOtdName.equals(oldotdName);
        }
        return temp;
    }

    private String getXsdGroupOtdName(OtdWood otdWood) {
        String temp = null;
        if (otdWood.getType() == 2) {
            String agName = otdWood.getName();
            if (agName.startsWith("_choice_") || agName.startsWith("_replace_c_")) {
                temp = "_choice_";
            } else if (agName.startsWith("_sequence_") || agName.startsWith("_replace_s_")) {
                temp = "_sequence_";
            } else if (agName.startsWith("_all_") || agName.startsWith("_replace_a_")) {
                temp = "_all_";
            }
        }
        return temp;
    }

    private String getXsdGroupOtdKey(String xsdGroupOtdName) {
        String key = "";
        if (xsdGroupOtdName.indexOf("_", 1) > 0) {
            key = xsdGroupOtdName.substring(xsdGroupOtdName.indexOf("_", 1) + 1);
        }
        return key;
    }

    private boolean isRelunchable(OtdWood otdWood) {
        boolean temp = false;
        try {
            long id = Long.parseLong(otdWood.getId());
            temp = true;
        }
        catch (Exception e) {
            System.out.println(e);
        }
        return temp;
    }

    private boolean isOtdBranch(OtdWood otdWood) {
        boolean b = false;
        if (otdWood.getType() == 2 && "branch".equals(otdWood.getComment())) {
            b = true;
        }
        return b;
    }

    private boolean isTopRoot(OtdWood otdWood) {
        boolean temp = false;
        if (otdWood instanceof OtdTree) {
            temp = ((OtdTree)otdWood).isTop();
        }
        return temp;
    }

    private boolean isTopElement(OtdWood otdWood) {
        OtdWood vine;
        boolean temp = false;
        if (otdWood instanceof OtdTree && !((OtdTree)otdWood).isTop() && (vine = otdWood.getFirstChild()) != null && vine.getType() == 4) {
            temp = this.isIdentical(vine, otdWood);
        }
        return temp;
    }

    private Hashtable getNoneleafOtds(OtdWood otdParent, OtdOrigin otdOrigin) {
        Hashtable noneleafOtds = new Hashtable();
        OtdWoodList otdWoods = otdParent.getChildren();
        for (int i = 0; i < otdWoods.size(); ++i) {
            ArrayList<OtdWood> list;
            OtdWood otdWood = otdWoods.getOtdWood(i);
            if (otdWood.getFirstChild() == null) continue;
            String name = this.getXsdGroupOtdName(otdWood);
            if (name == null) {
                name = this.getQualifiedOtdName(otdWood, otdOrigin);
            }
            if ((list = (ArrayList<OtdWood>)noneleafOtds.get(name)) == null) {
                list = new ArrayList<OtdWood>(0);
                noneleafOtds.put(name, list);
            }
            if (list.contains(otdWood)) continue;
            list.add(otdWood);
        }
        return noneleafOtds;
    }

    private String getQualifiedOtdName(OtdWood otdWood, OtdOrigin otdOrigin) {
        String qName = null;
        if (otdWood != null && otdOrigin != null) {
            String ns;
            OtdNameValueType valueType;
            qName = otdWood.getName();
            OtdNameValueTypeMap seed = otdOrigin.getOtdSeedInfo(otdWood.getId());
            if (seed != null && (valueType = seed.get("namespaceURI")) != null && (ns = (String)valueType.getValue()) != null && ns.length() > 0) {
                qName = "{" + ns + "}" + qName;
            }
        }
        return qName;
    }

    private OtdNameValueType getRelaunchFlag(OtdWood otdWood, OtdOrigin otdOrigin) {
        OtdNameValueTypeMap seed;
        OtdNameValueType relaunchFlag = null;
        if (otdWood != null && this.isRelunchable(otdWood) && (seed = otdOrigin.getOtdSeedInfo(otdWood.getId())) != null && (relaunchFlag = seed.get("RelaunchFlag")) == null) {
            otdOrigin.addOtdSeed(otdWood.getId(), "RelaunchFlag", (Object)"");
            relaunchFlag = seed.get("RelaunchFlag");
        }
        return relaunchFlag;
    }

    private void updateRelaunchFlag(OtdWood otdWood, OtdOrigin otdOrigin, String value) {
        OtdNameValueType relaunchFlag = this.getRelaunchFlag(otdWood, otdOrigin);
        if (relaunchFlag != null) {
            relaunchFlag.setValue((Object)value);
        }
    }

    private List getMatchNoneleafOtds(List newXsdGroupOtds, OtdOrigin newOtdOrigin, List oldXsdGroupOtds, OtdOrigin oldOtdOrigin, double weight) {
        ArrayList matches;
        block15: {
            matches = new ArrayList(0);
            if (newXsdGroupOtds == null || newXsdGroupOtds.size() <= 0) break block15;
            int[] rows = new int[newXsdGroupOtds.size()];
            if (oldXsdGroupOtds != null && oldXsdGroupOtds.size() > 0) {
                int k;
                int[] columns = new int[oldXsdGroupOtds.size()];
                double[][] matrix = new double[rows.length][columns.length];
                for (int row = 0; row < rows.length; ++row) {
                    rows[row] = row;
                    OtdWood newXsdGroupOtd = (OtdWood)newXsdGroupOtds.get(row);
                    for (int column = 0; column < columns.length; ++column) {
                        columns[column] = column;
                        OtdWood oldXsdGroupOtd = (OtdWood)oldXsdGroupOtds.get(column);
                        matrix[row][column] = this.getNoneleafOtdMatchIndex(newXsdGroupOtd, newOtdOrigin, oldXsdGroupOtd, oldOtdOrigin, weight);
                    }
                }
                int diagonal = rows.length;
                if (diagonal > columns.length) {
                    diagonal = columns.length;
                }
                for (k = 0; k < diagonal; ++k) {
                    int temp;
                    int row;
                    double maxValue = 0.0;
                    int maxRow = k;
                    int maxColumn = k;
                    for (row = k; row < rows.length; ++row) {
                        for (int column = k; column < columns.length; ++column) {
                            double value = matrix[row][column];
                            if (!(maxValue < matrix[row][column])) continue;
                            maxRow = row;
                            maxColumn = column;
                            maxValue = matrix[row][column];
                        }
                    }
                    if (maxColumn != k) {
                        for (row = k; row < rows.length; ++row) {
                            maxValue = matrix[row][k];
                            matrix[row][k] = matrix[row][maxColumn];
                            matrix[row][maxColumn] = maxValue;
                        }
                        temp = columns[k];
                        columns[k] = columns[maxColumn];
                        columns[maxColumn] = temp;
                    }
                    if (maxRow == k) continue;
                    for (int column = k; column < columns.length; ++column) {
                        maxValue = matrix[k][column];
                        matrix[k][column] = matrix[maxRow][column];
                        matrix[maxRow][column] = maxValue;
                    }
                    temp = rows[k];
                    rows[k] = rows[maxRow];
                    rows[maxRow] = temp;
                }
                for (k = 0; k < rows.length; ++k) {
                    Hashtable<String, Object> match = new Hashtable<String, Object>();
                    OtdWood newXsdGroupOtd = (OtdWood)newXsdGroupOtds.get(rows[k]);
                    match.put("newOtdWood", newXsdGroupOtd);
                    OtdWood oldXsdGroupOtd = null;
                    double value = 0.0;
                    if (k < diagonal) {
                        value = matrix[k][k];
                        oldXsdGroupOtd = (OtdWood)oldXsdGroupOtds.get(columns[k]);
                    }
                    if (oldXsdGroupOtd != null) {
                        match.put("oldOtdWood", oldXsdGroupOtd);
                    }
                    match.put("value", new Double(value));
                    matches.add(match);
                }
            } else {
                for (int k = 0; k < rows.length; ++k) {
                    Hashtable<String, Object> match = new Hashtable<String, Object>();
                    OtdWood newXsdGroupOtd = (OtdWood)newXsdGroupOtds.get(k);
                    match.put("newOtdWood", newXsdGroupOtd);
                    match.put("value", new Double(0.0));
                    matches.add(match);
                }
            }
        }
        return matches;
    }

    private double getNoneleafOtdMatchIndex(OtdWood newNoneleafOtd, OtdOrigin newOtdOrigin, OtdWood oldNoneleafOtd, OtdOrigin oldOtdOrigin, double weight) {
        double value = 0.0;
        List matches = this.getMatchOtdChildren(newNoneleafOtd, newOtdOrigin, oldNoneleafOtd, oldOtdOrigin, weight);
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            Hashtable ht = (Hashtable)iterator.next();
            Double temp = (Double)ht.get("value");
            value += temp.doubleValue();
        }
        return value;
    }

    private void relaunchAfterUpdate(OtdWood newOtdParent, OtdOrigin newOtdOrigin, OtdWood oldOtdParent, OtdOrigin oldOtdOrigin) {
        String oldotdJavaName;
        String newOtdJavaName;
        OtdNameValueType relaunchFlag = this.getRelaunchFlag(newOtdParent, newOtdOrigin);
        if (relaunchFlag != null && !"relaunched".equals((String)relaunchFlag.getValue()) && this.isRelunchable(newOtdParent) && this.isRelunchable(oldOtdParent) && !(newOtdJavaName = newOtdParent.getJavaName()).equals(oldotdJavaName = oldOtdParent.getJavaName())) {
            OtdWood newOtdParent2 = null;
            OtdWoodList newOtdWoods = newOtdParent.getParent().getChildren();
            for (int i = 0; i < newOtdWoods.size(); ++i) {
                OtdWood newOtdWood = newOtdWoods.getOtdWood(i);
                if (!oldotdJavaName.equals(newOtdWood.getJavaName())) continue;
                newOtdParent2 = newOtdWood;
                break;
            }
            if (newOtdParent2 != null) {
                String newOtdJavaName2 = oldotdJavaName + "_";
                boolean b = true;
                block1: while (b) {
                    b = false;
                    for (int i = 0; i < newOtdWoods.size(); ++i) {
                        OtdWood newOtdWood = newOtdWoods.getOtdWood(i);
                        if (!newOtdJavaName2.equals(newOtdWood.getJavaName())) continue;
                        newOtdJavaName2 = newOtdJavaName2 + "_";
                        b = true;
                        continue block1;
                    }
                }
                newOtdParent2.setJavaName(newOtdJavaName2);
                this.updateRelaunchFlag(newOtdParent2, newOtdOrigin, "1");
            }
            newOtdParent.setJavaName(oldotdJavaName);
            this.updateRelaunchFlag(newOtdParent, newOtdOrigin, "1");
        }
        List matches = this.getMatchOtdChildren(newOtdParent, newOtdOrigin, oldOtdParent, oldOtdOrigin, 1.7797162035136925E308);
        Iterator iterator = matches.iterator();
        while (iterator.hasNext()) {
            Hashtable match = (Hashtable)iterator.next();
            OtdWood newOtdWood = (OtdWood)match.get("newOtdWood");
            OtdWood oldOtdWood = (OtdWood)match.get("oldOtdWood");
            if (oldOtdWood == null) continue;
            this.relaunchAfterUpdate(newOtdWood, newOtdOrigin, oldOtdWood, oldOtdOrigin);
        }
    }
}

