/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.builder;

import com.stc.otd.forest.OtdSeed;
import com.stc.otd.xsd.runtime.XsdPatternSet;
import com.stc.otd.xsd.runtime.provider.XsdEnumerationSetImpl;
import com.stc.otd.xsd.runtime.provider.XsdFacetsImpl;
import com.stc.otd.xsd.runtime.provider.XsdPatternSetImpl;
import com.stc.util.NestedException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.exolab.castor.xml.schema.Facet;
import org.exolab.castor.xml.schema.SimpleType;
import org.exolab.castor.xml.schema.Union;
import org.exolab.castor.xml.schema.XMLType;
import org.exolab.castor.xml.schema.simpletypes.ListType;

public class XsdUtil {
    private static final String SCALE = "scale";
    private static final String URI_REFERENCE = "uriReference";
    private static final Set mBigPrimitives = new HashSet();

    private static boolean isBig(String xsdPrimType) {
        return mBigPrimitives.contains(xsdPrimType);
    }

    public static boolean isRestrictedBuiltInType(SimpleType type) {
        while (!(type instanceof Union) && !(type instanceof ListType) && type.getBaseType() != null && type.getBaseType() instanceof SimpleType) {
            type = (SimpleType)type.getBaseType();
        }
        return type.isBuiltInType();
    }

    public static Facets getFacets(SimpleType type, OtdSeed seed) {
        Enumeration en;
        Facets stcFacet = new Facets();
        XMLType baseType = type.getBaseType();
        if (baseType != null) {
            stcFacet.mBasicType = baseType.getName();
        }
        if (XsdUtil.isRestrictedBuiltInType(type)) {
            stcFacet.mPrimitive = type.getBuiltInBaseType().getName();
        }
        String xsdType = stcFacet.mPrimitive != null ? stcFacet.mPrimitive : stcFacet.mBasicType;
        seed.addOtdSeedInfo("xsdType", (Object)xsdType);
        Facet f = type.getFacet("fractionDigits");
        if (f != null) {
            stcFacet.mTotalDigits = f.getValue();
            seed.addOtdSeedInfo("totalDigits", (Object)stcFacet.mTotalDigits);
        }
        if ((f = type.getFacet("length")) != null) {
            stcFacet.mLength = f.getValue();
            seed.addOtdSeedInfo("LENGTH", (Object)stcFacet.mLength);
        }
        if ((f = type.getFacet("maxExclusive")) != null) {
            stcFacet.mMaxExclusive = f.getValue();
            seed.addOtdSeedInfo("MAX_EXCLUSIVE", (Object)stcFacet.mMaxExclusive);
        }
        if ((f = type.getFacet("maxInclusive")) != null) {
            stcFacet.mMaxInclusive = f.getValue();
            seed.addOtdSeedInfo("MAX_INCLUSIVE", (Object)stcFacet.mMaxInclusive);
        }
        if ((f = type.getFacet("maxLength")) != null) {
            stcFacet.mMaxLength = f.getValue();
            seed.addOtdSeedInfo("MAX_LENGTH", (Object)stcFacet.mMaxLength);
        }
        if ((f = type.getFacet("minExclusive")) != null) {
            stcFacet.mMinExclusive = f.getValue();
            seed.addOtdSeedInfo("MIN_EXCLUSIVE", (Object)stcFacet.mMinExclusive);
        }
        if ((f = type.getFacet("minInclusive")) != null) {
            stcFacet.mMinInclusive = f.getValue();
            seed.addOtdSeedInfo("MIN_INCLUSIVE", (Object)stcFacet.mMinInclusive);
        }
        if ((f = type.getFacet("minLength")) != null) {
            stcFacet.mMinLength = f.getValue();
            seed.addOtdSeedInfo("MIN_LENGTH", (Object)stcFacet.mMinLength);
        }
        if ((f = type.getFacet("pattern")) != null) {
            stcFacet.mPattern = f.getValue();
            seed.addOtdSeedInfo("PATTERN", (Object)stcFacet.mPattern);
        }
        if ((f = type.getFacet("precision")) != null) {
            stcFacet.mPrecision = f.getValue();
            seed.addOtdSeedInfo("PRECISION", (Object)stcFacet.mPrecision);
        }
        if ((f = type.getFacet("totalDigits")) != null) {
            stcFacet.mTotalDigits = f.getValue();
            seed.addOtdSeedInfo("TOTALDIGITS", (Object)stcFacet.mTotalDigits);
        }
        if ((f = type.getFacet("whiteSpace")) != null) {
            stcFacet.mWhiteSpace = f.getValue();
            seed.addOtdSeedInfo("WHITESPACE", (Object)stcFacet.mWhiteSpace);
        }
        if ((en = type.getFacets("enumeration")) != null) {
            String enumValue = "";
            stcFacet.mEnumeration = new ArrayList();
            while (en.hasMoreElements()) {
                Facet f1 = (Facet)en.nextElement();
                stcFacet.mEnumeration.add(f1.getValue());
                enumValue = enumValue + f1.getValue() + "|";
            }
            if (enumValue.length() > 0) {
                enumValue = enumValue.substring(0, enumValue.length() - 1);
                seed.addOtdSeedInfo("enumeration", (Object)enumValue);
            }
        }
        return stcFacet;
    }

    public static String getJavaType(SimpleType type, String schemaVersion, OtdSeed seed) {
        if (type == null) {
            return "java.lang.String";
        }
        Facets f = XsdUtil.getFacets(type, seed);
        if (schemaVersion.equals("200010")) {
            return XsdUtil.makeJavaType200010(f, false, false);
        }
        String type1 = XsdUtil.makeJavaType2001(f, false, false);
        return type1;
    }

    public static String getJavaType(SimpleType type, String schemaVersion, OtdSeed seed, boolean bAccurateDecimal, boolean useInterface) {
        if (type == null) {
            return "java.lang.String";
        }
        Facets f = XsdUtil.getFacets(type, seed);
        if (schemaVersion.equals("200010")) {
            return XsdUtil.makeJavaType200010(f, bAccurateDecimal, useInterface);
        }
        String type1 = XsdUtil.makeJavaType2001(f, bAccurateDecimal, useInterface);
        return type1;
    }

    private static String makeJavaType200010(Facets facets, boolean bAccurateDecimal, boolean useInterface) {
        int i;
        String prim = facets.mPrimitive;
        String[] primitives = new String[]{"anyType", "java.lang.String", "anySimpleType", "java.lang.String", "byte", "byte", "string", "java.lang.String", "boolean", "boolean", "float", "float", "double", "double", "int", "int", "integer", "long", "long", "long", "decimal", "decimal", "negativeInteger", "long", "positiveInteger", "long", "unsignedLong", "long", "unsignedInt", "long", "unsignedShort", "int", "unsignedByte", "short", "timeDuration", "com.stc.otd.xsd.datatype.TimeDuration", "recurringDuration", "com.stc.otd.xsd.datatype.RecurringDuration", "recurringDay", "com.stc.otd.xsd.datatype.RecurringDay", "recurringDate", "com.stc.otd.xsd.datatype.RecurringDate", "time", "com.stc.otd.xsd.datatype.Time", "timeInstant", "com.stc.otd.xsd.datatype.TimeInstant", "date", "com.stc.otd.xsd.datatype.Date", "year", "com.stc.otd.xsd.datatype.Year", "month", "com.stc.otd.xsd.datatype.Month", "century", "com.stc.otd.xsd.datatype.Century", "binary", "byte[]", URI_REFERENCE, "java.lang.String", "ID", "java.lang.String", "IDREF", "java.lang.String", "ENTITY", "java.lang.String", "QName", "java.lang.String", "NMTOKEN", "java.lang.String", "language", "java.lang.String", "token", "java.lang.String", "nonNegativeInteger", "long", "nonPositiveInteger", "long"};
        if (!(prim == null || prim.equals("decimal") && bAccurateDecimal)) {
            for (i = 0; i < primitives.length; i += 2) {
                if (!prim.equals(primitives[i])) continue;
                return primitives[i + 1];
            }
        }
        if (!((prim = facets.mBasicType) == null || prim.equals("decimal") && bAccurateDecimal)) {
            for (i = 0; i < primitives.length; i += 2) {
                if (!prim.equals(primitives[i])) continue;
                return primitives[i + 1];
            }
        }
        String string = prim = facets.mPrimitive == null ? facets.mBasicType : facets.mPrimitive;
        if (prim == null) {
            return "java.lang.String";
        }
        if (prim.equals("decimal")) {
            if (facets.mMinInclusive == null && facets.mMinExclusive == null || facets.mMaxInclusive == null && facets.mMaxExclusive == null) {
                if (facets.mScale != null && new BigDecimal(facets.mScale).equals(new BigDecimal("0"))) {
                    return "java.math.BigInteger";
                }
                return "java.math.BigDecimal";
            }
            if (facets.mScale != null && new BigDecimal(facets.mScale).equals(new BigDecimal("0"))) {
                BigInteger min = null;
                BigInteger max = null;
                if (facets.mMinInclusive != null) {
                    min = new BigInteger(facets.mMinInclusive);
                } else if (facets.mMinExclusive != null) {
                    min = new BigInteger(facets.mMinExclusive).add(new BigInteger("1"));
                }
                if (facets.mMaxInclusive != null) {
                    max = new BigInteger(facets.mMaxInclusive);
                } else if (facets.mMaxExclusive != null) {
                    max = new BigInteger(facets.mMaxExclusive);
                    max = max.subtract(new BigInteger("1"));
                }
                if (min != null && max != null) {
                    int bitLength;
                    int r1 = min.bitLength();
                    boolean neg = false;
                    if (min.signum() < 0) {
                        ++r1;
                        neg = true;
                    }
                    int r2 = 0;
                    if (max.signum() > 0) {
                        r2 = max.bitLength();
                    }
                    int n = bitLength = r1 > r2 ? r1 : r2;
                    if (!neg && bitLength <= 8) {
                        return "byte";
                    }
                    if (bitLength <= 16) {
                        return "short";
                    }
                    if (bitLength <= 32) {
                        return "int";
                    }
                    if (bitLength <= 64) {
                        return "long";
                    }
                }
                return "java.math.BigInteger";
            }
            return "java.math.BigDecimal";
        }
        if (prim.equals("list")) {
            return XsdUtil.makeJavaType200010(facets.mItemType, bAccurateDecimal, useInterface);
        }
        return "java.lang.String";
    }

    private static String makeJavaType2001(Facets facets, boolean bAccurateDecimal, boolean useInterface) {
        int i;
        String prim = facets.mPrimitive;
        String[] primitives = new String[]{"anyType", "java.lang.String", "anySimpleType", "java.lang.String", "byte", "byte", "short", "short", "string", "java.lang.String", "boolean", "boolean", "float", "float", "double", "double", "int", "int", "integer", "long", "long", "long", "decimal", "double", "negativeInteger", "long", "positiveInteger", "long", "unsignedLong", "long", "unsignedInt", "long", "unsignedShort", "int", "unsignedByte", "short", "duration", "com.stc.otd.xsd.datatype.Duration", "time", "com.stc.otd.xsd.datatype.Time2001", "dateTime", "com.stc.otd.xsd.datatype.DateTime", "date", "com.stc.otd.xsd.datatype.Date2001", "gYearMonth", "com.stc.otd.xsd.datatype.GYearMonth", "gYear", "com.stc.otd.xsd.datatype.GYear", "gMonth", "com.stc.otd.xsd.datatype.GMonth", "gMonthDay", "com.stc.otd.xsd.datatype.GMonthDay", "gDay", "com.stc.otd.xsd.datatype.GDay", "hexBinary", "byte[]", "base64Binary", "byte[]", "anyURI", "java.lang.String", "ID", "java.lang.String", "IDREF", "java.lang.String", "ENTITY", "java.lang.String", "QName", "java.lang.String", "NMTOKEN", "java.lang.String", "language", "java.lang.String", "token", "java.lang.String", "nonNegativeInteger", "long", "nonPositiveInteger", "long"};
        if (prim != null) {
            if (prim.equals("date") && useInterface) {
                return "com.stc.runtime.dt.Date";
            }
            if (prim.equals("dateTime") && useInterface) {
                return "com.stc.runtime.dt.DateTime";
            }
            if (!XsdUtil.isBig(prim) || !bAccurateDecimal) {
                for (i = 0; i < primitives.length; i += 2) {
                    if (!prim.equals(primitives[i])) continue;
                    return primitives[i + 1];
                }
            }
        }
        if ((prim = facets.mBasicType) != null) {
            if (prim.equals("date") && useInterface) {
                return "com.stc.runtime.dt.Date";
            }
            if (prim.equals("dateTime") && useInterface) {
                return "com.stc.runtime.dt.DateTime";
            }
            if (!XsdUtil.isBig(prim) || !bAccurateDecimal) {
                for (i = 0; i < primitives.length; i += 2) {
                    if (!prim.equals(primitives[i])) continue;
                    return primitives[i + 1];
                }
            }
        }
        String string = prim = facets.mPrimitive == null ? facets.mBasicType : facets.mPrimitive;
        if (prim == null) {
            return "java.lang.String";
        }
        if (XsdUtil.isBig(prim)) {
            if (facets.mMinInclusive == null && facets.mMinExclusive == null || facets.mMaxInclusive == null && facets.mMaxExclusive == null) {
                if (!"decimal".equals(prim) || facets.mScale != null && facets.mScale.length() > 0 && new BigDecimal(facets.mScale).equals(new BigDecimal("0"))) {
                    return "java.math.BigInteger";
                }
                return "java.math.BigDecimal";
            }
            if (!"decimal".equals(prim) || facets.mScale != null && facets.mScale.length() > 0 && new BigDecimal(facets.mScale).equals(new BigDecimal("0"))) {
                BigInteger min = null;
                BigInteger max = null;
                if (facets.mMinInclusive != null) {
                    min = new BigInteger(facets.mMinInclusive);
                } else if (facets.mMinExclusive != null) {
                    min = new BigInteger(facets.mMinExclusive).add(new BigInteger("1"));
                }
                if (facets.mMaxInclusive != null) {
                    max = new BigInteger(facets.mMaxInclusive);
                } else if (facets.mMaxExclusive != null) {
                    max = new BigInteger(facets.mMaxExclusive);
                    max = max.subtract(new BigInteger("1"));
                }
                if (min != null && max != null) {
                    int bitLength;
                    int r1 = min.bitLength();
                    boolean neg = false;
                    if (min.signum() < 0) {
                        ++r1;
                        neg = true;
                    }
                    int r2 = 0;
                    if (max.signum() > 0) {
                        r2 = max.bitLength();
                    }
                    int n = bitLength = r1 > r2 ? r1 : r2;
                    if (!neg && bitLength <= 8) {
                        return "byte";
                    }
                    if (bitLength <= 16) {
                        return "short";
                    }
                    if (bitLength <= 32) {
                        return "int";
                    }
                    if (bitLength <= 64) {
                        return "long";
                    }
                }
                return "java.math.BigInteger";
            }
            return "java.math.BigDecimal";
        }
        if (prim.equals("list")) {
            return "java.lang.String";
        }
        return "java.lang.String";
    }

    private static XsdFacetsImpl getLocalFacets(SimpleType type) {
        XsdFacetsImpl localFacets = new XsdFacetsImpl();
        XsdEnumerationSetImpl enumSet = new XsdEnumerationSetImpl(3);
        XsdPatternSetImpl patternSet = new XsdPatternSetImpl(2);
        Enumeration e = type.getLocalFacets();
        while (e != null && e.hasMoreElements()) {
            Facet f = (Facet)e.nextElement();
            if ("enumeration".equals(f.getName())) {
                enumSet.addChild(f.getValue());
                continue;
            }
            if ("fractionDigits".equals(f.getName())) {
                localFacets.setFractionDigits(Integer.valueOf(f.getValue()));
                continue;
            }
            if ("length".equals(f.getName())) {
                localFacets.setLength(Integer.valueOf(f.getValue()));
                continue;
            }
            if ("maxExclusive".equals(f.getName())) {
                localFacets.setMaxExclusive(f.getValue());
                continue;
            }
            if ("maxInclusive".equals(f.getName())) {
                localFacets.setMaxInclusive(f.getValue());
                continue;
            }
            if ("maxLength".equals(f.getName())) {
                localFacets.setMaxLength(Integer.valueOf(f.getValue()));
                continue;
            }
            if ("minExclusive".equals(f.getName())) {
                localFacets.setMinExclusive(f.getValue());
                continue;
            }
            if ("minInclusive".equals(f.getName())) {
                localFacets.setMinInclusive(f.getValue());
                continue;
            }
            if ("minLength".equals(f.getName())) {
                localFacets.setMinLength(Integer.valueOf(f.getValue()));
                continue;
            }
            if ("pattern".equals(f.getName())) {
                XsdPatternSetImpl patternItem = new XsdPatternSetImpl(3);
                patternItem.setPattern(f.getValue());
                patternSet.addChild(patternItem);
                localFacets.setPattern(patternSet);
                continue;
            }
            if ("totalDigits".equals(f.getName())) {
                localFacets.setTotalDigits(Integer.valueOf(f.getValue()));
                continue;
            }
            if (!"whiteSpace".equals(f.getName())) continue;
            localFacets.setWhitespace(f.getValue());
        }
        if (enumSet.getChildrenCount() > 0) {
            localFacets.setEnumeration(enumSet);
        }
        if (type instanceof ListType) {
            localFacets.setIsListType(true);
        } else if (type instanceof Union) {
            localFacets.setIsUnion(true);
        }
        if (type.isBuiltInType()) {
            localFacets.setBuiltInType(type.getName());
        }
        return localFacets;
    }

    private static void restrictFacets(SimpleType type, XsdFacetsImpl superFacets) {
        XsdFacetsImpl localFacets = XsdUtil.getLocalFacets(type);
        if (localFacets.getLength() != null) {
            superFacets.setLength(localFacets.getLength());
        }
        if (localFacets.getFractionDigits() != null) {
            superFacets.setFractionDigits(localFacets.getFractionDigits());
        }
        if (localFacets.getMaxExclusive() != null) {
            superFacets.setMaxExclusive(localFacets.getMaxExclusive());
        }
        if (localFacets.getMaxInclusive() != null) {
            superFacets.setMaxInclusive(localFacets.getMaxInclusive());
        }
        if (localFacets.getMaxLength() != null) {
            superFacets.setMaxLength(localFacets.getMaxLength());
        }
        if (localFacets.getMinExclusive() != null) {
            superFacets.setMinExclusive(localFacets.getMinExclusive());
        }
        if (localFacets.getMinInclusive() != null) {
            superFacets.setMinInclusive(localFacets.getMinInclusive());
        }
        if (localFacets.getMinLength() != null) {
            superFacets.setMinLength(localFacets.getMinLength());
        }
        if (localFacets.getTotalDigits() != null) {
            superFacets.setTotalDigits(localFacets.getTotalDigits());
        }
        if (localFacets.getWhitespace() != null) {
            superFacets.setWhitespace(localFacets.getWhitespace());
        }
        if (localFacets.getEnumeration() != null) {
            superFacets.setEnumeration((XsdEnumerationSetImpl)localFacets.getEnumeration());
        }
        if (localFacets.getPattern() != null) {
            XsdPatternSet superPatternSet = superFacets.getPattern();
            if (superPatternSet != null) {
                XsdPatternSetImpl newPatternSet = new XsdPatternSetImpl(1);
                newPatternSet.addChild(superPatternSet);
                newPatternSet.addChild(localFacets.getPattern());
            } else {
                superFacets.setPattern((XsdPatternSetImpl)localFacets.getPattern());
            }
        }
    }

    public static XsdFacetsImpl getFullFacets(SimpleType type) {
        if (type.isBuiltInType()) {
            return XsdUtil.getLocalFacets(type);
        }
        XsdFacetsImpl fullfacets = null;
        if (type instanceof Union) {
            fullfacets = XsdUtil.getLocalFacets(type);
            Union unionType = (Union)type;
            Enumeration e = unionType.getMemberTypes();
            while (e.hasMoreElements()) {
                SimpleType memberType = (SimpleType)e.nextElement();
                XsdFacetsImpl memberFacets = XsdUtil.getFullFacets(memberType);
                fullfacets.addMemberFacets(memberFacets);
            }
        } else if (type instanceof ListType) {
            ListType listType = (ListType)type;
            fullfacets = XsdUtil.getLocalFacets(type);
            XsdFacetsImpl baseFacets = XsdUtil.getFullFacets(listType.getItemType());
            fullfacets.setBaseItemFacets(baseFacets);
        } else if ((type.getBaseType() != null || type.getBuiltInBaseType() != null) && type.getDerivationMethod().equals("restriction")) {
            SimpleType baseType = (SimpleType)type.getBaseType();
            fullfacets = XsdUtil.getFullFacets(baseType);
            XsdUtil.restrictFacets(type, fullfacets);
        } else {
            throw new NestedException("If a simple type is not a built-in type, then it must be either Union, List or Restriction.");
        }
        return fullfacets;
    }

    static {
        mBigPrimitives.add("decimal");
        mBigPrimitives.add("integer");
        mBigPrimitives.add("negativeInteger");
        mBigPrimitives.add("positiveInteger");
        mBigPrimitives.add("nonNegativeInteger");
        mBigPrimitives.add("nonPositiveInteger");
    }

    public static class Facets {
        private String mPrimitive = "anyType";
        private String mBasicType = null;
        private String mTypeName = null;
        private String mPrecision = null;
        private String mScale = null;
        private String mTotalDigits = null;
        private String mPattern = null;
        private String mWhiteSpace = null;
        private List mEnumeration = null;
        private String mMaxInclusive = null;
        private String mMaxExclusive = null;
        private String mMinInclusive = null;
        private String mMinExclusive = null;
        private String mLength = null;
        private String mMinLength = null;
        private String mMaxLength = null;
        private Facets mItemType = null;
        private String mEncoding = null;
        private String mDuration = null;
        private String mPeriod = null;
    }
}

