/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.xsd.codegen.XsdCodeGeneratorUtil;
import com.stc.otd.xsd.codegen.XsdOriginVelocityWrapper;
import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.util.HashMap;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class AntlrGrammarGeneratorTask {
    private OtdMetaContainer mOtd = null;
    private File mWorkingDir;
    private VelocityEngine mEngine;
    private VelocityContext mVC;

    public void generate(OtdMetaContainer otd, File packageDir, VelocityEngine ve, VelocityContext vc) throws Exception {
        this.mOtd = otd;
        this.mWorkingDir = packageDir;
        this.mEngine = ve;
        this.mVC = vc;
        this.generate();
    }

    private void generate() throws Exception {
        XsdOriginVelocityWrapper originWrapper;
        HashMap extList;
        NodeWrapper wrapper = XsdCodeGeneratorUtil.getNodeWrapper();
        FileWriter mOut = new FileWriter(new File(this.mWorkingDir, wrapper.wrapNode((OtdWood)this.mOtd.getOtdGrove()).getJavaName() + ".g"));
        if (!this.mVC.containsKey((Object)"otdNode")) {
            this.mVC.put("otdNode", (Object)wrapper.wrapNode((OtdWood)this.mOtd.getOtdGrove()));
        }
        if (!this.mVC.containsKey((Object)"otdList")) {
            this.mVC.put("otdList", (Object)XsdCodeGeneratorUtil.createReachableOtdWrapperList(this.mOtd));
        }
        if (!this.mVC.containsKey((Object)"inlineTierMarker")) {
            this.mVC.put("inlineTierMarker", (Object)new CodeGeneratorUtil.OtdTierMarker());
        }
        if (this.mOtd.getOtdOrigin() != null && (extList = (originWrapper = new XsdOriginVelocityWrapper(this.mOtd.getOtdOrigin())).getExtensionList(this.mOtd.getOtdGrove())) != null && extList.size() > 0) {
            this.mVC.put("extendedList", (Object)extList);
        }
        System.out.println("XSD....... Generating ANTLR grammar from OTD - " + this.mOtd.getOtdGrove().getName());
        Template t = this.mEngine.getTemplate("com/stc/otd/xsd/codegen/templates/grammar.vm");
        t.merge((Context)this.mVC, (Writer)mOut);
        mOut.close();
        t = null;
        this.mVC.remove((Object)"inlineTierMarker");
        this.mVC.remove((Object)"otdList");
        this.mVC.remove((Object)"otdNode");
        this.mVC.remove((Object)"extendedList");
    }
}

