/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.GenMeta;
import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdLeaf;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdVine;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import com.stc.otd.xsd.codegen.XsdCodeGeneratorUtil;
import com.stc.otd.xsd.codegen.XsdOriginVelocityWrapper;
import com.stc.otd.xsd.codegen.XsdParserGenerator;
import com.stc.util.UnicodeFile;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class RuleGeneratorTask {
    private OtdMetaContainer mOtd = null;
    private File mWorkingDir;
    private VelocityEngine mEngine;
    private VelocityContext mVC;
    private PrintWriter mOut;
    private XsdOriginVelocityWrapper mOrigin;
    private NodeWrapper mWrapper = XsdCodeGeneratorUtil.getNodeWrapper();

    public EntryMap generate(OtdMetaContainer otd, File packageDir, VelocityEngine ve, VelocityContext vc, Map tokenmap) throws Exception {
        this.mWorkingDir = packageDir;
        this.mEngine = ve;
        this.mVC = vc;
        this.mOtd = otd;
        this.mOrigin = new XsdOriginVelocityWrapper(this.mOtd.getOtdOrigin());
        this.generateRuleCode();
        Set reachableTrees = null;
        if (XsdParserGenerator.mCheckReachable) {
            reachableTrees = XsdCodeGeneratorUtil.reachable(this.mOtd);
        }
        return this.generateRuleMeta(tokenmap, reachableTrees);
    }

    private void generateRuleCode() throws Exception {
        String pkgName;
        OutputStreamWriter out = UnicodeFile.makeOutputWriter((File)new File(this.mWorkingDir, "Rule.java"));
        if (!this.mVC.containsKey((Object)"otdPackageName")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackageName", (Object)pkgName);
        }
        if (!this.mVC.containsKey((Object)"otdPackagePath")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackagePath", (Object)pkgName.replace('.', '/'));
        }
        System.out.println("Generating Rule.java code from OTD - " + this.mOtd.getOtdGrove().getName());
        Template t = this.mEngine.getTemplate("com/stc/otd/xsd/codegen/templates/rule.vm");
        t.merge((Context)this.mVC, (Writer)out);
        out.close();
        t = null;
    }

    private String quote(String s) {
        if (s == null || s.length() == 0) {
            return "-";
        }
        s = s.replaceAll("\\\\", "\\\\\\\\");
        s = s.replaceAll("\\\"", "\\\\\\\"");
        return '\"' + s + '\"';
    }

    private String intstr(int i) {
        if (i == -1) {
            return "-";
        }
        return String.valueOf(i);
    }

    private String boolStr(boolean value) {
        if (value) {
            return "t";
        }
        return "f";
    }

    private void emitSequenceRule(int ruleindex, int childindex, int min, int max, int start, String startname, int end, String endname, boolean nillable) throws Exception {
        this.mOut.println("s " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.intstr(start) + " " + this.quote(startname) + " " + this.intstr(end) + " " + this.quote(endname) + " " + this.boolStr(nillable));
    }

    private void emitAnyOrderRule(int ruleindex, int childindex, int min, int max, int start, String startname, int end, String endname, boolean nillable) throws Exception {
        this.mOut.println("n " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.intstr(start) + " " + this.quote(startname) + " " + this.intstr(end) + " " + this.quote(endname) + " " + this.boolStr(nillable));
    }

    private void emitChoiceRule(int ruleindex, int childindex, int min, int max, int start, String startname, int end, String endname, boolean nillable) throws Exception {
        this.mOut.println("c " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.intstr(start) + " " + this.quote(startname) + " " + this.intstr(end) + " " + this.quote(endname) + " " + this.boolStr(nillable));
    }

    private void emitSimpleRule(int ruleindex, int childindex, int min, int max, int start, String startname, int end, String endname, String jtype, String facets, boolean nillable, String builtInXsdType) throws Exception {
        this.mOut.println("u " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.intstr(start) + " " + this.quote(startname) + " " + this.intstr(end) + " " + this.quote(endname) + " " + this.quote(jtype) + " " + this.quote(facets) + " " + this.boolStr(nillable) + " " + this.quote(builtInXsdType));
    }

    private void emitAttributeRule(int ruleindex, int childindex, int min, int max, String nsURI, String name, String jtype) throws Exception {
        this.mOut.println("a " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.quote(nsURI) + " " + this.quote(name) + " " + this.quote(jtype));
    }

    private void emitWildcardRule(int ruleindex, int childindex, int min, int max, String ns, boolean nillable) throws Exception {
        this.mOut.println("w " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.quote(ns) + " " + this.boolStr(nillable));
    }

    private void emitDataRule(int ruleindex, int childindex, int min, int max, String jtype, String builtInXsdType) throws Exception {
        this.mOut.println("d " + ruleindex + " " + childindex + " " + min + " " + this.intstr(max) + " " + this.quote(jtype) + " " + this.quote(builtInXsdType));
    }

    private void emitSTValidationRule(int ruleindex, int childindex, String validationFacets) throws Exception {
        this.mOut.println("v " + ruleindex + " " + childindex + " 1 1 " + this.quote(validationFacets));
    }

    private void emitRuleRefViaVine(int ruleindex, Integer[] refrule) throws Exception {
        this.mOut.print("x " + ruleindex + " " + refrule.length);
        for (int i = 0; i < refrule.length; ++i) {
            this.mOut.print(" " + refrule[i]);
        }
        this.mOut.println();
    }

    private void emitRuleRefForSimpleType(int ruleindex, int refindex) throws Exception {
        this.mOut.println("z " + ruleindex + " " + refindex);
    }

    private void emitKeyComment(String nodeid, int childindex) throws Exception {
        this.mOut.println("# " + nodeid + "." + childindex);
    }

    private EntryMap generateRuleMeta(Map tokenmap, Set reachableTrees) throws Exception {
        System.out.println("Generating rule.meta from OTD - " + this.mOtd.getOtdGrove().getName());
        OutputStreamWriter osw = UnicodeFile.makeOutputWriter((File)new File(this.mWorkingDir, "rule.meta"));
        this.mOut = new PrintWriter(osw);
        this.mOut.println("# This is a generated file that describes the parsing rules");
        this.mOut.println("# For string, '-' means null; for integer, '-' means -1");
        this.mOut.println("# 'x' Child reference list: ruleindex count childrule1 childrule2 ... ");
        this.mOut.println("# 'y' Extendion list: ruleindex count extrule1 extrule2 ... ");
        this.mOut.println("# 'z' Validation rule reference: ruleindex referencedrule");
        this.mOut.println("# 's' Sequence rule: ruleindex childindex min max starttoken endtoken");
        this.mOut.println("# 'c' Choice rule: ruleindex childindex min max starttoken endtoken");
        this.mOut.println("# 'n' Any order rule: ruleindex childindex min max starttoken endtoken");
        this.mOut.println("# 'a' Attribute rule: ruleindex childindex min max uri javatype");
        this.mOut.println("# 'd' Data rule: ruleindex childindex min max");
        this.mOut.println("# 'u' Simple rule: ruleindex childindex min max starttoken endtoken javatype validationfacets");
        this.mOut.println("# 'w' Wildcard rule: ruleindex childindex min max namespace");
        this.mOut.println("# 'v' Validation rule: ruleindex childindex validationfacets");
        EntryMap entrymap = new EntryMap();
        entrymap.put("*", 0);
        this.emitKeyComment("*", 0);
        this.emitChoiceRule(entrymap.get("*", 0), 0, 1, 1, -1, null, -1, null, false);
        this.genNodeRule((OtdWood)this.mOtd.getOtdGrove(), tokenmap, entrymap, reachableTrees);
        this.genRuleRefViaVine((OtdWood)this.mOtd.getOtdGrove(), 0, entrymap, reachableTrees);
        this.genRuleRefForSimpleType((OtdWood)this.mOtd.getOtdGrove(), 0, entrymap, reachableTrees);
        this.generateRuleExtensions(entrymap, reachableTrees);
        this.mOut.close();
        return entrymap;
    }

    private String getNamespaceURI(String id) {
        String elementFormDefault = this.mOrigin.getProperty(id, "elementFormDefault");
        if (elementFormDefault != null && elementFormDefault.equals("qualified")) {
            return this.mOrigin.getProperty(id, "namespaceURI") == null ? "" : this.mOrigin.getProperty(id, "namespaceURI");
        }
        return "";
    }

    private void genNodeRule(OtdWood node, Map tokenmap, EntryMap entrymap, Set reachableTrees) throws Exception {
        String nodeid;
        OtdWoodList woodlist;
        if (node.getType() == 999) {
            woodlist = ((OtdGrove)node).getTrees();
            nodeid = "N";
        } else {
            woodlist = node.getChildren();
            nodeid = node.getId();
        }
        if (node.getType() != 1 && node.getType() != 2 && node.getType() != 999 || woodlist == null) {
            return;
        }
        int childindex = 0;
        int reachableChildIndex = 0;
        Iterator iter = woodlist.iterator();
        while (iter.hasNext()) {
            String value;
            int max;
            OtdVine vine;
            OtdWood childnode;
            OtdWood ref = childnode = (OtdWood)iter.next();
            if (reachableTrees != null && node.getType() == 999) {
                if (!reachableTrees.contains(childnode)) {
                    ++childindex;
                    continue;
                }
            } else {
                reachableChildIndex = childindex;
            }
            ref = GenMeta.resolveFakeTreeReference((OtdMetaContainer)this.mOtd, (OtdWood)ref);
            while (ref.getType() == 4 && !(vine = (OtdVine)ref).isExternalRef()) {
                ref = vine.getRef();
            }
            int min = childnode.isOptional() ? 0 : 1;
            int n = max = childnode.isRepeated() ? -1 : 1;
            if (this.mOrigin != null && childnode != null && childnode.getId() != null && (value = this.mOrigin.getProperty(childnode.getId(), "maxOccurs")) != null && value.length() > 0) {
                try {
                    max = Integer.parseInt(value);
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            int stoken = -1;
            int etoken = -1;
            String sname = null;
            String ename = null;
            switch (ref.getType()) {
                case 1: {
                    String nodeTreeType = this.mOrigin.getProperty(ref.getId(), "treeType");
                    if (nodeTreeType.length() == 0 || nodeTreeType.equals("Element")) {
                        if (!tokenmap.containsKey(ref.getId())) {
                            throw new Exception("tokens needed: " + nodeid + "." + ref.getId());
                        }
                        int[] tokens = (int[])tokenmap.get(ref.getId());
                        stoken = tokens[0];
                        etoken = tokens[1];
                        sname = "{" + this.getNamespaceURI(ref.getId()) + "}" + this.removeQualification(ref.getName());
                        ename = "/{" + this.getNamespaceURI(ref.getId()) + "}" + this.removeQualification(ref.getName());
                        boolean nillable = this.mOrigin.isNillable(childnode.getId());
                        if (nillable && !this.mOrigin.isOptionalNillable(childnode.getId())) {
                            min = 1;
                        }
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        this.emitSequenceRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        entrymap.rememberTreeRuleIndex(ref.getId(), entrymap.get(nodeid, childindex));
                        break;
                    }
                    if (nodeTreeType.equals("ComplexType") || nodeTreeType.equals("Group")) {
                        boolean nillable = false;
                        if (tokenmap.containsKey(childnode.getId())) {
                            int[] tokens = (int[])tokenmap.get(childnode.getId());
                            stoken = tokens[0];
                            etoken = tokens[1];
                            sname = "{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                            ename = "/{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                            nillable = this.mOrigin.isNillable(childnode.getId());
                            if (nillable && !this.mOrigin.isOptionalNillable(childnode.getId())) {
                                min = 1;
                            }
                        }
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        CodeGeneratorUtil.OtdVelocityWrapper wrappedNode = this.mWrapper.wrapNode(ref);
                        if (this.mOrigin.isChoice(ref.getId()) || wrappedNode.isSubstitutionChoice()) {
                            this.emitChoiceRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        } else if (this.mOrigin.isAll(ref.getId())) {
                            this.emitAnyOrderRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        } else {
                            this.emitSequenceRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        }
                        entrymap.rememberTreeRuleIndex(ref.getId(), entrymap.get(nodeid, childindex));
                        break;
                    }
                    if (nodeTreeType.equals("TopComplexTypeElement")) {
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        this.emitSequenceRule(entrymap.get(nodeid, childindex), reachableChildIndex, 1, 1, -1, null, -1, null, false);
                        entrymap.rememberTreeRuleIndex(ref.getId(), entrymap.get(nodeid, childindex));
                        break;
                    }
                    if (!nodeTreeType.equals("SimpleType")) break;
                    entrymap.put(nodeid, childindex);
                    this.emitKeyComment(nodeid, childindex);
                    String vf = this.mOrigin.getProperty(ref.getId(), "validationFacets");
                    this.emitSTValidationRule(entrymap.get(nodeid, childindex), reachableChildIndex, vf);
                    entrymap.rememberTreeRuleIndex(ref.getId(), entrymap.get(nodeid, childindex));
                    break;
                }
                case 2: {
                    boolean nillable = false;
                    if (tokenmap.containsKey(childnode.getId())) {
                        int[] tokens = (int[])tokenmap.get(childnode.getId());
                        stoken = tokens[0];
                        etoken = tokens[1];
                        sname = "{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                        ename = "/{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                        nillable = this.mOrigin.isNillable(childnode.getId());
                        if (nillable && !this.mOrigin.isOptionalNillable(childnode.getId())) {
                            min = 1;
                        }
                    }
                    entrymap.put(nodeid, childindex);
                    this.emitKeyComment(nodeid, childindex);
                    CodeGeneratorUtil.OtdVelocityWrapper wrappedNode = this.mWrapper.wrapNode(ref);
                    if (this.mOrigin.isChoice(ref.getId()) || wrappedNode.isSubstitutionChoice()) {
                        this.emitChoiceRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        break;
                    }
                    if (this.mOrigin.isAll(ref.getId())) {
                        this.emitAnyOrderRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                        break;
                    }
                    this.emitSequenceRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, nillable);
                    break;
                }
                case 3: {
                    if (this.mOrigin.isAny(ref.getId())) {
                        if (this.mOrigin.isAttribute(ref.getId())) break;
                        boolean nillable = this.mOrigin.isNillable(ref.getId());
                        if (nillable && !this.mOrigin.isOptionalNillable(ref.getId())) {
                            min = 1;
                        }
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        this.emitWildcardRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, "##any", nillable);
                        break;
                    }
                    if (this.mOrigin.isAttribute(ref.getId())) {
                        String nsURI = this.mOrigin.getProperty(ref.getId(), "namespaceURI");
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        this.emitAttributeRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, nsURI, this.removeQualification(childnode.getName()), ((OtdLeaf)ref).getJavaType());
                        break;
                    }
                    if (this.mOrigin.isText(ref.getId())) {
                        entrymap.put(nodeid, childindex);
                        this.emitKeyComment(nodeid, childindex);
                        String builtInXsdType = this.mOrigin.getProperty(childnode.getId(), "xsdType");
                        this.emitDataRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, ((OtdLeaf)ref).getJavaType(), builtInXsdType);
                        break;
                    }
                    boolean nillable = false;
                    if (tokenmap.containsKey(childnode.getId())) {
                        int[] tokens = (int[])tokenmap.get(childnode.getId());
                        stoken = tokens[0];
                        etoken = tokens[1];
                        sname = "{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                        ename = "/{" + this.getNamespaceURI(childnode.getId()) + "}" + this.removeQualification(childnode.getName());
                        nillable = this.mOrigin.isNillable(childnode.getId());
                        if (nillable && !this.mOrigin.isOptionalNillable(childnode.getId())) {
                            min = 1;
                        }
                    } else {
                        throw new Exception("tokens needed: " + nodeid + "." + childnode.getId());
                    }
                    String facets = this.mOrigin.getProperty(childnode.getId(), "validationFacets");
                    String builtInXsdType = this.mOrigin.getProperty(childnode.getId(), "xsdType");
                    entrymap.put(nodeid, childindex);
                    this.emitKeyComment(nodeid, childindex);
                    this.emitSimpleRule(entrymap.get(nodeid, childindex), reachableChildIndex, min, max, stoken, sname, etoken, ename, ((OtdLeaf)ref).getJavaType(), facets, nillable, builtInXsdType);
                }
            }
            ++childindex;
            ++reachableChildIndex;
            this.genNodeRule(childnode, tokenmap, entrymap, reachableTrees);
        }
    }

    private void genRuleRefForSimpleType(OtdWood node, int ruleindex, EntryMap entrymap, Set reachableTrees) throws Exception {
        String nodeid;
        OtdWoodList woodlist;
        String simpleTypeRef = this.mOrigin.getProperty(node.getId(), "simpleTypeRef");
        if (simpleTypeRef != null && simpleTypeRef.length() > 0) {
            this.emitRuleRefForSimpleType(ruleindex, entrymap.getTreeRuleIndex(simpleTypeRef));
            return;
        }
        if (node.getType() == 4) {
            OtdVine vine;
            OtdWood ref = node;
            ref = GenMeta.resolveFakeTreeReference((OtdMetaContainer)this.mOtd, (OtdWood)ref);
            while (ref.getType() == 4 && !(vine = (OtdVine)ref).isExternalRef()) {
                ref = vine.getRef();
            }
            woodlist = ref.getChildren();
            nodeid = ref.getId();
        } else if (node.getType() == 999) {
            woodlist = ((OtdGrove)node).getTrees();
            nodeid = "N";
        } else {
            woodlist = node.getChildren();
            nodeid = node.getId();
        }
        if (woodlist == null) {
            return;
        }
        int childindex = 0;
        Iterator iter = woodlist.iterator();
        while (iter.hasNext()) {
            OtdWood childnode = (OtdWood)iter.next();
            if (reachableTrees != null && node.getType() == 999 && !reachableTrees.contains(childnode)) {
                ++childindex;
                continue;
            }
            if (entrymap.contains(nodeid, childindex)) {
                int childrule = entrymap.get(nodeid, childindex);
                if (node.getType() == 1 || node.getType() == 2 || node.getType() == 999 || node.getType() == 3) {
                    this.genRuleRefForSimpleType(childnode, childrule, entrymap, reachableTrees);
                }
            }
            ++childindex;
        }
    }

    private void genRuleRefViaVine(OtdWood node, int ruleindex, EntryMap entrymap, Set reachableTrees) throws Exception {
        String nodeid;
        OtdWoodList woodlist;
        if (node.getType() == 4) {
            OtdVine vine;
            OtdWood ref = node;
            ref = GenMeta.resolveFakeTreeReference((OtdMetaContainer)this.mOtd, (OtdWood)ref);
            while (ref.getType() == 4 && !(vine = (OtdVine)ref).isExternalRef()) {
                ref = vine.getRef();
            }
            woodlist = ref.getChildren();
            nodeid = ref.getId();
        } else if (node.getType() == 999) {
            woodlist = ((OtdGrove)node).getTrees();
            nodeid = "N";
        } else {
            woodlist = node.getChildren();
            nodeid = node.getId();
        }
        if (woodlist == null) {
            return;
        }
        int childindex = 0;
        ArrayList<Integer> childrules = new ArrayList<Integer>();
        Iterator iter = woodlist.iterator();
        while (iter.hasNext()) {
            OtdWood childnode = (OtdWood)iter.next();
            if (reachableTrees != null && node.getType() == 999 && !reachableTrees.contains(childnode)) {
                ++childindex;
                continue;
            }
            if (entrymap.contains(nodeid, childindex)) {
                int childrule = entrymap.get(nodeid, childindex);
                if (node.getType() == 999) {
                    String nodeTreeType = this.mOrigin.getProperty(childnode.getId(), "treeType");
                    if (nodeTreeType.length() == 0 || nodeTreeType.equals("Element")) {
                        childrules.add(new Integer(childrule));
                    }
                } else {
                    childrules.add(new Integer(childrule));
                }
                if (node.getType() == 1 || node.getType() == 2 || node.getType() == 999) {
                    this.genRuleRefViaVine(childnode, childrule, entrymap, reachableTrees);
                }
            }
            ++childindex;
        }
        if (childrules.size() > 0) {
            Integer[] arr = new Integer[childrules.size()];
            childrules.toArray(arr);
            this.emitRuleRefViaVine(ruleindex, arr);
        }
    }

    private void generateRuleExtensions(EntryMap entrymap, Set reachableTrees) throws Exception {
        HashMap extList = this.mOrigin.getExtensionList(this.mOtd.getOtdGrove());
        Map jNameRuleMap = this.getJavaNameRuleMap(entrymap);
        this.generateRuleExtension((OtdWood)this.mOtd.getOtdGrove(), jNameRuleMap, extList, entrymap, reachableTrees);
    }

    private Map getJavaNameRuleMap(EntryMap entrymap) {
        OtdWoodList woodlist = this.mOtd.getOtdGrove().getTrees();
        HashMap extList = this.mOrigin.getExtensionList(this.mOtd.getOtdGrove());
        HashMap<String, Integer> jNameRuleMap = new HashMap<String, Integer>();
        if (woodlist == null || extList == null) {
            return jNameRuleMap;
        }
        int childindex = 0;
        Iterator iter = woodlist.iterator();
        while (iter.hasNext()) {
            OtdWood tree = (OtdWood)iter.next();
            if (!entrymap.contains("N", childindex)) {
                ++childindex;
                continue;
            }
            int ruleid = entrymap.get("N", childindex);
            jNameRuleMap.put(tree.getJavaName(), new Integer(ruleid));
            ++childindex;
        }
        return jNameRuleMap;
    }

    private void generateRuleExtension(OtdWood node, Map jNameRuleMap, Map extList, EntryMap entrymap, Set reachableTrees) throws Exception {
        String nodeid;
        OtdWoodList woodlist;
        if (node.getType() != 1 && node.getType() != 2 && node.getType() != 999) {
            return;
        }
        if (node.getType() == 999) {
            woodlist = ((OtdGrove)node).getTrees();
            nodeid = "N";
        } else {
            woodlist = node.getChildren();
            nodeid = node.getId();
        }
        if (woodlist == null) {
            return;
        }
        int childindex = 0;
        Iterator iter = woodlist.iterator();
        while (iter.hasNext()) {
            OtdVine vine;
            OtdWood childnode = (OtdWood)iter.next();
            if (reachableTrees != null && node.getType() == 999 && !reachableTrees.contains(childnode)) {
                ++childindex;
                continue;
            }
            if (childnode.getType() != 4) {
                this.generateRuleExtension(childnode, jNameRuleMap, extList, entrymap, reachableTrees);
                ++childindex;
                continue;
            }
            OtdWood ref = childnode;
            ref = GenMeta.resolveFakeTreeReference((OtdMetaContainer)this.mOtd, (OtdWood)ref);
            while (ref.getType() == 4 && !(vine = (OtdVine)ref).isExternalRef()) {
                ref = vine.getRef();
            }
            if (!entrymap.contains(nodeid, childindex) || !extList.containsKey(ref.getId())) {
                ++childindex;
                continue;
            }
            int ruleid = entrymap.get(nodeid, childindex);
            Map extNodes = (Map)extList.get(ref.getId());
            if (extNodes.size() <= 0) {
                ++childindex;
                continue;
            }
            String groveId = this.mOtd.getOtdGrove().getId();
            this.mOut.print("y " + ruleid + " " + extNodes.size());
            Iterator iter2 = extNodes.keySet().iterator();
            while (iter2.hasNext()) {
                String qname = (String)iter2.next();
                String jname = (String)extNodes.get(qname);
                String classname = this.mOtd.getPackageName() + "." + jname;
                this.mOut.print(" " + this.quote(this.mOrigin.getElementNS(qname, groveId)));
                this.mOut.print(" " + this.quote(this.mOrigin.getElementLocalName(qname)));
                if (!jNameRuleMap.containsKey(jname)) {
                    throw new Exception("Java name not found in the tree list: " + jname);
                }
                this.mOut.print(" " + jNameRuleMap.get(jname));
                this.mOut.print(" " + this.quote(classname));
            }
            this.mOut.println();
            ++childindex;
        }
    }

    private String removeQualification(String name) {
        if (name == null) {
            return null;
        }
        int i = name.indexOf(58);
        if (i >= 0) {
            return name.substring(i + 1);
        }
        return name;
    }

    public static class EntryMap {
        private final Map mMap = new HashMap();
        private final Map mTreeIdRuleIndexMap = new HashMap();
        private int mEntry = 0;
        public static final String NONE = "N";

        public int count() {
            return this.mEntry;
        }

        public String key(String node, int child) {
            return node + '.' + child;
        }

        public String key(int node, int child) {
            return this.key(Integer.toString(node), child);
        }

        public String put(String node, int child) {
            String key = this.key(node, child);
            if (this.mMap.get(key) != null) {
                throw new IllegalArgumentException("duplicate map key [" + key + "]");
            }
            this.mMap.put(key, new Integer(this.mEntry++));
            return key;
        }

        public int get(String node, int child) {
            String key = this.key(node, child);
            Integer value = (Integer)this.mMap.get(key);
            if (value == null) {
                throw new IllegalArgumentException("key [" + key + "]: no runtime metadata entry");
            }
            return value;
        }

        public boolean contains(String node, int child) {
            String key = this.key(node, child);
            Integer value = (Integer)this.mMap.get(key);
            return value != null;
        }

        public int get(int node, int child) {
            String key = this.key(node, child);
            Integer value = (Integer)this.mMap.get(key);
            if (value == null) {
                throw new IllegalArgumentException("key [" + key + "]: no parsing rule entry");
            }
            return value;
        }

        public void rememberTreeRuleIndex(String nodeId, int ruleIndex) {
            this.mTreeIdRuleIndexMap.put(nodeId, new Integer(ruleIndex));
        }

        public int getTreeRuleIndex(String nodeId) {
            if (!this.mTreeIdRuleIndexMap.containsKey(nodeId)) {
                throw new IllegalArgumentException("No rule index found for node: '" + nodeId + "'");
            }
            return (Integer)this.mTreeIdRuleIndexMap.get(nodeId);
        }
    }
}

