/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.tools.xml.Characters;
import com.stc.otd.tools.xml.EndDocument;
import com.stc.otd.tools.xml.EndElement;
import com.stc.otd.tools.xml.ParseEvent;
import com.stc.otd.tools.xml.ParseException;
import com.stc.otd.tools.xml.StartDocument;
import com.stc.otd.tools.xml.StartElement;
import com.stc.otd.tools.xml.XXLLexerAdapter;
import com.stc.otd.xsd.datatype.Century;
import com.stc.otd.xsd.datatype.Date;
import com.stc.otd.xsd.datatype.Date2001;
import com.stc.otd.xsd.datatype.DateTime;
import com.stc.otd.xsd.datatype.Duration;
import com.stc.otd.xsd.datatype.GDay;
import com.stc.otd.xsd.datatype.GMonth;
import com.stc.otd.xsd.datatype.GMonthDay;
import com.stc.otd.xsd.datatype.GYear;
import com.stc.otd.xsd.datatype.GYearMonth;
import com.stc.otd.xsd.datatype.MimeBase64Decoder;
import com.stc.otd.xsd.datatype.MimeBase64Encoder;
import com.stc.otd.xsd.datatype.Month;
import com.stc.otd.xsd.datatype.RecurringDate;
import com.stc.otd.xsd.datatype.RecurringDay;
import com.stc.otd.xsd.datatype.RecurringDuration;
import com.stc.otd.xsd.datatype.Time;
import com.stc.otd.xsd.datatype.Time2001;
import com.stc.otd.xsd.datatype.TimeDuration;
import com.stc.otd.xsd.datatype.TimeInstant;
import com.stc.otd.xsd.datatype.TimePeriod;
import com.stc.otd.xsd.datatype.Year;
import java.io.StringReader;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.StringTokenizer;
import org.xml.sax.ContentHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class SchemaRuntime {
    private static final char[] B_MAP = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static void main(String[] args) {
        String ulongStr = "18446744073709551615";
        long ulongVal = SchemaRuntime.unmarshalUnsignedLong(ulongStr.toCharArray());
        ulongStr = new String(SchemaRuntime.marshalUnsignedLong(ulongVal));
        System.out.println("18446744073709551615 ulong unmarshal --> " + String.valueOf(ulongVal) + " ulong marshal --> " + ulongStr);
        String uintStr = "4294967295";
        int uintVal = SchemaRuntime.unmarshalUnsignedInt(uintStr.toCharArray());
        uintStr = new String(SchemaRuntime.marshalUnsignedInt(uintVal));
        System.out.println("4294967295 uint unmarshal --> " + String.valueOf(uintVal) + " uint marshal --> " + uintStr);
        String qnameChars = "xsd:integer";
        String qnameStr = SchemaRuntime.unmarshalQName(qnameChars.toCharArray());
        System.out.println(qnameChars + " QName unmarshal --> " + qnameStr);
        String mmChars = "-209801-11";
        Month mm = SchemaRuntime.unmarshalMonth(mmChars.toCharArray());
        System.out.println(mmChars + " Month unmarshal --> " + mm.toString());
        String base64Chars = "WE1MIFNjaGVtYQ==";
        byte[] base64Bytes = SchemaRuntime.unmarshalBase64Binary(base64Chars.toCharArray());
        String base64Str = new String(base64Bytes);
        System.out.println(base64Chars + " unmarshal Binary64 --> " + base64Str);
        char[] base64Enc = SchemaRuntime.marshalBase64Binary(base64Bytes);
        String base64Str2 = new String(base64Enc);
        System.out.println(base64Str + " marshal Binary64 --> " + base64Str2);
    }

    public static void marshalAny(String value, ContentHandler handler, ErrorHandler errorHandler, String schemaInstance) throws SAXException {
        if (value.indexOf(60) >= 0) {
            XXLLexerAdapter lexer = new XXLLexerAdapter();
            lexer.setInputSource(new InputSource(new StringReader(value)), schemaInstance);
            lexer.setAllowMixed(false);
            while (true) {
                ParseEvent p;
                if ((p = lexer.lex()) instanceof StartDocument) {
                    continue;
                }
                if (!(p instanceof EndDocument)) {
                    if (p instanceof ParseException) {
                        ParseException e = (ParseException)p;
                        throw (SAXException)e.exception.fillInStackTrace();
                    }
                    if (p instanceof Characters) {
                        Characters c = (Characters)p;
                        boolean empty = true;
                        for (int i = 0; i < c.chars.length; ++i) {
                            char cc = c.chars[i];
                            if (cc == '\r' || cc == '\n' || cc == '\t' || cc == '\f' || cc == ' ') continue;
                            empty = false;
                            break;
                        }
                        if (empty) continue;
                        handler.characters(c.chars, 0, c.chars.length);
                        continue;
                    }
                    if (p instanceof StartElement) {
                        StartElement se = (StartElement)p;
                        handler.startElement(se.namespaceURI, se.localName, se.qName, se.attributes);
                        continue;
                    }
                    if (!(p instanceof EndElement)) continue;
                    EndElement ee = (EndElement)p;
                    handler.endElement(ee.namespaceURI, ee.localName, ee.qName);
                    continue;
                }
                break;
            }
        } else {
            char[] chs = value.toCharArray();
            handler.characters(chs, 0, chs.length);
        }
    }

    public static void marshalAnySimpleType(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.marshalString(value, handler);
    }

    public static char[] marshalAnyURI(String value) {
        return value.toCharArray();
    }

    public static void marshalAnyURI(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalAnyURI(value));
    }

    public static char[] marshalBinary16(byte[] value) {
        char[] result = new char[value.length * 2];
        int j = 0;
        for (int i = 0; i < value.length; ++i) {
            byte b = value[i];
            result[j++] = SchemaRuntime.byteToHex((byte)((b & 0xF0) >>> 4));
            result[j++] = SchemaRuntime.byteToHex((byte)(b & 0xF));
        }
        return result;
    }

    public static void marshalBinary16(byte[] value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalBinary16(value));
    }

    public static char[] marshalBase64Binary(byte[] value) {
        MimeBase64Encoder encoder = new MimeBase64Encoder();
        char[] in = new char[value.length];
        for (int i = 0; i < value.length; ++i) {
            in[i] = (char)value[i];
        }
        encoder.translate(in);
        return encoder.getCharArray();
    }

    public static void marshalBase64Binary(byte[] value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalBase64Binary(value));
    }

    public static char[] marshalBoolean(boolean value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalBoolean(boolean value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalBoolean(value));
    }

    public static char[] marshalByte(byte value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalByte(byte value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalByte(value));
    }

    public static char[] marshalCDATA(String value) {
        return value.toCharArray();
    }

    public static void marshalCDATA(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalCDATA(value));
    }

    public static char[] marshalCentury(Century value) {
        return value.toString().toCharArray();
    }

    public static void marshalCentury(Century value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalCentury(value));
    }

    public static char[] marshalDate(Date value) {
        return value.toString().toCharArray();
    }

    public static void marshalDate(Date value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDate(value));
    }

    public static char[] marshalDate2001(Date2001 value) {
        return value.toString().toCharArray();
    }

    public static void marshalDate2001(Date2001 value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDate2001(value));
    }

    public static char[] marshalDate2001(com.stc.runtime.dt.Date value) {
        Date2001 dt = new Date2001(value);
        return dt.toString().toCharArray();
    }

    public static void marshalDate2001(com.stc.runtime.dt.Date value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDate2001(value));
    }

    public static char[] marshalDateTime(DateTime value) {
        return value.toString().toCharArray();
    }

    public static char[] marshalDateTime(com.stc.runtime.dt.DateTime value) {
        DateTime dt = new DateTime(value);
        return dt.toString().toCharArray();
    }

    public static void marshalDateTime(DateTime value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDateTime(value));
    }

    public static void marshalDateTime(com.stc.runtime.dt.DateTime value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDateTime(value));
    }

    public static char[] marshalDecimal(BigDecimal value) {
        return value.toString().toCharArray();
    }

    public static void marshalDecimal(BigDecimal value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDecimal(value));
    }

    public static char[] marshalBigDecimal(BigDecimal value) {
        return value.toString().toCharArray();
    }

    public static void marshalBigDecimal(BigDecimal value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDecimal(value));
    }

    public static char[] marshalDouble(double value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalDouble(double value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDouble(value));
    }

    public static char[] marshalDuration(Duration value) {
        return value.toString().toCharArray();
    }

    public static void marshalDuration(Duration value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalDuration(value));
    }

    public static char[] marshalENTITIES(String[] value) {
        String result = "";
        if (value.length > 0) {
            result = new String(SchemaRuntime.marshalENTITY(value[0]));
            for (int i = 1; i < value.length; ++i) {
                result = result + " " + new String(SchemaRuntime.marshalENTITY(value[i]));
            }
        }
        return result.toCharArray();
    }

    public static void marshalENTITIES(String[] value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalENTITIES(value));
    }

    public static char[] marshalENTITY(String value) {
        return SchemaRuntime.marshalNCName(value);
    }

    public static void marshalENTITY(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalENTITY(value));
    }

    public static char[] marshalFloat(float value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalFloat(float value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalFloat(value));
    }

    public static char[] marshalGDay(GDay value) {
        return value.toString().toCharArray();
    }

    public static void marshalGDay(GDay value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalGDay(value));
    }

    public static char[] marshalGMonth(GMonth value) {
        return value.toString().toCharArray();
    }

    public static void marshalGMonth(GMonth value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalGMonth(value));
    }

    public static char[] marshalGMonthDay(GMonthDay value) {
        return value.toString().toCharArray();
    }

    public static void marshalGMonthDay(GMonthDay value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalGMonthDay(value));
    }

    public static char[] marshalGYear(GYear value) {
        return value.toString().toCharArray();
    }

    public static void marshalGYear(GYear value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalGYear(value));
    }

    public static char[] marshalGYearMonth(GYearMonth value) {
        return value.toString().toCharArray();
    }

    public static void marshalGYearMonth(GYearMonth value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalGYearMonth(value));
    }

    public static char[] marshalID(String value) {
        return SchemaRuntime.marshalNCName(value);
    }

    public static void marshalID(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalID(value));
    }

    public static char[] marshalIDREF(String value) {
        return SchemaRuntime.marshalNCName(value);
    }

    public static void marshalIDREF(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalIDREF(value));
    }

    public static char[] marshalIDREFS(String[] value) {
        String result = "";
        if (value.length > 0) {
            result = new String(SchemaRuntime.marshalIDREF(value[0]));
            for (int i = 1; i < value.length; ++i) {
                result = result + " " + new String(SchemaRuntime.marshalIDREF(value[i]));
            }
        }
        return result.toCharArray();
    }

    public static char[] marshalIDREFS(String value) {
        String result = "";
        StringTokenizer st = new StringTokenizer(value);
        while (st.hasMoreTokens()) {
            result = result + new String(SchemaRuntime.marshalIDREF(st.nextToken()));
            if (!st.hasMoreTokens()) continue;
            result = result + " ";
        }
        return result.toCharArray();
    }

    public static void marshalIDREFS(String[] value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalIDREFS(value));
    }

    public static void marshalIDREFS(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalIDREFS(value));
    }

    public static char[] marshalInt(int value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalInt(int value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalInt(value));
    }

    public static char[] marshalInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalInteger(value));
    }

    public static char[] marshalBigInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalBigInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalInteger(value));
    }

    public static char[] marshalLanguage(String value) {
        return value.toCharArray();
    }

    public static void marshalLanguage(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalLanguage(value));
    }

    public static char[] marshalLong(long value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalLong(long value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalLong(value));
    }

    public static char[] marshalMonth(Month value) {
        return value.toString().toCharArray();
    }

    public static void marshalMonth(Month value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalMonth(value));
    }

    public static char[] marshalNCName(String value) {
        return value.toCharArray();
    }

    public static void marshalNCName(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNCName(value));
    }

    public static char[] marshalNMTOKEN(String value) {
        return value.toCharArray();
    }

    public static void marshalNMTOKEN(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNMTOKEN(value));
    }

    public static char[] marshalNMTOKENS(String[] value) {
        String result = "";
        if (value.length > 0) {
            result = new String(SchemaRuntime.marshalNMTOKEN(value[0]));
            for (int i = 1; i < value.length; ++i) {
                result = result + " " + new String(SchemaRuntime.marshalNMTOKEN(value[i]));
            }
        }
        return result.toCharArray();
    }

    public static char[] marshalNOTATION(String value) {
        return SchemaRuntime.marshalQName(value);
    }

    public static void marshalNOTATION(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNOTATION(value));
    }

    public static char[] marshalName(String value) {
        return value.toCharArray();
    }

    public static void marshalName(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalName(value));
    }

    public static char[] marshalNegativeInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalNegativeInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNegativeInteger(value));
    }

    public static char[] marshalNonNegativeInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalNonNegativeInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNonNegativeInteger(value));
    }

    public static char[] marshalNonPositiveInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalNonPositiveInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNonPositiveInteger(value));
    }

    public static char[] marshalNormalizedString(String value) {
        return value.toCharArray();
    }

    public static void marshalNormalizedString(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalNormalizedString(value));
    }

    public static char[] marshalPositiveInteger(BigInteger value) {
        return value.toString().toCharArray();
    }

    public static void marshalPositiveInteger(BigInteger value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalPositiveInteger(value));
    }

    public static char[] marshalQName(String value) {
        return value.toCharArray();
    }

    public static void marshalQName(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalQName(value));
    }

    public static char[] marshalRecurringDate(RecurringDate value) {
        return value.toString().toCharArray();
    }

    public static void marshalRecurringDate(RecurringDate value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalRecurringDate(value));
    }

    public static char[] marshalRecurringDay(RecurringDay value) {
        return value.toString().toCharArray();
    }

    public static void marshalRecurringDay(RecurringDay value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalRecurringDay(value));
    }

    public static char[] marshalRecurringDuration(RecurringDuration value) {
        return value.toString().toCharArray();
    }

    public static void marshalRecurringDuration(RecurringDuration value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalRecurringDuration(value));
    }

    public static char[] marshalShort(short value) {
        return String.valueOf(value).toCharArray();
    }

    public static void marshalShort(short value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalShort(value));
    }

    public static char[] marshalString(String value) {
        return value.toCharArray();
    }

    public static void marshalString(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, value.toCharArray());
    }

    public static char[] marshalTime(Time value) {
        return value.toString().toCharArray();
    }

    public static void marshalTime(Time value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalTime(value));
    }

    public static char[] marshalTime2001(Time2001 value) {
        return value.toString().toCharArray();
    }

    public static void marshalTime2001(Time2001 value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalTime2001(value));
    }

    public static char[] marshalTimeDuration(TimeDuration value) {
        return value.toString().toCharArray();
    }

    public static void marshalTimeDuration(TimeDuration value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalTimeDuration(value));
    }

    public static char[] marshalTimeInstant(TimeInstant value) {
        return value.toString().toCharArray();
    }

    public static void marshalTimeInstant(TimeInstant value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalTimeInstant(value));
    }

    public static char[] marshalTimePeriod(TimePeriod value) {
        return value.toString().toCharArray();
    }

    public static void marshalTimePeriod(TimePeriod value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalTimePeriod(value));
    }

    public static char[] marshalToken(String value) {
        return value.toCharArray();
    }

    public static void marshalToken(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalToken(value));
    }

    public static char[] marshalUnsignedByte(byte value) {
        short s = value;
        return String.valueOf(s).toString().toCharArray();
    }

    public static void marshalUnsignedByte(byte value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalUnsignedByte(value));
    }

    public static char[] marshalUnsignedInt(int value) {
        if (value > -1) {
            return String.valueOf(value).toCharArray();
        }
        return String.valueOf(0x100000000L + (long)value).toCharArray();
    }

    public static void marshalUnsignedInt(int value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalUnsignedInt(value));
    }

    public static char[] marshalUnsignedLong(long value) {
        BigInteger ul = new BigInteger("18446744073709551615");
        if (value > ul.longValue()) {
            return String.valueOf(value).toCharArray();
        }
        BigInteger ul1 = BigInteger.valueOf(value);
        BigInteger ul2 = new BigInteger("18446744073709551616");
        return ul2.add(ul1).toString().toCharArray();
    }

    public static void marshalUnsignedLong(long value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalUnsignedLong(value));
    }

    public static char[] marshalUnsignedShort(short value) {
        short i = value;
        return String.valueOf(i).toCharArray();
    }

    public static void marshalUnsignedShort(short value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalLong(value));
    }

    public static char[] marshalUriReference(String value) {
        return value.toCharArray();
    }

    public static void marshalUriReference(String value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalUriReference(value));
    }

    public static char[] marshalYear(Year value) {
        return value.toString().toCharArray();
    }

    public static void marshalYear(Year value, ContentHandler handler) throws SAXException {
        SchemaRuntime.characters(handler, SchemaRuntime.marshalYear(value));
    }

    public static String unmarshalAnySimpleType(char[] value) {
        return SchemaRuntime.unmarshalString(value);
    }

    public static byte[] unmarshalBinary16(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing binary hex value");
        }
        if (value.length % 2 != 0) {
            throw new UnmarshalException("There must be an even number of chars in " + new String(value));
        }
        int idx = 0;
        int i = 0;
        byte[] result = new byte[value.length / 2];
        while (idx < value.length) {
            result[i++] = (byte)(SchemaRuntime.hexToByte(value[idx++]) << 4 | SchemaRuntime.hexToByte(value[idx++]));
        }
        return result;
    }

    public static byte[] unmarshalBase64Binary(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing binary base64 value");
        }
        if (value.length == 0) {
            return new byte[0];
        }
        MimeBase64Decoder decoder = new MimeBase64Decoder();
        decoder.translate(value, 0, value.length);
        return decoder.getByteArray();
    }

    public static boolean unmarshalBoolean(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing boolean value");
        }
        String str = new String(value).trim();
        if (str.equals("true") || str.equals("1")) {
            return true;
        }
        if (str.equals("false") || str.equals("0")) {
            return false;
        }
        throw new UnmarshalException("Boolean value true/false expected; got " + str);
    }

    public static byte unmarshalByte(char[] value) {
        short result = SchemaRuntime.unmarshalShort(value);
        if (result <= 127 && result >= -128) {
            return (byte)result;
        }
        throw new UnmarshalException(value.toString() + " does not represent a byte");
    }

    public static String unmarshalCDATA(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing CDATA value");
        }
        String result = new String(value);
        for (int i = 0; i < value.length; ++i) {
            char ch = value[i];
            if (ch >= ' ' && ch <= '\ud7ff' || ch == '\t' || ch == '\n' || ch == '\r' || ch >= '\ue000' && ch <= '\ufffd' || ch >= '\u10000' && ch <= '\u10ffff') continue;
            throw new UnmarshalException("Invalid CDATA: " + result);
        }
        return result;
    }

    public static Century unmarshalCentury(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Century value");
        }
        return Century.parseCentury(value);
    }

    public static Date unmarshalDate(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Date value");
        }
        return Date.parseDate(value);
    }

    public static Date2001 unmarshalDate2001(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return Date2001.parse(str);
    }

    public static DateTime unmarshalDateTime(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing dateTime value");
        }
        String str = new String(value, 0, value.length).trim();
        return DateTime.parse(str);
    }

    public static BigDecimal unmarshalDecimal(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing decimal value");
        }
        String str = new String(value).trim();
        try {
            BigDecimal bd = new BigDecimal(str);
            return bd;
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException("Invalid decimal value: " + str);
        }
    }

    public static BigDecimal unmarshalBigDecimal(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing big decimal value");
        }
        String str = new String(value).trim();
        try {
            BigDecimal bd = new BigDecimal(str);
            return bd;
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException("Invalid big decimal value: " + str);
        }
    }

    public static BigInteger unmarshalBigInteger(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing big integer value");
        }
        String str = new String(value).trim();
        try {
            BigInteger bi = new BigInteger(str);
            return bi;
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException("Invalid big integer value: " + str);
        }
    }

    public static double unmarshalDouble(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing double value");
        }
        String str = new String(value).trim();
        if (str.equals("INF")) {
            return Double.POSITIVE_INFINITY;
        }
        if (str.equals("-INF")) {
            return Double.NEGATIVE_INFINITY;
        }
        if (str.equals("NaN")) {
            return Double.NaN;
        }
        try {
            Double d = new Double(str);
            return d;
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException("Invalid double value: " + str);
        }
    }

    public static Duration unmarshalDuration(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Duration value");
        }
        String str = new String(value, 0, value.length).trim();
        return Duration.parse(str);
    }

    public static String[] unmarshalENTITIES(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing ENTITIES value");
        }
        String str = new String(value);
        StringTokenizer st = new StringTokenizer(str);
        int num = st.countTokens();
        String[] strs = new String[num];
        int i = 0;
        while (st.hasMoreTokens()) {
            strs[i++] = SchemaRuntime.unmarshalENTITY(st.nextToken().toCharArray());
        }
        return strs;
    }

    public static String unmarshalENTITY(char[] value) {
        return SchemaRuntime.unmarshalNCName(value);
    }

    public static float unmarshalFloat(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing float value");
        }
        String str = new String(value).trim();
        if (str.equals("INF")) {
            return Float.POSITIVE_INFINITY;
        }
        if (str.equals("-INF")) {
            return Float.NEGATIVE_INFINITY;
        }
        if (str.equals("NaN")) {
            return Float.NaN;
        }
        try {
            Float f = new Float(str);
            return f.floatValue();
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException("Invalid float value: " + str);
        }
    }

    public static GDay unmarshalGDay(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return GDay.parse(str);
    }

    public static GMonth unmarshalGMonth(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return GMonth.parse(str);
    }

    public static GMonthDay unmarshalGMonthDay(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return GMonthDay.parse(str);
    }

    public static GYear unmarshalGYear(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return GYear.parse(str);
    }

    public static GYearMonth unmarshalGYearMonth(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return GYearMonth.parse(str);
    }

    public static String unmarshalID(char[] value) {
        return SchemaRuntime.unmarshalNCName(value);
    }

    public static String unmarshalIDREF(char[] value) {
        return SchemaRuntime.unmarshalNCName(value);
    }

    public static String unmarshalIDREFS(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing IDREFS value");
        }
        String str = new String(value);
        StringTokenizer st = new StringTokenizer(str);
        String result = "";
        while (st.hasMoreTokens()) {
            result = result + SchemaRuntime.unmarshalIDREF(st.nextToken().toCharArray());
            if (!st.hasMoreTokens()) continue;
            result = result + " ";
        }
        return result;
    }

    public static int unmarshalInt(char[] value) {
        try {
            long result = SchemaRuntime.unmarshalLong(value);
            if (result <= Integer.MAX_VALUE && result >= Integer.MIN_VALUE) {
                return (int)result;
            }
            throw new UnmarshalException(new String(value) + " does not represent an int");
        }
        catch (UnmarshalException e) {
            throw new UnmarshalException(new String(value) + " does not represent an int");
        }
    }

    public static BigInteger unmarshalInteger(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing integer value");
        }
        try {
            BigInteger big = new BigInteger(new String(value).trim());
            return big;
        }
        catch (NumberFormatException e) {
            throw new UnmarshalException(new String(value) + " does not represent an integer");
        }
    }

    public static String unmarshalLanguage(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing language value");
        }
        String langs = "en en-us en-gb fr de it da el";
        String lang = new String(value);
        if (langs.indexOf(lang.toLowerCase()) == -1) {
            throw new UnmarshalException("Invalid language: " + lang);
        }
        return lang;
    }

    public static long unmarshalLong(char[] value) {
        try {
            BigInteger big = SchemaRuntime.unmarshalInteger(value);
            if (big.compareTo(new BigInteger("9223372036854775807")) <= 0 && big.compareTo(new BigInteger("-9223372036854775808")) >= 0) {
                return big.longValue();
            }
            throw new UnmarshalException(value.toString() + " does not represent a long");
        }
        catch (UnmarshalException e) {
            throw new UnmarshalException(value.toString() + " does not represent a long");
        }
    }

    public static Month unmarshalMonth(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Month value");
        }
        return Month.parseMonth(value);
    }

    public static String unmarshalNCName(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing NCName value");
        }
        String result = new String(value);
        return result;
    }

    public static String unmarshalNMTOKEN(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing NMTOKEN value");
        }
        String result = new String(value);
        return new String(value);
    }

    public static String[] unmarshalNMTOKENS(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing NMTOKENS value");
        }
        String str = new String(value);
        StringTokenizer st = new StringTokenizer(str);
        int num = st.countTokens();
        String[] strs = new String[num];
        int i = 0;
        while (st.hasMoreTokens()) {
            strs[i++] = new String(SchemaRuntime.unmarshalNMTOKEN(st.nextToken().toCharArray()));
        }
        return strs;
    }

    public static String unmarshalNOTATION(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing NOTATION value");
        }
        return SchemaRuntime.unmarshalQName(value);
    }

    public static String unmarshalName(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Name value");
        }
        String result = new String(value);
        return result;
    }

    public static BigInteger unmarshalNegativeInteger(char[] value) {
        BigInteger big = SchemaRuntime.unmarshalInteger(value);
        if (big.compareTo(BigInteger.ZERO) < 0) {
            return big;
        }
        throw new UnmarshalException(value.toString() + " does not represent a negative integer");
    }

    public static BigInteger unmarshalNonNegativeInteger(char[] value) {
        BigInteger big = SchemaRuntime.unmarshalInteger(value);
        if (big.compareTo(BigInteger.ZERO) >= 0) {
            return big;
        }
        throw new UnmarshalException(value.toString() + " does not represent a non-negative integer");
    }

    public static BigInteger unmarshalNonPositiveInteger(char[] value) {
        try {
            BigInteger big = SchemaRuntime.unmarshalInteger(value);
            if (big.compareTo(BigInteger.ZERO) <= 0) {
                return big;
            }
            throw new UnmarshalException(value.toString() + " does not represent a non-positive integer");
        }
        catch (UnmarshalException e) {
            throw new UnmarshalException(value.toString() + " does not represent a non-positive integer");
        }
    }

    public static String unmarshalNormalizedString(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing normalizedString value");
        }
        String result = new String(value);
        for (int i = 0; i < value.length; ++i) {
            char ch = value[i];
            if (ch != '\t' && ch != '\n' && ch != '\r') continue;
            throw new UnmarshalException("Invalid normalizedString: " + result);
        }
        return result;
    }

    public static BigInteger unmarshalPositiveInteger(char[] value) {
        BigInteger big = SchemaRuntime.unmarshalInteger(value);
        if (big.compareTo(BigInteger.ZERO) > 0) {
            return big;
        }
        throw new UnmarshalException(value.toString() + " does not represent a positive integer");
    }

    public static String unmarshalQName(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing QName value");
        }
        String result = new String(value);
        int colonLoc = result.indexOf(":");
        boolean isValid = true;
        if (!isValid) {
            throw new UnmarshalException("Invalid QName: " + result);
        }
        return result;
    }

    public static RecurringDate unmarshalRecurringDate(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing RecurringDate value");
        }
        return RecurringDate.parseRecurringDate(value);
    }

    public static RecurringDay unmarshalRecurringDay(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing RecurringDay value");
        }
        return RecurringDay.parseRecurringDay(value);
    }

    public static RecurringDuration unmarshalRecurringDuration(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing RecurringDuration value");
        }
        return RecurringDuration.parse(value);
    }

    public static short unmarshalShort(char[] value) {
        int result = SchemaRuntime.unmarshalInt(value);
        if (result <= Short.MAX_VALUE && result >= Short.MIN_VALUE) {
            return (short)result;
        }
        throw new UnmarshalException(value.toString() + " does not represent a short");
    }

    public static String unmarshalString(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing string value");
        }
        return new String(value);
    }

    public static Time unmarshalTime(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Time value");
        }
        return Time.parseTime(value);
    }

    public static Time2001 unmarshalTime2001(char[] value) {
        String str = new String(value, 0, value.length).trim();
        return Time2001.parse(str);
    }

    public static TimeDuration unmarshalTimeDuration(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing TimeDuration value");
        }
        return TimeDuration.parse(value);
    }

    public static TimeInstant unmarshalTimeInstant(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing TimeInstant value");
        }
        return TimeInstant.parseTimeInstant(value);
    }

    public static TimePeriod unmarshalTimePeriod(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing TimePeriod value");
        }
        return TimePeriod.parseTimePeriod(value);
    }

    public static String unmarshalToken(char[] value) {
        if (value == null) {
            throw new UnmarshalException("Missing token value");
        }
        String str = new String(value);
        if (str.charAt(0) != ' ' && !str.endsWith(" ") && str.indexOf(9) == -1 && str.indexOf(10) == -1 && str.indexOf("  ") == -1) {
            return str;
        }
        throw new UnmarshalException("Invalid token: " + str);
    }

    public static byte unmarshalUnsignedByte(char[] value) {
        short result = SchemaRuntime.unmarshalUnsignedShort(value);
        if (result <= 255) {
            return (byte)result;
        }
        throw new UnmarshalException(value.toString() + " does not represent an unsigned byte");
    }

    public static int unmarshalUnsignedInt(char[] value) {
        long result = SchemaRuntime.unmarshalLong(value);
        if (result >= 0L && result <= 0xFFFFFFFFL) {
            return (int)result;
        }
        throw new UnmarshalException(value.toString() + " does not represent an unsigned int");
    }

    public static long unmarshalUnsignedLong(char[] value) {
        BigInteger big = SchemaRuntime.unmarshalNonNegativeInteger(value);
        if (big.compareTo(new BigInteger("18446744073709551615")) <= 0) {
            return big.longValue();
        }
        throw new UnmarshalException(value.toString() + " does not represent an unsigned long");
    }

    public static short unmarshalUnsignedShort(char[] value) {
        int result = SchemaRuntime.unmarshalUnsignedInt(value);
        if (result <= 65535) {
            return (short)result;
        }
        throw new UnmarshalException(value.toString() + " does not represent an unsigned short");
    }

    public static String unmarshalUriReference(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing UriReference value");
        }
        return new String(value);
    }

    public static Year unmarshalYear(char[] value) {
        if (value == null || value.length == 0) {
            throw new UnmarshalException("Missing Year value");
        }
        return Year.parseYear(value);
    }

    private static char byteToHex(byte b) {
        if (b < 0 || b > 15) {
            throw new MarshalException("Invalid hex byte " + b);
        }
        return B_MAP[b];
    }

    private static void characters(ContentHandler handler, char[] ch) throws SAXException {
        handler.characters(ch, 0, ch.length);
    }

    private static char hexToByte(char ch) {
        switch (ch) {
            case '0': {
                return '\u0000';
            }
            case '1': {
                return '\u0001';
            }
            case '2': {
                return '\u0002';
            }
            case '3': {
                return '\u0003';
            }
            case '4': {
                return '\u0004';
            }
            case '5': {
                return '\u0005';
            }
            case '6': {
                return '\u0006';
            }
            case '7': {
                return '\u0007';
            }
            case '8': {
                return '\b';
            }
            case '9': {
                return '\t';
            }
            case 'A': 
            case 'a': {
                return '\n';
            }
            case 'B': 
            case 'b': {
                return '\u000b';
            }
            case 'C': 
            case 'c': {
                return '\f';
            }
            case 'D': 
            case 'd': {
                return '\r';
            }
            case 'E': 
            case 'e': {
                return '\u000e';
            }
            case 'F': 
            case 'f': {
                return '\u000f';
            }
        }
        throw new UnmarshalException("Invalid hex digit '" + ch + "'");
    }
}

