/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.xsd.codegen.XsdCodeGeneratorUtil;
import com.stc.otd.xsd.codegen.XsdOriginVelocityWrapper;
import com.stc.util.UnicodeFile;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TokenGeneratorTask {
    private OtdMetaContainer mOtd = null;
    private File mWorkingDir;
    private VelocityEngine mEngine;
    private VelocityContext mVC;

    private String quote(String s) {
        if (s == null || s.length() == 0) {
            return "-";
        }
        return '\"' + s + '\"';
    }

    public Map generate(OtdMetaContainer otd, File packageDir, VelocityEngine ve, VelocityContext vc) throws Exception {
        this.mWorkingDir = packageDir;
        this.mEngine = ve;
        this.mVC = vc;
        this.mOtd = otd;
        this.generateTokenCode();
        return this.generateTokenMap();
    }

    private void generateTokenCode() throws Exception {
        String pkgName;
        NodeWrapper wrapper = XsdCodeGeneratorUtil.getNodeWrapper();
        OutputStreamWriter mOut = UnicodeFile.makeOutputWriter((File)new File(this.mWorkingDir, wrapper.wrapNode((OtdWood)this.mOtd.getOtdGrove()).getJavaName() + "ParserToken.java"));
        if (!this.mVC.containsKey((Object)"otdPackageName")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackageName", (Object)pkgName);
        }
        if (!this.mVC.containsKey((Object)"otdPackagePath")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackagePath", (Object)pkgName.replace('.', '/'));
        }
        System.out.println("Generating Token.java code from OTD - " + this.mOtd.getOtdGrove().getName());
        Template t = this.mEngine.getTemplate("com/stc/otd/xsd/codegen/templates/token.vm");
        t.merge((Context)this.mVC, (Writer)mOut);
        mOut.close();
        t = null;
    }

    private Map generateTokenMap() throws Exception {
        System.out.println("Generating token.meta from OTD - " + this.mOtd.getOtdGrove().getName());
        OutputStreamWriter osw = UnicodeFile.makeOutputWriter((File)new File(this.mWorkingDir, "token.meta"));
        PrintWriter mOut = new PrintWriter(osw);
        Collection nodelist = this.mVC.containsKey((Object)"otdList") ? (Collection)this.mVC.get("otdList") : XsdCodeGeneratorUtil.createReachableOtdWrapperList(this.mOtd);
        if (!this.mVC.containsKey((Object)"mReverseNameSpaces")) {
            mOut.close();
            throw new Exception("No namespace uri to prefix map.");
        }
        Hashtable mapUri2Prefix = (Hashtable)this.mVC.get("mReverseNameSpaces");
        mOut.println("# This is a generated file that describes the mapping from token");
        mOut.println("# names to token integer values");
        mOut.println("# 'n' mapping from namespace URI to namespace prefix");
        mOut.println("# 's' mapping from start token name to token integer value");
        mOut.println("# 'e' mapping from end token name to token integer value");
        Iterator iter = mapUri2Prefix.keySet().iterator();
        while (iter.hasNext()) {
            String uri = (String)iter.next();
            mOut.println("n " + this.quote(uri) + " " + this.quote((String)mapUri2Prefix.get(uri)));
        }
        XsdOriginVelocityWrapper origin = new XsdOriginVelocityWrapper(this.mOtd.getOtdOrigin());
        int token = 1;
        HashMap<String, int[]> tokenmap = new HashMap<String, int[]>();
        HashMap<String, Integer> tokenKeyMap = new HashMap<String, Integer>();
        Iterator iter2 = nodelist.iterator();
        while (iter2.hasNext()) {
            int end;
            int start;
            CodeGeneratorUtil.OtdVelocityWrapper node = (CodeGeneratorUtil.OtdVelocityWrapper)iter2.next();
            String nodeName = node.getNQActualName();
            String tokenName = node.getName();
            String treeType = origin.getProperty(node.getId(), "treeType");
            String refType = origin.getProperty(node.getId(), "refType");
            if (node.getRef() != null && origin.getProperty(node.getRef().getId(), "treeType").equals("TopComplexTypeElement")) {
                refType = "ComplexType";
            }
            String nsURI = origin.getProperty(node.getId(), "namespaceURI");
            String elementFormDefault = origin.getProperty(node.getId(), "elementFormDefault");
            String nodeTag = nodeName;
            String prefix = (String)mapUri2Prefix.get(nsURI);
            if (prefix == null) {
                prefix = "";
            }
            if (elementFormDefault.equals("qualified") && prefix.length() > 0) {
                nodeTag = prefix + ":" + nodeName;
            }
            if (node.getNodeType() == 999 || node.isInline() || node.isSubstitutionChoice() || origin.isAttribute(node.getId()) || origin.isText(node.getId()) || origin.isAny(node.getId()) || treeType.equals("ComplexType") || treeType.equals("SimpleType") || treeType.equals("Group") || node.getNodeType() == 4 && (node.getNodeType() != 4 || !refType.equals("ComplexType"))) continue;
            if (tokenKeyMap.containsKey("s." + nodeTag)) {
                start = (Integer)tokenKeyMap.get("s." + nodeTag);
            } else {
                start = token++;
                tokenKeyMap.put("s." + nodeTag, new Integer(start));
                mOut.println("s " + this.quote(nodeTag) + " " + start);
            }
            if (tokenKeyMap.containsKey("e." + nodeTag)) {
                end = (Integer)tokenKeyMap.get("e." + nodeTag);
            } else {
                end = token++;
                tokenKeyMap.put("e." + nodeTag, new Integer(end));
                mOut.println("e " + this.quote(nodeTag) + " " + end);
            }
            tokenmap.put(node.getId(), new int[]{start, end});
        }
        mOut.close();
        return tokenmap;
    }
}

