/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.xsd.codegen.XsdCodeGeneratorUtil;
import com.stc.util.UnicodeFile;
import java.io.File;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.apache.velocity.context.Context;

public class TokenStreamGeneratorTask {
    private OtdMetaContainer mOtd = null;
    private File mWorkingDir;
    private VelocityEngine mEngine;
    private VelocityContext mVC;

    public void generate(OtdMetaContainer otd, File packageDir, VelocityEngine ve, VelocityContext vc) throws Exception {
        this.mWorkingDir = packageDir;
        this.mEngine = ve;
        this.mVC = vc;
        this.mOtd = otd;
        this.generateTokenStreamCode();
    }

    private void generateTokenStreamCode() throws Exception {
        String pkgName;
        NodeWrapper wrapper = XsdCodeGeneratorUtil.getNodeWrapper();
        OutputStreamWriter mOut = UnicodeFile.makeOutputWriter((File)new File(this.mWorkingDir, wrapper.wrapNode((OtdWood)this.mOtd.getOtdGrove()).getJavaName() + "ParserTokenStream.java"));
        if (!this.mVC.containsKey((Object)"otdPackageName")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackageName", (Object)pkgName);
        }
        if (!this.mVC.containsKey((Object)"otdPackagePath")) {
            pkgName = this.mOtd.getPackageName();
            this.mVC.put("otdPackagePath", (Object)pkgName.replace('.', '/'));
        }
        System.out.println("Generating TokenStream.java code from OTD - " + this.mOtd.getOtdGrove().getName());
        Template t = this.mEngine.getTemplate("com/stc/otd/xsd/codegen/templates/token_stream.vm");
        t.merge((Context)this.mVC, (Writer)mOut);
        mOut.close();
        t = null;
    }
}

