/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.codegen.OriginVelocityWrapper;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdStem;
import com.stc.otd.forest.OtdTree;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import com.stc.otd.forest.provider.OtdIterator;
import com.stc.otd.xsd.datatype.Date2001;
import com.stc.otd.xsd.datatype.DateTime;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class XsdCodeGeneratorUtil
extends CodeGeneratorUtil {
    public static boolean isDate2001Constant(String defaultValue) {
        if (defaultValue == null) {
            return false;
        }
        String v = defaultValue.trim();
        if (v.length() <= 0) {
            return false;
        }
        try {
            Date2001.parse(defaultValue);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isDateTimeConstant(String defaultValue) {
        if (defaultValue == null) {
            return false;
        }
        String v = defaultValue.trim();
        if (v.length() <= 0) {
            return false;
        }
        try {
            DateTime.parse(defaultValue);
            return true;
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static HashMap getExtensionList(OtdMetaContainer otd) {
        HashMap<String, HashSet<OtdWood>> list = null;
        if (otd == null) {
            return list;
        }
        OriginVelocityWrapper ovw = new OriginVelocityWrapper(otd.getOtdOrigin());
        list = new HashMap<String, HashSet<OtdWood>>();
        OtdIterator iter = new OtdIterator((OtdWood)otd.getOtdGrove(), true);
        while (iter.hasNext()) {
            OtdWood node = (OtdWood)iter.next();
            if (node.getType() != 1) continue;
            String baseId = ovw.getProperty(node.getId(), "extBaseType");
            while (baseId != null && !baseId.equals("")) {
                HashSet<OtdWood> set = (HashSet<OtdWood>)list.get(baseId);
                if (set == null) {
                    set = new HashSet<OtdWood>();
                }
                set.add(node);
                list.put(baseId, set);
                baseId = ovw.getProperty(baseId, "extBaseType");
            }
        }
        return list;
    }

    public static void reach(OtdWood node, Set done, Set todo, Map extensionList, OriginVelocityWrapper ovw, OtdGrove grove, Set doneNames) {
        if (node != null) {
            switch (node.getType()) {
                case 1: 
                case 2: {
                    OtdWood basenode;
                    String baseId;
                    OtdWoodList kids = node.getChildren();
                    int i = kids.size();
                    while (i-- > 0) {
                        XsdCodeGeneratorUtil.reach(kids.getOtdWood(i), done, todo, extensionList, ovw, grove, doneNames);
                    }
                    if (node.getType() == 1 && extensionList.containsKey(node.getId())) {
                        Iterator iter = ((Set)extensionList.get(node.getId())).iterator();
                        while (iter.hasNext()) {
                            OtdWood todonode = (OtdWood)iter.next();
                            if (doneNames.contains(todonode.getJavaName())) continue;
                            doneNames.add(todonode.getJavaName());
                            todo.add(todonode);
                        }
                    }
                    if ((baseId = ovw.getProperty(node.getId(), "extBaseType")) == null || baseId.equals("") || (basenode = grove.getChild(baseId)) == null || doneNames.contains(basenode.getJavaName())) break;
                    doneNames.add(basenode.getJavaName());
                    todo.add(basenode);
                    break;
                }
                case 4: 
                case 7: {
                    OtdTree tree = ((OtdStem)node).getRef();
                    if (tree == null || doneNames.contains(tree.getJavaName())) break;
                    doneNames.add(tree.getJavaName());
                    todo.add(tree);
                    break;
                }
                case 3: {
                    OtdWood basenode;
                    String simpleTypeRefId = ovw.getProperty(node.getId(), "simpleTypeRef");
                    if (simpleTypeRefId == null || simpleTypeRefId.equals("") || (basenode = grove.getChild(simpleTypeRefId)) == null || doneNames.contains(basenode.getJavaName())) break;
                    doneNames.add(basenode.getJavaName());
                    todo.add(basenode);
                }
            }
        }
    }

    public static Set reachable(OtdMetaContainer otd, Map extensionList) {
        HashSet<OtdTree> done = new HashSet<OtdTree>();
        HashSet<OtdTree> todo = new HashSet<OtdTree>();
        HashSet<String> doneNames = new HashSet<String>();
        OriginVelocityWrapper ovw = new OriginVelocityWrapper(otd.getOtdOrigin());
        OtdWoodList trees = otd.getTopTrees();
        if (trees == null) {
            return done;
        }
        int i = trees.size();
        while (i-- > 0) {
            OtdTree tree = (OtdTree)trees.getOtdWood(i);
            if (!tree.isTop()) continue;
            doneNames.add(tree.getJavaName());
            todo.add(tree);
        }
        while (todo.size() > 0) {
            HashSet<OtdTree> loop = todo;
            todo = new HashSet();
            Iterator iter = loop.iterator();
            while (iter.hasNext()) {
                OtdTree tree = (OtdTree)iter.next();
                done.add(tree);
                XsdCodeGeneratorUtil.reach((OtdWood)tree, done, todo, extensionList, ovw, otd.getOtdGrove(), doneNames);
            }
        }
        System.out.println("Trees used:");
        Iterator iter = done.iterator();
        while (iter.hasNext()) {
            System.out.println(" " + ((OtdTree)iter.next()).getId());
        }
        return done;
    }

    public static Set reachable(OtdMetaContainer otd) {
        return XsdCodeGeneratorUtil.reachable(otd, XsdCodeGeneratorUtil.getExtensionList(otd));
    }

    public static Set createReachableOtdWrapperList(OtdMetaContainer otd) {
        Set treeset = XsdCodeGeneratorUtil.reachable(otd, XsdCodeGeneratorUtil.getExtensionList(otd));
        return XsdCodeGeneratorUtil.createReachableOtdWrapperList(otd, treeset);
    }

    public static Set createReachableOtdWrapperList(OtdMetaContainer otd, Set reachableTopNodes) {
        HashSet<CodeGeneratorUtil.OtdVelocityWrapper> nodelist = new HashSet<CodeGeneratorUtil.OtdVelocityWrapper>();
        nodelist.add(XsdCodeGeneratorUtil.wrapNode((OtdWood)otd.getOtdGrove()));
        Set<Object> prevlist = nodelist;
        prevlist = XsdCodeGeneratorUtil.createOtdWrapperList((Set)reachableTopNodes, prevlist, (NodeWrapper)XsdCodeGeneratorUtil.getNodeWrapper());
        return prevlist;
    }

    public static NodeWrapper getNodeWrapper() {
        return new NodeWrapper(){

            public CodeGeneratorUtil.OtdVelocityWrapper wrapNode(OtdWood wood) {
                return new XsdOtdVelocityWrapper(wood);
            }
        };
    }

    public static class XsdOtdVelocityWrapper
    extends CodeGeneratorUtil.OtdVelocityWrapper {
        public XsdOtdVelocityWrapper(OtdWood otd) {
            super(otd);
        }

        public XsdOtdVelocityWrapper(OtdWood otd, int forceType) {
            super(otd, forceType);
        }

        public XsdOtdVelocityWrapper(OtdWood otd, boolean optional, boolean repeat) {
            super(otd, optional, repeat);
        }

        public XsdOtdVelocityWrapper(OtdWood otd, String name, String javaName, boolean optional, boolean repeat) {
            super(otd, name, javaName, optional, repeat);
        }

        protected CodeGeneratorUtil.OtdVelocityWrapper wrapNode(OtdWood wood) {
            return new XsdOtdVelocityWrapper(wood);
        }

        protected CodeGeneratorUtil.OtdVelocityWrapper wrapNode(OtdWood wood, String name, String javaName, boolean optional, boolean repeat) {
            return new XsdOtdVelocityWrapper(wood, name, javaName, optional, repeat);
        }

        protected String getCodeForJavaObjectExt(String type, String javaType, String defaultValue, String objname, String metaDecl) {
            boolean handled = false;
            String objectType = null;
            String newObject = null;
            String objectValue = null;
            String result = null;
            if (javaType.equals("com.stc.runtime.dt.Date")) {
                objectType = "com.stc.otd.xsd.datatype.Date2001";
                if (defaultValue != null && defaultValue.length() > 0) {
                    defaultValue = !XsdCodeGeneratorUtil.isDate2001Constant(defaultValue) ? "(" + defaultValue + " != null?" + defaultValue + ".toString():null)" : "\"" + defaultValue + "\"";
                    newObject = objectType + " " + objname + " = " + objectType + ".parse(" + defaultValue + ");";
                } else {
                    newObject = objectType + " " + objname + " = new " + objectType + "();";
                }
                objectValue = "(" + javaType + ")" + objname + ";";
                handled = true;
            } else if (javaType.equals("com.stc.runtime.dt.DateTime")) {
                objectType = "com.stc.otd.xsd.datatype.DateTime";
                if (defaultValue != null && defaultValue.length() > 0) {
                    defaultValue = !XsdCodeGeneratorUtil.isDateTimeConstant(defaultValue) ? "(" + defaultValue + " != null?" + defaultValue + ".toString():null)" : "\"" + defaultValue + "\"";
                    newObject = objectType + " " + objname + " = " + objectType + ".parse(" + defaultValue + ");";
                } else {
                    newObject = objectType + " " + objname + " = new " + objectType + "();";
                }
                objectValue = "(" + javaType + ")" + objname + ";";
                handled = true;
            }
            if (handled) {
                if (type.equals("objectType")) {
                    result = objectType;
                } else if (type.equals("newObject")) {
                    result = newObject;
                } else if (type.equals("objectValue")) {
                    result = objectValue;
                }
                return result;
            }
            return null;
        }
    }
}

