/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.codegen;

import com.stc.model.common.ObjectTypeDefinition;
import com.stc.otd.builder.OtdBuilderException;
import com.stc.otd.builder.OtdBuilderSpec;
import com.stc.otd.codegen.BaseXsdDtdGenerator;
import com.stc.otd.codegen.CodeGeneratorFactory;
import com.stc.otd.codegen.CodeGeneratorTask;
import com.stc.otd.codegen.CodeGeneratorUtil;
import com.stc.otd.codegen.Generator;
import com.stc.otd.codegen.NodeWrapper;
import com.stc.otd.codegen.OtdCodeGenException;
import com.stc.otd.forest.OtdContext;
import com.stc.otd.forest.OtdContextException;
import com.stc.otd.forest.OtdContextSpec;
import com.stc.otd.forest.OtdGrove;
import com.stc.otd.forest.OtdMetaContainer;
import com.stc.otd.forest.OtdNameValueType;
import com.stc.otd.forest.OtdNameValueTypeMap;
import com.stc.otd.forest.OtdOrigin;
import com.stc.otd.forest.OtdSeed;
import com.stc.otd.forest.OtdTrunk;
import com.stc.otd.forest.OtdWood;
import com.stc.otd.forest.OtdWoodList;
import com.stc.otd.forest.provider.OtdContextFactory;
import com.stc.otd.forest.provider.OtdNativeContextSpec;
import com.stc.otd.xsd.builder.XsdOtdBuilder;
import com.stc.otd.xsd.codegen.AntlrGrammarGeneratorTask;
import com.stc.otd.xsd.codegen.AntlrParserGeneratorTask;
import com.stc.otd.xsd.codegen.AntlrTokenGeneratorTask;
import com.stc.otd.xsd.codegen.AntlrTokenStreamGeneratorTask;
import com.stc.otd.xsd.codegen.AntlrTokenTypeNamesGeneratorTask;
import com.stc.otd.xsd.codegen.RuleGeneratorTask;
import com.stc.otd.xsd.codegen.TokenGeneratorTask;
import com.stc.otd.xsd.codegen.TokenStreamGeneratorTask;
import com.stc.otd.xsd.codegen.XsdCodeGeneratorUtil;
import com.stc.otd.xsd.codegen.XsdOriginVelocityWrapper;
import com.stc.otd.xsd.codegen.XsdRuleMapWrapper;
import com.stc.otd.xsd.repository.impl.XSDObjectTypeDefinitionImpl;
import com.stc.repository.RepositoryException;
import com.stc.repository.RepositoryObject;
import com.stc.util.EgateConfig;
import com.stc.util.UnicodeFile;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.log4j.Logger;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;

public class XsdParserGenerator
extends BaseXsdDtdGenerator {
    private Logger mLogger = Logger.getLogger((String)"XsdParserGenerator");
    static final String XSD_REPOSITORY_OTD = "com.stc.otd.xsd.repository.impl.XSDObjectTypeDefinitionImpl";
    static final String[] COMPILE_CLASS_PATH = new String[]{"com.stc.otd.runtime.OtdRoot", "com.stc.otd.xsd.builder.XsdOtdBuilder", "com.stc.runtime.dt.DateTime"};
    public static final boolean mXXLCodegen = XsdParserGenerator.readCfgXXLCodegen();
    public static final boolean mCheckReachable = XsdParserGenerator.readCfgCheckReachable();
    private static VelocityEngine mVelocityEngine = null;
    private static final String VELOCITY_CODE_TEMPLATE = "com/stc/otd/xsd/codegen/templates/xsd_otd_impl.vm";
    private static final String VELOCITY_CODE_TEMPLATE_XXL = "com/stc/otd/xsd/codegen/templates/xsd_otd_impl_XXL.vm";

    public void buildOtd(OtdMetaContainer otd, OtdBuilderSpec aSpec) throws OtdBuilderException, OtdContextException, IOException {
        XsdOtdBuilder builder = new XsdOtdBuilder(aSpec);
        builder.buildOtd(otd);
    }

    public ObjectTypeDefinition newRepositoryOtd(String otdName) throws RepositoryException {
        XSDObjectTypeDefinitionImpl otd = new XSDObjectTypeDefinitionImpl(otdName);
        return otd;
    }

    public RepositoryObject newWSDLObject(ObjectTypeDefinition otd) throws RepositoryException {
        return null;
    }

    public void compile(File sourceDir, File targetDir) {
        String classpath = this.getOtdClassPath(COMPILE_CLASS_PATH);
        this.mLogger.debug((Object)("ext classpath: " + classpath));
        this.compile(sourceDir, targetDir, classpath);
    }

    public void generateJavaCode(OtdMetaContainer otd, File workingDir) throws OtdCodeGenException {
        try {
            NodeWrapper wrapper = XsdCodeGeneratorUtil.getNodeWrapper();
            VelocityContext mVC = new VelocityContext();
            OtdOrigin otdOrigin = otd.getOtdOrigin();
            boolean isRelease50X = false;
            if (otdOrigin != null) {
                Hashtable<String, String> nslist = new Hashtable<String, String>();
                Hashtable nsreverselist = new Hashtable();
                Hashtable<String, String> targetnslist = new Hashtable<String, String>();
                boolean hasNillable = false;
                OtdNameValueTypeMap table = otdOrigin.getOtdSeedInfo(otd.getOtdGrove().getId());
                if (table != null && table.values() != null) {
                    Iterator en = table.values().iterator();
                    while (en.hasNext()) {
                        String nsURI;
                        OtdNameValueType content = (OtdNameValueType)en.next();
                        String name = content.getName();
                        if (name.equals("isRelease50X")) {
                            isRelease50X = "true".equals(content.getValue());
                            continue;
                        }
                        if (name.indexOf("NS:") >= 0) {
                            nsURI = (String)content.getValue();
                            if (this.excludeNamespace(nsURI) || nsreverselist.containsKey(nsURI) && nsreverselist.get(nsURI) != null && ((String)nsreverselist.get(nsURI)).length() > 0) continue;
                            nsreverselist.remove(nsURI);
                            nsreverselist.put(nsURI, name.substring("NS:".length()));
                            continue;
                        }
                        if (name.equals("hasNillableElem")) {
                            if (XsdOriginVelocityWrapper.isTrue(content.getValue())) {
                                hasNillable = true;
                            }
                        } else if (name.indexOf("targetNamespace") >= 0) {
                            nsURI = (String)content.getValue();
                            targetnslist.put(nsURI, "");
                        }
                        mVC.put(content.getName(), content.getValue());
                    }
                }
                if (nsreverselist != null && nsreverselist.size() > 0) {
                    Enumeration ens = nsreverselist.keys();
                    while (ens.hasMoreElements()) {
                        String url = (String)ens.nextElement();
                        String prefix = (String)nsreverselist.get(url);
                        if (prefix == null) {
                            prefix = "";
                        }
                        nslist.put(prefix, url);
                    }
                }
                String xsiUri = "http://www.w3.org/2001/XMLSchema-instance";
                if (nsreverselist.containsKey("http://www.w3.org/2001/XMLSchema-instance") && !"xsi".equals((String)nsreverselist.get("http://www.w3.org/2001/XMLSchema-instance"))) {
                    nslist.remove(nsreverselist.remove("http://www.w3.org/2001/XMLSchema-instance"));
                }
                if (!nsreverselist.containsKey("http://www.w3.org/2001/XMLSchema-instance") && nslist.containsKey("xsi")) {
                    int i = 2;
                    while (true) {
                        if (!nslist.containsKey("xsi" + i)) {
                            nsreverselist.put(nslist.get("xsi"), "xsi" + i);
                            nslist.put("xsi" + i, (String)nslist.remove("xsi"));
                            break;
                        }
                        ++i;
                    }
                }
                if (!nsreverselist.containsKey("http://www.w3.org/2001/XMLSchema-instance")) {
                    nsreverselist.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
                    nslist.put("xsi", "http://www.w3.org/2001/XMLSchema-instance");
                }
                if (!isRelease50X && targetnslist != null && targetnslist.size() > 0) {
                    Iterator iter = targetnslist.keySet().iterator();
                    while (iter.hasNext()) {
                        String tns = (String)iter.next();
                        if (this.excludeNamespace(tns) || nsreverselist.containsKey(tns)) continue;
                        String prefix = this.crackOutPrefix(nslist.keySet(), "tns");
                        nsreverselist.put(tns, prefix);
                        nslist.put(prefix, tns);
                    }
                }
                mVC.put("mReverseNameSpaces", nsreverselist);
                if (nslist != null && nslist.size() > 0) {
                    mVC.put("mNameSpaces", nslist);
                }
                mVC.put("mTargetNamespaces", targetnslist);
            } else {
                otdOrigin = otd.createOrigin("origin");
            }
            mVC.put("otdOrigin", (Object)new XsdOriginVelocityWrapper(otdOrigin));
            OtdSeed otdSeed = otdOrigin.getOtdSeed(otd.getOtdGrove().getId());
            String pkgName = otd.getPackageName();
            mVC.put("otdPackageName", (Object)pkgName);
            mVC.put("otdPackagePath", (Object)pkgName.replace('.', '/'));
            mVC.put("otdGroveWrapper", (Object)wrapper.wrapNode((OtdWood)otd.getOtdGrove()));
            mVC.put("mSchemaVersion", otdSeed.getOtdSeedInfo("schemaVersion").getValue());
            Set otdList = mCheckReachable ? XsdCodeGeneratorUtil.createReachableOtdWrapperList(otd) : CodeGeneratorUtil.createOtdWrapperList((OtdGrove)otd.getOtdGrove(), (NodeWrapper)wrapper);
            mVC.put("otdNode", (Object)wrapper.wrapNode((OtdWood)otd.getOtdGrove()));
            mVC.put("otdList", (Object)otdList);
            String strictValidation = (String)otdSeed.getOtdSeedInfo("validate").getValue();
            if (strictValidation.startsWith("t") || strictValidation.startsWith("T") || strictValidation.equals("1") || strictValidation.equals("-1")) {
                mVC.put("strictValidation", (Object)"true");
            } else {
                mVC.put("strictValidation", (Object)"false");
            }
            if (otdSeed.getOtdSeedInfo("CannotMarshalUninitialized") != null) {
                String cannotMarshalUninitialized = (String)otdSeed.getOtdSeedInfo("CannotMarshalUninitialized").getValue();
                mVC.put("cannotMarshalUninitialized", (Object)cannotMarshalUninitialized);
            }
            String targetNamespace = "";
            if (otdSeed.getOtdSeedInfo("targetNamespace") != null) {
                targetNamespace = (String)otdSeed.getOtdSeedInfo("targetNamespace").getValue();
            }
            mVC.put("targetNamespace", (Object)targetNamespace);
            String outputEncoding = "UTF-8";
            if (otdSeed.getOtdSeedInfo("outputEncoding") != null) {
                outputEncoding = (String)otdSeed.getOtdSeedInfo("outputEncoding").getValue();
            }
            mVC.put("outputEncoding", (Object)outputEncoding);
            HashSet<String> reachableIds = null;
            if (mCheckReachable) {
                reachableIds = new HashSet<String>();
                Iterator it = otdList.iterator();
                while (it.hasNext()) {
                    reachableIds.add(((CodeGeneratorUtil.OtdVelocityWrapper)it.next()).getId());
                }
            }
            mVC.put("simpleDataConverterFactory", (Object)"com.stc.otd.xsd.runtime.provider.SimpleDataConverterFactory.getConverter()");
            if (!mXXLCodegen) {
                CodeGeneratorTask code = new CodeGeneratorTask(wrapper);
                Template t = mVelocityEngine.getTemplate(VELOCITY_CODE_TEMPLATE);
                code.generate(otd, workingDir, t, mVC, true, reachableIds);
                AntlrGrammarGeneratorTask grammar = new AntlrGrammarGeneratorTask();
                grammar.generate(otd, workingDir, mVelocityEngine, mVC);
                AntlrTokenStreamGeneratorTask tstream = new AntlrTokenStreamGeneratorTask();
                tstream.generate(otd, workingDir, mVelocityEngine, mVC);
                AntlrTokenGeneratorTask token = new AntlrTokenGeneratorTask();
                token.generate(otd, workingDir, mVelocityEngine, mVC);
                AntlrTokenTypeNamesGeneratorTask namesTask = new AntlrTokenTypeNamesGeneratorTask();
                namesTask.generate(otd, workingDir, mVelocityEngine, mVC);
                AntlrParserGeneratorTask parser = new AntlrParserGeneratorTask();
                parser.generate(otd.getOtdGrove().getJavaName(), workingDir);
            } else {
                Set fullOtdList = mCheckReachable ? CodeGeneratorUtil.createOtdWrapperList((OtdGrove)otd.getOtdGrove()) : otdList;
                mVC.put("otdList", (Object)fullOtdList);
                TokenGeneratorTask tokentask = new TokenGeneratorTask();
                Map tokenmap = tokentask.generate(otd, workingDir, mVelocityEngine, mVC);
                mVC.put("otdList", (Object)otdList);
                TokenStreamGeneratorTask tstream = new TokenStreamGeneratorTask();
                tstream.generate(otd, workingDir, mVelocityEngine, mVC);
                RuleGeneratorTask ruletask = new RuleGeneratorTask();
                RuleGeneratorTask.EntryMap ruleEntryMap = ruletask.generate(otd, workingDir, mVelocityEngine, mVC, tokenmap);
                if (!mVC.containsKey((Object)"XsdRuleMap")) {
                    XsdRuleMapWrapper rulemap = new XsdRuleMapWrapper(ruleEntryMap);
                    mVC.put("XsdRuleMap", (Object)rulemap);
                }
                CodeGeneratorTask code = new CodeGeneratorTask(wrapper);
                code.mXXLCodegen = true;
                Template t = mVelocityEngine.getTemplate(VELOCITY_CODE_TEMPLATE_XXL);
                code.generate(otd, workingDir, t, mVC, true, reachableIds);
            }
        }
        catch (Exception e) {
            throw new OtdCodeGenException("generateJavaCode", e.getMessage(), (Throwable)e);
        }
    }

    private static void initializeVelocity() throws Exception {
        Properties vprops = new Properties();
        vprops.put("resource.loader", "class");
        vprops.put("class.resource.loader.description", "Velocity Classpath Resource Loader");
        String velocityLoader = System.getProperty("velocity.classloader");
        if (velocityLoader == null) {
            Logger.getRootLogger().debug((Object)"=== use com.stc.velocity.NBSystemResourceLoader ===");
            vprops.put("class.resource.loader.class", "com.stc.velocity.NBSystemResourceLoader");
        } else {
            Logger.getRootLogger().debug((Object)"=== use org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader ===");
            vprops.put("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        }
        String logFile = System.getProperty("xsd.velocity.logFile");
        if (logFile != null && !logFile.trim().equals("")) {
            vprops.setProperty("runtime.log", logFile);
        }
        vprops.put("directive.foreach.counter.initial.value", "0");
        vprops.put("file.resource.loader.cache", "false");
        vprops.put("file.resource.loader.modificationCheckInterval", "0");
        if (!mXXLCodegen) {
            vprops.put("velocimacro.library", "com/stc/otd/codegen/templates/otd_dtd_xsd_method_lib.vm");
        } else {
            vprops.put("velocimacro.library", "com/stc/otd/codegen/templates/otd_dtd_xsd_method_lib_XXL.vm");
        }
        mVelocityEngine = new VelocityEngine();
        mVelocityEngine.init(vprops);
    }

    public List getDependentJarClassNames() {
        List classList = super.getDependentJarClassNames();
        classList.add("com.stc.otd.xsd.codegen.SchemaRuntime");
        return classList;
    }

    public static void main(String[] args) {
        if (args == null || args.length != 2) {
            System.out.println("Usage: com.stc.otd.dtd.run.XMLParserGenerator  otdName workingDir");
            return;
        }
        try {
            OtdNativeContextSpec spec = new OtdNativeContextSpec(args[1]);
            OtdContext oc = OtdContextFactory.getOtdNativeContext();
            oc.setOtdContextSpec((OtdContextSpec)spec);
            OtdMetaContainer otd = oc.lookUpOtd(args[0]);
            Generator gen = CodeGeneratorFactory.createCodeGenerator((String)otd.getOtdType(), (ClassLoader)otd.getClass().getClassLoader());
            gen.generate(otd, new File(spec.getBaseDir()));
        }
        catch (Exception exc) {
            exc.printStackTrace();
            System.exit(-1);
        }
    }

    private String getTopNodeName(OtdMetaContainer otdMeta, String topNodeId) {
        String className;
        block2: {
            OtdGrove grove;
            block1: {
                grove = otdMeta.getOtdGrove();
                OtdTrunk topTrunk = grove.getTopTree(topNodeId);
                className = null;
                if (topTrunk == null) break block1;
                className = topTrunk.getJavaName();
                if (className != null) break block2;
                className = topTrunk.getName();
                break block2;
            }
            OtdWoodList woodList = grove.getTrees();
            Iterator iter = woodList.iterator();
            while (iter.hasNext()) {
                OtdWood wood = (OtdWood)iter.next();
                OtdTrunk trunk = (OtdTrunk)wood;
                if (!trunk.isTop()) continue;
                className = wood.getJavaName();
                if (className != null) break;
                className = wood.getName();
                break;
            }
        }
        return className;
    }

    public static boolean readCfgXXLCodegen() {
        return EgateConfig.getFlag((String)"otd.xsd.codegen.useXXL", (boolean)true);
    }

    public static boolean readCfgCheckReachable() {
        return EgateConfig.getFlag((String)"otd.xsd.checkReachable", (boolean)true);
    }

    public void generateGenInfo(File aDir) throws FileNotFoundException, IOException {
        File file = new File(aDir.getAbsoluteFile(), File.separatorChar + "OTD.info");
        OutputStreamWriter fw = UnicodeFile.makeOutputWriter((File)file);
        fw.write("Java_Code_Generator=" + ((Object)((Object)this)).getClass().getName());
        ((Writer)fw).close();
    }

    private boolean excludeNamespace(String ns) {
        return ns.equals("http://www.w3.org/2001/XMLSchema") || ns.equals("http://www.w3.org/2000/10/XMLSchema") || ns.equals("http://www.w3.org/XML/1998/namespace");
    }

    private String crackOutPrefix(Set existing, String seed) {
        if (!existing.contains(seed)) {
            return seed;
        }
        int i = 1;
        String prefix = seed + i++;
        while (existing.contains(prefix)) {
            prefix = seed + i++;
        }
        return prefix;
    }

    static {
        try {
            XsdParserGenerator.initializeVelocity();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

