/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.RecurringDuration;
import java.util.StringTokenizer;

public class Date
extends RecurringDuration {
    protected static final char[] INIT_DURATION = new char[]{'P', '1', 'D'};
    protected static final char[] INIT_PERIOD = new char[]{'P', '0', 'Y'};

    public Date() {
        super(INIT_DURATION, INIT_PERIOD);
    }

    public static Date parseDate(char[] value) {
        StringTokenizer token;
        if (value == null || value.length == 0) {
            throw new MarshalException("Missing Date value");
        }
        Date result = new Date();
        String str = new String(value);
        if (str.startsWith("-")) {
            result.setNegative();
        }
        if ((token = new StringTokenizer(str, "-")).countTokens() != 3) {
            throw new MarshalException("Invalid date format");
        }
        String temp = token.nextToken();
        if (temp.length() < 4) {
            throw new MarshalException("Invalid century and year");
        }
        result.setCentury(Integer.parseInt(temp.substring(0, temp.length() - 2)));
        result.setYear(Integer.parseInt(temp.substring(temp.length() - 2)));
        temp = token.nextToken();
        if (temp.length() < 2) {
            throw new MarshalException("Invalid month");
        }
        result.setMonth(Integer.parseInt(temp));
        temp = token.nextToken();
        if (temp.length() < 2) {
            throw new MarshalException("Invalid day");
        }
        result.setDay(Integer.parseInt(temp));
        return result;
    }

    public String toString() {
        String temp;
        String result = "";
        if (this.isNegative()) {
            result = result + "-";
        }
        if ((temp = String.valueOf(this.getCentury())).length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        temp = String.valueOf(this.getYear());
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        temp = String.valueOf(this.getMonth());
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + "-" + temp;
        temp = String.valueOf(this.getDay());
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + "-" + temp;
        return result;
    }
}

