/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import java.util.TimeZone;

class DateParser {
    DateParser() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static GregorianCalendar getCalendar(String isodate) {
        int year = 0;
        int month = 0;
        int day = 0;
        int hour = 0;
        int minute = 0;
        int second = 0;
        int millisec = 0;
        TimeZone timeZone = null;
        StringTokenizer st = new StringTokenizer(isodate, "-T:.+Z", true);
        try {
            if (!st.hasMoreTokens()) {
                throw new RuntimeException("Incorrectly formatted dateTime string.");
            }
            year = Integer.parseInt(st.nextToken());
            if (DateParser.check(st, "-") && st.hasMoreTokens()) {
                month = Integer.parseInt(st.nextToken()) - 1;
            }
            if (DateParser.check(st, "-") && st.hasMoreTokens()) {
                day = Integer.parseInt(st.nextToken());
            }
            if (DateParser.check(st, "T") && st.hasMoreTokens()) {
                hour = Integer.parseInt(st.nextToken());
            }
            if (DateParser.check(st, ":") && st.hasMoreTokens()) {
                minute = Integer.parseInt(st.nextToken());
            }
            if (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (tok.equals(":")) {
                    if (!st.hasMoreTokens()) {
                        throw new RuntimeException("No secondes specified following \":\".");
                    }
                    second = Integer.parseInt(st.nextToken());
                    tok = null;
                    if (st.hasMoreTokens() && (tok = st.nextToken()).equals(".")) {
                        if (!st.hasMoreTokens()) throw new RuntimeException("No millisecondes specified following \".\".");
                        String nt = st.nextToken();
                        while (nt.length() < 3) {
                            nt = nt + "0";
                        }
                        nt = nt.substring(0, 3);
                        millisec = Integer.parseInt(nt);
                        tok = st.hasMoreTokens() ? st.nextToken() : null;
                    }
                }
                if (tok != null) {
                    if (tok.equals("Z")) {
                        timeZone = TimeZone.getTimeZone("UTC");
                    } else {
                        if (!tok.equals("+") && !tok.equals("-")) throw new RuntimeException("Only Z, + or - are allowed after the date and time.");
                        StringBuffer customTZ = new StringBuffer("GMT" + tok);
                        if (!st.hasMoreTokens()) throw new RuntimeException("No time zone specified after a \"+\" or \"-\" sign.");
                        customTZ.append(st.nextToken());
                        if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                            throw new RuntimeException("Minute field is missing in time zone specification.");
                        }
                        customTZ.append(st.nextToken());
                        timeZone = TimeZone.getTimeZone(customTZ.toString());
                    }
                }
            }
            if (timeZone == null) {
                timeZone = TimeZone.getDefault();
            }
        }
        catch (NumberFormatException ex) {
            throw new RuntimeException(ex.getMessage());
        }
        GregorianCalendar calendar = new GregorianCalendar(timeZone);
        calendar.set(1, year);
        calendar.set(2, month);
        calendar.set(5, day);
        calendar.set(11, hour);
        calendar.set(12, minute);
        calendar.set(13, second);
        calendar.set(14, millisec);
        return calendar;
    }

    public static String getIsoDate(Calendar calendar) {
        int zoneOffSet;
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(5)));
        buffer.append("T");
        buffer.append(DateParser.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(13)));
        int millisecond = calendar.get(14);
        if (millisecond > 0) {
            buffer.append(".");
            if (millisecond < 10) {
                buffer.append("00");
            } else if (millisecond >= 10 && millisecond < 100) {
                buffer.append("0");
            }
            buffer.append(millisecond);
        }
        if ((zoneOffSet = calendar.get(15)) == 0) {
            buffer.append("Z");
        } else if (zoneOffSet > 0) {
            int hour = zoneOffSet / 3600000;
            int minute = (zoneOffSet - hour * 3600000) / 60000;
            buffer.append("+");
            buffer.append(DateParser.twoDigit(hour));
            buffer.append(":");
            buffer.append(DateParser.twoDigit(minute));
        } else {
            int hour = -1 * zoneOffSet / 3600000;
            int minute = (-1 * zoneOffSet - hour * 3600000) / 60000;
            buffer.append("-");
            buffer.append(DateParser.twoDigit(hour));
            buffer.append(":");
            buffer.append(DateParser.twoDigit(minute));
        }
        return buffer.toString();
    }

    public static Date parse(String isodate) throws RuntimeException {
        GregorianCalendar calendar = DateParser.getCalendar(isodate);
        return calendar.getTime();
    }

    private static boolean check(StringTokenizer st, String token) throws RuntimeException {
        try {
            if (st.nextToken().equals(token)) {
                return true;
            }
            throw new RuntimeException("Missing [" + token + "]");
        }
        catch (NoSuchElementException ex) {
            return false;
        }
    }

    private static String threeDigit(int i) {
        if (i == 0) {
            return "000";
        }
        String s = String.valueOf(i);
        if (s.length() > 3) {
            s = s.substring(0, 3);
        }
        if (s.length() == 1) {
            s = "00" + s;
        } else if (s.length() == 2) {
            s = "0" + s;
        }
        return s;
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }
}

