/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.xsd.datatype.DateParser;
import com.stc.runtime.dt.Duration;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class DateTime
implements com.stc.runtime.dt.DateTime,
Comparable {
    GregorianCalendar cal;
    public static final TimeZone UTC = TimeZone.getTimeZone("UTC");

    public DateTime() {
        this.cal = new GregorianCalendar(UTC);
        this.cal.setLenient(true);
    }

    public DateTime(GregorianCalendar cal) {
        this.cal = (GregorianCalendar)cal.clone();
        this.cal.setLenient(true);
    }

    public DateTime(com.stc.runtime.dt.DateTime copy) {
        if (!(copy.getCal() instanceof GregorianCalendar)) {
            throw new IllegalArgumentException("DateTime should use GregorianCalendar");
        }
        this.cal = (GregorianCalendar)copy.getCal();
        this.cal.setLenient(true);
    }

    public DateTime(int year, int month, int day) {
        this(year, month, day, 0, 0, 0, 0);
    }

    public DateTime(int year, int month, int day, int hour, int minute, int second, int millisecond) {
        this.cal = new GregorianCalendar(year, month, day, hour, minute, second);
        this.cal.setLenient(true);
        this.cal.set(14, millisecond);
    }

    public static DateTime parse(char[] value) {
        return DateTime.parse(new String(value));
    }

    public static DateTime parse(String value) {
        return new DateTime(DateParser.getCalendar(value));
    }

    public int getDay() {
        return this.cal.get(5);
    }

    public int getHours() {
        return this.cal.get(11);
    }

    public int getMilliseconds() {
        return this.cal.get(14);
    }

    public int getMinutes() {
        return this.cal.get(12);
    }

    public int getMonth() {
        return this.cal.get(2) + 1;
    }

    public int getSeconds() {
        return this.cal.get(13);
    }

    public int getYear() {
        return this.cal.get(1);
    }

    public void setCalendar(GregorianCalendar cal) {
        cal = (GregorianCalendar)cal.clone();
        cal.setLenient(true);
    }

    public void setDay(int day) {
        this.cal.set(5, day);
    }

    public void setHours(int hours) {
        this.cal.set(11, hours);
    }

    public void setMilliseconds(int millis) {
        this.cal.set(14, millis);
    }

    public void setMinutes(int minutes) {
        this.cal.set(12, minutes);
    }

    public void setMonth(int month) {
        this.cal.set(2, month - 1);
    }

    public void setSeconds(int seconds) {
        this.cal.set(13, seconds);
    }

    public void setYear(int year) {
        this.cal.set(1, year);
    }

    public void addDay(int days) {
        this.cal.add(5, days);
    }

    public void addHours(int hours) {
        this.cal.add(11, hours);
    }

    public void addMilliseconds(int millis) {
        this.cal.add(14, millis);
    }

    public void addMinutes(int minutes) {
        this.cal.add(12, minutes);
    }

    public void addMonth(int months) {
        this.cal.add(2, months);
    }

    public void addSeconds(int seconds) {
        this.cal.add(13, seconds);
    }

    public void addYear(int years) {
        this.cal.add(1, years);
    }

    public boolean after(com.stc.runtime.dt.DateTime other) {
        return this.cal.after(other.getCal());
    }

    public boolean before(com.stc.runtime.dt.DateTime other) {
        return this.cal.before(other.getCal());
    }

    public void rollDay(int days) {
        this.cal.roll(5, days);
    }

    public void rollHours(int hours) {
        this.cal.roll(11, hours);
    }

    public void rollMilliseconds(int millis) {
        this.cal.roll(14, millis);
    }

    public void rollMinutes(int minutes) {
        this.cal.roll(12, minutes);
    }

    public void rollMonth(int months) {
        this.cal.roll(2, months);
    }

    public void rollSeconds(int seconds) {
        this.cal.roll(13, seconds);
    }

    public void rollYear(int years) {
        this.cal.roll(1, years);
    }

    public GregorianCalendar toCalendar() {
        return this.cal;
    }

    public String toString() {
        return DateParser.getIsoDate(this.cal);
    }

    public void add(Duration dur) {
        int m = dur.isNegative() ? -1 : 1;
        this.addYear(m * dur.getYears());
        this.addMonth(m * dur.getMonths());
        this.addDay(m * dur.getDays());
        this.addHours(m * dur.getHours());
        this.addMinutes(m * dur.getMinutes());
        this.addSeconds(m * dur.getSeconds());
        this.addMilliseconds(m * dur.getMilliseconds());
    }

    public void roll(Duration dur) {
        int m = dur.isNegative() ? -1 : 1;
        this.rollYear(m * dur.getYears());
        this.rollMonth(m * dur.getMonths());
        this.rollDay(m * dur.getDays());
        this.rollHours(m * dur.getHours());
        this.rollMinutes(m * dur.getMinutes());
        this.rollSeconds(m * dur.getSeconds());
        this.rollMilliseconds(m * dur.getMilliseconds());
    }

    public void subtract(Duration dur) {
        int m = dur.isNegative() ? 1 : -1;
        this.addYear(m * dur.getYears());
        this.addMonth(m * dur.getMonths());
        this.addDay(m * dur.getDays());
        this.addHours(m * dur.getHours());
        this.addMinutes(m * dur.getMinutes());
        this.addSeconds(m * dur.getSeconds());
        this.addMilliseconds(m * dur.getMilliseconds());
    }

    public Calendar getCal() {
        return this.cal;
    }

    public void setTimeZone(TimeZone tzz) {
        this.cal.setTimeZone(tzz);
    }

    public TimeZone getTimeZone() {
        return this.cal.getTimeZone();
    }

    public int compareTo(Object o) {
        com.stc.runtime.dt.DateTime to = (com.stc.runtime.dt.DateTime)o;
        if (to == null) {
            return -2;
        }
        if (this.after(to)) {
            return 1;
        }
        if (this.before(to)) {
            return -1;
        }
        return 0;
    }
}

