/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import java.text.DecimalFormat;

public class Duration
implements com.stc.runtime.dt.Duration,
Comparable {
    private static DecimalFormat fmt = new DecimalFormat(".###");
    private int days;
    private int hours;
    private int milliseconds;
    private int minutes;
    private int months;
    private boolean negative;
    private int seconds;
    private int years;

    public Duration() {
    }

    public Duration(com.stc.runtime.dt.Duration copy) {
        this.negative = copy.isNegative();
        this.years = copy.getYears();
        this.months = copy.getMonths();
        this.days = copy.getDays();
        this.hours = copy.getHours();
        this.minutes = copy.getMinutes();
        this.seconds = copy.getSeconds();
        this.milliseconds = copy.getMilliseconds();
    }

    public static void main(String[] argv) {
        Duration d = Duration.parse(argv[0]);
        System.out.println(d);
    }

    public static Duration parse(String value) {
        DurationParser parser = new DurationParser(value);
        return parser.parseDuration();
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getMonths() {
        return this.months;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public int getYears() {
        return this.years;
    }

    public boolean isNegative() {
        return this.negative;
    }

    public void setDays(int days) {
        this.check(days);
        this.days = days;
    }

    public void setHours(int hours) {
        this.check(hours);
        this.hours = hours;
    }

    public void setMilliseconds(int millis) {
        this.check(millis);
        this.milliseconds = millis;
    }

    public void setMinutes(int minutes) {
        this.check(minutes);
        this.minutes = minutes;
    }

    public void setMonths(int months) {
        this.check(months);
        this.months = months;
    }

    public void setNegative(boolean value) {
        this.negative = value;
    }

    public void setSeconds(int seconds) {
        this.check(seconds);
        this.seconds = seconds;
    }

    public void setYears(int years) {
        this.check(years);
        this.years = years;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String buffer = "";
        if (this.negative) {
            buffer = buffer + "-";
        }
        buffer = buffer + "P";
        if (this.years > 0) {
            buffer = buffer + this.years;
            buffer = buffer + "Y";
        }
        if (this.months > 0) {
            buffer = buffer + this.months;
            buffer = buffer + "M";
        }
        if (this.days > 0) {
            buffer = buffer + this.days;
            buffer = buffer + "D";
        }
        if (this.hours > 0 || this.minutes > 0 || this.seconds > 0 || this.milliseconds > 0) {
            buffer = buffer + "T";
            if (this.hours > 0) {
                buffer = buffer + this.hours;
                buffer = buffer + "H";
            }
            if (this.minutes > 0) {
                buffer = buffer + this.minutes;
                buffer = buffer + "M";
            }
            if (this.seconds > 0 || this.milliseconds > 0) {
                buffer = buffer + this.seconds;
                if (this.milliseconds > 0) {
                    DecimalFormat decimalFormat = fmt;
                    synchronized (decimalFormat) {
                        buffer = buffer + fmt.format((double)this.milliseconds / 1000.0);
                    }
                }
                buffer = buffer + "S";
            }
        }
        return buffer;
    }

    private void check(int value) {
        if (value < 0) {
            throw new IllegalArgumentException("value cannot be negative");
        }
    }

    public long maxSeconds() {
        long seconds = 0L;
        seconds += (long)(this.years * 366 * 24 * 3600);
        seconds += (long)(this.months * 31 * 24 * 3600);
        seconds += (long)(this.days * 24 * 3600);
        seconds += (long)(this.hours * 3600);
        seconds += (long)(this.minutes * 60);
        return seconds += (long)this.seconds;
    }

    public long minSeconds() {
        long seconds = 0L;
        seconds += (long)(this.years * 364 * 24 * 3600);
        seconds += (long)(this.months * 27 * 24 * 3600);
        seconds += (long)(this.days * 24 * 3600);
        seconds += (long)(this.hours * 3600);
        seconds += (long)(this.minutes * 60);
        return seconds += (long)this.seconds;
    }

    public int compareTo(Object o) {
        Duration to = (Duration)o;
        if (to == null) {
            return -2;
        }
        if (this.minSeconds() > to.maxSeconds()) {
            return 1;
        }
        if (this.maxSeconds() < to.minSeconds()) {
            return -1;
        }
        if (this.maxSeconds() == to.maxSeconds() && this.minSeconds() == to.minSeconds()) {
            return 0;
        }
        return -2;
    }

    static class DurationParser {
        char[] buf;
        int mark;
        int pos;
        Duration result;

        DurationParser(String value) {
            this.buf = value.toCharArray();
            this.pos = this.buf.length - 1;
            this.result = new Duration();
        }

        void lex() {
            --this.pos;
        }

        boolean parseDay() {
            if (this.peek() == 68) {
                this.lex();
                this.result.setDays(this.parseInt());
                return true;
            }
            return false;
        }

        Duration parseDuration() {
            boolean some = false;
            if (this.parseSeconds()) {
                some = true;
            }
            if (this.parseMinutes()) {
                some = true;
            }
            if (this.parseHours()) {
                some = true;
            }
            if (some) {
                this.parseT();
            }
            if (this.parseDay()) {
                some = true;
            }
            if (this.parseMonth()) {
                some = true;
            }
            if (this.parseYear()) {
                some = true;
            }
            this.parseP();
            this.parseNegative();
            this.parseEnd(some);
            return this.result;
        }

        void parseEnd(boolean some) {
            if (!some) {
                throw new RuntimeException("No fields specified");
            }
            if (this.pos > 0) {
                throw new RuntimeException("unexpected text: " + new String(this.buf, 0, this.pos));
            }
        }

        boolean parseHours() {
            if (this.peek() == 72) {
                this.lex();
                this.result.setHours(this.parseInt());
                return true;
            }
            return false;
        }

        int parseInt() {
            int mark = this.pos;
            while (this.pos > 0 && Character.isDigit(this.buf[this.pos - 1])) {
                --this.pos;
            }
            int result = Integer.parseInt(new String(this.buf, this.pos, mark + 1 - this.pos));
            --this.pos;
            return result;
        }

        boolean parseMinutes() {
            if (this.peek() == 77) {
                this.lex();
                this.result.setMinutes(this.parseInt());
                return true;
            }
            return false;
        }

        boolean parseMonth() {
            if (this.peek() == 77) {
                this.lex();
                this.result.setMonths(this.parseInt());
                return true;
            }
            return false;
        }

        void parseNegative() {
            if (this.pos >= 0 && this.peek() == 45) {
                this.lex();
                this.result.setNegative(true);
            }
        }

        void parseP() {
            if (this.peek() != 80) {
                throw new RuntimeException("Expected 'P' instead of '" + (char)this.peek() + "'");
            }
            this.lex();
        }

        boolean parseSeconds() {
            if (this.peek() == 83) {
                this.lex();
                int value = this.parseInt();
                if (this.peek() == 46) {
                    this.result.setMilliseconds((int)(Double.parseDouble("0." + value) * 1000.0));
                    this.lex();
                    value = this.pos >= 0 && Character.isDigit(this.buf[this.pos]) ? this.parseInt() : 0;
                }
                this.result.setSeconds(value);
                return true;
            }
            return false;
        }

        void parseT() {
            if (this.peek() != 84) {
                throw new RuntimeException("Expected 'T' instead of '" + (char)this.peek() + "'");
            }
            this.lex();
        }

        boolean parseYear() {
            if (this.peek() == 89) {
                this.lex();
                this.result.setYears(this.parseInt());
                return true;
            }
            return false;
        }

        int peek() {
            if (this.pos < 0) {
                throw new RuntimeException("malformed duration");
            }
            return this.buf[this.pos];
        }
    }
}

