/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.xsd.datatype.TimeZoneParser;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GMonthDay
implements com.stc.runtime.dt.GMonthDay,
Comparable {
    private static DecimalFormat fmt = new DecimalFormat("00");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("--MM-dd");
    private int day;
    private int month;
    private TimeZone tz;

    public GMonthDay() {
    }

    public GMonthDay(int month, int day, TimeZone tz) {
        this.month = month;
        this.day = day;
        this.tz = tz;
    }

    public GMonthDay(com.stc.runtime.dt.GMonthDay copy) {
        this.month = copy.getMonth();
        this.day = copy.getDay();
        this.tz = copy.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GMonthDay parse(String value) {
        Date date;
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            date = dateFormat.parse(value, pos);
            if (date == null) {
                throw new UnmarshalException("Invalid GDate format, expected: " + dateFormat.toPattern() + ", value:" + value);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeZone tz = null;
        if (pos.getIndex() < value.length()) {
            tz = TimeZoneParser.parse(value.substring(pos.getIndex()));
        }
        return new GMonthDay(calendar.get(2) + 1, calendar.get(5), tz);
    }

    public int getDay() {
        return this.day;
    }

    public int getMonth() {
        return this.month;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public void setDay(int value) {
        this.day = value;
    }

    public void setMonth(int value) {
        this.month = value;
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result;
        DecimalFormat decimalFormat = fmt;
        synchronized (decimalFormat) {
            result = "--" + fmt.format(this.month);
            result = result + "-";
            result = result + fmt.format(this.day);
        }
        if (this.tz != null) {
            result = result + TimeZoneParser.format(this.tz);
        }
        return result;
    }

    public int compareTo(Object o) {
        GMonthDay to = (GMonthDay)o;
        if (to == null) {
            return -2;
        }
        int compare = this.toString().compareTo(to.toString());
        if (compare > 0) {
            return 1;
        }
        if (compare < 0) {
            return -1;
        }
        return 0;
    }
}

