/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.xsd.datatype.TimeZoneParser;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GYear
implements com.stc.runtime.dt.GYear,
Comparable {
    private static DecimalFormat fmt = new DecimalFormat("0000");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy");
    private TimeZone tz;
    private int year;

    public GYear() {
    }

    public GYear(int date, TimeZone tz) {
        this.year = date;
        this.tz = tz;
    }

    public GYear(com.stc.runtime.dt.GYear copy) {
        this.year = copy.getYear();
        this.tz = copy.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GYear parse(String value) {
        Date date;
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            date = dateFormat.parse(value, pos);
            if (date == null) {
                throw new UnmarshalException("Invalid GYear format, expected: " + dateFormat.toPattern() + ", value: " + value);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeZone tz = null;
        if (pos.getIndex() < value.length()) {
            tz = TimeZoneParser.parse(value.substring(pos.getIndex()));
        }
        return new GYear(calendar.get(1), tz);
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public int getYear() {
        return this.year;
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    public void setYear(int value) {
        this.year = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result;
        DecimalFormat decimalFormat = fmt;
        synchronized (decimalFormat) {
            result = fmt.format(this.year);
        }
        if (this.tz != null) {
            result = result + TimeZoneParser.format(this.tz);
        }
        return result;
    }

    public int compareTo(Object o) {
        GYear to = (GYear)o;
        if (to == null) {
            return -2;
        }
        if (this.getYear() > to.getYear()) {
            return 1;
        }
        if (this.getYear() < to.getYear()) {
            return -1;
        }
        return 0;
    }
}

