/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.UnmarshalException;
import com.stc.otd.xsd.datatype.TimeZoneParser;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class GYearMonth
implements com.stc.runtime.dt.GYearMonth,
Comparable {
    private static final DecimalFormat YEAR_FMT = new DecimalFormat("0000");
    private static final DecimalFormat MONTH_FMT = new DecimalFormat("00");
    private static final SimpleDateFormat DATE_FMT = new SimpleDateFormat("yyyy-MM");
    private int month;
    private TimeZone tz;
    private int year;

    public GYearMonth() {
    }

    public GYearMonth(int year, int month, TimeZone tz) {
        this.year = year;
        this.month = month;
        this.tz = tz;
    }

    public GYearMonth(com.stc.runtime.dt.GYearMonth copy) {
        this.year = copy.getYear();
        this.month = copy.getMonth();
        this.tz = copy.getTimeZone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GYearMonth parse(String value) {
        Date date;
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = DATE_FMT;
        synchronized (simpleDateFormat) {
            date = DATE_FMT.parse(value, pos);
            if (date == null) {
                throw new UnmarshalException("Invalid GyearMonth format, expected: " + DATE_FMT.toPattern() + ", value: " + value);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeZone tz = null;
        if (pos.getIndex() < value.length()) {
            tz = TimeZoneParser.parse(value.substring(pos.getIndex()));
        }
        return new GYearMonth(calendar.get(1), calendar.get(2) + 1, tz);
    }

    public int getMonth() {
        return this.month;
    }

    public TimeZone getTimeZone() {
        return this.tz;
    }

    public int getYear() {
        return this.year;
    }

    public void setMonth(int value) {
        this.month = value;
    }

    public void setTimeZone(TimeZone tz) {
        this.tz = tz;
    }

    public void setYear(int value) {
        this.year = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result;
        DecimalFormat decimalFormat = YEAR_FMT;
        synchronized (decimalFormat) {
            result = YEAR_FMT.format(this.year);
        }
        result = result + "-";
        decimalFormat = MONTH_FMT;
        synchronized (decimalFormat) {
            result = result + MONTH_FMT.format(this.month);
        }
        if (this.tz != null) {
            result = result + TimeZoneParser.format(this.tz);
        }
        return result;
    }

    public int compareTo(Object o) {
        GYearMonth to = (GYearMonth)o;
        if (to == null) {
            return -2;
        }
        int compare = this.toString().compareTo(to.toString());
        if (compare > 0) {
            return 1;
        }
        if (compare < 0) {
            return -1;
        }
        return 0;
    }
}

