/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import java.io.ByteArrayOutputStream;

public final class MimeBase64Decoder {
    private ByteArrayOutputStream out = new ByteArrayOutputStream();
    private byte[] token = new byte[4];
    private byte[] bytes = new byte[3];
    private int tokenLength = 0;
    private static final byte NUL = 127;
    private static final byte EOF = 126;
    private static final byte[] MIME_MAP = new byte[]{127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 62, 127, 127, 127, 63, 52, 53, 54, 55, 56, 57, 58, 59, 60, 61, 127, 127, 127, 126, 127, 127, 127, 0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 127, 127, 127, 127, 127, 127, 26, 27, 28, 29, 30, 31, 32, 33, 34, 35, 36, 37, 38, 39, 40, 41, 42, 43, 44, 45, 46, 47, 48, 49, 50, 51, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127, 127};

    public byte[] getByteArray() {
        this.eof();
        return this.out.toByteArray();
    }

    public final void translate(char[] ch, int offset, int length) {
        if (this.token == null) {
            return;
        }
        for (int i = offset; i < offset + length; ++i) {
            byte t = MIME_MAP[ch[i] & 0xFF];
            if (t == 126) {
                this.eof();
            } else if (t != 127) {
                this.token[this.tokenLength++] = t;
            }
            if (this.tokenLength != 4) continue;
            this.decodeToken();
            this.tokenLength = 0;
        }
    }

    public final void translate(String str) {
        if (this.token == null) {
            return;
        }
        int length = str.length();
        for (int i = 0; i < length; ++i) {
            byte t = MIME_MAP[str.charAt(i) & 0xFF];
            if (t == 126) {
                this.eof();
            } else if (t != 127) {
                this.token[this.tokenLength++] = t;
            }
            if (this.tokenLength != 4) continue;
            this.decodeToken();
            this.tokenLength = 0;
        }
    }

    private final void decodeFinalToken() {
        byte b0 = this.token[0];
        byte b1 = this.token[1];
        byte b2 = this.token[2];
        byte b3 = this.token[3];
        int eqCount = 0;
        if (b0 == 126) {
            b0 = 0;
            ++eqCount;
        }
        if (b1 == 126) {
            b1 = 0;
            ++eqCount;
        }
        if (b2 == 126) {
            b2 = 0;
            ++eqCount;
        }
        if (b3 == 126) {
            b3 = 0;
            ++eqCount;
        }
        int num = b0 << 18 | b1 << 12 | b2 << 6 | b3;
        this.out.write((byte)(num >> 16));
        if (eqCount <= 1) {
            this.out.write((byte)(num >> 8 & 0xFF));
            if (eqCount == 0) {
                this.out.write((byte)(num & 0xFF));
            }
        }
    }

    private void decodeToken() {
        int num = this.token[0] << 18 | this.token[1] << 12 | this.token[2] << 6 | this.token[3];
        this.bytes[0] = (byte)(0xFF & num >> 16);
        this.bytes[1] = (byte)(0xFF & num >> 8);
        this.bytes[2] = (byte)(0xFF & num);
        this.out.write(this.bytes, 0, 3);
    }

    private void eof() {
        if (this.token != null && this.tokenLength != 0) {
            while (this.tokenLength < 4) {
                this.token[this.tokenLength++] = 126;
            }
            this.decodeFinalToken();
        }
        this.tokenLength = 0;
        this.token = new byte[4];
        this.bytes = new byte[3];
    }
}

