/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

public final class MimeBase64Encoder {
    private StringBuffer out = new StringBuffer();
    private int buf = 0;
    private int bufBytes = 0;
    private char[] line = new char[74];
    private int lineLength = 0;
    private static final char[] ENCODER_MAP = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};

    public char[] getCharArray() {
        if (this.bufBytes != 0) {
            this.encodePartialToken();
        }
        this.flushLine();
        for (int i = 0; i < this.line.length; ++i) {
            this.line[i] = '\u0000';
        }
        char[] ch = new char[this.out.length()];
        if (this.out.length() > 0) {
            this.out.getChars(0, this.out.length(), ch, 0);
        }
        return ch;
    }

    public final void translate(char[] in) {
        int i;
        int inLength = in.length;
        for (i = 0; i < inLength; ++i) {
            this.buf = this.bufBytes == 0 ? this.buf & 0xFFFF | in[i] << 16 : (this.bufBytes == 1 ? this.buf & 0xFF00FF | in[i] << 8 & 0xFFFF : this.buf & 0xFFFF00 | in[i] & 0xFF);
            if (++this.bufBytes == 3) {
                this.encodeToken();
                if (this.lineLength >= 72) {
                    this.flushLine();
                }
            }
            if (i != inLength - 1) continue;
            if (this.bufBytes > 0 && this.bufBytes < 3) {
                this.encodePartialToken();
            }
            if (this.lineLength <= 0) continue;
            this.flushLine();
        }
        for (i = 0; i < this.line.length; ++i) {
            this.line[i] = '\u0000';
        }
    }

    private final void encodePartialToken() {
        int i = this.lineLength;
        this.line[i] = ENCODER_MAP[0x3F & this.buf >> 18];
        this.line[i + 1] = ENCODER_MAP[0x3F & this.buf >> 12];
        this.line[i + 2] = this.bufBytes == 1 ? 61 : ENCODER_MAP[0x3F & this.buf >> 6];
        this.line[i + 3] = this.bufBytes <= 2 ? 61 : ENCODER_MAP[0x3F & this.buf];
        this.lineLength += 4;
        this.buf = 0;
        this.bufBytes = 0;
    }

    private final void encodeToken() {
        int i = this.lineLength;
        this.line[i] = ENCODER_MAP[0x3F & this.buf >> 18];
        this.line[i + 1] = ENCODER_MAP[0x3F & this.buf >> 12];
        this.line[i + 2] = ENCODER_MAP[0x3F & this.buf >> 6];
        this.line[i + 3] = ENCODER_MAP[0x3F & this.buf];
        this.lineLength += 4;
        this.buf = 0;
        this.bufBytes = 0;
    }

    private final void flushLine() {
        this.out.append(this.line, 0, this.lineLength);
        this.lineLength = 0;
    }
}

