/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.TimePeriod;
import java.util.StringTokenizer;

public class Month
extends TimePeriod {
    protected static final char[] INIT_DURATION = new char[]{'P', '1', 'M'};

    public Month() {
        super(INIT_DURATION);
    }

    public static Month parseMonth(char[] value) {
        StringTokenizer st;
        Month result = new Month();
        String str = new String(value);
        if (str.length() < 7) {
            throw new MarshalException("Month bad format");
        }
        if (str.charAt(0) == '-') {
            result.setNegative();
            str = str.substring(1);
        }
        if ((st = new StringTokenizer(str, "-")).countTokens() != 2) {
            throw new MarshalException("Month bad format");
        }
        String token = st.nextToken();
        if (token.length() < 4) {
            throw new MarshalException("Month bad format");
        }
        int i = Integer.parseInt(token.substring(0, token.length() - 2));
        result.setCentury(i);
        i = Integer.parseInt(token.substring(token.length() - 2));
        result.setYear(i);
        token = st.nextToken();
        if (token.length() < 2) {
            throw new MarshalException("Month bad format");
        }
        i = Integer.parseInt(token);
        result.setMonth(i);
        return result;
    }

    public String toString() {
        String result = this.mIsNegative ? "-" : "";
        String temp = String.valueOf(this.mCentury);
        result = result + temp;
        temp = String.valueOf(this.mYear);
        if (temp.length() < 2) {
            temp = "0" + temp;
        }
        result = result + temp;
        result = result + "-";
        temp = String.valueOf(this.mMonth);
        if (temp.length() < 2) {
            temp = "0" + temp;
        }
        result = result + temp;
        return result;
    }
}

