/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.RecurringDuration;

public class RecurringDate
extends RecurringDuration {
    protected static final char[] INIT_DURATION = new char[]{'P', '1', 'D'};
    protected static final char[] INIT_PERIOD = new char[]{'P', '1', 'Y'};

    public RecurringDate() {
        super(INIT_DURATION, INIT_PERIOD);
    }

    public static RecurringDate parseRecurringDate(char[] value) {
        RecurringDate rd = new RecurringDate();
        if (value == null || value.length == 0) {
            throw new MarshalException("Missing RecurringDate value");
        }
        if (value.length == 7 && value[0] == '-' && value[1] == '-' && value[4] == '-') {
            String str = new String(value);
            int month = Integer.parseInt(str.substring(2, 4));
            int day = Integer.parseInt(str.substring(5));
            if (month == 2 && day < 30 || (month == 4 || month == 6 || month == 9 || month == 11) && day < 31 || (month == 1 || month == 3 || month == 5 || month == 7 || month == 8 || month == 10 || month == 12) && day < 32) {
                rd.setMonth(month);
                rd.setDay(day);
                return rd;
            }
            throw new MarshalException("Invalid month/day value");
        }
        throw new MarshalException("Invalid RecurringDate format");
    }

    public String toString() {
        String result = "--";
        String temp = String.valueOf(this.getMonth());
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        temp = String.valueOf(this.getDay());
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        return result;
    }
}

