/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.TimeDuration;
import java.util.StringTokenizer;

public class RecurringDuration {
    protected TimeDuration mPeriod = null;
    protected TimeDuration mDuration = null;
    protected int mCentury = 0;
    protected int mYear = 0;
    protected int mMonth = 0;
    protected int mDay = 0;
    protected int mHour = 0;
    protected int mMinute = 0;
    protected int mSecond = 0;
    protected int mMillsecond = 0;
    protected int mMillidigits = 0;
    protected int mZoneHour = 0;
    protected int mZoneMinute = 0;
    protected boolean mUTC = false;
    protected boolean mZoneNegative = false;
    protected boolean mIsNegative = false;

    public RecurringDuration() {
    }

    public RecurringDuration(TimeDuration duration, TimeDuration period) {
        this.setDuration(duration);
        this.setPeriod(period);
    }

    public RecurringDuration(char[] duration, char[] period) {
        this.setDuration(TimeDuration.parse(duration));
        this.setPeriod(TimeDuration.parse(period));
    }

    public static RecurringDuration parse(char[] chars) {
        String zoneStr;
        boolean timeZone;
        RecurringDuration result = new RecurringDuration();
        String str = new String(chars);
        if (str.endsWith("Z")) {
            str = str.substring(0, str.indexOf("Z"));
        }
        if (str.startsWith("-")) {
            result.setNegative();
        }
        boolean bl = timeZone = ((zoneStr = str.substring(str.length() - 6)).lastIndexOf("-") != -1 || zoneStr.lastIndexOf("+") != -1) && zoneStr.lastIndexOf(":") != -1;
        if (!timeZone) {
            zoneStr = null;
        } else {
            int index = str.lastIndexOf("+") != -1 ? str.lastIndexOf("+") : str.lastIndexOf("-");
            str = str.substring(0, index);
        }
        if (str.indexOf(84) == -1) {
            throw new MarshalException("The 'T' element is required");
        }
        String date = str.substring(0, str.indexOf("T"));
        String time = str.substring(str.indexOf("T"));
        StringTokenizer token = new StringTokenizer(date, "-");
        if (token.countTokens() != 3) {
            throw new MarshalException("Date (" + date + ") bad format");
        }
        String temp = token.nextToken();
        if (temp.length() != 4) {
            throw new MarshalException("Year (" + temp + ") bad format");
        }
        result.setCentury(Integer.parseInt(temp.substring(0, 2)));
        result.setYear(Integer.parseInt(temp.substring(2, 4)));
        temp = token.nextToken();
        if (temp.length() != 2) {
            throw new MarshalException("Month (" + temp + ") bad format");
        }
        result.setMonth(Integer.parseInt(temp));
        temp = token.nextToken();
        if (temp.length() != 2) {
            throw new MarshalException("Day (" + temp + ") bad format");
        }
        result.setDay(Integer.parseInt(temp));
        token = new StringTokenizer(time, ":");
        if (token.countTokens() < 3 && token.countTokens() > 5) {
            throw new MarshalException("Time (" + time + ") bad format");
        }
        temp = token.nextToken();
        if ((temp = temp.substring(temp.indexOf("T") + 1)).length() != 2) {
            throw new MarshalException("Hour (" + temp + ") bad format");
        }
        result.setHour(Integer.parseInt(temp));
        temp = token.nextToken();
        if (temp.length() != 2) {
            throw new MarshalException("Minute (" + temp + ") bad format");
        }
        result.setMinute(Integer.parseInt(temp));
        temp = token.nextToken();
        String milsecond = "0";
        if (temp.indexOf(".") != -1) {
            milsecond = temp.substring(temp.indexOf(".") + 1);
            temp = temp.substring(0, temp.indexOf("."));
        }
        if (temp.length() != 2) {
            throw new MarshalException("Second (" + temp + ") bad format");
        }
        result.setSecond(Integer.parseInt(temp.substring(0, 2)), Integer.parseInt(milsecond), milsecond.length());
        if (timeZone) {
            if (zoneStr.startsWith("-")) {
                result.setZoneNegative();
            }
            if (zoneStr.length() != 6) {
                throw new MarshalException("Time zone (" + zoneStr + ") bad format");
            }
            result.setZone(Integer.parseInt(zoneStr.substring(1, 3)), Integer.parseInt(zoneStr.substring(4, 6)));
        } else {
            result.isUTC();
        }
        return result;
    }

    public int getCentury() {
        return this.mCentury;
    }

    public int getDay() {
        return this.mDay;
    }

    public TimeDuration getDuration() {
        return this.mDuration;
    }

    public int getHour() {
        return this.mHour;
    }

    public int getMilli() {
        return this.mMillsecond;
    }

    public int getMilliDigits() {
        return this.mMillidigits;
    }

    public int getMinute() {
        return this.mMinute;
    }

    public int getMonth() {
        return this.mMonth;
    }

    public TimeDuration getPeriod() {
        return this.mPeriod;
    }

    public int getSeconds() {
        return this.mSecond;
    }

    public int getYear() {
        return this.mYear;
    }

    public int getZoneHour() {
        return this.mZoneHour;
    }

    public int getZoneMinute() {
        return this.mZoneMinute;
    }

    public boolean isLeap() {
        int temp = this.mCentury * 100 + this.mYear;
        boolean result = temp % 4 == 0 && temp % 100 != 0;
        result = result || temp % 400 == 0;
        return result;
    }

    public boolean isNegative() {
        return this.mIsNegative;
    }

    public boolean isUTC() {
        this.mUTC = this.mZoneHour == 0 && this.mZoneMinute == 0;
        return this.mUTC;
    }

    public boolean isZoneNegative() {
        return this.mZoneNegative;
    }

    public void setCentury(int century) {
        if (century < 0) {
            throw new MarshalException("The century field (" + century + ") must not be negative");
        }
        this.mCentury = century;
    }

    public void setDay(int day) {
        if (day < 1 || day > 31) {
            throw new MarshalException("The day field (" + day + ") must be in the range 1..31");
        }
        if (this.mMonth == 2) {
            if (this.isLeap() && day > 29) {
                throw new MarshalException("The day field (" + day + ") is incorrect (leap year, February)");
            }
            if (day > 28) {
                throw new MarshalException("The day field (" + day + ") is incorrect (NOT leap year, February)");
            }
        } else if ((this.mMonth == 4 || this.mMonth == 6 || this.mMonth == 9 || this.mMonth == 11) && day > 30) {
            throw new MarshalException("The day field (" + day + ") is incorrect (month is Apr|Jun|Sep|Nov)");
        }
        this.mDay = day;
    }

    public void setDuration(TimeDuration duration) {
        this.mDuration = duration;
    }

    public void setDuration(char[] duration) {
        this.mDuration = TimeDuration.parse(duration);
    }

    public void setHour(int hour) {
        if (hour > 23) {
            throw new MarshalException("The hour field (" + hour + ") must be strictly lower than 24");
        }
        this.mHour = hour;
    }

    public void setMinute(int minute) {
        if (minute > 59) {
            throw new MarshalException("The minute field (" + minute + ") must be strictly lower than 60");
        }
        this.mMinute = minute;
    }

    public void setMonth(int month) {
        if (month < 1 || month > 12) {
            throw new MarshalException("The month field (" + month + ") must be in the range 1..12");
        }
        this.mMonth = month;
    }

    public void setNegative() {
        this.mIsNegative = true;
    }

    public void setPeriod(TimeDuration period) {
        this.mPeriod = period;
    }

    public void setPeriod(char[] period) {
        this.mPeriod = TimeDuration.parse(period);
    }

    public void setSecond(int second, int millsecond, int millidigits) {
        if (second > 60) {
            throw new MarshalException("The second field (" + second + ") must be strictly lower than 60");
        }
        this.mSecond = second;
        this.mMillsecond = millsecond;
        this.mMillidigits = millidigits;
    }

    public void setUTC() {
        this.mUTC = true;
    }

    public void setYear(int year) {
        if (year < 0) {
            throw new MarshalException("The year field (" + year + ") must not be negative");
        }
        if (year == 0 && this.mCentury == 0) {
            throw new MarshalException("The year 0000 is not allowed");
        }
        this.mYear = year;
    }

    public void setZone(int hour, int minute) {
        if (hour > 23) {
            throw new MarshalException("The zone hour field (" + hour + ") must be strictly lower than 24");
        }
        this.mZoneHour = hour;
        if (minute > 59) {
            throw new MarshalException("The zone minute field (" + hour + ") must be strictly lower than 60");
        }
        this.mZoneMinute = minute;
    }

    public void setZoneNegative() {
        this.mZoneNegative = true;
    }

    public String toString() {
        String result = null;
        String timeZone = null;
        String temp = String.valueOf(this.mCentury);
        if (temp.length() == 1) {
            temp = "0" + result;
        }
        result = temp;
        temp = String.valueOf(this.mYear);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        temp = String.valueOf(this.mMonth);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + "-" + temp;
        temp = String.valueOf(this.mDay);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + "-" + temp;
        result = result + "T";
        temp = String.valueOf(this.mHour);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + temp;
        temp = String.valueOf(this.mMinute);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + ":" + temp;
        temp = String.valueOf(this.mSecond);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + ":" + temp;
        temp = String.valueOf(this.mMillsecond);
        result = result + ".";
        if (temp.length() < this.mMillidigits) {
            for (int i = 0; i < this.mMillidigits - temp.length(); ++i) {
                result = result + "0";
            }
        }
        result = result + temp;
        String string = result = this.isNegative() ? "-" + result : result;
        if (!this.isUTC()) {
            temp = String.valueOf(this.mZoneHour);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            timeZone = temp;
            temp = String.valueOf(this.mZoneMinute);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            timeZone = timeZone + ":" + temp;
            timeZone = this.isZoneNegative() ? "-" + timeZone : "+" + timeZone;
            result = result + timeZone;
        }
        return result;
    }
}

