/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.RecurringDuration;
import java.util.StringTokenizer;

public class Time
extends RecurringDuration {
    protected static final char[] INIT_DURATION = new char[]{'P', '0', 'Y'};
    protected static final char[] INIT_PERIOD = new char[]{'P', '1', 'D'};

    public Time() {
        super(INIT_DURATION, INIT_PERIOD);
    }

    public static Time parseTime(char[] chars) {
        String zoneStr;
        boolean timeZone;
        Time result = new Time();
        String str = new String(chars);
        if (str.endsWith("Z")) {
            str = str.substring(0, str.indexOf("Z"));
        }
        if (str.startsWith("-")) {
            result.setNegative();
        }
        boolean bl = timeZone = (zoneStr = str.substring(str.length() - 6, str.length())).lastIndexOf("-") != -1 || zoneStr.lastIndexOf("+") != -1;
        if (!timeZone) {
            zoneStr = null;
        } else {
            int index = str.lastIndexOf("+") != -1 ? str.lastIndexOf("+") : str.lastIndexOf("-");
            str = str.substring(0, index);
        }
        StringTokenizer token = new StringTokenizer(str, ":");
        if (token.countTokens() < 3 && token.countTokens() > 5) {
            throw new MarshalException("Bad time format");
        }
        String temp = token.nextToken();
        if ((temp = temp.substring(temp.indexOf("T") + 1)).length() != 2) {
            throw new MarshalException("Bad hour format: must contain 2 digits");
        }
        result.setHour(Integer.parseInt(temp));
        temp = token.nextToken();
        if (temp.length() != 2) {
            throw new MarshalException("Bad minute format: must contain 2 digits");
        }
        result.setMinute(Integer.parseInt(temp));
        temp = token.nextToken();
        String milsecond = "0";
        if (temp.indexOf(".") != -1) {
            milsecond = temp.substring(temp.indexOf(".") + 1);
            temp = temp.substring(0, temp.indexOf("."));
        }
        if (temp.length() != 2) {
            throw new MarshalException("Bad second format: must contain 2 digits");
        }
        result.setSecond(Integer.parseInt(temp.substring(0, 2)), Integer.parseInt(milsecond), milsecond.length());
        if (timeZone) {
            if (zoneStr.startsWith("-")) {
                result.setZoneNegative();
            }
            if (zoneStr.length() != 6) {
                throw new MarshalException("Bad time zone format");
            }
            result.setZone(Integer.parseInt(zoneStr.substring(1, 3)), Integer.parseInt(zoneStr.substring(4, 6)));
        } else {
            result.setUTC();
        }
        return result;
    }

    public String toString() {
        String temp = String.valueOf(this.mHour);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        String result = temp;
        temp = String.valueOf(this.mMinute);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + ":" + temp;
        temp = String.valueOf(this.mSecond);
        if (temp.length() == 1) {
            temp = "0" + temp;
        }
        result = result + ":" + temp;
        temp = String.valueOf(this.mMillsecond);
        result = result + ".";
        if (temp.length() < this.mMillidigits) {
            for (int i = 0; i < this.mMillidigits - temp.length(); ++i) {
                result = result + "0";
            }
        }
        result = result + temp;
        String string = result = this.isNegative() ? "-" + result : result;
        if (!this.isUTC()) {
            temp = String.valueOf(this.mZoneHour);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            String timeZone = temp;
            temp = String.valueOf(this.mZoneMinute);
            if (temp.length() == 1) {
                temp = "0" + temp;
            }
            timeZone = timeZone + ":" + temp;
            timeZone = this.isZoneNegative() ? "-" + timeZone : "+" + timeZone;
            result = result + timeZone;
        }
        return result;
    }
}

