/*
 * Decompiled with CFR 0.152.
 */
package com.stc.otd.xsd.datatype;

import com.stc.otd.runtime.MarshalException;
import com.stc.otd.xsd.datatype.TimeZoneParser;
import com.stc.runtime.dt.Time;
import java.text.DecimalFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class Time2001
implements Time,
Comparable {
    private static DecimalFormat fmt = new DecimalFormat("00");
    private static DecimalFormat milliFmt = new DecimalFormat(".000");
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("HH:mm:ss");
    private static DecimalFormat fmt1 = new DecimalFormat(".#");
    private int hours;
    private int milliseconds;
    private int minutes;
    private int seconds;
    private TimeZone tz;

    public Time2001() {
    }

    public Time2001(int hours, int minutes, int seconds, int milliseconds, TimeZone tz) {
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = seconds;
        this.milliseconds = milliseconds;
        this.tz = tz;
    }

    public Time2001(Time copy) {
        this.hours = copy.getHours();
        this.minutes = copy.getMinutes();
        this.seconds = copy.getSeconds();
        this.milliseconds = copy.getMilliseconds();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Time2001 parse(String value) {
        Date date;
        ParsePosition pos = new ParsePosition(0);
        SimpleDateFormat simpleDateFormat = dateFormat;
        synchronized (simpleDateFormat) {
            date = dateFormat.parse(value, pos);
            if (date == null) {
                throw new MarshalException("Invalid Time2001 format, expected: " + dateFormat.toPattern() + ", value: " + value);
            }
        }
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        TimeZone tz = null;
        int milliseconds = 0;
        if (pos.getIndex() < value.length()) {
            if (value.charAt(pos.getIndex()) == '.') {
                double fractionalSeconds;
                DecimalFormat decimalFormat = fmt1;
                synchronized (decimalFormat) {
                    fractionalSeconds = fmt1.parse(value, pos).doubleValue();
                }
                milliseconds = (int)(fractionalSeconds * 1000.0);
                calendar.set(14, milliseconds);
            }
            if (pos.getIndex() < value.length()) {
                tz = TimeZoneParser.parse(value.substring(pos.getIndex()));
            }
        }
        return new Time2001(calendar.get(11), calendar.get(12), calendar.get(13), calendar.get(14), tz);
    }

    public int getHours() {
        return this.hours;
    }

    public int getMilliseconds() {
        return this.milliseconds;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds;
    }

    public void setHours(int hours) {
        this.hours = hours;
    }

    public void setMilliseconds(int millis) {
        this.milliseconds = millis;
    }

    public void setMinutes(int minutes) {
        this.minutes = minutes;
    }

    public void setSeconds(int seconds) {
        this.seconds = seconds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String result;
        DecimalFormat decimalFormat = fmt;
        synchronized (decimalFormat) {
            result = fmt.format(this.getHours());
            result = result + ":";
            result = result + fmt.format(this.getMinutes());
            result = result + ":";
            result = result + fmt.format(this.getSeconds());
        }
        if (this.milliseconds > 0) {
            decimalFormat = milliFmt;
            synchronized (decimalFormat) {
                result = result + Double.parseDouble(milliFmt.format((double)this.milliseconds * 0.001));
            }
        }
        if (this.tz != null) {
            result = result + TimeZoneParser.format(this.tz);
        }
        return result;
    }

    public int compareTo(Object o) {
        Time2001 to = (Time2001)o;
        if (to == null) {
            return -2;
        }
        int compare = this.toString().compareTo(to.toString());
        if (compare > 0) {
            return 1;
        }
        if (compare < 0) {
            return -1;
        }
        return 0;
    }
}

